/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.se6120.internal;

import com.sun.netstorage.array.mgmt.se6120.internal.ArrayException;
import com.sun.netstorage.array.mgmt.se6120.internal.ArrayObject;
import com.sun.netstorage.array.mgmt.se6120.internal.Constants;
import com.sun.netstorage.array.mgmt.se6120.internal.CreateRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.DeleteRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.DevComm;
import com.sun.netstorage.array.mgmt.se6120.internal.InvokeRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyModule;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.RequestBroker;
import com.sun.netstorage.array.mgmt.se6120.internal.SetRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.StorEdgeIOException;
import com.sun.netstorage.array.mgmt.se6120.internal.StorEdge_6120ArrayProvider;
import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMMethodException;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.client.CIMOMHandle;

public class ModifyMasking
extends ModifyModule
implements Constants {
    private static String CLASSNAME = "ModifyMasking";
    private static String EMPTY = ",";
    private static String DELETE = "";
    private static String BOGUS_WWN = "FFFFFFFFFFFFFFFF";
    private static final int NUM_LUN_CHANGE_CMDS = 3;
    private String[] classes = new String[]{"StorEdge_6120AuthorizationViewSCSIController", "StorEdge_6120PortSCSIController", "StorEdge_6120AccessControlInformation", "StorEdge_6120AuthorizationService", "StorEdge_6120StorageHardwareID", "StorEdge_6120StorageHardwareIDManagementService", "StorEdge_6120SystemSpecificCollection", "StorEdge_6120StorageVolume", "StorEdge_6120AuthViewConcreteIdentity", "StorEdge_6120HostedAuthorizationService", "StorEdge_6120MappedSCSILUN", "StorEdge_6120SCSILUN", "StorEdge_6120AuthorizedUse", "StorEdge_6120AuthorizationTarget", "StorEdge_6120ACIConcreteComponent", "StorEdge_6120AuthViewSystemDevice", "StorEdge_6120AuthorizationSubject", "StorEdge_6120MemberOfCollection", "StorEdge_6120ServiceAffectsElement", "StorEdge_6120HostedIDService", "StorEdge_6120HostedCollection"};
    private static final CIMValue _MASK_SERVICE_OK = new CIMValue((Object)new UnsignedInt32(0L));
    private static final CIMValue _MASK_SERVICE_TIMEOUT = new CIMValue((Object)new UnsignedInt32(3L));
    private static final CIMValue _MASK_SERVICE_FAILED = new CIMValue((Object)new UnsignedInt32(4L));
    private static final CIMValue _MASK_SERVICE_INVALID_PARAM = new CIMValue((Object)new UnsignedInt32(5L));
    private static final CIMValue _MASK_SERVICE_DUPLICATE = new CIMValue((Object)new UnsignedInt32(32768L));
    private static final CIMValue _MASK_SERVICE_WRONG_ID_TYPE = new CIMValue((Object)new UnsignedInt32(4097L));
    private static final CIMValue _MASK_SERVICE_INVALID_VOLUME = new CIMValue((Object)new UnsignedInt32(4096L));
    private static final CIMValue _MASK_SERVICE_UNIT_NUMBER_MUST_BE_NULL = new CIMValue((Object)new UnsignedInt32(4098L));
    private static final CIMValue _MASK_SERVICE_NOT_FOUND = new CIMValue((Object)new UnsignedInt32(4096L));

    public void shutdown() {
    }

    public boolean handleRequest(ModifyRequest request) throws CIMException {
        String METHOD = "handleRequest";
        boolean validClass = false;
        WBEMDebug.trace3((String)(CLASSNAME + "." + "handleRequest" + " entered"));
        if (request == null) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "handleRequest" + " Null request argument. "));
            throw new CIMException("CIM_ERR_FAILED");
        }
        String classname = request.getCIMClassName();
        String methodName = null;
        int i = 0;
        while (i < this.classes.length) {
            if (classname.toLowerCase().equals(this.classes[i].toLowerCase())) {
                validClass = true;
                break;
            }
            ++i;
        }
        if (!validClass) {
            return false;
        }
        try {
            String pkg = request.getClass().getPackage().getName();
            methodName = request.getClass().getName().substring(pkg.length() + 1) + request.getCIMClassName();
            Class[] argTypes = new Class[]{request.getClass()};
            Object[] args = new Object[]{request};
            Method method = this.getClass().getMethod(methodName, argTypes);
            try {
                method.invoke((Object)this, args);
                if (request instanceof InvokeRequest) {
                    InvokeRequest req = (InvokeRequest)request;
                    if (req.results().equals((Object)new CIMValue((Object)new UnsignedInt32(0L)))) {
                        RequestBroker.getInstance().invalidateCache(this.getSystem());
                    }
                } else {
                    RequestBroker.getInstance().invalidateCache(this.getSystem());
                }
            }
            catch (InvocationTargetException wrapperE) {
                WBEMDebug.trace2((String)(CLASSNAME + "." + "handleRequest" + " Method \"" + methodName + "\" threw an exception: "), (Throwable)wrapperE.getTargetException());
                throw (CIMException)wrapperE.getTargetException();
            }
            catch (Exception e) {
                WBEMDebug.trace2((String)(CLASSNAME + "." + "handleRequest" + " Method \"" + methodName + "\" existed but unable to call: "), (Throwable)e);
                CIMException tmp = new CIMException("CIM_ERR_FAILED");
                tmp.setDescription("Internal failure calling " + methodName + " " + e);
                throw tmp;
            }
        }
        catch (NoSuchMethodException e1) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "handleRequest" + " Unsupported method \"" + methodName + "\""));
            WBEMDebug.trace2((String)(CLASSNAME + "." + "handleRequest" + " Method \"" + methodName + "\" does not exist: "), (Throwable)e1);
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        return true;
    }

    public ModifyMasking(ArrayObject system) {
        super(system);
    }

    public void SetRequestStorEdge_6120StorageHardwareID(SetRequest request) throws CIMException {
        String METHOD = "SetRequestStorEdge_6120StorageHardwareID";
        WBEMDebug.trace3((String)(CLASSNAME + "." + "SetRequestStorEdge_6120StorageHardwareID" + " entered"));
        if (request == null) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120StorageHardwareID" + " Null request argument. "));
            throw new CIMException("CIM_ERR_FAILED");
        }
        String wwn = null;
        String description = null;
        try {
            wwn = (String)request.getPropertyValue("ID");
            description = (String)request.getPropertyValue("Description");
        }
        catch (Exception e) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120StorageHardwareID" + " internal error " + "encountered: " + request.getProperties()), (Throwable)e);
            WBEMDebug.trace2((String)(CLASSNAME + "." + "SetRequestStorEdge_6120StorageHardwareID"), (Throwable)e);
            CIMException tmp = new CIMException("CIM_ERR_FAILED");
            tmp.setDescription("Internal failure extracting WWN and description from request " + e.getMessage());
            throw tmp;
        }
        if (description == null || description.equals("")) {
            description = " ";
        }
        try {
            Properties props = new Properties();
            props.setProperty("Initiator" + wwn, description);
            DevComm.getInstance().setSysProps(this.getSystem(), props);
        }
        catch (Exception e) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120StorageHardwareID" + " IO error " + "encountered. "), (Throwable)e);
            WBEMDebug.trace2((String)(CLASSNAME + "." + "SetRequestStorEdge_6120StorageHardwareID"), (Throwable)e);
            CIMException tmp = new CIMException("CIM_ERR_FAILED");
            tmp.setDescription("IO failure setting initiator description" + e.getMessage());
            throw tmp;
        }
    }

    public void InvokeRequestStorEdge_6120StorageHardwareIDManagementService(InvokeRequest request) throws CIMException {
        String METHOD = "InvokeRequestStorEdge_6120StorageHardwareIDManagementService";
        if (request == null) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120StorageHardwareIDManagementService" + " Null request argument. "));
            throw new CIMException("CIM_ERR_FAILED");
        }
        UnsignedInt16 IDTYPE = new UnsignedInt16(2);
        WBEMDebug.trace3((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120StorageHardwareIDManagementService" + " entered"));
        String[] req = new String[]{"InitiatorList"};
        Properties props = null;
        try {
            props = DevComm.getInstance().getSysProps(this.getSystem(), req);
            if (props == null) {
                WBEMDebug.trace3((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120StorageHardwareIDManagementService" + " No results from T4 getSysProps, stubbing."));
                props = new Properties();
            }
        }
        catch (ArrayException e) {
            request.setResults(_MASK_SERVICE_FAILED);
            return;
        }
        catch (StorEdgeIOException e) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120StorageHardwareIDManagementService" + " IO error communicating to T4: " + e.getMessage()));
            WBEMDebug.trace2((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120StorageHardwareIDManagementService"), (Throwable)e);
            CIMException tmp = new CIMException("CIM_ERR_FAILED");
            tmp.setDescription(e.getMessage());
            throw tmp;
        }
        String wwn = null;
        if (request.getMethodName().equalsIgnoreCase("createStorageHardwareIDWithDescription")) {
            String description = null;
            try {
                UnsignedInt16 type = (UnsignedInt16)request.getInParamValue(1);
                if (!type.equals((Object)IDTYPE)) {
                    request.setResults(_MASK_SERVICE_WRONG_ID_TYPE);
                    return;
                }
                wwn = ((String)request.getInParamValue(0)).toUpperCase();
                description = (String)request.getInParamValue(2);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120StorageHardwareIDManagementService" + " Invalid parameter " + e.getMessage()));
                WBEMDebug.trace2((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120StorageHardwareIDManagementService"), (Throwable)e);
                request.setResults(_MASK_SERVICE_INVALID_PARAM);
                return;
            }
            catch (ClassCastException e1) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120StorageHardwareIDManagementService" + " Invalid parameter " + e1.getMessage()));
                WBEMDebug.trace2((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120StorageHardwareIDManagementService"), (Throwable)e1);
                request.setResults(_MASK_SERVICE_INVALID_PARAM);
                return;
            }
            if (props.getProperty("InitiatorList") == null) {
                props.setProperty("InitiatorList", wwn);
            } else {
                if (this.isInCommaList(props.getProperty("InitiatorList"), wwn)) {
                    WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120StorageHardwareIDManagementService" + " requested wwn \"" + wwn + "\" already stored."));
                    request.setResults(_MASK_SERVICE_FAILED);
                    return;
                }
                props.setProperty("InitiatorList", this.commaCleanup(props.getProperty("InitiatorList") + "," + wwn + ","));
            }
            if (description == null || description.equals("")) {
                description = " ";
            }
            props.setProperty("Initiator" + wwn, description);
            try {
                DevComm.getInstance().setSysProps(this.getSystem(), props);
            }
            catch (ArrayException e) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120StorageHardwareIDManagementService" + " IO failure: " + e.getMessage()));
                WBEMDebug.trace2((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120StorageHardwareIDManagementService"), (Throwable)e);
                CIMException tmp = new CIMException("CIM_ERR_FAILED");
                tmp.setDescription("IO failure communicating to array: " + e.getMessage());
                throw tmp;
            }
            catch (StorEdgeIOException e) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120StorageHardwareIDManagementService" + " IO error communicating to T4: " + e.getMessage()));
                WBEMDebug.trace2((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120StorageHardwareIDManagementService"), (Throwable)e);
                CIMException tmp = new CIMException("CIM_ERR_FAILED");
                tmp.setDescription(e.getMessage());
                throw tmp;
            }
            request.setResults(_MASK_SERVICE_OK);
        } else if (request.getMethodName().equalsIgnoreCase("deleteHardwareID")) {
            if (props.getProperty("InitiatorList") == null) {
                request.setResults(_MASK_SERVICE_NOT_FOUND);
                return;
            }
            try {
                CIMObjectPath ref = (CIMObjectPath)request.getInParamValue(0);
                Vector refVec = ref.getKeys();
                int i = 0;
                while (i < refVec.size()) {
                    CIMProperty prop = (CIMProperty)refVec.elementAt(i);
                    if (prop.getName().equalsIgnoreCase("ID")) {
                        wwn = (String)prop.getValue().getValue();
                    }
                    ++i;
                }
                if (wwn == null) {
                    WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120StorageHardwareIDManagementService" + " delete wwn not found in argument"));
                    request.setResults(_MASK_SERVICE_INVALID_PARAM);
                    return;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120StorageHardwareIDManagementService" + " Invalid parameter " + e.getMessage()));
                WBEMDebug.trace2((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120StorageHardwareIDManagementService"), (Throwable)e);
                request.setResults(_MASK_SERVICE_INVALID_PARAM);
                return;
            }
            catch (ClassCastException e1) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120StorageHardwareIDManagementService" + " Invalid parameter " + e1.getMessage()));
                WBEMDebug.trace2((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120StorageHardwareIDManagementService"), (Throwable)e1);
                request.setResults(_MASK_SERVICE_INVALID_PARAM);
                return;
            }
            String initiators = props.getProperty("InitiatorList");
            try {
                initiators = this.commaCleanup(this.subtractString(initiators, wwn));
            }
            catch (NoSuchElementException e) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120StorageHardwareIDManagementService" + " delete wwn not found on T4"));
                request.setResults(_MASK_SERVICE_NOT_FOUND);
                return;
            }
            props.setProperty("InitiatorList", initiators);
            props.setProperty("Initiator" + wwn, DELETE);
            try {
                DevComm.getInstance().setSysProps(this.getSystem(), props);
                Vector<String> cleanup = new Vector<String>();
                cleanup.add("lunMaskWWN=" + wwn);
                DevComm.getInstance().post(this.getSystem(), cleanup, "lunWWNRemove");
            }
            catch (ArrayException e) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120StorageHardwareIDManagementService" + " IO failure: " + e.getMessage()));
                WBEMDebug.trace2((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120StorageHardwareIDManagementService"), (Throwable)e);
                CIMException tmp = new CIMException("CIM_ERR_FAILED");
                tmp.setDescription("IO failure communicating to array: " + e.getMessage());
                throw tmp;
            }
            catch (StorEdgeIOException e) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120StorageHardwareIDManagementService" + " IO error communicating to T4: " + e.getMessage()));
                WBEMDebug.trace2((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120StorageHardwareIDManagementService"), (Throwable)e);
                CIMException tmp = new CIMException("CIM_ERR_FAILED");
                tmp.setDescription(e.getMessage());
                throw tmp;
            }
            request.setResults(_MASK_SERVICE_OK);
        } else {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120StorageHardwareIDManagementService" + " Method \"" + request.getMethodName() + "\" does not exist"));
            throw new CIMMethodException("NO_SUCH_METHOD");
        }
    }

    public void CreateRequestStorEdge_6120SystemSpecificCollection(CreateRequest request) throws CIMException {
        String METHOD = "CreateRequestStorEdge_6120SystemSpecificCollection";
        WBEMDebug.trace3((String)(CLASSNAME + "." + "CreateRequestStorEdge_6120SystemSpecificCollection" + " entered (redirecting)"));
        ModifyMasking.createInitiatorGroup(request);
    }

    public void DeleteRequestStorEdge_6120SystemSpecificCollection(DeleteRequest request) throws CIMException {
        String METHOD = "DeleteRequestStorEdge_6120SystemSpecificCollection";
        WBEMDebug.trace3((String)(CLASSNAME + "." + "DeleteRequestStorEdge_6120SystemSpecificCollection" + " entered"));
        if (request == null) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "DeleteRequestStorEdge_6120SystemSpecificCollection" + " Null request argument. "));
            throw new CIMException("CIM_ERR_FAILED");
        }
        if (RequestBroker.getInstance().isSyntheticCacheInstance(request.getObjectPath())) {
            RequestBroker.getInstance().deleteSyntheticCacheInstance(request.getObjectPath());
        } else {
            CIMInstance iGroup = RequestBroker.getInstance().getCacheInstance(request.getObjectPath());
            if (iGroup == null) {
                throw new CIMException("CIM_ERR_NOT_FOUND");
            }
            CIMProperty tmp = iGroup.getProperty("ElementName");
            if (tmp == null) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "DeleteRequestStorEdge_6120SystemSpecificCollection" + "Unable to locate initiator group name " + iGroup));
                CIMException tmpe = new CIMException("CIM_ERR_FAILED");
                tmpe.setDescription("Missing Initiator Group Name property");
                throw tmpe;
            }
            String iGroupName = (String)tmp.getValue().getValue();
            try {
                Vector<String> remPost = new Vector<String>();
                remPost.add("lunGroupName=" + iGroupName);
                DevComm.getInstance().post(this.getSystem(), remPost, "lunGroupRemove");
            }
            catch (ArrayException e) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "DeleteRequestStorEdge_6120SystemSpecificCollection" + " IO failure: " + e.getMessage()));
                WBEMDebug.trace2((String)(CLASSNAME + "." + "DeleteRequestStorEdge_6120SystemSpecificCollection"), (Throwable)e);
                CIMException tmpe = new CIMException("CIM_ERR_FAILED");
                tmpe.setDescription("IO failure communicating to array: " + e.getMessage());
                throw tmpe;
            }
            catch (StorEdgeIOException e) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "DeleteRequestStorEdge_6120SystemSpecificCollection" + " IO failure: " + e.getMessage()));
                WBEMDebug.trace2((String)(CLASSNAME + "." + "DeleteRequestStorEdge_6120SystemSpecificCollection"), (Throwable)e);
                CIMException tmpE = new CIMException("CIM_ERR_FAILED");
                tmpE.setDescription(e.getMessage());
                throw tmpE;
            }
        }
    }

    public static void createAccessControlInformation(CreateRequest request) throws CIMException {
        String METHOD = "createAccessControlInformation";
        WBEMDebug.trace3((String)(CLASSNAME + "." + "createAccessControlInformation" + " entered"));
        if (request == null) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "createAccessControlInformation" + " Null request argument. "));
            throw new CIMException("CIM_ERR_FAILED");
        }
        RequestBroker.getInstance().addSyntheticCacheInstance(request.getNewInstance());
        request.setResults(request.getNewInstance().getObjectPath());
    }

    public void SetRequestStorEdge_6120AccessControlInformation(SetRequest request) throws CIMException {
        String METHOD = "SetRequestStorEdge_6120AccessControlInformation";
        WBEMDebug.trace3((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AccessControlInformation" + " entered"));
        if (request == null) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AccessControlInformation" + " Null request argument. "));
            throw new CIMException("CIM_ERR_FAILED");
        }
        CIMObjectPath aciPath = request.getObjectPath();
        aciPath.setNameSpace("\\root\\se6x20");
        try {
            Vector accessProps = (Vector)request.getPropertyValue("AccessType");
            String accessMode = (String)accessProps.elementAt(0);
            CIMInstance[] vGroups = RequestBroker.getInstance().associators(new CIMObjectPath("StorEdge_6120AuthorizationTarget", "\\root\\se6x20"), aciPath, "StorEdge_6120AuthorizationViewSCSIController", null, null, true, false, null);
            if (vGroups == null || vGroups.length <= 0) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AccessControlInformation" + " No AuthorizationViewSCSIController found for ACI"));
                throw new CIMException("CIM_ERR_FAILED");
            }
            int vCount = 0;
            while (vCount < vGroups.length) {
                CIMProperty tmp;
                CIMProperty isDefault = vGroups[vCount].getProperty("DefaultGlobalAccess");
                CIMInstance[] luns = RequestBroker.getInstance().references(new CIMObjectPath("StorEdge_6120MappedSCSILUN", "\\root\\se6x20"), vGroups[vCount].getObjectPath(), null, true, false, null);
                if (((Boolean)isDefault.getValue().getValue()).booleanValue()) {
                    if (luns == null || luns.length <= 0) {
                        WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AccessControlInformation" + " No LUNs found for Volume Group: " + vGroups[vCount].getObjectPath()));
                        throw new CIMException("CIM_ERR_FAILED");
                    }
                    if (luns.length > 1) {
                        WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AccessControlInformation" + " Multiple LUNs found for default global access"));
                    }
                    tmp = luns[0].getProperty("DeviceNumber");
                    int unitNumber = -1;
                    try {
                        unitNumber = Integer.parseInt((String)tmp.getValue().getValue(), 10);
                    }
                    catch (NumberFormatException e) {
                        WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AccessControlInformation" + " Volume has no Unit Number assigned."));
                        unitNumber = 65535;
                    }
                    if (unitNumber == 65535) {
                        WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AccessControlInformation" + " Unable to assign access with invalid unit number. "));
                        throw new CIMException("CIM_ERR_FAILED");
                    }
                    Vector<String> addMap = new Vector<String>();
                    addMap.add("lunMapLUNNo=" + unitNumber);
                    addMap.add("lunMaskAccess=" + this.convertCIMToT4Access(accessMode));
                    try {
                        DevComm.getInstance().post(this.getSystem(), addMap, "lunMaskPermAllWWN");
                    }
                    catch (ArrayException e) {
                        WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AccessControlInformation" + " Unable to set default access " + addMap + " " + e.getMessage()));
                        WBEMDebug.trace2((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AccessControlInformation"), (Throwable)e);
                        throw new CIMException("CIM_ERR_FAILED");
                    }
                    catch (StorEdgeIOException e) {
                        WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AccessControlInformation" + " Unable to set default access " + addMap + " " + e.getMessage()));
                        WBEMDebug.trace2((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AccessControlInformation"), (Throwable)e);
                        CIMException tmpE = new CIMException("CIM_ERR_FAILED");
                        tmpE.setDescription(e.getMessage());
                        throw tmpE;
                    }
                }
                tmp = vGroups[vCount].getProperty("DeviceID");
                WBEMDebug.trace3((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AccessControlInformation" + " Operating on vGroup " + vGroups[vCount].getObjectPath()));
                String vGroupName = (String)tmp.getValue().getValue();
                CIMInstance[] iGroups = RequestBroker.getInstance().associators(new CIMObjectPath("StorEdge_6120AuthorizationSubject", "\\root\\se6x20"), aciPath, "StorEdge_6120SystemSpecificCollection", null, null, true, false, null);
                if (iGroups == null || iGroups.length <= 0) {
                    WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AccessControlInformation" + " No iGroups found for ACI"));
                    throw new CIMException("CIM_ERR_FAILED");
                }
                if (luns != null) {
                    WBEMDebug.trace3((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AccessControlInformation" + " Volume Group: " + vGroups[vCount].getObjectPath()));
                    int i = 0;
                    while (i < luns.length) {
                        tmp = luns[i].getProperty("DeviceNumber");
                        int unitNumber = Integer.parseInt((String)tmp.getValue().getValue(), 10);
                        WBEMDebug.trace3((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AccessControlInformation" + " " + "Operating on LUN: " + tmp.getValue()));
                        int j = 0;
                        while (j < iGroups.length) {
                            tmp = iGroups[j].getProperty("ElementName");
                            String iGroupName = (String)tmp.getValue().getValue();
                            Vector<String> addMap = new Vector<String>();
                            addMap.add("lunMapLUNNo=" + unitNumber);
                            addMap.add("lunGroupName=" + iGroupName);
                            addMap.add("lunMaskAccess=" + this.convertCIMToT4Access(accessMode));
                            try {
                                DevComm.getInstance().post(this.getSystem(), addMap, "lunMaskPermGroup");
                            }
                            catch (ArrayException e) {
                                WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AccessControlInformation" + " Unable to set maskings " + addMap + " " + e.getMessage()));
                                WBEMDebug.trace2((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AccessControlInformation"), (Throwable)e);
                                throw new CIMException("CIM_ERR_FAILED");
                            }
                            catch (StorEdgeIOException e) {
                                WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AccessControlInformation" + " Unable to set maskings " + addMap + " " + e.getMessage()));
                                WBEMDebug.trace2((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AccessControlInformation"), (Throwable)e);
                                CIMException tmpE = new CIMException("CIM_ERR_FAILED");
                                tmpE.setDescription(e.getMessage());
                                throw tmpE;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                String groupAccess = "VolGroupAccess" + vGroupName;
                WBEMDebug.trace3((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AccessControlInformation" + " Operating on sysProp " + groupAccess));
                String[] req = new String[]{groupAccess};
                Properties props = null;
                try {
                    props = DevComm.getInstance().getSysProps(this.getSystem(), req);
                }
                catch (ArrayException e) {
                    WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AccessControlInformation" + " Unable to get sysProps from T4 " + req), (Throwable)e);
                    WBEMDebug.trace2((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AccessControlInformation"), (Throwable)e);
                    throw new CIMException("CIM_ERR_FAILED");
                }
                catch (StorEdgeIOException e) {
                    WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AccessControlInformation" + " Unable to get sysProps from T4 " + req), (Throwable)e);
                    WBEMDebug.trace2((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AccessControlInformation"), (Throwable)e);
                    CIMException tmpE = new CIMException("CIM_ERR_FAILED");
                    tmpE.setDescription(e.getMessage());
                    throw tmpE;
                }
                if (iGroups.length > 1) {
                    WBEMDebug.trace3((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AccessControlInformation" + " " + "Number of Initiator Groups returned: " + iGroups.length + " The algoritam may break."));
                }
                int j = 0;
                while (j < iGroups.length) {
                    tmp = iGroups[j].getProperty("ElementName");
                    String iGroupName = (String)tmp.getValue().getValue();
                    String members = props.getProperty(groupAccess) + ",";
                    WBEMDebug.trace3((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AccessControlInformation" + " " + "Before: " + members));
                    int start = members.indexOf(iGroupName + ":");
                    if (start < 0) {
                        WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AccessControlInformation" + " " + iGroupName + " not found in " + members));
                        throw new CIMException("CIM_ERR_FAILED");
                    }
                    start = members.indexOf(":", start);
                    int end = members.indexOf(",", start);
                    members = members.substring(0, start) + ":" + accessMode + members.substring(end);
                    props.setProperty(groupAccess, this.commaCleanup(members));
                    WBEMDebug.trace3((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AccessControlInformation" + " " + "After: " + members));
                    try {
                        DevComm.getInstance().setSysProps(this.getSystem(), props);
                    }
                    catch (ArrayException e) {
                        WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AccessControlInformation" + " Unable to update system properties " + e.getMessage()));
                        WBEMDebug.trace2((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AccessControlInformation"), (Throwable)e);
                        throw new CIMException("CIM_ERR_FAILED");
                    }
                    catch (StorEdgeIOException e) {
                        WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AccessControlInformation" + " Unable to update system properties " + e.getMessage()));
                        WBEMDebug.trace2((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AccessControlInformation"), (Throwable)e);
                        CIMException tmpE = new CIMException("CIM_ERR_FAILED");
                        tmpE.setDescription(e.getMessage());
                        throw tmpE;
                    }
                    ++j;
                }
                ++vCount;
            }
        }
        catch (NullPointerException npe) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AccessControlInformation" + " General failure " + npe.getMessage()));
            WBEMDebug.trace2((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AccessControlInformation" + " NPE: "), (Throwable)npe);
            throw new CIMException("CIM_ERR_FAILED");
        }
    }

    public void SetRequestStorEdge_6120AuthorizationViewSCSIController(SetRequest request) throws CIMException {
        String METHOD = "SetRequestStorEdge_6120AuthorizationViewSCSIController";
        WBEMDebug.trace3((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AuthorizationViewSCSIController" + " entered"));
        String newName = null;
        String oldName = null;
        if (request == null) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AuthorizationViewSCSIController" + " Null request argument. "));
            throw new CIMException("CIM_ERR_FAILED");
        }
        CIMInstance oldInst = RequestBroker.getInstance().getCacheInstance(request.getObjectPath());
        if (oldInst == null) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AuthorizationViewSCSIController" + " could not find " + "old volume group " + request.getObjectPath()));
            throw new CIMException("CIM_ERR_NOT_FOUND");
        }
        try {
            CIMProperty tmp = oldInst.getProperty("DeviceID");
            if (tmp == null) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AuthorizationViewSCSIController" + "Unable to get initiator group name " + oldInst));
                CIMException tmpe = new CIMException("CIM_ERR_FAILED");
                tmpe.setDescription("Missing Old Initiator Group Name property");
                throw tmpe;
            }
            oldName = (String)tmp.getValue().getValue();
            newName = (String)request.getPropertyValue("ElementName");
        }
        catch (Exception e) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AuthorizationViewSCSIController" + " internal error " + "encountered. " + e.getMessage()));
            WBEMDebug.trace2((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AuthorizationViewSCSIController"), (Throwable)e);
            CIMException tmp = new CIMException("CIM_ERR_FAILED");
            tmp.setDescription("Internal failure extracting new name from request " + e.getMessage());
            throw tmp;
        }
        Properties props = null;
        String oldVols = "VolGroupVols" + oldName;
        String oldAccess = "VolGroupAccess" + oldName;
        String newVols = "VolGroupVols" + newName;
        String newAccess = "VolGroupAccess" + newName;
        String[] req = new String[]{"VolGroupList", oldVols, oldAccess};
        try {
            props = DevComm.getInstance().getSysProps(this.getSystem(), req);
            String list = props.getProperty("VolGroupList");
            if (list.indexOf("," + newName + ",") >= 0 || list.startsWith(newName + ",") || list.endsWith("," + newName) || list.equals(newName)) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AuthorizationViewSCSIController" + " Volume Group \"" + newName + "\" already exists."));
                throw new CIMException("CIM_ERR_ALREADY_EXISTS");
            }
            props.setProperty(newVols, props.getProperty(oldVols));
            props.setProperty(newAccess, props.getProperty(oldAccess));
            props.setProperty(oldVols, DELETE);
            props.setProperty(oldAccess, DELETE);
            int start = list.indexOf(oldName);
            if (start < 0) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AuthorizationViewSCSIController" + " Volume Group \"" + oldName + "\" not found."));
                CIMException tmp = new CIMException("CIM_ERR_FAILED");
                tmp.setDescription("Unrecognized Volume Group " + oldName);
                throw tmp;
            }
            list = list.substring(0, start) + newName + list.substring(start + oldName.length());
            props.setProperty("VolGroupList", list);
            DevComm.getInstance().setSysProps(this.getSystem(), props);
        }
        catch (CIMException e1) {
            throw e1;
        }
        catch (Exception e) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AuthorizationViewSCSIController" + " IO failure: " + e.getMessage()));
            WBEMDebug.trace2((String)(CLASSNAME + "." + "SetRequestStorEdge_6120AuthorizationViewSCSIController"), (Throwable)e);
            CIMException tmp = new CIMException("CIM_ERR_FAILED");
            tmp.setDescription("IO failure communicating to array: " + e.getMessage());
            throw tmp;
        }
    }

    public synchronized void InvokeRequestStorEdge_6120AuthorizationViewSCSIController(InvokeRequest request) throws CIMException {
        String METHOD = "InvokeRequestStorEdge_6120AuthorizationViewSCSIController";
        WBEMDebug.trace3((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController" + " entered"));
        if (request == null) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController" + " Null request argument. "));
            throw new CIMException("CIM_ERR_FAILED");
        }
        boolean isAttachDevice = request.getMethodName().equalsIgnoreCase("attachDevice");
        String groupVols = "VolGroupVols" + request.getKeyValue("DeviceID");
        String groupAccess = "VolGroupAccess" + request.getKeyValue("DeviceID");
        String guid = null;
        CIMObjectPath volp = null;
        CIMInstance vol = null;
        try {
            volp = (CIMObjectPath)request.getInParamValue(0);
            vol = RequestBroker.getInstance().getCacheInstance(volp);
            if (vol == null) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController" + " Unrecognised GUID.  Not found in cache " + volp));
                request.setResults(_MASK_SERVICE_INVALID_VOLUME);
                return;
            }
            guid = (String)vol.getProperty("DeviceID").getValue().getValue();
        }
        catch (Exception e) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController" + " Unable to extract GUID from AuthViewSCSIController " + " request " + e.getMessage()));
            WBEMDebug.trace2((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController"), (Throwable)e);
            CIMException tmp = new CIMException("CIM_ERR_FAILED");
            tmp.setDescription(" Unable to extract GUID from AuthViewSCSIController request " + e);
            throw tmp;
        }
        String[] req = new String[]{groupVols, groupAccess};
        Properties props = null;
        Properties allProps = null;
        try {
            props = DevComm.getInstance().getSysProps(this.getSystem(), req);
            if (isAttachDevice) {
                allProps = DevComm.getInstance().getSysProps(this.getSystem(), null);
            }
        }
        catch (ArrayException e) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController" + " Unable to get volume group from T4 " + groupVols + " " + e.getMessage()));
            WBEMDebug.trace2((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController"), (Throwable)e);
            request.setResults(_MASK_SERVICE_FAILED);
            return;
        }
        catch (StorEdgeIOException e) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController" + " Unable to get volume group from T4 " + groupVols + " " + e.getMessage()));
            WBEMDebug.trace2((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController"), (Throwable)e);
            CIMException tmp = new CIMException("CIM_ERR_FAILED");
            tmp.setDescription(e.getMessage());
            throw tmp;
        }
        int unitNumber = this.getUnitNumber(vol.getObjectPath());
        WBEMDebug.trace3((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController" + " Looking for ACIs for this vol group " + request.getObjectPath()));
        CIMObjectPath op = request.getObjectPath();
        op.setNameSpace("\\root\\se6x20");
        CIMInstance[] acis = RequestBroker.getInstance().associators(new CIMObjectPath("StorEdge_6120AuthorizationTarget", "\\root\\se6x20"), op, "StorEdge_6120AccessControlInformation", null, null, true, false, null);
        if (isAttachDevice) {
            if (guid != null && allProps != null) {
                Pattern pat = Pattern.compile("\\b" + guid + "\\b");
                Enumeration<?> allPropKeys = allProps.propertyNames();
                while (allPropKeys.hasMoreElements()) {
                    Matcher match;
                    String val;
                    String keyProp = (String)allPropKeys.nextElement();
                    if (!keyProp.startsWith("VolGroupVols") || (val = (String)allProps.get(keyProp)) == null || !(match = pat.matcher(val)).find()) continue;
                    WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController" + " Volume already a member of a volume group." + volp));
                    request.setResults(_MASK_SERVICE_INVALID_VOLUME);
                    return;
                }
            }
            if (acis == null) {
                WBEMDebug.trace3((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController" + " sysProp " + groupAccess + " setting was: " + props.getProperty(groupAccess)));
                if (props.getProperty(groupAccess) != null && props.getProperty(groupAccess).length() > 1) {
                    WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController" + " Internal failure.  Unable to get ACI " + "associations for " + request.getObjectPath() + " yet sysProp shows there is access granted " + props.getProperty(groupAccess)));
                } else {
                    WBEMDebug.trace3((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController" + " No ACIs found for this vol group " + request.getObjectPath()));
                }
            } else if (acis.length > 0) {
                int i = 0;
                while (i < acis.length) {
                    CIMObjectPath acip = acis[i].getObjectPath();
                    acip.setNameSpace("\\root\\se6x20");
                    CIMInstance[] iGroups = RequestBroker.getInstance().associators(new CIMObjectPath("StorEdge_6120AuthorizationSubject", "\\root\\se6x20"), acip, "StorEdge_6120SystemSpecificCollection", null, null, true, false, null);
                    if (iGroups == null) {
                        WBEMDebug.trace3((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController" + " Unable to get volume groups for ACI " + acis[i]));
                    } else {
                        int j = 0;
                        while (j < iGroups.length) {
                            CIMProperty tmp = acis[i].getProperty("AccessType");
                            if (tmp == null) {
                                WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController" + "Unable to get access mode" + acis[i]));
                                CIMException tmpe = new CIMException("CIM_ERR_FAILED");
                                tmpe.setDescription("Missing access mode");
                                throw tmpe;
                            }
                            Vector access = (Vector)tmp.getValue().getValue();
                            tmp = iGroups[j].getProperty("ElementName");
                            if (tmp == null) {
                                WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController" + "Unable to get Initiator Group name" + iGroups[j]));
                                CIMException tmpe = new CIMException("CIM_ERR_FAILED");
                                tmpe.setDescription("Missing group name");
                                throw tmpe;
                            }
                            String iGroupName = (String)tmp.getValue().getValue();
                            Vector<String> addMap = new Vector<String>();
                            addMap.add("lunMapLUNNo=" + unitNumber);
                            addMap.add("lunGroupName=" + iGroupName);
                            addMap.add("lunMaskAccess=" + this.convertCIMToT4Access((String)access.elementAt(0)));
                            try {
                                DevComm.getInstance().post(this.getSystem(), addMap, "lunMaskPermGroup");
                            }
                            catch (ArrayException e) {
                                WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController" + " Unable to set maskings " + addMap + " " + e.getMessage()));
                                WBEMDebug.trace2((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController"), (Throwable)e);
                                request.setResults(_MASK_SERVICE_FAILED);
                                return;
                            }
                            catch (StorEdgeIOException e) {
                                WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController" + " Unable to set maskings " + addMap + " " + e.getMessage()));
                                WBEMDebug.trace2((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController"), (Throwable)e);
                                CIMException tmpE = new CIMException("CIM_ERR_FAILED");
                                tmpE.setDescription(e.getMessage());
                                throw tmpE;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            } else {
                WBEMDebug.trace3((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController" + " Unable to get ACI associations for " + request.getObjectPath()));
            }
            try {
                props.setProperty(groupVols, this.commaCleanup(props.getProperty(groupVols) + "," + guid + ","));
                DevComm.getInstance().setSysProps(this.getSystem(), props);
            }
            catch (ArrayException e) {
                request.setResults(_MASK_SERVICE_FAILED);
                return;
            }
            catch (StorEdgeIOException e) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController" + " IO error communicating to T4: " + e.getMessage()));
                WBEMDebug.trace2((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController"), (Throwable)e);
                CIMException tmp = new CIMException("CIM_ERR_FAILED");
                tmp.setDescription(e.getMessage());
                throw tmp;
            }
        }
        if (request.getMethodName().equalsIgnoreCase("removeDevice")) {
            if (acis == null) {
                WBEMDebug.trace3((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController" + " Unable to get ACI associations for " + request.getObjectPath()));
            } else if (acis.length > 0) {
                int i = 0;
                while (i < acis.length) {
                    CIMObjectPath acip = acis[i].getObjectPath();
                    acip.setNameSpace("\\root\\se6x20");
                    CIMInstance[] iGroups = RequestBroker.getInstance().associators(new CIMObjectPath("StorEdge_6120AuthorizationSubject", "\\root\\se6x20"), acip, "StorEdge_6120SystemSpecificCollection", null, null, true, false, null);
                    if (iGroups == null) {
                        WBEMDebug.trace3((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController" + " Unable to get volume groups for ACI " + acis[i]));
                    } else {
                        int j = 0;
                        while (j < iGroups.length) {
                            CIMProperty tmp = iGroups[j].getProperty("ElementName");
                            if (tmp == null) {
                                WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController" + "Unable to get Initiator Group name" + iGroups[j]));
                                CIMException tmpe = new CIMException("CIM_ERR_FAILED");
                                tmpe.setDescription("Missing group name");
                                throw tmpe;
                            }
                            String iGroupName = (String)tmp.getValue().getValue();
                            Vector<String> addMap = new Vector<String>();
                            addMap.add("lunMapLUNNo=" + unitNumber);
                            addMap.add("lunGroupName=" + iGroupName);
                            addMap.add("lunMaskAccess=none");
                            try {
                                DevComm.getInstance().post(this.getSystem(), addMap, "lunMaskPermGroup");
                            }
                            catch (ArrayException e) {
                                WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController" + " Unable to set maskings " + addMap + " " + e.getMessage()));
                                WBEMDebug.trace2((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController"), (Throwable)e);
                                request.setResults(_MASK_SERVICE_FAILED);
                                return;
                            }
                            catch (StorEdgeIOException e) {
                                WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController" + " Unable to set maskings " + addMap + " " + e.getMessage()));
                                WBEMDebug.trace2((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController"), (Throwable)e);
                                CIMException tmpE = new CIMException("CIM_ERR_FAILED");
                                tmpE.setDescription(e.getMessage());
                                throw tmpE;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            try {
                String members = this.commaCleanup(this.subtractString(props.getProperty(groupVols), guid));
                props.setProperty(groupVols, members);
                DevComm.getInstance().setSysProps(this.getSystem(), props);
            }
            catch (ArrayException e) {
                request.setResults(_MASK_SERVICE_FAILED);
                return;
            }
            catch (StorEdgeIOException e) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController" + " IO error communicating to T4: " + e.getMessage()));
                WBEMDebug.trace2((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController"), (Throwable)e);
                CIMException tmp = new CIMException("CIM_ERR_FAILED");
                tmp.setDescription(e.getMessage());
                throw tmp;
            }
            catch (NoSuchElementException e2) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController" + " Failed attempt to remove a volume (" + guid + ") that wasn't in the group (" + groupVols + "=" + props.getProperty(groupVols)));
                WBEMDebug.trace2((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController" + "Volume Group = " + request.getObjectPath()));
                WBEMDebug.trace2((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController" + "Volume = " + volp));
                request.setResults(_MASK_SERVICE_INVALID_VOLUME);
                return;
            }
        }
        WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationViewSCSIController" + " Method \"" + request.getMethodName() + "\" does not exist"));
        throw new CIMMethodException("NO_SUCH_METHOD");
        request.setResults(_MASK_SERVICE_OK);
    }

    public void InvokeRequestStorEdge_6120PortSCSIController(InvokeRequest request) throws CIMException {
        String METHOD = "InvokeRequestStorEdge_6120PortSCSIController";
        WBEMDebug.trace3((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120PortSCSIController" + " entered"));
        if (request == null) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120PortSCSIController" + " Null request argument. "));
            throw new CIMException("CIM_ERR_FAILED");
        }
        String[] req = new String[]{"VolGroupList"};
        Properties props = null;
        try {
            props = DevComm.getInstance().getSysProps(this.getSystem(), req);
        }
        catch (ArrayException e) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120PortSCSIController" + " Unable to get volume group list from T4 " + e.getMessage()));
            WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120PortSCSIController"), (Throwable)e);
            request.setResults(_MASK_SERVICE_FAILED);
            return;
        }
        catch (StorEdgeIOException e) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120PortSCSIController" + " Unable to get volume group list from T4 " + e.getMessage()));
            WBEMDebug.trace2((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120PortSCSIController"), (Throwable)e);
            CIMException tmp = new CIMException("CIM_ERR_FAILED");
            tmp.setDescription(e.getMessage());
            throw tmp;
        }
        if (request.getMethodName().equalsIgnoreCase("createViewWithName")) {
            String name = null;
            name = request.getInParamValue(0) != null ? (String)request.getInParamValue(0) : Long.toString(Calendar.getInstance().getTimeInMillis());
            CIMOMHandle cimom = StorEdge_6120ArrayProvider.getCIMOMHandle();
            if (cimom == null) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120PortSCSIController" + " CIMOM handle is null.  Unable to proceed. "));
                CIMException tmp = new CIMException("CIM_ERR_FAILED");
                tmp.setDescription("Internal error: null CIMOM handle.");
                throw tmp;
            }
            CIMObjectPath tmp = new CIMObjectPath("StorEdge_6120AuthorizationViewSCSIController");
            tmp.setNameSpace(request.getObjectPath().getNameSpace());
            CIMClass avcClass = cimom.getClass(tmp, false, true, false, null);
            if (avcClass == null) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120PortSCSIController" + " Unable to get AuthView SCSI controller. "));
                CIMException tmpe = new CIMException("CIM_ERR_FAILED");
                tmpe.setDescription("Internal error: Failed getClass.");
                throw tmpe;
            }
            CIMInstance avc = avcClass.newInstance();
            avc.setProperty("SystemCreationClassName", new CIMValue((Object)"StorEdge_6120Cluster"));
            avc.setProperty("SystemName", new CIMValue((Object)((String)request.getKeyValue("SystemName"))));
            avc.setProperty("CreationClassName", new CIMValue((Object)"StorEdge_6120AuthorizationViewSCSIController"));
            avc.setProperty("DeviceID", new CIMValue((Object)name));
            avc.setProperty("ElementName", new CIMValue((Object)name));
            CIMArgument[] outArgs = request.getOutParams();
            WBEMDebug.trace3((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120PortSCSIController" + " Out args length: " + outArgs.length));
            outArgs[0] = new CIMArgument("View", new CIMValue((Object)avc.getObjectPath()));
            try {
                String oldList = props.getProperty("VolGroupList");
                if (oldList == null) {
                    oldList = "";
                } else if (this.isInCommaList(oldList, name)) {
                    WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120PortSCSIController" + " requested Volume Group \"" + name + "\" already stored."));
                    request.setResults(_MASK_SERVICE_FAILED);
                    return;
                }
                props.setProperty("VolGroupList", this.commaCleanup(oldList + "," + name + ","));
                props.setProperty("VolGroupVols" + name, EMPTY);
                props.setProperty("VolGroupAccess" + name, EMPTY);
                DevComm.getInstance().setSysProps(this.getSystem(), props);
            }
            catch (ArrayException e) {
                request.setResults(_MASK_SERVICE_FAILED);
                return;
            }
            catch (StorEdgeIOException e) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120PortSCSIController" + " IO error communicating to T4: " + e.getMessage()));
                WBEMDebug.trace2((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120PortSCSIController"), (Throwable)e);
                CIMException tmpE = new CIMException("CIM_ERR_FAILED");
                tmpE.setDescription(e.getMessage());
                throw tmpE;
            }
        }
        if (request.getMethodName().equalsIgnoreCase("deleteView")) {
            String name = null;
            CIMObjectPath volGroup = null;
            try {
                volGroup = (CIMObjectPath)request.getInParamValue(0);
                volGroup.setNameSpace("\\root\\se6x20");
                Vector vec = volGroup.getKeys();
                int i = 0;
                while (i < vec.size()) {
                    CIMProperty prop = (CIMProperty)vec.elementAt(i);
                    if (prop.getName().equalsIgnoreCase("DeviceID")) {
                        name = (String)prop.getValue().getValue();
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120PortSCSIController" + " Unable to extract view name from port SCSI " + "controller request " + e.getMessage()));
                WBEMDebug.trace2((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120PortSCSIController"), (Throwable)e);
                CIMException tmp = new CIMException("CIM_ERR_FAILED");
                tmp.setDescription(" Unable to extract view name from port SCSI controller request " + e);
                throw tmp;
            }
            CIMInstance[] acis = RequestBroker.getInstance().associators(new CIMObjectPath("StorEdge_6120AuthorizationTarget", "\\root\\se6x20"), volGroup, "StorEdge_6120AccessControlInformation", null, null, true, false, null);
            if (acis != null && acis.length > 0) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120PortSCSIController" + " User Error:  The Volume Group " + name + " has assigned access.  The ACI " + "instances must be removed first."));
                request.setResults(_MASK_SERVICE_FAILED);
                return;
            }
            try {
                String members = this.commaCleanup(this.subtractString(props.getProperty("VolGroupList"), name));
                props.setProperty("VolGroupList", members);
                props.setProperty("VolGroupVols" + name, DELETE);
                props.setProperty("VolGroupAccess" + name, DELETE);
                DevComm.getInstance().setSysProps(this.getSystem(), props);
            }
            catch (ArrayException e) {
                request.setResults(_MASK_SERVICE_FAILED);
                return;
            }
            catch (StorEdgeIOException e) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120PortSCSIController" + " IO error communicating to T4: " + e.getMessage()));
                WBEMDebug.trace2((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120PortSCSIController"), (Throwable)e);
                CIMException tmp = new CIMException("CIM_ERR_FAILED");
                tmp.setDescription(e.getMessage());
                throw tmp;
            }
            catch (NoSuchElementException e2) {
                request.setResults(_MASK_SERVICE_INVALID_PARAM);
                return;
            }
        }
        if (request.getMethodName().equalsIgnoreCase("deleteViewWithCleanup")) {
            this.deleteViewWithCleanup(request);
        } else {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "InvokeRequestStorEdge_6120PortSCSIController" + " Method \"" + request.getMethodName() + "\" does not exist"));
            throw new CIMMethodException("NO_SUCH_METHOD");
        }
        request.setResults(_MASK_SERVICE_OK);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void InvokeRequestStorEdge_6120AuthorizationService(InvokeRequest request) throws CIMException {
        METHOD = "InvokeRequestStorEdge_6120AuthorizationService";
        WBEMDebug.trace3((String)(ModifyMasking.CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationService" + " entered"));
        if (request == null) {
            WBEMDebug.trace1((String)(ModifyMasking.CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationService" + " Null request argument. "));
            throw new CIMException("CIM_ERR_FAILED");
        }
        initGroupPath = null;
        initGroup = null;
        targets = null;
        iGroupName = null;
        try {
            initGroupPath = (CIMObjectPath)request.getInParamValue(0);
            initGroup = RequestBroker.getInstance().getCacheInstance(initGroupPath);
            tmp /* !! */  = initGroup.getProperty("ElementName");
            if (tmp /* !! */  == null) {
                WBEMDebug.trace1((String)(ModifyMasking.CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationService" + "Unable to get Initiator Group name" + initGroup));
                tmpe = new CIMException("CIM_ERR_FAILED");
                tmpe.setDescription("Missing initiator group name");
                throw tmpe;
            }
            iGroupName = (String)tmp /* !! */ .getValue().getValue();
        }
        catch (Exception e) {
            WBEMDebug.trace1((String)(ModifyMasking.CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationService" + " Unable to extract initiator group from " + "request " + e.getMessage()));
            WBEMDebug.trace2((String)(ModifyMasking.CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationService"), (Throwable)e);
            tmp = new CIMException("CIM_ERR_FAILED");
            tmp.setDescription(" Unable to extract initiator group from request " + e);
            throw tmp;
        }
        if (iGroupName == null) {
            WBEMDebug.trace1((String)(ModifyMasking.CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationService" + " Unable to find init group " + initGroupPath));
            tmp /* !! */  = new CIMException("CIM_ERR_FAILED");
            tmp /* !! */ .setDescription(" Unable to find init group " + initGroupPath);
            throw tmp /* !! */ ;
        }
        try {
            targPaths = (Vector)request.getInParamValue(2);
            targets = new String[targPaths.size()];
            i = 0;
            while (i < targPaths.size()) {
                targPath = (String)targPaths.elementAt(i);
                WBEMDebug.trace3((String)(ModifyMasking.CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationService" + " Extracted targPaths[" + i + "] = \"" + targPath + "\""));
                start = targPath.indexOf("DeviceID=\\\"");
                start = targPath.indexOf("\\\"", start) + 2;
                end = targPath.indexOf("\\\"", start);
                targets[i] = targPath.substring(start, end);
                WBEMDebug.trace3((String)(ModifyMasking.CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationService" + " Extracted targets[" + i + "] = " + targets[i]));
                ++i;
            }
        }
        catch (Exception e) {
            WBEMDebug.trace1((String)(ModifyMasking.CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationService" + " Unable to extract targets from " + "request:" + e.getMessage()));
            WBEMDebug.trace2((String)(ModifyMasking.CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationService"), (Throwable)e);
            tmp = new CIMException("CIM_ERR_FAILED");
            tmp.setDescription(" Unable to extract targets from request " + e);
            throw tmp;
        }
        accessMode = null;
        if (request.getMethodName().equalsIgnoreCase("assignAccess")) {
            aciPath = null;
            aci = null;
            try {
                aciPath = (CIMObjectPath)request.getInParamValue(1);
                aci = RequestBroker.getInstance().getCacheInstance(aciPath);
                tmp = aci.getProperty("AccessType");
                if (tmp == null) {
                    WBEMDebug.trace1((String)(ModifyMasking.CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationService" + "Unable to get access mode " + aci));
                    tmpe = new CIMException("CIM_ERR_FAILED");
                    tmpe.setDescription("Missing access mode");
                    throw tmpe;
                }
                access = (Vector)tmp.getValue().getValue();
                accessMode = (String)access.elementAt(0);
                if (!RequestBroker.getInstance().isSyntheticCacheInstance(aci.getObjectPath())) ** GOTO lbl85
                RequestBroker.getInstance().deleteSyntheticCacheInstance(aci.getObjectPath());
            }
            catch (Exception e) {
                WBEMDebug.trace1((String)(ModifyMasking.CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationService" + " Unable to extract ACI from " + "request: " + e.getMessage()));
                WBEMDebug.trace2((String)(ModifyMasking.CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationService"), (Throwable)e);
                tmp = new CIMException("CIM_ERR_FAILED");
                tmp.setDescription(" Unable to extract ACI from request " + e);
                throw tmp;
            }
        } else if (request.getMethodName().equalsIgnoreCase("removeAccess")) {
            accessMode = "none";
        } else {
            WBEMDebug.trace1((String)(ModifyMasking.CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationService" + " Unrecognized method " + request.getMethodName()));
            tmp = new CIMException("CIM_ERR_FAILED");
            tmp.setDescription(" Unrecognized method " + request.getMethodName());
            throw tmp;
        }
lbl85:
        // 3 sources

        WBEMDebug.trace3((String)(ModifyMasking.CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationService" + " Updating T4..."));
        props = null;
        i = 0;
        while (i < targets.length) {
            groupVols = "VolGroupVols" + targets[i];
            groupAccess = "VolGroupAccess" + targets[i];
            req = new String[]{groupVols, groupAccess};
            WBEMDebug.trace3((String)(ModifyMasking.CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationService" + " Working on " + groupVols + " " + groupAccess));
            try {
                props = DevComm.getInstance().getSysProps(this.getSystem(), req);
            }
            catch (ArrayException e) {
                WBEMDebug.trace1((String)(ModifyMasking.CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationService" + " Unable to get volume group from T4 " + groupVols + " " + e.getMessage()));
                WBEMDebug.trace2((String)(ModifyMasking.CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationService"), (Throwable)e);
                request.setResults(ModifyMasking._MASK_SERVICE_FAILED);
                return;
            }
            catch (StorEdgeIOException e) {
                WBEMDebug.trace1((String)(ModifyMasking.CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationService" + " Unable to get volume group from T4 " + groupVols + " " + e.getMessage()));
                WBEMDebug.trace2((String)(ModifyMasking.CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationService"), (Throwable)e);
                tmp = new CIMException("CIM_ERR_FAILED");
                tmp.setDescription(e.getMessage());
                throw tmp;
            }
            if (request.getMethodName().equalsIgnoreCase("assignAccess") && (start = (members = props.getProperty(groupAccess)).indexOf(iGroupName + ":")) >= 0) {
                WBEMDebug.trace1((String)(ModifyMasking.CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationService" + " User attempted to assign duplicate access."));
                request.setResults(ModifyMasking._MASK_SERVICE_DUPLICATE);
                return;
            }
            tok = new StringTokenizer(props.getProperty(groupVols), ",");
            while (tok.hasMoreTokens()) {
                volPath = new CIMObjectPath("StorEdge_6120StorageVolume");
                volPath.addKey("SystemCreationClassName", new CIMValue((Object)"StorEdge_6120Cluster"));
                volPath.addKey("SystemName", new CIMValue(request.getKeyValue("SystemName")));
                volPath.addKey("CreationClassName", new CIMValue((Object)"StorEdge_6120StorageVolume"));
                volPath.addKey("DeviceID", new CIMValue((Object)tok.nextToken()));
                vol = RequestBroker.getInstance().getCacheInstance(volPath);
                if (vol == null) {
                    WBEMDebug.trace3((String)(ModifyMasking.CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationService" + " Unable to get volume from cache " + volPath));
                    continue;
                }
                unitNumber = this.getUnitNumber(vol.getObjectPath());
                addMap = new Vector<String>();
                addMap.add("lunMapLUNNo=" + unitNumber);
                addMap.add("lunGroupName=" + iGroupName);
                addMap.add("lunMaskAccess=" + this.convertCIMToT4Access(accessMode));
                try {
                    DevComm.getInstance().post(this.getSystem(), addMap, "lunMaskPermGroup");
                }
                catch (ArrayException e) {
                    WBEMDebug.trace1((String)(ModifyMasking.CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationService" + " Unable to set maskings " + addMap + " " + e.getMessage()));
                    WBEMDebug.trace2((String)(ModifyMasking.CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationService"), (Throwable)e);
                    request.setResults(ModifyMasking._MASK_SERVICE_FAILED);
                    return;
                }
                catch (StorEdgeIOException e) {
                    WBEMDebug.trace1((String)(ModifyMasking.CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationService" + " Unable to set maskings " + addMap + " " + e.getMessage()));
                    WBEMDebug.trace2((String)(ModifyMasking.CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationService"), (Throwable)e);
                    tmp = new CIMException("CIM_ERR_FAILED");
                    tmp.setDescription(e.getMessage());
                    throw tmp;
                }
            }
            WBEMDebug.trace3((String)(ModifyMasking.CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationService" + " Old " + groupAccess + " = " + props.getProperty(groupAccess)));
            if (request.getMethodName().equalsIgnoreCase("assignAccess")) {
                props.setProperty(groupAccess, this.commaCleanup(props.getProperty(groupAccess) + "," + iGroupName + ":" + accessMode + ","));
            } else {
                members = props.getProperty(groupAccess) + ",";
                start = members.indexOf(iGroupName + ":");
                if (start < 0) {
                    throw new NoSuchElementException(iGroupName + " not found in " + members);
                }
                end = members.indexOf(",", start + iGroupName.length() + 1);
                members = members.substring(0, start) + members.substring(end);
                props.setProperty(groupAccess, this.commaCleanup(members));
            }
            WBEMDebug.trace3((String)(ModifyMasking.CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationService" + " New " + groupAccess + " = " + props.getProperty(groupAccess)));
            try {
                DevComm.getInstance().setSysProps(this.getSystem(), props);
            }
            catch (ArrayException e) {
                WBEMDebug.trace1((String)(ModifyMasking.CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationService" + " Unable to update sysProp " + props + " " + e.getMessage()));
                WBEMDebug.trace2((String)(ModifyMasking.CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationService"), (Throwable)e);
                request.setResults(ModifyMasking._MASK_SERVICE_FAILED);
                return;
            }
            catch (StorEdgeIOException e) {
                WBEMDebug.trace1((String)(ModifyMasking.CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationService" + " Unable to update sysProp " + props + " " + e.getMessage()));
                WBEMDebug.trace2((String)(ModifyMasking.CLASSNAME + "." + "InvokeRequestStorEdge_6120AuthorizationService"), (Throwable)e);
                tmp = new CIMException("CIM_ERR_FAILED");
                tmp.setDescription(e.getMessage());
                throw tmp;
            }
            ++i;
        }
        request.setResults(ModifyMasking._MASK_SERVICE_OK);
    }

    public void SetRequestStorEdge_6120MappedSCSILUN(SetRequest request) throws CIMException {
        String METHOD = "SetRequestStorEdge_6120MappedSCSILUN";
        WBEMDebug.trace3((String)(CLASSNAME + "." + "SetRequestStorEdge_6120MappedSCSILUN" + " entered"));
        int oldLUN = -1;
        int newLUN = -1;
        String sliceNum = null;
        CIMProperty tmpProp = null;
        if (request == null) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120MappedSCSILUN" + " Null request argument. "));
            throw new CIMException("CIM_ERR_FAILED");
        }
        try {
            CIMObjectPath target = request.getObjectPath();
            CIMInstance oldLUNInstance = RequestBroker.getInstance().getCacheInstance(request.getObjectPath());
            if (oldLUNInstance == null) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120MappedSCSILUN" + " unable to locate " + "old LUN. "));
                WBEMDebug.trace2((String)(CLASSNAME + "." + "SetRequestStorEdge_6120MappedSCSILUN" + " Client specified LUN " + "not found in cache: " + target));
                CIMException tmp = new CIMException("CIM_ERR_FAILED");
                tmp.setDescription("Unable to locate old LUN.");
                throw tmp;
            }
            tmpProp = oldLUNInstance.getProperty("DeviceNumber");
            if (tmpProp == null) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120MappedSCSILUN" + " unable to locate " + "old LUN information. "));
                CIMException tmp = new CIMException("CIM_ERR_FAILED");
                tmp.setDescription("Unable to locate old LUN information");
                throw tmp;
            }
            try {
                oldLUN = Integer.parseInt((String)tmpProp.getValue().getValue(), 10);
            }
            catch (Exception e) {
                oldLUN = -1;
            }
            if (oldLUN == 65535) {
                oldLUN = -1;
            }
            CIMObjectPath volPath = (CIMObjectPath)oldLUNInstance.getProperty("Dependent").getValue().getValue();
            CIMInstance volInstance = RequestBroker.getInstance().getCacheInstance(volPath);
            if (volInstance == null) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120MappedSCSILUN" + " unable to locate " + "volume. " + volPath));
                CIMException tmp = new CIMException("CIM_ERR_FAILED");
                tmp.setDescription("Unable to locate volume." + volPath);
                throw tmp;
            }
            tmpProp = volInstance.getProperty("ElementName");
            if (tmpProp == null) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120MappedSCSILUN" + " unable to locate " + "Volume slice number. "));
                CIMException tmp = new CIMException("CIM_ERR_FAILED");
                tmp.setDescription("Unable to locate volume slice number");
                throw tmp;
            }
            sliceNum = (String)tmpProp.getValue().getValue();
            try {
                newLUN = Integer.parseInt((String)request.getPropertyValue("DeviceNumber"), 10);
            }
            catch (Exception e) {
                newLUN = -1;
            }
        }
        catch (Exception e) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120MappedSCSILUN" + " internal error " + "encountered extracting unit number from request. " + e.getMessage()));
            WBEMDebug.trace2((String)(CLASSNAME + "." + "SetRequestStorEdge_6120MappedSCSILUN"), (Throwable)e);
            CIMException tmp = new CIMException("CIM_ERR_FAILED");
            tmp.setDescription("Internal failure extracting Unit Number from request " + e.getMessage());
            throw tmp;
        }
        try {
            if (oldLUN != newLUN) {
                this.changeLUN(oldLUN, newLUN, sliceNum);
            }
        }
        catch (Exception e) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120MappedSCSILUN" + " IO failure: " + e.getMessage()));
            WBEMDebug.trace2((String)(CLASSNAME + "." + "SetRequestStorEdge_6120MappedSCSILUN"), (Throwable)e);
            CIMException tmp = new CIMException("CIM_ERR_FAILED");
            tmp.setDescription("IO failure communicating to array: " + e.getMessage());
            throw tmp;
        }
    }

    public void CreateRequestStorEdge_6120HostedCollection(CreateRequest request) throws CIMException {
        Object tmp;
        String METHOD = "CreateRequestStorEdge_6120HostedCollection";
        WBEMDebug.trace3((String)(CLASSNAME + "." + "CreateRequestStorEdge_6120HostedCollection" + " entered"));
        String iGroupName = null;
        if (request == null) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "CreateRequestStorEdge_6120HostedCollection" + " Null request argument. "));
            throw new CIMException("CIM_ERR_FAILED");
        }
        CIMObjectPath iGroupRef = null;
        try {
            iGroupRef = (CIMObjectPath)request.getKeyValue("Dependent");
            CIMInstance iGroup = RequestBroker.getInstance().getCacheInstance(iGroupRef);
            tmp = iGroup.getProperty("ElementName");
            if (tmp == null) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "CreateRequestStorEdge_6120HostedCollection" + " unable to get " + "Initiator group name. "));
                CIMException tmpe = new CIMException("CIM_ERR_FAILED");
                tmpe.setDescription("Unable to get initiator group name");
                throw tmpe;
            }
            iGroupName = (String)tmp.getValue().getValue();
        }
        catch (Exception e) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "CreateRequestStorEdge_6120HostedCollection" + " internal error " + "encountered. " + request.getNewInstance() + " " + e.getMessage()));
            WBEMDebug.trace2((String)(CLASSNAME + "." + "CreateRequestStorEdge_6120HostedCollection"), (Throwable)e);
            CIMException tmp2 = new CIMException("CIM_ERR_FAILED");
            tmp2.setDescription("Internal failure extracting group from request " + e.getMessage());
            throw tmp2;
        }
        try {
            Vector<String> postv = new Vector<String>();
            postv.add("lunGroupName=" + iGroupName);
            postv.add("lunGroupWWN=" + BOGUS_WWN);
            DevComm.getInstance().post(this.getSystem(), postv, "lunGroupAddWWN");
            DevComm.getInstance().post(this.getSystem(), postv, "lunGroupRemoveWWN");
            Vector<String> cleanup = new Vector<String>();
            cleanup.add("lunMaskWWN=" + BOGUS_WWN);
            DevComm.getInstance().post(this.getSystem(), cleanup, "lunWWNRemove");
        }
        catch (Exception e) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "CreateRequestStorEdge_6120HostedCollection" + " IO failure: "), (Throwable)e);
            WBEMDebug.trace2((String)(CLASSNAME + "." + "CreateRequestStorEdge_6120HostedCollection"), (Throwable)e);
            tmp = new CIMException("CIM_ERR_FAILED");
            tmp.setDescription("IO failure communicating to array: " + e.getMessage());
            throw tmp;
        }
        RequestBroker.getInstance().deleteSyntheticCacheInstance(iGroupRef);
        request.setResults(request.getNewInstance().getObjectPath());
    }

    public void DeleteRequestStorEdge_6120HostedCollection(DeleteRequest request) throws CIMException {
        String METHOD = "DeleteRequestStorEdge_6120HostedCollection";
        WBEMDebug.trace3((String)(CLASSNAME + "." + "DeleteRequestStorEdge_6120HostedCollection" + " entered"));
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void CreateRequestStorEdge_6120MemberOfCollection(CreateRequest request) throws CIMException {
        String METHOD = "CreateRequestStorEdge_6120MemberOfCollection";
        WBEMDebug.trace3((String)(CLASSNAME + "." + "CreateRequestStorEdge_6120MemberOfCollection" + " entered"));
        if (request == null) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "CreateRequestStorEdge_6120MemberOfCollection" + " Null request argument. "));
            throw new CIMException("CIM_ERR_FAILED");
        }
        this.processIGroupChange(request, "lunGroupAddWWN");
        request.setResults(request.getObjectPath());
    }

    public void DeleteRequestStorEdge_6120MemberOfCollection(DeleteRequest request) throws CIMException {
        String METHOD = "DeleteRequestStorEdge_6120MemberOfCollection";
        WBEMDebug.trace3((String)(CLASSNAME + "." + "DeleteRequestStorEdge_6120MemberOfCollection" + " entered"));
        this.processIGroupChange(request, "lunGroupRemoveWWN");
    }

    public void SetRequestStorEdge_6120StorageVolume(SetRequest request) throws CIMException {
        block20: {
            CIMException tmp;
            String METHOD = "SetRequestStorEdge_6120StorageVolume";
            WBEMDebug.trace3((String)(CLASSNAME + "." + "SetRequestStorEdge_6120StorageVolume" + " entered"));
            int oldLUN = -1;
            int newLUN = -1;
            String sliceNum = null;
            CIMProperty tmpProp = null;
            if (request == null) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120StorageVolume" + " Null request argument. "));
                throw new CIMException("CIM_ERR_FAILED");
            }
            try {
                CIMObjectPath target = request.getObjectPath();
                CIMInstance volInstance = RequestBroker.getInstance().getCacheInstance(request.getObjectPath());
                if (volInstance == null) {
                    WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120StorageVolume" + " unable to locate " + "old instance. "));
                    WBEMDebug.trace2((String)(CLASSNAME + "." + "SetRequestStorEdge_6120StorageVolume" + " Client specified LUN " + "not found in cache: " + target));
                    CIMException tmp2 = new CIMException("CIM_ERR_FAILED");
                    tmp2.setDescription("Unable to locate old StorageVolume object.");
                    throw tmp2;
                }
                tmpProp = volInstance.getProperty("DeviceNumber");
                if (tmpProp == null) {
                    WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120StorageVolume" + " unable to locate " + "old LUN information. "));
                    CIMException tmp3 = new CIMException("CIM_ERR_FAILED");
                    tmp3.setDescription("Unable to locate old LUN information");
                    throw tmp3;
                }
                try {
                    oldLUN = Integer.parseInt((String)tmpProp.getValue().getValue(), 10);
                }
                catch (Exception e) {
                    oldLUN = -1;
                }
                if (oldLUN == 65535) {
                    oldLUN = -1;
                }
                if ((tmpProp = volInstance.getProperty("ElementName")) == null) {
                    WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120StorageVolume" + " unable to locate " + "Volume slice number. "));
                    CIMException tmp4 = new CIMException("CIM_ERR_FAILED");
                    tmp4.setDescription("Unable to locate volume slice number");
                    throw tmp4;
                }
                sliceNum = (String)tmpProp.getValue().getValue();
                try {
                    newLUN = Integer.parseInt((String)request.getPropertyValue("DeviceNumber"), 10);
                }
                catch (Exception e) {
                    newLUN = -1;
                }
            }
            catch (Exception e) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120StorageVolume" + " internal error " + "encountered extracting unit number from request. " + e.getMessage()));
                WBEMDebug.trace2((String)(CLASSNAME + "." + "SetRequestStorEdge_6120StorageVolume"), (Throwable)e);
                CIMException tmp5 = new CIMException("CIM_ERR_FAILED");
                tmp5.setDescription("Internal failure extracting Unit Number from request " + e.getMessage());
                throw tmp5;
            }
            try {
                if (oldLUN != newLUN) {
                    this.changeLUN(oldLUN, newLUN, sliceNum);
                }
            }
            catch (Exception e) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120StorageVolume" + " IO failure: " + e.getMessage()));
                WBEMDebug.trace2((String)(CLASSNAME + "." + "SetRequestStorEdge_6120StorageVolume"), (Throwable)e);
                tmp = new CIMException("CIM_ERR_FAILED");
                tmp.setDescription("IO failure communicating to array: " + e.getMessage());
                throw tmp;
            }
            try {
                Vector accessProps = (Vector)request.getPropertyValue("AccessType");
                String accessMode = (String)accessProps.elementAt(0);
                if (newLUN != -1) {
                    Vector<String> addMap = new Vector<String>();
                    addMap.add("lunMapLUNNo=" + newLUN);
                    addMap.add("lunMaskAccess=" + this.convertCIMToT4Access(accessMode));
                    try {
                        DevComm.getInstance().post(this.getSystem(), addMap, "lunMaskPermAllWWN");
                        break block20;
                    }
                    catch (ArrayException e) {
                        WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120StorageVolume" + " Unable to set default access " + addMap + " " + e.getMessage()));
                        WBEMDebug.trace2((String)(CLASSNAME + "." + "SetRequestStorEdge_6120StorageVolume"), (Throwable)e);
                        throw new CIMException("CIM_ERR_FAILED");
                    }
                    catch (StorEdgeIOException e) {
                        WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120StorageVolume" + " Unable to set default access " + addMap + " " + e.getMessage()));
                        WBEMDebug.trace2((String)(CLASSNAME + "." + "SetRequestStorEdge_6120StorageVolume"), (Throwable)e);
                        CIMException tmpE = new CIMException("CIM_ERR_FAILED");
                        tmpE.setDescription(e.getMessage());
                        throw tmpE;
                    }
                }
                WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120StorageVolume" + " Unable to assign access with invalid unit number. "));
                throw new CIMException("CIM_ERR_FAILED");
            }
            catch (Exception e) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "SetRequestStorEdge_6120StorageVolume" + " IO failure: " + e.getMessage()));
                WBEMDebug.trace2((String)(CLASSNAME + "." + "SetRequestStorEdge_6120StorageVolume"), (Throwable)e);
                tmp = new CIMException("CIM_ERR_FAILED");
                tmp.setDescription("IO failure communicating to array: " + e.getMessage());
                throw tmp;
            }
        }
    }

    private void changeLUN(int oldLUN, int newLUN, String sliceNum) throws Exception {
        String METHOD = "changeLUN";
        if (oldLUN == -1 && newLUN != -1) {
            DevComm.getInstance().telnetPost(this.getSystem(), "lun map add lun " + newLUN + " slice " + sliceNum);
        } else if (newLUN != -1) {
            String[] cmds = new String[3];
            String[] prompts = new String[3];
            String[] resp = new String[]{"Remove the mapping, are you sure? [N]:", ">", ">"};
            String[] errs = new String[]{"Failed to remove old lun", "Failed to remove old lun", "Failed to add new lun"};
            cmds[0] = "lun map rm lun " + oldLUN;
            prompts[0] = "[N]";
            cmds[1] = "Y";
            cmds[2] = "lun map add lun " + newLUN + " slice " + sliceNum;
            DevComm.getInstance().telnetMultiPost(this.getSystem(), cmds, resp, errs, prompts, new int[0]);
        } else {
            WBEMDebug.trace3((String)(CLASSNAME + "." + "changeLUN" + " Removing LUN: " + oldLUN + " to leave slice with no LUN."));
            DevComm.getInstance().telnetPost(this.getSystem(), "lun map rm lun " + oldLUN);
        }
    }

    private void processIGroupChange(ModifyRequest request, String operation) throws CIMException {
        String METHOD = "processIGroupChange";
        WBEMDebug.trace3((String)(CLASSNAME + "." + "processIGroupChange" + " entered"));
        String iGroupName = null;
        String wwn = null;
        if (request == null) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "processIGroupChange" + " Null request argument. "));
            throw new CIMException("CIM_ERR_FAILED");
        }
        try {
            CIMObjectPath iGroupRef = (CIMObjectPath)request.getKeyValue("Collection");
            CIMInstance iGroup = RequestBroker.getInstance().getCacheInstance(iGroupRef);
            if (iGroup == null) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "processIGroupChange" + " unable to " + "locate requested group: " + iGroupRef));
                CIMException tmp = new CIMException("CIM_ERR_FAILED");
                tmp.setDescription("Unable to locate requested group ");
                throw tmp;
            }
            CIMProperty tmp = iGroup.getProperty("ElementName");
            if (tmp == null) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "processIGroupChange" + " unable to get " + "Initiator group name. "));
                CIMException tmpe = new CIMException("CIM_ERR_FAILED");
                tmpe.setDescription("Unable to get initiator group name");
                throw tmpe;
            }
            iGroupName = (String)tmp.getValue().getValue();
            wwn = (String)this.getReferenceKeyProperty(request.getObjectPath(), "Member", "ID");
        }
        catch (NullPointerException e) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "processIGroupChange" + " internal error " + "encountered extracting initiator and group from request"));
            WBEMDebug.trace2((String)(CLASSNAME + "." + "processIGroupChange"), (Throwable)e);
            CIMException tmp = new CIMException("CIM_ERR_FAILED");
            tmp.setDescription("Internal failure extracting initiator and group from request " + e.getMessage());
            throw tmp;
        }
        try {
            Vector<String> postv = new Vector<String>();
            postv.add("lunGroupWWN=" + wwn);
            postv.add("lunGroupName=" + iGroupName);
            DevComm.getInstance().post(this.getSystem(), postv, operation);
        }
        catch (Exception e) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "processIGroupChange" + " IO error " + "encountered. " + e.getMessage()));
            WBEMDebug.trace2((String)(CLASSNAME + "." + "processIGroupChange"), (Throwable)e);
            CIMException tmp = new CIMException("CIM_ERR_FAILED");
            tmp.setDescription("IO failure assigning initiator to group " + e.getMessage());
            throw tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteViewWithCleanup(InvokeRequest request) throws CIMException {
        String METHOD = "deleteViewWithCleanup";
        boolean _PARAM_INDEX_VOLGROUP = false;
        Properties props = null;
        String name = null;
        CIMObjectPath volGroup = null;
        CIMInstance[] acis = null;
        CIMInstance[] iGroups = null;
        CIMInstance[] vols = null;
        Object targets = null;
        ArrayList<Object> unitNumbers = null;
        String iGroupName = null;
        String groupVols = null;
        Object guid = null;
        String groupAccess = null;
        String members = null;
        String unitNumber = null;
        try {
            volGroup = (CIMObjectPath)request.getInParamValue(0);
            volGroup.setNameSpace("\\root\\se6x20");
            CIMInstance cacheVolGroup = RequestBroker.getInstance().getCacheInstance(volGroup);
            if (cacheVolGroup == null) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "deleteViewWithCleanup" + " Unable to extract parameter AuthViewSCSI " + "controller from cache.  The controller does not  " + "exist."));
                request.setResults(_MASK_SERVICE_INVALID_PARAM);
                return;
            }
            volGroup = cacheVolGroup.getObjectPath();
            volGroup.setNameSpace("\\root\\se6x20");
            CIMProperty prop = cacheVolGroup.getProperty("DeviceID");
            if (prop.getValue() != null && prop.getValue().getValue() != null) {
                name = (String)prop.getValue().getValue();
            }
            if (name == null) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "deleteViewWithCleanup" + " Unable to extract view name from the cached instance " + "of the controller."));
                request.setResults(_MASK_SERVICE_INVALID_PARAM);
                return;
            }
        }
        catch (Exception e) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "deleteViewWithCleanup" + " Unable to extract view name from port SCSI " + "controller request " + e.getMessage()));
            WBEMDebug.trace2((String)(CLASSNAME + "." + "deleteViewWithCleanup"), (Throwable)e);
            WBEMDebug.trace3((String)(" Unable to extract view name from port SCSI controller request " + e));
            request.setResults(_MASK_SERVICE_INVALID_PARAM);
            return;
        }
        vols = RequestBroker.getInstance().associators(new CIMObjectPath("StorEdge_6120MappedSCSILUN", "\\root\\se6x20"), volGroup, "StorEdge_6120StorageVolume", null, null, true, false, null);
        acis = RequestBroker.getInstance().associators(new CIMObjectPath("StorEdge_6120AuthorizationTarget", "\\root\\se6x20"), volGroup, "StorEdge_6120AccessControlInformation", null, null, true, false, null);
        groupVols = "VolGroupVols" + name;
        groupAccess = "VolGroupAccess" + name;
        String[] req = new String[]{"VolGroupList", groupVols, groupAccess};
        WBEMDebug.trace3((String)(CLASSNAME + "." + "deleteViewWithCleanup" + " Working on " + "VolGroupList" + " " + groupVols + " " + groupAccess));
        try {
            props = DevComm.getInstance().getSysProps(this.getSystem(), req);
        }
        catch (ArrayException e) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "deleteViewWithCleanup" + " Unable to get volume group from array " + this.getSystem() + ": " + groupVols + " " + e.getMessage()));
            WBEMDebug.trace2((String)(CLASSNAME + "." + "deleteViewWithCleanup"), (Throwable)e);
            request.setResults(_MASK_SERVICE_FAILED);
            return;
        }
        catch (StorEdgeIOException e) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "deleteViewWithCleanup" + " Unable to get volume group from array " + this.getSystem() + ": " + groupVols + " " + e.getMessage()));
            WBEMDebug.trace2((String)(CLASSNAME + "." + "deleteViewWithCleanup"), (Throwable)e);
            CIMException tmp = new CIMException("CIM_ERR_FAILED");
            tmp.setDescription(e.getMessage());
            throw tmp;
        }
        if (vols != null) {
            unitNumbers = new ArrayList<Object>();
            int i = 0;
            while (i < vols.length) {
                CIMInstance vol = vols[i];
                try {
                    unitNumbers.add(vol.getProperty("DeviceNumber").getValue().getValue());
                }
                catch (NullPointerException npe) {
                    WBEMDebug.trace3((String)(CLASSNAME + "." + "deleteViewWithCleanup" + " A NPE was thrown while retrieving the device " + "number property from this Storage Voulme: " + vol.getObjectPath()));
                }
                ++i;
            }
        }
        try {
            this.getSystem().pauseRefresh(true);
            if (acis != null) {
                int j = 0;
                while (j < acis.length) {
                    CIMObjectPath acip = acis[j].getObjectPath();
                    acip.setNameSpace("\\root\\se6x20");
                    iGroups = RequestBroker.getInstance().associators(new CIMObjectPath("StorEdge_6120AuthorizationSubject", "\\root\\se6x20"), acip, "StorEdge_6120SystemSpecificCollection", null, null, true, false, null);
                    if (iGroups == null) {
                        WBEMDebug.trace3((String)(CLASSNAME + "." + "deleteViewWithCleanup" + " Unable to get volume groups for ACI " + acis[j]));
                    } else {
                        int k = 0;
                        while (k < iGroups.length) {
                            CIMProperty tmp = iGroups[k].getProperty("ElementName");
                            if (tmp == null || tmp.getValue() == null || tmp.getValue().getValue() == null) {
                                WBEMDebug.trace1((String)(CLASSNAME + "." + "deleteViewWithCleanup" + "Unable to get Initiator Group name" + iGroups[k]));
                                request.setResults(_MASK_SERVICE_FAILED);
                                Object var30_35 = null;
                                this.getSystem().pauseRefresh(false);
                                return;
                            }
                            iGroupName = (String)tmp.getValue().getValue();
                            int i = 0;
                            while (unitNumbers != null && i < unitNumbers.size()) {
                                unitNumber = unitNumbers.get(i).toString();
                                Vector<String> addMap = new Vector<String>();
                                addMap.add("lunMapLUNNo=" + unitNumber);
                                addMap.add("lunGroupName=" + iGroupName);
                                addMap.add("lunMaskAccess=none");
                                try {
                                    DevComm.getInstance().post(this.getSystem(), addMap, "lunMaskPermGroup");
                                }
                                catch (ArrayException e) {
                                    WBEMDebug.trace1((String)(CLASSNAME + "." + "deleteViewWithCleanup" + " Unable to set maskings " + addMap + " " + e.getMessage()));
                                    WBEMDebug.trace2((String)(CLASSNAME + "." + "deleteViewWithCleanup"), (Throwable)e);
                                    request.setResults(_MASK_SERVICE_FAILED);
                                    Object var30_36 = null;
                                    this.getSystem().pauseRefresh(false);
                                    return;
                                }
                                catch (StorEdgeIOException e) {
                                    WBEMDebug.trace1((String)(CLASSNAME + "." + "deleteViewWithCleanup" + " Unable to set maskings " + addMap + " " + e.getMessage()));
                                    WBEMDebug.trace2((String)(CLASSNAME + "." + "deleteViewWithCleanup"), (Throwable)e);
                                    CIMException tmpE = new CIMException("CIM_ERR_FAILED");
                                    tmpE.setDescription(e.getMessage());
                                    throw tmpE;
                                }
                                ++i;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            try {
                members = this.commaCleanup(this.subtractString(props.getProperty("VolGroupList"), name));
                props.setProperty("VolGroupList", members);
                props.setProperty("VolGroupVols" + name, DELETE);
                props.setProperty("VolGroupAccess" + name, DELETE);
                DevComm.getInstance().setSysProps(this.getSystem(), props);
            }
            catch (ArrayException e) {
                request.setResults(_MASK_SERVICE_FAILED);
                Object var30_37 = null;
                this.getSystem().pauseRefresh(false);
                return;
            }
            catch (StorEdgeIOException e) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + "deleteViewWithCleanup" + " IO error communicating to T4: " + e.getMessage()));
                WBEMDebug.trace2((String)(CLASSNAME + "." + "deleteViewWithCleanup"), (Throwable)e);
                request.setResults(_MASK_SERVICE_FAILED);
                Object var30_38 = null;
                this.getSystem().pauseRefresh(false);
                return;
            }
            catch (NoSuchElementException e2) {
                request.setResults(_MASK_SERVICE_INVALID_PARAM);
                Object var30_39 = null;
                this.getSystem().pauseRefresh(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var30_41 = null;
            this.getSystem().pauseRefresh(false);
            throw throwable;
        }
        Object var30_40 = null;
        this.getSystem().pauseRefresh(false);
        request.setResults(_MASK_SERVICE_OK);
    }

    public static void createInitiatorGroup(ModifyRequest request) throws CIMException {
        String METHOD = "createInitatorGroup";
        WBEMDebug.trace3((String)(CLASSNAME + "." + "createInitatorGroup" + " entered"));
        if (request == null) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "createInitatorGroup" + " Null request argument. "));
            throw new CIMException("CIM_ERR_FAILED");
        }
        try {
            CreateRequest req = (CreateRequest)request;
            WBEMDebug.trace3((String)(CLASSNAME + "." + "createInitatorGroup" + " Creating new" + " synthetic instance: " + req.getNewInstance()));
            RequestBroker.getInstance().addSyntheticCacheInstance(req.getNewInstance());
            req.setResults(req.getNewInstance().getObjectPath());
        }
        catch (Exception e) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "createInitatorGroup" + " unable to create " + "new initator group " + request + " " + e.getMessage()));
            WBEMDebug.trace2((String)(CLASSNAME + "." + "createInitatorGroup"), (Throwable)e);
            CIMException tmp = new CIMException("CIM_ERR_FAILED");
            tmp.setDescription("Unable to create initiator group " + e.getMessage());
            throw tmp;
        }
    }

    public Object getReferenceKeyProperty(CIMObjectPath association, String refName, String keyName) throws CIMException {
        String METHOD = "getReferenceKeyProperty";
        if (association == null || refName == null || keyName == null) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "getReferenceKeyProperty" + " Null request argument. "));
            throw new CIMException("CIM_ERR_FAILED");
        }
        Vector refVec = association.getKeys();
        int j = 0;
        while (j < refVec.size()) {
            CIMProperty prop = (CIMProperty)refVec.elementAt(j);
            if (prop.getName().equalsIgnoreCase(refName)) {
                CIMObjectPath ref = (CIMObjectPath)prop.getValue().getValue();
                Vector vec = ref.getKeys();
                int i = 0;
                while (i < vec.size()) {
                    CIMProperty prop2 = (CIMProperty)vec.elementAt(i);
                    if (prop2.getName().equalsIgnoreCase(keyName)) {
                        return prop2.getValue().getValue();
                    }
                    ++i;
                }
            }
            ++j;
        }
        CIMException tmp = new CIMException("CIM_ERR_FAILED");
        tmp.setDescription("Unable to locate key property \"" + keyName + "\" in reference \"" + refName + "\" in association \"" + association.toString() + "\"");
        throw tmp;
    }

    public String subtractString(String s1, String s2) throws NoSuchElementException {
        String METHOD = "subtractString";
        if (s1 == null || s2 == null) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "subtractString" + " Null request argument. "));
            throw new NoSuchElementException("Null arguments: " + s1 + ", " + s2);
        }
        int start = s1.indexOf(s2);
        if (start < 0) {
            throw new NoSuchElementException(s2 + " not found in " + s1);
        }
        s1 = s1.substring(0, start) + s1.substring(start + s2.length());
        return s1;
    }

    public int newToOldLUN(UnsignedInt64 input) {
        BigInteger val = input.bigIntValue();
        return val.shiftRight(48).and(new BigInteger("3fff", 16)).intValue();
    }

    public UnsignedInt64 oldToNewLUN(int input) {
        return new UnsignedInt64(new BigInteger(Integer.toString(input)).shiftLeft(48));
    }

    public int getUnitNumber(CIMObjectPath vol) throws CIMException {
        String METHOD = "getUnitNumber";
        if (vol == null) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "getUnitNumber" + " Null request argument. "));
            throw new CIMException("CIM_ERR_FAILED");
        }
        CIMInstance[] luns = RequestBroker.getInstance().references(new CIMObjectPath("StorEdge_6120MappedSCSILUN"), vol, null, true, false, null);
        if (luns == null) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "getUnitNumber" + "No StorEdge_6120MappedSCSILUN found matching " + "GUID in cache " + vol));
            CIMException tmp = new CIMException("CIM_ERR_FAILED");
            tmp.setDescription("Unrecognised Volume GUID");
            throw tmp;
        }
        if (luns[0] == null) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "getUnitNumber" + "No StorEdge_6120MappedSCSILUN found matching " + "GUID in cache " + vol));
            CIMException tmp = new CIMException("CIM_ERR_FAILED");
            tmp.setDescription("Unrecognised Volume GUID");
            throw tmp;
        }
        CIMProperty tmp = luns[0].getProperty("DeviceNumber");
        if (tmp == null) {
            CIMException tmpe = new CIMException("CIM_ERR_FAILED");
            tmpe.setDescription("No Unit number property in LUN");
            throw tmpe;
        }
        return Integer.parseInt((String)tmp.getValue().getValue(), 10);
    }

    private String convertT4ToCIMAccess(String access) throws CIMException {
        if (access.equalsIgnoreCase("rw")) {
            return "Read/Write";
        }
        if (access.equalsIgnoreCase("ro")) {
            return "Read-only";
        }
        if (access.equalsIgnoreCase("none")) {
            return "None";
        }
        CIMException tmp = new CIMException("CIM_ERR_FAILED");
        tmp.setDescription("Unrecognized array access mode: " + access);
        throw tmp;
    }

    private String convertCIMToT4Access(String access) throws CIMException {
        if (access.equalsIgnoreCase("Read/Write")) {
            return "rw";
        }
        if (access.equalsIgnoreCase("Read-only")) {
            return "ro";
        }
        if (access.equalsIgnoreCase("None")) {
            return "none";
        }
        if (access.equalsIgnoreCase("rw")) {
            return "rw";
        }
        if (access.equalsIgnoreCase("ro")) {
            return "ro";
        }
        CIMException tmp = new CIMException("CIM_ERR_FAILED");
        tmp.setDescription("Unrecognized CIM access mode: " + access);
        throw tmp;
    }

    private String commaCleanup(String input) {
        boolean keepGoing = false;
        StringBuffer tmp = new StringBuffer(input.trim());
        int index = -1;
        do {
            if (tmp.length() == 0) {
                keepGoing = false;
                continue;
            }
            if (tmp.charAt(0) == ',') {
                tmp.deleteCharAt(0);
                keepGoing = true;
                continue;
            }
            if (tmp.charAt(tmp.length() - 1) == ',') {
                tmp.deleteCharAt(tmp.length() - 1);
                keepGoing = true;
                continue;
            }
            index = tmp.indexOf(",,");
            if (index >= 0) {
                tmp.deleteCharAt(index);
                keepGoing = true;
                continue;
            }
            keepGoing = false;
        } while (keepGoing);
        if (tmp.length() == 0) {
            return ",";
        }
        return tmp.toString();
    }

    private boolean isInCommaList(String list, String target) {
        if (list == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("(^" + target + ",|," + target + ",|," + target + "$|^" + target + "$)");
        Matcher matcher = pattern.matcher(list);
        return matcher.find();
    }
}

