/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.se6120.internal;

import com.sun.netstorage.array.mgmt.se6120.internal.ArrayException;
import com.sun.netstorage.array.mgmt.se6120.internal.ArrayInventory;
import com.sun.netstorage.array.mgmt.se6120.internal.ArrayObject;
import com.sun.netstorage.array.mgmt.se6120.internal.DevComm;
import com.sun.netstorage.array.mgmt.se6120.internal.InvokeRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyJobs;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyModule;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.RequestBroker;
import com.sun.netstorage.array.mgmt.se6120.internal.StorEdgeIOException;
import com.sun.netstorage.array.mgmt.util.StorEdge_PersistentStorage;
import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;

public class ModifyConfigService
extends ModifyModule {
    static Vector classMap = new Vector();
    public static final int MAX_NAME_LENGTH_VOL = 12;
    public static final int MAX_NAME_LENGTH_POOL = 12;
    public static final int _LOCK_FILE_VOL_CREATE_ = 0;
    public static final int _LOCK_FILE_VOL_DELETE_ = 1;
    public static final int _LOCK_FILE_POOL_CREATE_ = 2;
    public static final int _LOCK_FILE_POOL_DELETE_ = 3;
    public static final int _LOCK_FILE_POOL_MOUNT_ = 4;
    public static final int _LOCK_FILE_POOL_UNMOUNT_ = 5;
    public static final int _LOCK_FILE_ARRAY_STANDBY_ADD_ = 6;
    public static final int _LOCK_FILE_ARRAY_STANDBY_REMOVE_ = 7;
    private static final CIMValue _CONF_SERVICE_FAILURE;
    private static final CIMValue _CONF_SERVICE_NOT_SUPPORTED;
    private static final CIMValue _CONF_SERVICE_INVALID_PARAMETER;
    private static final CIMValue _CONF_SERVICE_COMPLETE_SUCCESSFUL;
    private static final CIMValue _CONF_SERVICE_JOB_STARTED;
    private static String CLASSNAME;

    public ModifyConfigService(ArrayObject host) {
        super(host);
    }

    public boolean handleRequest(ModifyRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        String METHOD = "handleRequest";
        boolean reqReturn = false;
        WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " entered"));
        if (classMap.contains(request.getCIMClassName())) {
            if (request instanceof InvokeRequest) {
                try {
                    reqReturn = this.invokeStorageConfigurationService((InvokeRequest)request);
                }
                catch (CIMException e) {
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " threw an exception: " + e.getMessage()), (Throwable)e);
                    throw e;
                }
            } else {
                throw new CIMException("CIM_ERR_NOT_SUPPORTED");
            }
        }
        return reqReturn;
    }

    private boolean invokeStorageConfigurationService(InvokeRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        boolean ret;
        block10: {
            String METHOD = "invokeStorageConfigurationService";
            ret = false;
            WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " entered"));
            String method = request.getMethodName();
            try {
                if (method.equalsIgnoreCase("DeleteStoragePool")) {
                    ret = true;
                    this.deleteStoragePool(request);
                    break block10;
                }
                if (method.equalsIgnoreCase("CreateOrModifyStoragePool")) {
                    ret = true;
                    this.createOrModifyStoragePool(request);
                    break block10;
                }
                if (method.equalsIgnoreCase("ReturnToStoragePool")) {
                    ret = true;
                    this.returnToStoragePool(request);
                    break block10;
                }
                if (method.equalsIgnoreCase("CreateOrModifyElementFromStoragePool")) {
                    ret = true;
                    this.createOrModifyElementFromStoragePool(request, false);
                    break block10;
                }
                if (method.equalsIgnoreCase("CreateMappedElementFromStoragePool")) {
                    ret = true;
                    this.createMappedElementFromStoragePool(request);
                    break block10;
                }
                if (method.equalsIgnoreCase("CreateOrModifyArraySparedSet")) {
                    ret = true;
                    this.createOrModifyArraySparedSet(request);
                    break block10;
                }
                if (method.equalsIgnoreCase("InitializeStoragePool")) {
                    ret = true;
                    this.initializeStoragePool(request);
                    break block10;
                }
                throw new CIMException("CIM_ERR_FAILED");
            }
            catch (ArrayException ae) {
                request.setResults(_CONF_SERVICE_FAILURE);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " encountered an" + " exception, " + ae), (Throwable)ae);
                throw ae;
            }
            catch (StorEdgeIOException ioe) {
                request.setResults(_CONF_SERVICE_FAILURE);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " encountered an" + " exception, " + ioe), (Throwable)ioe);
                throw ioe;
            }
        }
        return ret;
    }

    public void shutdown() {
    }

    private void createMappedElementFromStoragePool(InvokeRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        this.createOrModifyElementFromStoragePool(request, true);
    }

    /*
     * Unable to fully structure code
     */
    private void createOrModifyElementFromStoragePool(InvokeRequest request, boolean isMapped) throws CIMException, ArrayException, StorEdgeIOException {
        METHOD = "createOrModifyElementFromStoragePool";
        poolInst = null;
        tokenArgs = new Vector<String>();
        retCode = ModifyConfigService._CONF_SERVICE_FAILURE;
        thisVol = null;
        vInst = null;
        aInst = null;
        volSliceName = null;
        volSliceIndex = null;
        jobOp = null;
        storVols = null;
        _ELEMENT_TYPE_INDEX = 1;
        _ELEMENT_NAME_INDEX = 0;
        _POOL_SIZE_INDEX = 3;
        _STORAGE_POOL_INDEX = 4;
        _JOB_DESCRIPTION_INDEX = 6;
        _DEVICE_NUMBER_INDEX = 7;
        _ACCESS_MODE_INDEX = 8;
        _MAX_SLICE_NUMBER = 64;
        _GIG_VALUE = new BigDecimal(1.073741824E9);
        _MEG_VALUE = new BigDecimal(1048576.0);
        _MIN_SLICE_SIZE = new BigDecimal(1.048576E7);
        _STORAGE_VOLUME = 2;
        elementType = null;
        availPoolSpace = 0L;
        paramIndex = new int[]{_ELEMENT_NAME_INDEX, _ELEMENT_TYPE_INDEX, _POOL_SIZE_INDEX, _STORAGE_POOL_INDEX};
        paramNames = new String[]{"ElementName", "ElementType", "Size", "Pool"};
        WBEMDebug.trace3((String)(ModifyConfigService.CLASSNAME + "." + METHOD + " entered"));
        try {
            badIndex = this.checkForNullParams(paramIndex, request);
            if (badIndex != -1) {
                request.setResults(ModifyConfigService._CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Encountered a null parameter: " + paramNames[badIndex]));
                return;
            }
        }
        catch (Exception e) {
            request.setResults(ModifyConfigService._CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Encountered an exception. " + e), (Throwable)e);
            return;
        }
        inArgs = request.getInParams();
        elementType = (UnsignedInt16)inArgs[_ELEMENT_TYPE_INDEX].getValue().getValue();
        gaa = RequestBroker.getInstance().enumerateInstances(this.getSystem(), new CIMObjectPath("StorEdge_6120PortSCSIController"), false, true, false, null, null);
        if (gaa == null) {
            WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Failed to discover instance of PortSCSIController for" + " this cluster. "));
            request.setResults(ModifyConfigService._CONF_SERVICE_FAILURE);
            return;
        }
        gaai = gaa[0];
        prop = gaai.getProperty("MaxNumberControlled");
        if (prop.getValue() == null || prop.getValue().getValue() == null) {
            request.setResults(ModifyConfigService._CONF_SERVICE_FAILURE);
            WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Failed to discover MaxNumberControlled property of" + " Storage Pool: " + gaai));
            return;
        }
        _MAX_SLICE_NUMBER = ((UnsignedInt32)prop.getValue().getValue()).intValue();
        if (elementType.intValue() != _STORAGE_VOLUME || inArgs[_STORAGE_POOL_INDEX].getType().getType() != 28) ** GOTO lbl285
        if (inArgs[_STORAGE_POOL_INDEX].getType().getRefClassName().equalsIgnoreCase("StorEdge_6120StoragePool")) {
            op = (CIMObjectPath)inArgs[_STORAGE_POOL_INDEX].getValue().getValue();
            poolInst = RequestBroker.getInstance().getInstance(op, false, true, false, null, null);
            WBEMDebug.trace3((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": gotInstance: " + poolInst.getObjectPath()));
            if (poolInst == null) {
                request.setResults(ModifyConfigService._CONF_SERVICE_FAILURE);
                WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Failed to discover instance of Storage Pool: " + op));
                return;
            }
            prop = poolInst.getProperty("PoolID");
            if (prop.getValue() == null || prop.getValue().getValue() == null) {
                request.setResults(ModifyConfigService._CONF_SERVICE_FAILURE);
                WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Failed to discover PoolID property of StoragePool: " + poolInst));
                return;
            }
            poolid = (String)prop.getValue().getValue();
            uIndex = poolid.substring(poolid.indexOf("u") + 1, poolid.indexOf("v"));
            vIndex = poolid.substring(poolid.indexOf("v") + 1);
            WBEMDebug.trace3((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": pool id val:" + poolid + " unitIndex: " + uIndex + " volIndex: " + vIndex));
            prop = poolInst.getProperty("ElementName");
            if (prop.getValue() == null || prop.getValue().getValue() == null) {
                request.setResults(ModifyConfigService._CONF_SERVICE_FAILURE);
                WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Failed to discover ElementName property of StoragePool: " + poolInst));
                return;
            }
            poolName = (String)prop.getValue().getValue();
            prop = poolInst.getProperty("MaxVolumeSizeAvailable");
            if (prop.getValue() == null || prop.getValue().getValue() == null) {
                request.setResults(ModifyConfigService._CONF_SERVICE_FAILURE);
                WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Failed to discover " + "MaxVolumeSizeAvailable" + "property of Storage Pool: " + poolInst));
                return;
            }
            capacity = new BigDecimal(prop.getValue().getValue().toString());
            capacity = capacity.multiply(_MEG_VALUE);
            WBEMDebug.trace3((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": determined available capacity to be: " + capacity));
            volumeInst = null;
            volPath = new CIMObjectPath("StorEdge_6120StorageVolume", "\\root\\se6x20");
            volumeInst = RequestBroker.getInstance().enumerateInstances(this.getSystem(), volPath, true, false, false, null, null);
            volSliceName = (String)inArgs[_ELEMENT_NAME_INDEX].getValue().getValue();
            if (volSliceName.length() > 12) {
                request.setResults(ModifyConfigService._CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Name given for volume " + volSliceName + " exceeds" + " the name length limit, " + 12));
                return;
            }
            currentVolCount = 0;
            if (volumeInst != null) {
                i = 0;
                while (i < volumeInst.length) {
                    ++currentVolCount;
                    aInst = volumeInst[i];
                    oii = aInst.getProperty("OtherIdentifyingInfo");
                    if (oii.getValue() == null || oii.getValue().getValue() == null) {
                        request.setResults(ModifyConfigService._CONF_SERVICE_FAILURE);
                        WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Failed to discover OtherIdentyingInfo" + " from instance of StorageVolume: " + aInst));
                        return;
                    }
                    oiiv = oii.getValue();
                    oiivv = (Vector)oiiv.getValue();
                    tempName = (String)oiivv.firstElement();
                    WBEMDebug.trace3((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": comparing " + tempName));
                    if (tempName.equals(volSliceName)) {
                        request.setResults(ModifyConfigService._CONF_SERVICE_INVALID_PARAMETER);
                        WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + " was given a duplicate StorageVolume name: " + volSliceName));
                        return;
                    }
                    ++i;
                }
            }
            volumeInst = null;
            volPath = new CIMObjectPath("StorEdge_6120CreateStorageVolumeJob", "\\root\\se6x20");
            volumeInst = RequestBroker.getInstance().enumerateInstances(this.getSystem(), volPath, true, false, false, null, null);
            if (volumeInst != null) {
                i = 0;
                while (i < volumeInst.length) {
                    aInst = volumeInst[i];
                    oii = aInst.getProperty("OperationalStatus");
                    if (oii.getValue() == null || oii.getValue().getValue() == null) {
                        request.setResults(ModifyConfigService._CONF_SERVICE_FAILURE);
                        WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Failed to discover " + "OperationalStatus" + " from instance of: " + "StorEdge_6120CreateStorageVolumeJob" + " in: " + aInst));
                        return;
                    }
                    oiiv = oii.getValue();
                    oiivv = (Vector)oiiv.getValue();
                    isComplete = false;
                    j = 0;
                    while (j < oiivv.size()) {
                        stat = ((UnsignedInt16)oiivv.get(j)).intValue();
                        if (stat == 17) {
                            isComplete = true;
                        }
                        ++j;
                    }
                    if (!isComplete) {
                        ++currentVolCount;
                        oii = aInst.getProperty("StorageVolumeName");
                        if (oii.getValue() == null || oii.getValue().getValue() == null) {
                            request.setResults(ModifyConfigService._CONF_SERVICE_FAILURE);
                            WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Failed to discover name of requested volume."));
                            return;
                        }
                        if (volSliceName.equals((String)oii.getValue().getValue())) {
                            request.setResults(ModifyConfigService._CONF_SERVICE_INVALID_PARAMETER);
                            WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + " was given a duplicate StorageVolume name to" + " to a requested volume: " + volSliceName));
                            return;
                        }
                    }
                    ++i;
                }
            }
            if (currentVolCount >= _MAX_SLICE_NUMBER) {
                request.setResults(ModifyConfigService._CONF_SERVICE_NOT_SUPPORTED);
                WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + " maximum number of volumes (" + _MAX_SLICE_NUMBER + ") already reached."));
            }
            sliceIndex = new Vector<String>();
            otherPools = new Vector<E>();
            ourCluster = null;
            clustInsts = null;
            qualified = request.getObjectPath();
            qualified.setNameSpace("\\root\\se6x20");
            clustInsts = RequestBroker.getInstance().associators(new CIMObjectPath("StorEdge_6120HostedConfigService"), qualified, "StorEdge_6120Cluster", null, null, true, false, null);
            if (clustInsts == null) {
                request.setResults(ModifyConfigService._CONF_SERVICE_FAILURE);
                WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Failed to return an instance for associators of " + " this ConfigService to a cluster: " + request.getObjectPath()));
                return;
            }
            ourCluster = clustInsts[0];
            if (ourCluster == null) {
                request.setResults(ModifyConfigService._CONF_SERVICE_FAILURE);
                WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": No Cluster found for this system!" + this.getSystem().getHost()));
                return;
            }
            poolInsts = null;
            WBEMDebug.trace3((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": checking for pool - cluster association "));
            qualified = ourCluster.getObjectPath();
            qualified.setNameSpace("\\root\\se6x20");
            poolInsts = RequestBroker.getInstance().associators(new CIMObjectPath("StorEdge_6120HostedStoragePool"), qualified, "StorEdge_6120StoragePool", null, null, true, false, null);
            if (poolInsts == null) {
                request.setResults(ModifyConfigService._CONF_SERVICE_FAILURE);
                WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Failed to return an instance of HostedStoragePool" + " for cluster: " + request.getObjectPath()));
                return;
            }
            i = 0;
            while (i < poolInsts.length) {
                aPool = poolInsts[i];
                vols = null;
                WBEMDebug.trace3((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": checking for pool - volume association"));
                qualified = aPool.getObjectPath();
                qualified.setNameSpace("\\root\\se6x20");
                vols = RequestBroker.getInstance().associators(new CIMObjectPath("StorEdge_6120AllocatedFromStoragePool"), qualified, "StorEdge_6120StorageVolume", null, null, true, false, null);
                vollength = 0;
                if (vols != null) {
                    vollength = vols.length;
                }
                j = 0;
                while (j < vollength) {
                    if (vols[j].getProperty("Name").getValue() == null || vols[j].getProperty("Name").getValue().getValue() == null) {
                        request.setResults(ModifyConfigService._CONF_SERVICE_FAILURE);
                        WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Failed to discover property Name " + "for StorageVolume : " + vols[j]));
                        return;
                    }
                    sliceIndex.add((String)vols[j].getProperty("Name").getValue().getValue());
                    otherProp = vols[j].getProperty("OtherIdentifyingInfo");
                    if (otherProp.getValue() == null || otherProp.getValue().getValue() == null) {
                        request.setResults(ModifyConfigService._CONF_SERVICE_FAILURE);
                        WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Failed to discover OtherIdentifyingInfo " + "for StorageVolume : " + vols[j]));
                        return;
                    }
                    tempName = (String)((Vector)otherProp.getValue().getValue()).firstElement();
                    WBEMDebug.trace3((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": comparing " + tempName));
                    if (tempName.equals(volSliceName)) {
                        request.setResults(ModifyConfigService._CONF_SERVICE_INVALID_PARAMETER);
                        WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + " was given a duplicate StorageVolume name: " + volSliceName));
                        return;
                    }
                    ++j;
                }
                ++i;
            }
            WBEMDebug.trace3((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": finding slice value for volume "));
            volSliceIndex = this.getLowSeqValue(sliceIndex);
            sliceSizeIn = (UnsignedInt64)inArgs[_POOL_SIZE_INDEX].getValue().getValue();
            WBEMDebug.trace3((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": calculating GB for size entered: " + sliceSizeIn));
            sliceSize = null;
            try {
                sliceSize = new BigDecimal(sliceSizeIn.toString());
            }
            catch (Exception nfe) {
                request.setResults(ModifyConfigService._CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Value given for Size is invalid: " + sliceSizeIn), (Throwable)nfe);
                return;
            }
            if (sliceSize.compareTo(_MIN_SLICE_SIZE) < 0 || sliceSize.compareTo(capacity) > 0) {
                request.setResults(ModifyConfigService._CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Size for this volSlice is invalid: " + sliceSize + " min size is : " + _MIN_SLICE_SIZE + " remaining capacity is: " + capacity));
                return;
            }
            WBEMDebug.trace3((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": requested size is valid : " + sliceSize));
            volSliceSize = null;
            if (sliceSize.compareTo(_GIG_VALUE) >= 0) {
                sliceSize = sliceSize.divide(_GIG_VALUE, 2, 1);
                volSliceSize = sliceSize.toString() + "gb";
            } else {
                sliceSize = sliceSize.divide(_MEG_VALUE, 2, 1);
                volSliceSize = sliceSize.toString() + "mb";
            }
            WBEMDebug.trace3((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": size determined as " + volSliceSize));
            tokenArgs.add("unitIndex=" + uIndex);
            tokenArgs.add("volIndex=" + vIndex);
            tokenArgs.add("volSliceIndex=" + volSliceIndex);
            tokenArgs.add("volSliceName=" + volSliceName);
            tokenArgs.add("volSliceSize=" + volSliceSize);
            jobCommand = "createVolume";
            if (isMapped) {
                lunNum = null;
                if (inArgs[_DEVICE_NUMBER_INDEX].getValue() != null) {
                    lunNum = (UnsignedInt16)inArgs[_DEVICE_NUMBER_INDEX].getValue().getValue();
                }
                accVal = (UnsignedInt16)inArgs[_ACCESS_MODE_INDEX].getValue().getValue();
                if (lunNum != null || accVal != null) {
                    tokenArgs.add((String)lunNum);
                    tokenArgs.add((String)accVal);
                    jobCommand = "createMappedVolume";
                }
            }
            tokenArgs.add(poolName);
            tokenArgs.add((String)sliceSizeIn);
            WBEMDebug.trace3((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": arguments for tokens are:"));
            i = 0;
            while (i < tokenArgs.size()) {
                WBEMDebug.trace3((String)(ModifyConfigService.CLASSNAME + "." + METHOD + "" + tokenArgs.get(i)));
                ++i;
            }
            telnetcmds = new String[]{"volslice create " + volSliceName + " -z " + volSliceSize + " " + poolName, this.getSystem().getHost()};
            jobDesc = null;
            try {
                jobDesc = (String)inArgs[_JOB_DESCRIPTION_INDEX].getValue().getValue();
            }
            catch (NullPointerException ne) {
            }
            catch (ArrayIndexOutOfBoundsException ae) {
            }
            catch (Exception e) {
                request.setResults(ModifyConfigService._CONF_SERVICE_FAILURE);
                WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Encountered an exception. " + e.getMessage()), (Throwable)e);
                return;
            }
        } else {
            request.setResults(ModifyConfigService._CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + " failed to discover the correct parameters:" + " StoragePool name = " + inArgs[_STORAGE_POOL_INDEX].getType().getRefClassName()));
            return;
lbl285:
            // 1 sources

            request.setResults(ModifyConfigService._CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + " failed to discover the correct parameters:" + " Element Type = " + inArgs[_ELEMENT_TYPE_INDEX].getValue().getValue()));
            return;
        }
        jobOp = jobDesc != null ? ModifyJobs.getInstance(this.getSystem().getHost()).createJob(jobCommand, tokenArgs, telnetcmds, jobDesc) : ModifyJobs.getInstance(this.getSystem().getHost()).createJob(jobCommand, tokenArgs, telnetcmds);
        request.setResults(ModifyConfigService._CONF_SERVICE_JOB_STARTED);
        outArgs = request.getOutParams();
        outArgs[0] = new CIMArgument("Job", new CIMValue((Object)jobOp));
        outArgs[1] = new CIMArgument("Size", new CIMValue((Object)jobOp));
        outArgs[2] = new CIMArgument("TheElement", new CIMValue(null));
    }

    private void createOrModifyStoragePool(InvokeRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        String METHOD = "createOrModifyStoragePool";
        int _POOL_REF_INDEX = 5;
        int[] paramIndex = new int[]{5};
        try {
            int badIndex = this.checkForNullParams(paramIndex, request);
            if (badIndex == -1) {
                this.modifyStoragePool(request);
            } else {
                this.createStoragePool(request);
            }
        }
        catch (Exception e) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered an exception. "), (Throwable)e);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void modifyStoragePool(InvokeRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        String oldProfile;
        String profile;
        String WWN;
        boolean updateCache;
        CIMInstance caps;
        CIMInstance storSet;
        block41: {
            int newDataMin;
            int newSpindleMin;
            int oldDataMin;
            int oldDataMax;
            int oldSpindleDef;
            int oldSpindleMin;
            int oldSpindleMax;
            boolean support;
            String METHOD;
            block40: {
                storSet = null;
                CIMInstance pool = null;
                caps = null;
                Vector<CIMInstance> existingExtents = null;
                METHOD = "modifyStoragePool";
                support = false;
                boolean addSpare = false;
                boolean removeSpare = false;
                updateCache = false;
                boolean hasDedicatedSpare = false;
                boolean _STOR_SETT_INDEX = true;
                int _POOL_REF_INDEX = 5;
                int[] paramIndex = new int[]{1};
                String[] paramNames = new String[]{"Goal"};
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " entered"));
                try {
                    int badIndex = this.checkForNullParams(paramIndex, request);
                    if (badIndex != -1) {
                        request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                        WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered a null parameter: " + paramNames[badIndex]));
                        return;
                    }
                }
                catch (Exception e) {
                    request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered an exception. " + e));
                    return;
                }
                try {
                    CIMArgument[] inArgs = request.getInParams();
                    int i = 0;
                    while (i < inArgs.length) {
                        if (inArgs[i].getName().equalsIgnoreCase("Pool")) {
                            pool = RequestBroker.getInstance().getInstance((CIMObjectPath)inArgs[i].getValue().getValue(), false, true, false, null, null);
                        }
                        if (inArgs[i].getName().equalsIgnoreCase("Goal")) {
                            storSet = RequestBroker.getInstance().getInstance((CIMObjectPath)inArgs[i].getValue().getValue(), false, true, false, null, null);
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered an exception while enumerating " + " StoragePool or StorageSettings: " + e), (Throwable)e);
                    return;
                }
                CIMInstance[] insts = null;
                CIMObjectPath qualified = pool.getObjectPath();
                qualified.setNameSpace("\\root\\se6x20");
                String name = null;
                if (pool != null) {
                    name = this.getString(pool.getProperty("ElementName"));
                    insts = RequestBroker.getInstance().associators(new CIMObjectPath("StorEdge_6120ExtentConcreteComponent"), qualified, "StorEdge_6120StorageExtent", null, null, true, false, null);
                    if (insts == null) {
                        request.setResults(_CONF_SERVICE_FAILURE);
                        WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Failed to discover the StorageExtents for pool: " + pool.getObjectPath()));
                        return;
                    }
                    existingExtents = new Vector<CIMInstance>();
                    int i = 0;
                    while (i < insts.length) {
                        existingExtents.add(insts[i]);
                        ++i;
                    }
                }
                insts = null;
                if (pool != null) {
                    CIMObjectPath op = new CIMObjectPath("StorEdge_6120PoolSparedSet");
                    op.setNameSpace("\\root\\se6x20");
                    insts = RequestBroker.getInstance().enumerateInstances(this.getSystem(), op, false, true, false, null, null);
                    if (insts == null) {
                        hasDedicatedSpare = false;
                    } else {
                        int i = 0;
                        while (i < insts.length) {
                            if (name.equals(insts[i].getProperty("ElementName").getValue().getValue().toString())) {
                                hasDedicatedSpare = true;
                                break;
                            }
                            ++i;
                        }
                    }
                }
                insts = null;
                if (pool != null && (insts = RequestBroker.getInstance().associators(new CIMObjectPath("StorEdge_6120PoolElementCapabilities"), qualified, "StorEdge_6120PoolStorageCapabilities", null, null, true, false, null)) == null) {
                    request.setResults(_CONF_SERVICE_FAILURE);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Failed to discover the StorageCapabilities for pool: " + pool.getObjectPath()));
                    return;
                }
                caps = insts[0];
                if (ArrayInventory.getInstance().getArrayObject(this.getSystem().getHost()).isFeatureSupported(3)) {
                    support = true;
                }
                oldSpindleMax = this.getInt16(caps.getProperty("SpindleRedundancyMax"));
                oldSpindleMin = this.getInt16(caps.getProperty("SpindleRedundancyMin"));
                oldSpindleDef = this.getInt16(caps.getProperty("SpindleRedundancyDefault"));
                oldDataMax = this.getInt16(caps.getProperty("DataRedundancyMax"));
                oldDataMin = this.getInt16(caps.getProperty("DataRedundancyMin"));
                WWN = this.getString(caps.getProperty("InstanceID"));
                profile = this.getString(storSet.getProperty("Description"));
                newSpindleMin = this.getInt16(storSet.getProperty("SpindleRedundancyMin"));
                newDataMin = this.getInt16(storSet.getProperty("DataRedundancyMin"));
                if (!support || newDataMin == -1 || newSpindleMin == -1) break block40;
                if (oldDataMin != newDataMin) {
                    request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": An invalid RAID & Spare setting was given for the " + "current configuration."));
                    WBEMDebug.trace2((String)(CLASSNAME + "." + METHOD + " Old capabilities: " + "DataRedundancyMax=" + oldDataMax + " DataRedundancyMin=" + oldDataMin + " SpindleRedundancyMax=" + oldSpindleMax + " SpindleRedundancyMin=" + oldSpindleMin + " Request: " + " DataRedundancyMin=" + newDataMin + " SpindleRedundancyMin=" + newSpindleMin));
                    return;
                }
                if (oldSpindleMin != newSpindleMin) {
                    if (oldDataMax == 1 && oldDataMin == 1 && oldSpindleMax == 0 && oldSpindleMin == 0) {
                        request.setResults(_CONF_SERVICE_NOT_SUPPORTED);
                        WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": An invalid operation was attempted.  This" + " pool is RAID 0, which does not allow for" + " adding/removing a spare. "));
                        WBEMDebug.trace2((String)(CLASSNAME + "." + METHOD + " Old capabilities: " + "DataRedundancyMax=" + oldDataMax + " DataRedundancyMin=" + oldDataMin + " SpindleRedundancyMax=" + oldSpindleMax + " SpindleRedundancyMin=" + oldSpindleMin + " Request: " + " DataRedundancyMin=" + newDataMin + " SpindleRedundancyMin=" + newSpindleMin));
                        return;
                    }
                    if (newSpindleMin > oldSpindleMin) {
                        addSpare = true;
                    } else {
                        removeSpare = true;
                    }
                    String[] cmds = null;
                    String[] prompts = null;
                    String[] resp = null;
                    String[] errs = null;
                    if (removeSpare && support) {
                        if (!hasDedicatedSpare) {
                            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                            WBEMDebug.trace2((String)(CLASSNAME + "." + METHOD + ": Request was made to remove a spare " + "for a pool which has none.  Pool: " + name));
                            return;
                        }
                        cmds = new String[2];
                        prompts = new String[2];
                        resp = new String[3];
                        errs = new String[3];
                        resp[0] = "WARNING - The standby will be removed.";
                        resp[1] = ">";
                        resp[2] = ">";
                        errs[0] = "There is no standby drive";
                        errs[1] = "invalid argument value";
                        errs[2] = "ERROR";
                        cmds[0] = "vol remove_standby " + name;
                        prompts[0] = "[N]";
                        cmds[1] = "Y";
                    } else if (addSpare && support) {
                        if (hasDedicatedSpare) {
                            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                            WBEMDebug.trace2((String)(CLASSNAME + "." + METHOD + ": Request was made to add a dedicated spare " + "for a pool that has one.  Pool: " + name));
                            return;
                        }
                        String hotSpare = null;
                        try {
                            hotSpare = this.getHotSpareFruID(existingExtents, support, true);
                            if (null == hotSpare) {
                                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": No valid spare was discovered to add."));
                                return;
                            }
                        }
                        catch (CIMException ce) {
                            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": No valid spare was discovered to add."), (Throwable)ce);
                            return;
                        }
                        cmds = new String[1];
                        prompts = null;
                        resp = new String[1];
                        errs = new String[3];
                        resp[0] = ">";
                        errs[0] = "bad drive number";
                        errs[1] = "There is already a standby drive";
                        errs[2] = "ERROR";
                        cmds[0] = "vol add_standby " + name + " standby " + hotSpare;
                    }
                    try {
                        DevComm.getInstance().telnetMultiPost(this.getSystem(), cmds, resp, errs, prompts, new int[0]);
                    }
                    catch (StorEdgeIOException ioe) {
                        request.setResults(_CONF_SERVICE_FAILURE);
                        WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Exception occurred from communication " + "between the provider and the array." + ioe.getMessage()), (Throwable)ioe);
                        return;
                    }
                    catch (ArrayException ae) {
                        request.setResults(_CONF_SERVICE_FAILURE);
                        WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Exception occurred from communication " + "between the provider and the array."), (Throwable)ae);
                        return;
                    }
                    updateCache = true;
                    break block41;
                } else {
                    removeSpare = false;
                    addSpare = false;
                }
                break block41;
            }
            if (!support && newSpindleMin != -1 && newSpindleMin != oldSpindleDef) {
                request.setResults(_CONF_SERVICE_NOT_SUPPORTED);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": An invalid operation was attempted.  This" + " array does not support changing the spare" + " for a pool. "));
                WBEMDebug.trace2((String)(CLASSNAME + "." + METHOD + " Old capabilities: " + "DataRedundancyMax=" + oldDataMax + " DataRedundancyMin=" + oldDataMin + " SpindleRedundancyMax=" + oldSpindleMax + " SpindleRedundancyMin=" + oldSpindleMin + " Request: " + " DataRedundancyMin=" + newDataMin + " SpindleRedundancyMin=" + newSpindleMin));
                return;
            }
        }
        if (profile != null && !profile.equals(oldProfile = this.getString(caps.getProperty("Description")))) {
            StorEdge_PersistentStorage.getInstance().setPersistentString("StorEdge_6120StoragePool." + WWN + ".ProfileKey", profile, true);
            if (!updateCache) {
                caps.setProperty("Description", new CIMValue((Object)profile));
                RequestBroker.getInstance().addInstance(caps);
            }
        }
        if (RequestBroker.getInstance().isSyntheticCacheInstance(storSet.getObjectPath())) {
            RequestBroker.getInstance().deleteInstance(storSet.getObjectPath());
        }
        if (updateCache) {
            RequestBroker.getInstance().invalidateCache(this.getSystem());
        }
        CIMArgument[] outParams = request.getOutParams();
        outParams[0] = new CIMArgument("Job", null);
        outParams[1] = new CIMArgument("Size", null);
        outParams[2] = new CIMArgument("Pool", null);
        request.setResults(_CONF_SERVICE_COMPLETE_SUCCESSFUL);
    }

    private synchronized void createStoragePool(InvokeRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        String METHOD = "createStoragePool";
        Vector extents = new Vector();
        Vector<CIMInstance> newDrives = new Vector<CIMInstance>();
        CIMInstance storSet = null;
        CIMInstance cluster = null;
        String unitIndex = "-1";
        String volName = null;
        String volRaidLevel = "raid";
        String hotSpare = null;
        String volIndex = null;
        int _VOL_INIT_RATE = 8;
        boolean _VOL_SAFETY_LEVEL = true;
        boolean _INSTANCE_NAME_INDEX = false;
        boolean _STOR_SETT_INDEX = true;
        int _POOL_SIZE_INDEX = 2;
        int _EXTENT_ARRAY_INDEX = 4;
        int _JOB_DESCRIPTION_INDEX = 6;
        int[] paramIndex = new int[]{0, 1, 4};
        String[] paramNames = new String[]{"Name", "Goal", "InExtents[]"};
        WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " entered"));
        try {
            int badIndex = this.checkForNullParams(paramIndex, request);
            if (badIndex != -1) {
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered a null parameter: " + paramNames[badIndex]));
                return;
            }
        }
        catch (Exception e) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered an exception. "), (Throwable)e);
            return;
        }
        CIMArgument[] inArgs = request.getInParams();
        int i = 0;
        while (i < inArgs.length) {
            if (inArgs[i].getName().equalsIgnoreCase("InExtents")) {
                extents = (Vector)inArgs[i].getValue().getValue();
            }
            if (inArgs[i].getName().equalsIgnoreCase("Goal")) {
                storSet = RequestBroker.getInstance().getInstance((CIMObjectPath)inArgs[i].getValue().getValue(), false, false, false, null, null);
                WBEMDebug.trace2((String)(CLASSNAME + "." + METHOD + ": StorageSetting" + storSet.toString()));
            }
            ++i;
        }
        if (extents.isEmpty()) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " failed to discover any StorageExtents for this Pool"));
            return;
        }
        volName = (String)inArgs[0].getValue().getValue();
        if (volName == null) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " No name found for the intended pool "));
            return;
        }
        if (volName.length() >= 12) {
            volName = volName.substring(0, Math.min(volName.length(), 12));
        }
        int numDrives = extents.size();
        Vector<String> fruIds = new Vector<String>();
        Iterator driveIter = extents.iterator();
        while (driveIter.hasNext()) {
            String extent = (String)driveIter.next();
            int begInd = extent.indexOf("DeviceID=") + 11;
            int endInd = extent.indexOf(92, begInd);
            fruIds.add(extent.substring(begInd, endInd));
        }
        CIMInstance[] poolDrives = null;
        try {
            poolDrives = RequestBroker.getInstance().enumerateInstances(this.getSystem(), new CIMObjectPath("StorEdge_6120StorageExtent"), false, true, false, null, null);
        }
        catch (CIMException ce) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " An exception occurred while retrieving the " + "StorageExtents: " + (Object)((Object)ce)), (Throwable)ce);
            request.setResults(_CONF_SERVICE_FAILURE);
            return;
        }
        int i2 = 0;
        while (i2 < poolDrives.length) {
            CIMInstance aDrive = poolDrives[i2];
            CIMProperty prop = aDrive.getProperty("DeviceID");
            if (prop.getValue() == null && prop.getValue().getValue() == null) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not find the DeviceID property for " + "StorageExtent: " + aDrive));
                request.setResults(_CONF_SERVICE_FAILURE);
                return;
            }
            if (fruIds.contains((String)prop.getValue().getValue())) {
                newDrives.add(aDrive);
            }
            ++i2;
        }
        int dmin = 15;
        int dmax = 0;
        String inUnitIndex = null;
        Iterator fruIter = fruIds.iterator();
        while (fruIter.hasNext()) {
            String elementname = (String)fruIter.next();
            inUnitIndex = elementname.substring(elementname.indexOf("u") + 1, elementname.indexOf("d"));
            if (unitIndex.equals("-1")) {
                unitIndex = inUnitIndex;
            }
            if (!unitIndex.equals(inUnitIndex)) {
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " StorageExtents for Pool aren't within the same tray"));
                return;
            }
            int dval = new Integer(elementname.substring(elementname.indexOf("d") + 1));
            if (dval < dmin) {
                dmin = dval;
            }
            if (dval <= dmax) continue;
            dmax = dval;
        }
        if (dmax - dmin + 1 > numDrives || dmax < dmin) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " StorageExtents Not Proper"));
            return;
        }
        CIMObjectPath clusOp = new CIMObjectPath();
        clusOp.setNameSpace(request.getObjectPath().getNameSpace());
        clusOp.setObjectName("StorEdge_6120Cluster");
        CIMInstance[] insts = null;
        CIMObjectPath qualified = request.getObjectPath();
        qualified.setNameSpace("\\root\\se6x20");
        insts = RequestBroker.getInstance().associators(new CIMObjectPath("StorEdge_6120HostedConfigService"), qualified, "StorEdge_6120Cluster", null, null, true, false, null);
        if (insts == null) {
            request.setResults(_CONF_SERVICE_FAILURE);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Failed to discover the ConfigService for cluster: " + request.getObjectPath()));
            return;
        }
        cluster = insts[0];
        if (cluster == null) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not find the Cluster this array is supposed to map to: " + this.getSystem().getHost()));
            request.setResults(_CONF_SERVICE_FAILURE);
            return;
        }
        CIMObjectPath assocName = new CIMObjectPath("StorEdge_6120ComputerSystemPackage");
        qualified = cluster.getObjectPath();
        qualified.setNameSpace("\\root\\se6x20");
        insts = RequestBroker.getInstance().associators(assocName, qualified, "StorEdge_6120Chassis", null, null, true, false, null);
        if (insts.length == 0) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " : There are no trays for this pool to be created, on to: " + this.getSystem().getHost()));
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            return;
        }
        WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + ": found Cluster for this system."));
        HashSet<String> usedVolIndices = new HashSet<String>();
        assocName = new CIMObjectPath("StorEdge_6120HostedStoragePool");
        qualified = cluster.getObjectPath();
        qualified.setNameSpace("\\root\\se6x20");
        insts = RequestBroker.getInstance().associators(assocName, qualified, "StorEdge_6120StoragePool", null, null, true, false, null);
        int iUnitIndex = Integer.parseInt(unitIndex);
        if (insts != null) {
            int i3 = 0;
            while (i3 < insts.length) {
                CIMInstance poolInst = insts[i3];
                CIMProperty poolProp = poolInst.getProperty("PoolID");
                if (poolProp.getValue() == null || poolProp.getValue().getValue() == null) {
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not find the PoolID property for " + "Pool: " + poolInst));
                    request.setResults(_CONF_SERVICE_FAILURE);
                    return;
                }
                String poolid = (String)poolProp.getValue().getValue();
                String uIndex = poolid.substring(poolid.indexOf("u") + 1, poolid.indexOf("v"));
                if (Integer.parseInt(uIndex) + 1 == iUnitIndex) {
                    String vIndex = poolid.substring(poolid.indexOf("v") + 1);
                    WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " adding to usedVolIndices: " + vIndex));
                    usedVolIndices.add(vIndex);
                }
                ++i3;
            }
        }
        if (usedVolIndices.size() >= 2) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Maximum pools already exist on this tray!"));
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            return;
        }
        volIndex = usedVolIndices.contains("0") ? "1" : "0";
        Vector props = storSet.getProperties();
        Iterator iter = props.iterator();
        boolean noSinglePoint = false;
        int dataRedunMin = -1;
        int spindleRedunMin = -1;
        String profileDesc = "";
        while (iter.hasNext()) {
            CIMProperty settProp = (CIMProperty)iter.next();
            if (settProp.getValue() == null || settProp.getValue().getValue() == null) {
                if (!settProp.getName().equalsIgnoreCase("SpindleRedundancyMin") && !settProp.getName().equalsIgnoreCase("NoSinglePointOfFailure") && !settProp.getName().equalsIgnoreCase("DataRedundancyMin")) continue;
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Volume index not accepted:  " + unitIndex));
                return;
            }
            if (settProp.getName().equalsIgnoreCase("SpindleRedundancyMin")) {
                spindleRedunMin = this.getInt16(settProp);
                continue;
            }
            if (settProp.getName().equalsIgnoreCase("NoSinglePointOfFailure")) {
                if (settProp.getType().getType() != 9) continue;
                Boolean b = (Boolean)settProp.getValue().getValue();
                noSinglePoint = b;
                continue;
            }
            if (settProp.getName().equalsIgnoreCase("DataRedundancyMin")) {
                dataRedunMin = this.getInt16(settProp);
                continue;
            }
            if (!settProp.getName().equalsIgnoreCase("Description")) continue;
            profileDesc = this.getString(settProp);
        }
        int raid = -1;
        try {
            raid = this.getRaidLevel(spindleRedunMin, noSinglePoint, dataRedunMin);
        }
        catch (CIMException ce) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " RAID level is not within defined parameters,  " + " SpindleRedundancyMin = " + spindleRedunMin + " NoSinglePointOfFailure = " + noSinglePoint + " DataRedundancyMin = " + dataRedunMin), (Throwable)ce);
            return;
        }
        boolean useAnyHotSpare = false;
        boolean requestingDedicatedSpare = false;
        if (ArrayInventory.getInstance().getArrayObject(this.getSystem().getHost()).isFeatureSupported(3)) {
            useAnyHotSpare = true;
        }
        boolean invalidRequest = false;
        if (raid == 1 || raid == 5) {
            if (spindleRedunMin == 1) {
                requestingDedicatedSpare = false;
            } else if (spindleRedunMin == 2) {
                requestingDedicatedSpare = true;
            } else {
                invalidRequest = true;
            }
        } else if (raid == 0 && spindleRedunMin == 0) {
            requestingDedicatedSpare = false;
        } else {
            invalidRequest = true;
        }
        if (invalidRequest) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Provided RAID and spare request is not valid for " + " the given parameters and configuration of the " + " array.   Requested RAID level: " + raid + " SpindleRedundancyMin: " + spindleRedunMin + " DataRedundancyMin: " + dataRedunMin));
            return;
        }
        if (requestingDedicatedSpare) {
            try {
                hotSpare = this.getHotSpareFruID(newDrives, useAnyHotSpare, false);
                if (null == hotSpare) {
                    request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": No valid spare was discovered to add."));
                    return;
                }
            }
            catch (CIMException ce) {
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Provided spare request is not valid for the " + " given parameters and configuration of the array. " + " Requested RAID level: " + raid + " Drives requested: " + newDrives), (Throwable)ce);
                return;
            }
        }
        String drives = "u" + unitIndex + "d";
        drives = dmin > 9 ? drives + dmin : drives + "0" + dmin;
        drives = dmax > 9 ? drives + "-" + dmax : drives + "-0" + dmax;
        String cmd = "vol add " + volName + " data " + drives + " raid " + raid;
        if (requestingDedicatedSpare) {
            cmd = cmd + " standby " + hotSpare;
        }
        if (RequestBroker.getInstance().isSyntheticCacheInstance(storSet.getObjectPath())) {
            RequestBroker.getInstance().deleteInstance(storSet.getObjectPath());
        }
        String[] telnetcmds = new String[4];
        WBEMDebug.trace3((String)(CLASSNAME + ": telnet create pool cmd = " + cmd));
        telnetcmds[0] = cmd;
        telnetcmds[1] = cmd = "vol init " + volName + " data";
        telnetcmds[2] = cmd = "vol mount " + volName;
        telnetcmds[3] = this.getSystem().getHost();
        unitIndex = this.subtractOne(unitIndex);
        Vector<Object> tokenArgs = new Vector<Object>();
        tokenArgs.add("unitIndex=" + unitIndex);
        tokenArgs.add("volIndex=" + volIndex);
        tokenArgs.add("volName=" + volName);
        tokenArgs.add("volArrayWidth=" + numDrives);
        tokenArgs.add("volRaidLevel=" + volRaidLevel + raid);
        tokenArgs.add("volSafety=1");
        tokenArgs.add("volInitRate=8");
        tokenArgs.add("unitStandby=" + hotSpare);
        tokenArgs.add(extents);
        tokenArgs.add(profileDesc);
        CIMInstance hsInst = null;
        Vector<String> hsVector = new Vector<String>();
        if (requestingDedicatedSpare) {
            hsInst = this.getHotSpareInstance(newDrives, useAnyHotSpare, false);
            hsVector.add(hsInst.getObjectPath().toString());
        }
        tokenArgs.add(hsVector);
        String jobDesc = null;
        try {
            jobDesc = (String)inArgs[6].getValue().getValue();
        }
        catch (NullPointerException ne) {
        }
        catch (ArrayIndexOutOfBoundsException ae) {
        }
        catch (Exception e) {
            request.setResults(_CONF_SERVICE_FAILURE);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered an exception. " + e.getMessage()), (Throwable)e);
            return;
        }
        CIMObjectPath jobOp = null;
        jobOp = jobDesc != null ? ModifyJobs.getInstance(this.getSystem().getHost()).createJob("createPool", tokenArgs, telnetcmds, jobDesc) : ModifyJobs.getInstance(this.getSystem().getHost()).createJob("createPool", tokenArgs, telnetcmds);
        CIMArgument[] outParams = request.getOutParams();
        outParams[0] = new CIMArgument("Job", new CIMValue((Object)jobOp));
        outParams[1] = new CIMArgument("Size", null);
        outParams[2] = new CIMArgument("Pool", null);
        request.setResults(_CONF_SERVICE_JOB_STARTED);
    }

    private void initializeStoragePool(InvokeRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        String METHOD = "initializeStoragePool";
        boolean _POOL_INDEX = false;
        boolean _JOB_DESCRIPTION_INDEX = true;
        CIMInstance poolInst = null;
        Vector<String> tokenArgs = new Vector<String>();
        int[] paramIndex = new int[]{0};
        String[] paramNames = new String[]{"Pool"};
        WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " entered"));
        try {
            int badIndex = this.checkForNullParams(paramIndex, request);
            if (badIndex != -1) {
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered a null parameter: " + paramNames[badIndex]));
                return;
            }
        }
        catch (Exception e) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered an exception. "), (Throwable)e);
            return;
        }
        CIMArgument[] inArgs = request.getInParams();
        if (inArgs == null) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Did not have any parameters"));
            return;
        }
        if (inArgs[0].getValue().getType().getType() == 28) {
            WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " have reference type"));
            if (inArgs[0].getType().getRefClassName().equalsIgnoreCase("StorEdge_6120StoragePool")) {
                CIMArgument delArg;
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " have storage pool to initialize"));
                CIMObjectPath op = (CIMObjectPath)inArgs[0].getValue().getValue();
                poolInst = RequestBroker.getInstance().getInstance(op, false, false, false, null, null);
                if (poolInst == null) {
                    request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not find instance of Pool to initialize"));
                    return;
                }
                CIMProperty prop = poolInst.getProperty("PoolID");
                if (prop.getValue() == null || prop.getValue().getValue() == null) {
                    request.setResults(_CONF_SERVICE_FAILURE);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not discover PoolID property for Pool: " + poolInst));
                    return;
                }
                String poolid = (String)prop.getValue().getValue();
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " parsing poolId: " + poolid));
                String uIndex = poolid.substring(poolid.indexOf("u") + 1, poolid.indexOf("v"));
                String vIndex = poolid.substring(poolid.indexOf("v") + 1);
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " parsed uIndex: " + uIndex + " vIndex: " + vIndex));
                prop = poolInst.getProperty("ElementName");
                if (prop.getValue() == null || prop.getValue().getValue() == null) {
                    request.setResults(_CONF_SERVICE_FAILURE);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not discover ElementName property for Pool: " + poolInst));
                    return;
                }
                String volName = (String)prop.getValue().getValue();
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " have volName: " + volName));
                tokenArgs.add("unitIndex=" + uIndex);
                tokenArgs.add("volIndex=" + vIndex);
                tokenArgs.add("volName=" + volName);
                tokenArgs.add(poolid);
                String[] telnetcmds = new String[]{"padding to match createStoragePool indexing", "vol init " + volName + " data", "vol mount " + volName, this.getSystem().getHost()};
                String jobDesc = null;
                try {
                    jobDesc = (String)inArgs[1].getValue().getValue();
                }
                catch (NullPointerException ne) {
                }
                catch (ArrayIndexOutOfBoundsException ae) {
                }
                catch (Exception e) {
                    request.setResults(_CONF_SERVICE_FAILURE);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered an exception. " + e.getMessage()), (Throwable)e);
                    return;
                }
                CIMObjectPath jobOp = null;
                jobOp = jobDesc != null ? ModifyJobs.getInstance(this.getSystem().getHost()).createJob("initializePool", tokenArgs, telnetcmds, jobDesc) : ModifyJobs.getInstance(this.getSystem().getHost()).createJob("initializePool", tokenArgs, telnetcmds);
                CIMArgument[] outParams = request.getOutParams();
                CIMValue jobVal = new CIMValue((Object)jobOp);
                outParams[0] = delArg = new CIMArgument("Job", jobVal);
                request.setResults(_CONF_SERVICE_JOB_STARTED);
            }
        } else {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
        }
    }

    private void createOrModifyArraySparedSet(InvokeRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        String METHOD = "createOrModifyArraySparedSet";
        boolean _SPARED_SET_INDEX = true;
        boolean _REDUNDANT_EXTENT_INDEX = false;
        int _JOB_DESCRIPTION_INDEX = 2;
        int _EXTENT_STATE_INDEX = 2;
        int _EXTENT_ROLE_INDEX = 3;
        int _MAX_GLOBAL_STANDBY_DRIVE_COUNT = 8;
        String _TELNET_ERROR_INVALID_DRIVE = "ERROR (20001F) VN_DEVINVALID: invalid drive specified";
        String _TELNET_ERROR_INVALID_DRIVE_REMOVE = "is not found in the Global Standby pool.";
        String _TELNET_ERROR_REDUNDANT_DRIVE = "ERROR (200035) VN_DEVINGHSDB: The drive is already in";
        CIMInstance spareSet = null;
        Vector tokenArgs = new Vector();
        Vector newextents = new Vector();
        Vector<String> tobeRemoved = new Vector<String>();
        int[] paramIndex = new int[]{0};
        String[] paramNames = new String[]{"RedundantExtents"};
        WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " entered"));
        try {
            int badIndex = this.checkForNullParams(paramIndex, request);
            if (badIndex != -1) {
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered a null parameter: " + paramNames[badIndex]));
                return;
            }
        }
        catch (Exception e) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered an exception. "), (Throwable)e);
            return;
        }
        CIMArgument[] inArgs = request.getInParams();
        if (inArgs == null) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Did not have any parameters"));
            return;
        }
        if (!ArrayInventory.getInstance().getArrayObject(this.getSystem().getHost()).isFeatureSupported(3)) {
            request.setResults(_CONF_SERVICE_NOT_SUPPORTED);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Firmware version does not support this operation."));
            return;
        }
        int i = 0;
        while (i < inArgs.length) {
            if (inArgs[i].getName().equalsIgnoreCase("RedundantExtents")) {
                newextents = (Vector)inArgs[i].getValue().getValue();
                break;
            }
            ++i;
        }
        if (newextents.size() > 8) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Number of extents exceeds the maximum allowable " + "number of drives to be participant in the array" + "spare set, " + 8));
            return;
        }
        CIMInstance[] cacheExtents = RequestBroker.getInstance().enumerateInstances(this.getSystem(), new CIMObjectPath("StorEdge_6120StorageExtent"), false, true, false, null, null);
        HashMap<String, CIMInstance> templist = new HashMap<String, CIMInstance>();
        int i2 = 0;
        while (i2 < newextents.size()) {
            int endInd;
            String piece = (String)newextents.get(i2);
            int begInd = piece.indexOf("DeviceID") + 11;
            String driveIndex = (piece = piece.substring(begInd, endInd = piece.indexOf(92, begInd))).substring(piece.indexOf("d"));
            if (driveIndex.equalsIgnoreCase("d01")) {
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " The first drive in a tray is not valid for Array Spares."));
                return;
            }
            try {
                int k = 0;
                while (k < cacheExtents.length) {
                    CIMInstance anExtent = cacheExtents[k];
                    CIMProperty uid = anExtent.getProperty("DeviceID");
                    if (piece.equals((String)uid.getValue().getValue())) {
                        templist.put(piece, anExtent);
                        break;
                    }
                    ++k;
                }
            }
            catch (NullPointerException npe) {
                request.setResults(_CONF_SERVICE_FAILURE);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " A NullPointerException was encountered while attempting " + "to extract property data for a StorageExtent:" + npe), (Throwable)npe);
                return;
            }
            ++i2;
        }
        if (templist.size() != newextents.size()) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not find the StorageExtents in cache to match!"));
            return;
        }
        newextents.removeAllElements();
        newextents.addAll(templist.values());
        if (inArgs[1].getValue().getType().getType() == 28) {
            WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " have reference type"));
            if (inArgs[1].getType().getRefClassName().equalsIgnoreCase("StorEdge_6120ArraySparedSet")) {
                CIMArgument delArg;
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " have spared set to modify"));
                CIMObjectPath op = (CIMObjectPath)inArgs[1].getValue().getValue();
                spareSet = RequestBroker.getInstance().getInstance(op, false, false, false, null, null);
                if (spareSet == null) {
                    request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not find instance of SparedSet to modify"));
                    return;
                }
                boolean extentInUse = false;
                try {
                    Iterator extentIter = newextents.iterator();
                    while (extentIter.hasNext()) {
                        CIMInstance anExtent = (CIMInstance)extentIter.next();
                        CIMProperty extProp = anExtent.getProperty("OtherIdentifyingInfo");
                        Vector propVec = (Vector)extProp.getValue().getValue();
                        String extRole = (String)propVec.get(3);
                        String extState = (String)propVec.get(2);
                        if (extRole.equalsIgnoreCase("globalStandbyDisk") || extState.equalsIgnoreCase("enabled") && extRole.equalsIgnoreCase("unassigned")) continue;
                        extentInUse = true;
                        break;
                    }
                }
                catch (NullPointerException npe) {
                    request.setResults(_CONF_SERVICE_FAILURE);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " A NullPointerException was encountered while attempting " + "to extract property data for a StorageExtent:" + npe), (Throwable)npe);
                    return;
                }
                if (extentInUse) {
                    request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Passed in extent is currently in use as part " + "of a data volume or unavailable."));
                    return;
                }
                op = new CIMObjectPath("StorEdge_6120ArraySparedSet");
                CIMInstance[] oldSets = RequestBroker.getInstance().enumerateInstances(this.getSystem(), op, false, true, false, null, null);
                CIMInstance oldSet = oldSets[0];
                if (oldSet != null) {
                    CIMObjectPath qualified = oldSet.getObjectPath();
                    qualified.setNameSpace("\\root\\se6x20");
                    CIMObjectPath assoc = new CIMObjectPath("StorEdge_6120IsArraySpare");
                    CIMInstance[] oldextents = RequestBroker.getInstance().associators(assoc, qualified, "StorEdge_6120StorageExtent", null, null, true, false, null);
                    if (oldextents != null) {
                        try {
                            int i3 = 0;
                            while (i3 < oldextents.length) {
                                CIMInstance modextent = oldextents[i3];
                                String fruId = (String)modextent.getProperty("DeviceID").getValue().getValue();
                                if (templist.containsKey(fruId)) {
                                    templist.remove(fruId);
                                } else {
                                    tobeRemoved.add(fruId);
                                }
                                ++i3;
                            }
                        }
                        catch (NullPointerException npe) {
                            request.setResults(_CONF_SERVICE_FAILURE);
                            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " A NullPointerException was encountered while " + "attempting to extract property data for a " + "StorageExtent:" + npe), (Throwable)npe);
                            return;
                        }
                        if (oldextents.length - tobeRemoved.size() + templist.size() > 8) {
                            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Passed in extents exceed the maximum size of " + "the array standby set."));
                            return;
                        }
                        if (tobeRemoved.size() > 0) {
                            String base = "global_standby remove ";
                            int i4 = 0;
                            while (i4 < tobeRemoved.size()) {
                                tobeRemoved.set(i4, base.concat((String)tobeRemoved.get(i4)));
                                ++i4;
                            }
                        }
                    }
                }
                String[] resp = new String[tobeRemoved.size() + templist.size()];
                String[] telnetcmds = new String[tobeRemoved.size() + templist.size()];
                int i5 = 0;
                while (i5 < tobeRemoved.size()) {
                    telnetcmds[i5] = (String)tobeRemoved.get(i5);
                    resp[i5] = ">";
                    ++i5;
                }
                Iterator keyIter = templist.keySet().iterator();
                int i6 = tobeRemoved.size();
                while (keyIter.hasNext()) {
                    String devId = (String)keyIter.next();
                    telnetcmds[i6] = "global_standby add " + devId;
                    resp[i6] = ">";
                    ++i6;
                }
                String[] dserrs = new String[]{"usage: ", "Command not reentrant", "Command not found", "ERROR (20001F) VN_DEVINVALID: invalid drive specified", "ERROR", "It can't be removed"};
                try {
                    DevComm.getInstance().telnetMultiPost(this.getSystem(), telnetcmds, resp, dserrs, new int[0]);
                }
                catch (StorEdgeIOException ioe) {
                    request.setResults(_CONF_SERVICE_FAILURE);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Exception occurred from communication " + "between the provider and the array." + ioe.getMessage()), (Throwable)ioe);
                    return;
                }
                catch (ArrayException ae) {
                    request.setResults(_CONF_SERVICE_FAILURE);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Exception occurred from communication " + "between the provider and the array." + ae.getMessage()), (Throwable)ae);
                    return;
                }
                CIMArgument[] outParams = request.getOutParams();
                CIMValue jobVal = new CIMValue(null);
                outParams[0] = delArg = new CIMArgument("Job", jobVal);
                request.setResults(_CONF_SERVICE_COMPLETE_SUCCESSFUL);
                RequestBroker.getInstance().invalidateCache(this.getSystem());
            } else {
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " Unable to find the spared set in the parameters. Found class name: " + inArgs[1].getType().getRefClassName() + "  and found type: " + inArgs[1].getType()));
            }
        } else {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
        }
    }

    private void deleteStoragePool(InvokeRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        String METHOD = "deleteStoragePool";
        boolean _POOL_INDEX = false;
        boolean _JOB_DESCRIPTION_INDEX = true;
        CIMInstance poolInst = null;
        Vector<String> tokenArgs = new Vector<String>();
        int[] paramIndex = new int[]{0};
        String[] paramNames = new String[]{"Pool"};
        WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " entered"));
        try {
            int badIndex = this.checkForNullParams(paramIndex, request);
            if (badIndex != -1) {
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered a null parameter: " + paramNames[badIndex]));
                return;
            }
        }
        catch (Exception e) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered an exception. " + e), (Throwable)e);
            return;
        }
        CIMArgument[] inArgs = request.getInParams();
        if (inArgs == null) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Did not have any parameters"));
            return;
        }
        if (inArgs[0].getValue().getType().getType() == 28) {
            WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " have reference type"));
            if (inArgs[0].getType().getRefClassName().equalsIgnoreCase("StorEdge_6120StoragePool")) {
                CIMArgument delArg;
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " have storage pool to delete"));
                CIMObjectPath op = (CIMObjectPath)inArgs[0].getValue().getValue();
                poolInst = RequestBroker.getInstance().getInstance(op, false, false, false, null, null);
                if (poolInst == null) {
                    request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not find instance of Pool to delete"));
                    return;
                }
                CIMProperty prop = poolInst.getProperty("PoolID");
                if (prop.getValue() == null || prop.getValue().getValue() == null) {
                    request.setResults(_CONF_SERVICE_FAILURE);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not discover PoolID property for Pool: " + poolInst));
                    return;
                }
                String poolid = (String)prop.getValue().getValue();
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " parsing poolId: " + poolid));
                String uIndex = poolid.substring(poolid.indexOf("u") + 1, poolid.indexOf("v"));
                String vIndex = poolid.substring(poolid.indexOf("v") + 1);
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " parsed uIndex: " + uIndex + " vIndex: " + vIndex));
                prop = poolInst.getProperty("ElementName");
                if (prop.getValue() == null || prop.getValue().getValue() == null) {
                    request.setResults(_CONF_SERVICE_FAILURE);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not discover ElementName property for Pool: " + poolInst));
                    return;
                }
                CIMProperty poolWWN = poolInst.getProperty("InstanceID");
                String WWN = null;
                if (poolWWN != null && poolWWN.getValue() != null && poolWWN.getValue().getValue() != null) {
                    WWN = poolWWN.getValue().getValue().toString();
                    StorEdge_PersistentStorage.getInstance().removePersistentString("StorEdge_6120StoragePool." + WWN + ".ProfileKey", true);
                }
                String volName = (String)prop.getValue().getValue();
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " have volName: " + volName));
                tokenArgs.add("unitIndex=" + uIndex);
                tokenArgs.add("volIndex=" + vIndex);
                tokenArgs.add("volName=" + volName);
                tokenArgs.add(poolid);
                String[] telnetcmds = new String[]{"vol unmount " + volName, "vol -y remove " + volName, this.getSystem().getHost()};
                String jobDesc = null;
                try {
                    jobDesc = (String)inArgs[1].getValue().getValue();
                }
                catch (NullPointerException ne) {
                }
                catch (ArrayIndexOutOfBoundsException ae) {
                }
                catch (Exception e) {
                    request.setResults(_CONF_SERVICE_FAILURE);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered an exception. " + e.getMessage()), (Throwable)e);
                    return;
                }
                CIMObjectPath jobOp = null;
                jobOp = jobDesc != null ? ModifyJobs.getInstance(this.getSystem().getHost()).createJob("deletePool", tokenArgs, telnetcmds, jobDesc) : ModifyJobs.getInstance(this.getSystem().getHost()).createJob("deletePool", tokenArgs, telnetcmds);
                CIMArgument[] outParams = request.getOutParams();
                CIMValue jobVal = new CIMValue((Object)jobOp);
                outParams[0] = delArg = new CIMArgument("Job", jobVal);
                request.setResults(_CONF_SERVICE_JOB_STARTED);
            }
        } else {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
        }
    }

    private void returnToStoragePool(InvokeRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        String METHOD = "returnToStoragePool";
        boolean _JOB_DESCRIPTION_INDEX = true;
        CIMInstance poolInst = null;
        Vector<Object> tokenArgs = new Vector<Object>();
        boolean _VOLSLICE_INDEX = false;
        CIMInstance volInst = null;
        String uIndex = null;
        String vIndex = null;
        CIMInstance[] assocs = null;
        int[] paramIndex = new int[]{0};
        String[] paramNames = new String[]{"TheElement"};
        WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " entered"));
        try {
            int badIndex = this.checkForNullParams(paramIndex, request);
            if (badIndex != -1) {
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered a null parameter: " + paramNames[badIndex]));
                return;
            }
        }
        catch (Exception e) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered an exception. " + e), (Throwable)e);
            return;
        }
        CIMArgument[] inArgs = request.getInParams();
        if (inArgs[0].getType().getType() == 28) {
            if (inArgs[0].getType().getRefClassName().equalsIgnoreCase("StorEdge_6120StorageVolume")) {
                CIMProperty prop;
                int i;
                CIMObjectPath op = (CIMObjectPath)inArgs[0].getValue().getValue();
                volInst = RequestBroker.getInstance().getInstance(op, false, true, false, null, null);
                if (volInst == null) {
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not discover instance of StorageVolume" + " in cache to delete."));
                    request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                    return;
                }
                CIMObjectPath qualified = volInst.getObjectPath();
                qualified.setNameSpace("\\root\\se6x20");
                assocs = RequestBroker.getInstance().associators(new CIMObjectPath("StorEdge_6120MappedSCSILUN"), qualified, "StorEdge_6120AuthorizationViewSCSIController", null, null, true, false, null);
                if (assocs != null) {
                    i = 0;
                    while (i < assocs.length) {
                        CIMInstance mapInst = assocs[i];
                        CIMProperty defGlobAcc = mapInst.getProperty("DefaultGlobalAccess");
                        if (defGlobAcc.getValue() == null || defGlobAcc.getValue().getValue() == null) {
                            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not discover instance of StorageVolume" + " in cache to delete."));
                            request.setResults(_CONF_SERVICE_FAILURE);
                            return;
                        }
                        if (!((Boolean)defGlobAcc.getValue().getValue()).booleanValue()) {
                            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": There remains an ACI non-default instance for " + "this StorageVolume: " + volInst));
                            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                            return;
                        }
                        ++i;
                    }
                }
                qualified = volInst.getObjectPath();
                qualified.setNameSpace("\\root\\se6x20");
                assocs = RequestBroker.getInstance().associators(new CIMObjectPath("StorEdge_6120AllocatedFromStoragePool"), qualified, "StorEdge_6120StoragePool", null, null, true, false, null);
                if (assocs == null) {
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Did not find allocation for this storage volume."));
                    request.setResults(_CONF_SERVICE_FAILURE);
                    return;
                }
                i = 0;
                if (i < assocs.length) {
                    poolInst = assocs[i];
                    prop = poolInst.getProperty("PoolID");
                    if (prop.getValue() == null || prop.getValue().getValue() == null) {
                        WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Did not find property PoolID for Pool: " + poolInst));
                        request.setResults(_CONF_SERVICE_FAILURE);
                        return;
                    }
                    String poolId = (String)poolInst.getProperty("PoolID").getValue().getValue();
                    if (poolId != null) {
                        uIndex = poolId.substring(poolId.indexOf("u") + 1, poolId.indexOf("v"));
                        vIndex = poolId.substring(poolId.indexOf("v") + 1);
                    } else {
                        WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + "No PoolID existed for this StoragePool"));
                        request.setResults(_CONF_SERVICE_FAILURE);
                        return;
                    }
                }
                prop = volInst.getProperty("OtherIdentifyingInfo");
                if (prop.getType().isArrayType()) {
                    String volSliceName = (String)((Vector)prop.getValue().getValue()).get(0);
                    tokenArgs.add("unitIndex=" + uIndex);
                    tokenArgs.add("volIndex=" + vIndex);
                    tokenArgs.add("volSliceName=" + volSliceName);
                    CIMProperty poolName = poolInst.getProperty("ElementName");
                    if (poolName.getValue() == null || poolName.getValue().getValue() == null) {
                        WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Did not find property ElementName for Pool: " + poolInst));
                        request.setResults(_CONF_SERVICE_FAILURE);
                        return;
                    }
                    tokenArgs.add(poolName.getValue().getValue());
                    String[] telnetcmds = new String[]{"volslice remove " + volSliceName, this.getSystem().getHost()};
                    String jobDesc = null;
                    try {
                        jobDesc = (String)inArgs[1].getValue().getValue();
                    }
                    catch (NullPointerException ne) {
                    }
                    catch (ArrayIndexOutOfBoundsException ae) {
                    }
                    catch (Exception e) {
                        request.setResults(_CONF_SERVICE_FAILURE);
                        WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered an exception. " + e.getMessage()), (Throwable)e);
                        return;
                    }
                    CIMObjectPath jobOp = null;
                    jobOp = jobDesc != null ? ModifyJobs.getInstance(this.getSystem().getHost()).createJob("deleteVolume", tokenArgs, telnetcmds, jobDesc) : ModifyJobs.getInstance(this.getSystem().getHost()).createJob("deleteVolume", tokenArgs, telnetcmds);
                    request.setResults(_CONF_SERVICE_JOB_STARTED);
                    CIMArgument[] outParams = request.getOutParams();
                    outParams[0] = new CIMArgument("Job", new CIMValue((Object)jobOp));
                } else {
                    request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " unitIndex and volIndex were not discovered in" + " OtherIdentifyingInfo array"));
                }
            } else {
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + "Discovered element is not an instance of StorEdge" + "_6120StoragePool, required for this method"));
            }
        } else {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + "The discovered element provided is not a Reference type, " + " required for this method"));
        }
    }

    private String convertBooleanToYes(boolean in) {
        if (in) {
            return "yes";
        }
        return "no";
    }

    private String getString(CIMProperty target) {
        String retString = null;
        if (target.getValue() != null && target.getValue().getValue() != null) {
            retString = target.getValue().getValue().toString();
        }
        return retString;
    }

    private int getInt16(CIMProperty target) {
        int retInt = -1;
        if (target.getValue() != null && target.getValue().getValue() != null) {
            retInt = ((UnsignedInt16)target.getValue().getValue()).intValue();
        }
        return retInt;
    }

    private String getHotSpareFruID(Vector extents, boolean anyHotSpare, boolean changePool) throws CIMException {
        String fruId = null;
        CIMInstance extent = this.getHotSpareInstance(extents, anyHotSpare, changePool);
        CIMProperty aProp = extent.getProperty("DeviceID");
        if (aProp.getValue() != null && aProp.getValue().getValue() != null) {
            fruId = (String)aProp.getValue().getValue();
        }
        return fruId;
    }

    /*
     * Enabled aggressive block sorting
     */
    private CIMInstance getHotSpareInstance(Vector extents, boolean anyHotSpare, boolean changePool) throws CIMException {
        CIMInstance retVal = null;
        CIMInstance thisExtent = null;
        Object cacheExtents = null;
        Vector<String> fruInUse = new Vector<String>();
        String trayNum = "-1";
        int _EXTENT_STATE_INDEX = 2;
        int _EXTENT_ROLE_INDEX = 3;
        String _STATE_ENABLED = "enabled";
        String _ROLE_STANDBY = "standbyDisk";
        String _ROLE_UNASSIGNED = "unassigned";
        String _ROLE_DATA_DISK = "dataDisk";
        String _LAST_DRIVE_ID = "d14";
        String _RESERVED_DRIVE_ID = "d01";
        String METHOD = "getHotSpareInstance";
        boolean extentInvalid = false;
        BigInteger smallest = null;
        Iterator exIter = extents.iterator();
        while (exIter.hasNext()) {
            thisExtent = (CIMInstance)exIter.next();
            CIMProperty prop = thisExtent.getProperty("OtherIdentifyingInfo");
            Vector propVec = (Vector)prop.getValue().getValue();
            String extRole = (String)propVec.get(3);
            String extState = (String)propVec.get(2);
            if (!changePool) {
                if (!extState.equalsIgnoreCase("enabled") || !extRole.equalsIgnoreCase("unassigned")) {
                    extentInvalid = true;
                    WBEMDebug.trace1((String)(CLASSNAME + "." + "getHotSpareInstance" + "The provided extent is not available for use as " + "a data drive. " + thisExtent));
                    break;
                }
            } else if (!extState.equalsIgnoreCase("enabled") || !extRole.equalsIgnoreCase("dataDisk")) {
                extentInvalid = true;
                WBEMDebug.trace1((String)(CLASSNAME + "." + "getHotSpareInstance" + "The provided extent is not currently used as " + "a data drive. " + thisExtent.getObjectPath()));
                break;
            }
            prop = thisExtent.getProperty("NumberOfBlocks");
            BigInteger blkSize = ((UnsignedInt64)prop.getValue().getValue()).bigIntValue();
            smallest = smallest == null ? blkSize : smallest.min(blkSize);
            prop = thisExtent.getProperty("DeviceID");
            String tempId = (String)prop.getValue().getValue();
            fruInUse.add(tempId);
            String parts = tempId.substring(tempId.indexOf("u") + 1, tempId.indexOf("d"));
            if (!trayNum.equals("-1")) {
                if (trayNum.equals(parts)) continue;
                WBEMDebug.trace1((String)(CLASSNAME + "." + "getHotSpareInstance" + "The requested StoragePool cannot be constructed because " + "a requested drive does not exist in the tray."));
                extentInvalid = true;
                break;
            }
            trayNum = parts;
        }
        if (extentInvalid) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        CIMInstance[] gaa = RequestBroker.getInstance().enumerateInstances(this.getSystem(), new CIMObjectPath("StorEdge_6120StorageExtent"), false, true, false, null, null);
        trayNum = "u" + trayNum;
        Vector<CIMInstance> evalExtent = new Vector<CIMInstance>();
        CIMInstance[] poolJobs = this.getCreatePoolJobs();
        boolean supportsHotSpare = ArrayInventory.getInstance().getArrayObject(this.getSystem().getHost()).isFeatureSupported(3);
        int i = 0;
        while (i < gaa.length) {
            CIMInstance anExtent = gaa[i];
            CIMProperty aProp = anExtent.getProperty("DeviceID");
            String fruId = (String)aProp.getValue().getValue();
            if (fruId.startsWith(trayNum) && !fruInUse.contains(fruId) && fruId.indexOf("d01") == -1) {
                aProp = anExtent.getProperty("OtherIdentifyingInfo");
                Vector propVec = (Vector)aProp.getValue().getValue();
                String extRole = (String)propVec.get(3);
                String extState = (String)propVec.get(2);
                if (!anyHotSpare) {
                    if (changePool) {
                        WBEMDebug.trace1((String)(CLASSNAME + "." + "getHotSpareInstance" + "The requested operation for changing the spare " + "is not supported for this firmware level."));
                        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
                    }
                    if (fruId.equals(trayNum + "d" + "14") && extState.equalsIgnoreCase("enabled") && (extRole.equalsIgnoreCase("unassigned") || extRole.equalsIgnoreCase("standbyDisk"))) {
                        return anExtent;
                    }
                } else if (extState.equalsIgnoreCase("enabled") && extRole.equalsIgnoreCase("unassigned") && supportsHotSpare && !this.isSpareInList(anExtent.getObjectPath(), poolJobs)) {
                    evalExtent.add(anExtent);
                }
            }
            ++i;
        }
        if (evalExtent.isEmpty()) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "getHotSpareInstance" + "The requested StoragePool assignment cannot be performed because " + "the lack of available drives as a dedicated spare."));
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        String bigFru = null;
        int i2 = evalExtent.size() - 1;
        while (i2 >= 0) {
            CIMInstance extent = (CIMInstance)evalExtent.get(i2);
            BigInteger cap = ((UnsignedInt64)extent.getProperty("NumberOfBlocks").getValue().getValue()).bigIntValue();
            String fruId = (String)extent.getProperty("DeviceID").getValue().getValue();
            if (cap.compareTo(smallest) == 0) {
                return extent;
            }
            if (cap.compareTo(smallest) > 0 && bigFru == null) {
                bigFru = fruId;
                retVal = extent;
            }
            --i2;
        }
        if (retVal != null) {
            return retVal;
        }
        throw new CIMException("CIM_ERR_INVALID_PARAMETER");
    }

    private int getRaidLevel(int spindleRedun, boolean noSinglePoint, int dataRedun) throws CIMException {
        String METHOD = "getRaidLevel ";
        int level = -1;
        WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " entered"));
        if (!noSinglePoint && dataRedun == 1 && spindleRedun == 0) {
            level = 0;
        } else if (noSinglePoint && dataRedun == 2) {
            if (spindleRedun == 1 || spindleRedun == 2) {
                level = 1;
            }
        } else if (noSinglePoint && dataRedun == 1 && (spindleRedun == 1 || spindleRedun == 2)) {
            level = 5;
        }
        if (level == -1) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Invalid RAID level given in as parameters: " + " spindleRedundancy = " + spindleRedun + " noSinglePointOfFailure = " + noSinglePoint + " dataRedundancyMin = " + dataRedun));
            throw new CIMException("CIM_ERR_INVALID_PARAMETERinvalid RAID level");
        }
        return level;
    }

    private String getLowSeqValue(Vector valueVec) {
        int tempVal;
        if (valueVec.isEmpty()) {
            return "0";
        }
        int maxVal = Integer.parseInt((String)Collections.max(valueVec));
        WBEMDebug.trace3((String)(CLASSNAME + "." + "getLowSeqValue" + " Have maxVal: " + maxVal + ", minVal: " + tempVal));
        if (tempVal <= 0) {
            for (tempVal = Integer.parseInt((String)Collections.min(valueVec)); tempVal < maxVal; ++tempVal) {
                if (valueVec.contains(Integer.toString(tempVal + 1))) {
                    continue;
                }
                WBEMDebug.trace3((String)(CLASSNAME + "." + "getLowSeqValue" + " will inside return: " + (tempVal + 1)));
                return Integer.toString(tempVal + 1);
            }
            WBEMDebug.trace3((String)(CLASSNAME + "." + "getLowSeqValue" + " will return: " + (maxVal + 1)));
            return Integer.toString(maxVal + 1);
        }
        return "0";
    }

    private boolean isContiguous(Vector values, String cSize) {
        int size = Integer.parseInt(cSize);
        int maxcontinuity = 0;
        int continuity = 0;
        int[] vals = new int[values.size()];
        int i = 0;
        while (i < vals.length) {
            vals[i] = Integer.parseInt((String)values.get(i));
            ++i;
        }
        int i2 = 0;
        while (i2 < vals.length - 1) {
            if (vals[i2 + 1] == vals[i2] + 1) {
                ++continuity;
            } else {
                maxcontinuity = Math.max(continuity, maxcontinuity);
                continuity = 0;
            }
            ++i2;
        }
        return maxcontinuity >= size;
    }

    private int checkForNullParams(int[] paramIndices, InvokeRequest request) throws Exception {
        int i = 0;
        while (i < paramIndices.length) {
            if (request.getInParamValue(paramIndices[i]) == null) {
                return i;
            }
            WBEMDebug.trace3((String)("Parameter " + i + " passed null value checking"));
            ++i;
        }
        return -1;
    }

    private String subtractOne(String val) {
        String result = val;
        try {
            val = Integer.toString(Integer.parseInt(val) - 1);
        }
        catch (NumberFormatException nfe) {
            WBEMDebug.trace3((String)("subtractOne received non-number string: " + val));
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createStorADELock(String sysId, int code) {
        String[] lockFileDesc = new String[]{"Creating new StorageVolume", "Deleting existing StorageVolume", "Creating new StoragePool", "Deleting existing StoragePool", "Mounting a StoragePool", "Unmounting a StoragePool"};
        String METHOD = "createStorADELock";
        String MGMT_SOFT = "management_sw";
        File f = null;
        BufferedWriter w = null;
        try {
            f = new File("/tmp/" + sysId);
            w = new BufferedWriter(new FileWriter(f));
            w.write(MGMT_SOFT);
            w.newLine();
            w.write(code + ": " + lockFileDesc[code]);
            w.flush();
        }
        catch (Exception ex) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD), (Throwable)ex);
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (IOException ioe) {
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD), (Throwable)ioe);
                }
            }
        }
    }

    public static void removeStorADELock(String sysId) {
        String METHOD = "removeStorADELock";
        File f = null;
        try {
            f = new File("/tmp/" + sysId);
            f.delete();
        }
        catch (Exception ex) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD), (Throwable)ex);
        }
    }

    private CIMInstance[] getCreatePoolJobs() throws CIMException {
        String METHOD = "getCreatePoolJobs";
        CIMObjectPath poolCreateJobPath = new CIMObjectPath("StorEdge_6120CreateStoragePoolJob", "\\root\\se6x20");
        return RequestBroker.getInstance().enumerateInstances(this.getSystem(), poolCreateJobPath, true, false, false, null, null);
    }

    private boolean isSpareInList(CIMObjectPath spare, CIMInstance[] jobList) throws CIMException {
        boolean retVal = false;
        String METHOD = "isSpareInList";
        boolean getOut = false;
        if (jobList != null) {
            int i = 0;
            while (i < jobList.length) {
                getOut = false;
                CIMInstance aInst = jobList[i];
                CIMProperty statusProp = aInst.getProperty("OperationalStatus");
                if (statusProp.getValue() != null && statusProp.getValue().getValue() != null) {
                    CIMValue statusVal = statusProp.getValue();
                    Vector stausVector = (Vector)statusVal.getValue();
                    int j = 0;
                    while (j < stausVector.size()) {
                        int stat = ((UnsignedInt16)stausVector.get(j)).intValue();
                        if (stat == 17) {
                            getOut = true;
                            break;
                        }
                        ++j;
                    }
                    if (!getOut) {
                        String objectPathString;
                        CIMProperty hsProp = aInst.getProperty("HotSpareExtents");
                        if (hsProp.getValue() == null || hsProp.getValue().getValue() == null) {
                            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Failed to discover " + "HotSpareExtents" + " from instance of: " + "StorEdge_6120CreateStoragePoolJob" + " in: " + aInst));
                            return false;
                        }
                        CIMValue hsValue = hsProp.getValue();
                        Vector hsVector = (Vector)hsValue.getValue();
                        if (null != hsVector && hsVector.size() > 0 && (objectPathString = (String)hsVector.elementAt(0)).equals(spare.toString())) {
                            retVal = true;
                        }
                    }
                }
                ++i;
            }
        }
        return retVal;
    }

    static {
        classMap.add("StorEdge_6120StorageConfigurationService");
        _CONF_SERVICE_FAILURE = new CIMValue((Object)new UnsignedInt32(4L), new CIMDataType(4));
        _CONF_SERVICE_NOT_SUPPORTED = new CIMValue((Object)new UnsignedInt32(1L), new CIMDataType(4));
        _CONF_SERVICE_INVALID_PARAMETER = new CIMValue((Object)new UnsignedInt32(5L), new CIMDataType(4));
        _CONF_SERVICE_COMPLETE_SUCCESSFUL = new CIMValue((Object)new UnsignedInt32(0L), new CIMDataType(4));
        _CONF_SERVICE_JOB_STARTED = new CIMValue((Object)new UnsignedInt32(4096L), new CIMDataType(4));
        CLASSNAME = "ModifyConfigService";
    }
}

