/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.se6120.internal;

import com.sun.netstorage.array.mgmt.se6120.internal.ArrayException;
import com.sun.netstorage.array.mgmt.se6120.internal.ArrayInventory;
import com.sun.netstorage.array.mgmt.se6120.internal.ArrayObject;
import com.sun.netstorage.array.mgmt.se6120.internal.CreateRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.DeleteRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.InvokeRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyCluster;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyConfigService;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyControllerSystem;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyJobs;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyMasking;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyModule;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyNetworkSettings;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyPools;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyPorts;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyStorageSetting;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyTimeSettings;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyVolumes;
import com.sun.netstorage.array.mgmt.se6120.internal.RequestBroker;
import com.sun.netstorage.array.mgmt.se6120.internal.SetRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.StorEdgeIOException;
import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import java.util.HashMap;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;

public class ModifyBroker {
    private static String CLASSNAME = "ModifyBroker";
    private static ModifyBroker instance = new ModifyBroker();
    private HashMap[] maps = new HashMap[10];
    private HashMap masking;
    private HashMap ports;
    private HashMap volumes;
    private HashMap pools;
    private HashMap configService;
    private HashMap jobs;
    private HashMap cluster;
    private HashMap controller;
    private HashMap networkSettings;
    private HashMap timeSettings;
    private ModifyModule storageSetting;

    public static ModifyBroker getInstance() {
        return instance;
    }

    public CIMValue invokeMethod(CIMObjectPath op, String methodName, CIMArgument[] inArgs, CIMArgument[] outArgs) throws CIMException {
        String METHOD = "invokeMethod";
        WBEMDebug.trace3((String)(CLASSNAME + "." + "invokeMethod" + " entered"));
        InvokeRequest request = new InvokeRequest(op, methodName, inArgs, outArgs);
        this.dispatch(request);
        return request.results();
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        String METHOD = "createInstance";
        WBEMDebug.trace2((String)(CLASSNAME + "." + "createInstance" + " entered"));
        try {
            CreateRequest request = new CreateRequest(op, ci);
            if (op.getObjectName().equalsIgnoreCase("StorEdge_6120StorageSetting")) {
                if (!this.storageSetting.handleRequest(request)) {
                    // empty if block
                }
            } else if (op.getObjectName().equalsIgnoreCase("StorEdge_6120SystemSpecificCollection")) {
                ModifyMasking.createInitiatorGroup(request);
            } else if (op.getObjectName().equalsIgnoreCase("StorEdge_6120AccessControlInformation")) {
                ModifyMasking.createAccessControlInformation(request);
            } else {
                this.dispatch(request);
            }
            return request.results();
        }
        catch (ArrayException e) {
            throw new CIMException("Unable to communicate with Array. " + e.getMessage());
        }
        catch (StorEdgeIOException e) {
            CIMException tmp = new CIMException("CIM_ERR_FAILED");
            tmp.setDescription(e.getMessage());
            throw tmp;
        }
    }

    public void deleteInstance(CIMObjectPath op) throws CIMException {
        String METHOD = "deleteInstance";
        WBEMDebug.trace3((String)(CLASSNAME + "." + "deleteInstance" + " entered"));
        DeleteRequest request = new DeleteRequest(op);
        this.dispatch(request);
    }

    public ModifyModule[] getModule(String modulename) {
        if (modulename == null) {
            return null;
        }
        if (modulename.equalsIgnoreCase("ModifyMasking")) {
            return this.masking.values().toArray(new ModifyMasking[0]);
        }
        if (modulename.equalsIgnoreCase("ModifyPorts")) {
            return this.ports.values().toArray(new ModifyPorts[0]);
        }
        if (modulename.equalsIgnoreCase("ModifyVolumes")) {
            return this.volumes.values().toArray(new ModifyVolumes[0]);
        }
        if (modulename.equalsIgnoreCase("ModifyPools")) {
            return this.pools.values().toArray(new ModifyPools[0]);
        }
        if (modulename.equalsIgnoreCase("ModifyConfigService")) {
            return this.configService.values().toArray(new ModifyConfigService[0]);
        }
        if (modulename.equalsIgnoreCase("ModifyJobs")) {
            return this.jobs.values().toArray(new ModifyJobs[0]);
        }
        if (modulename.equalsIgnoreCase("ModifyCluster")) {
            return this.cluster.values().toArray(new ModifyCluster[0]);
        }
        if (modulename.equalsIgnoreCase("ModifyControllerSystem")) {
            return this.controller.values().toArray(new ModifyControllerSystem[0]);
        }
        if (modulename.equalsIgnoreCase("ModifyNetworkSettings")) {
            return this.jobs.values().toArray(new ModifyNetworkSettings[0]);
        }
        if (modulename.equalsIgnoreCase("ModifyTimeSettings")) {
            return this.cluster.values().toArray(new ModifyTimeSettings[0]);
        }
        return null;
    }

    public ModifyModule getModule(String hostname, String modulename) {
        if (modulename == null || hostname == null) {
            return null;
        }
        if (modulename.equalsIgnoreCase("ModifyMasking")) {
            return (ModifyModule)this.masking.get(hostname);
        }
        if (modulename.equalsIgnoreCase("ModifyPorts")) {
            return (ModifyModule)this.ports.get(hostname);
        }
        if (modulename.equalsIgnoreCase("ModifyVolumes")) {
            return (ModifyModule)this.volumes.get(hostname);
        }
        if (modulename.equalsIgnoreCase("ModifyPools")) {
            return (ModifyModule)this.pools.get(hostname);
        }
        if (modulename.equalsIgnoreCase("ModifyConfigService")) {
            return (ModifyModule)this.configService.get(hostname);
        }
        if (modulename.equalsIgnoreCase("ModifyJobs")) {
            return (ModifyModule)this.jobs.get(hostname);
        }
        if (modulename.equalsIgnoreCase("ModifyCluster")) {
            return (ModifyModule)this.cluster.get(hostname);
        }
        if (modulename.equalsIgnoreCase("ModifyControllerSystem")) {
            return (ModifyModule)this.controller.get(hostname);
        }
        if (modulename.equalsIgnoreCase("ModifyNetworkSettings")) {
            return (ModifyModule)this.cluster.get(hostname);
        }
        if (modulename.equalsIgnoreCase("ModifyTimeSettings")) {
            return (ModifyModule)this.cluster.get(hostname);
        }
        return null;
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci, boolean includeQualifiers, String[] propertyList) throws CIMException {
        String METHOD = "setInstance";
        WBEMDebug.trace3((String)(CLASSNAME + "." + "setInstance" + " entered"));
        SetRequest request = new SetRequest(op, ci, propertyList);
        this.dispatch(request);
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void dispatch(ModifyRequest request) throws CIMException {
        METHOD = "dispatch";
        WBEMDebug.trace3((String)(ModifyBroker.CLASSNAME + "." + "dispatch" + " entered"));
        hostname = null;
        try {
            hostname = RequestBroker.getInstance().getHostName(request.getObjectPath());
        }
        catch (NullPointerException npe) {
            WBEMDebug.trace3((String)(ModifyBroker.CLASSNAME + "." + "dispatch" + " NPE in getHostName: "), (Throwable)npe);
        }
        cimclass = request.getCIMClassName();
        if (hostname == null && (cimclass.equalsIgnoreCase("StorEdge_6120ConcreteJob") || cimclass.equalsIgnoreCase("StorEdge_6120CreateStoragePoolJob") || cimclass.equalsIgnoreCase("StorEdge_6120CreateStorageVolumeJob") || cimclass.equalsIgnoreCase("StorEdge_6120CreateMappedStorageVolumeJob") || cimclass.equalsIgnoreCase("StorEdge_6120DeleteStoragePoolJob") || cimclass.equalsIgnoreCase("StorEdge_6120DeleteStorageVolumeJob") || cimclass.equalsIgnoreCase("StorEdge_6120InitializeStoragePoolJob"))) {
            hostname = ModifyJobs.getHostname(request.getObjectPath());
        }
        if (hostname == null) {
            block22: {
                try {
                    hostname = (String)request.getKeyValue("SystemName");
                    break block22;
                }
                catch (ClassCastException e) {
                    throw new CIMException("Unable to handle request:  Couldn't determine which Array to operate on. SystemName property was not of type String. " + request.getObjectPath());
                }
                catch (CIMException e2) {
                    assoc = request.getObjectPath();
                    keys = assoc.getKeys();
                    i = 0;
                    ** while (i < keys.size())
                }
lbl-1000:
                // 1 sources

                {
                    prop = (CIMProperty)keys.elementAt(i);
                    if (prop.getType().isReferenceType()) {
                        ref = (CIMObjectPath)prop.getValue().getValue();
                        refKeys = ref.getKeys();
                        name = null;
                        k = 0;
                        while (k < refKeys.size()) {
                            check = (CIMProperty)refKeys.elementAt(k);
                            if (check.getName().equalsIgnoreCase("SystemName")) {
                                hostname = (String)check.getValue().getValue();
                            } else if (check.getName().equalsIgnoreCase("Name")) {
                                name = (String)check.getValue().getValue();
                            }
                            ++k;
                        }
                        if (ref.getObjectName().equalsIgnoreCase("StorEdge_6120Cluster")) {
                            hostname = name;
                        }
                    }
                    if (hostname != null) break;
                    ++i;
                    continue;
                }
            }
            if (hostname == null) {
                throw new CIMException("Unable to handle request:  Couldn't determine which Array to operate on. SystemName property was not present. " + request.getObjectPath());
            }
            tmp = ArrayInventory.getInstance().getArrayObject(hostname);
            if (tmp == null) {
                throw new CIMException("Unable to handle request:  Couldn't determine which Array to operate on.  SystemName referred to unknown Storage Array. " + hostname);
            }
            hostname = tmp.getHost();
        }
        i = 0;
        while (i < this.maps.length) {
            mod = (ModifyModule)this.maps[i].get(hostname);
            if (mod == null) {
                // empty if block
            }
            try {
                if (mod.handleRequest(request)) {
                    return;
                }
            }
            catch (ArrayException e) {
                throw new CIMException("Unable to communicate with Array. " + e.getMessage());
            }
            catch (StorEdgeIOException e) {
                tmp = new CIMException("CIM_ERR_FAILED");
                tmp.setDescription(e.getMessage());
                throw tmp;
            }
            ++i;
        }
        throw new CIMException("Unable to service request " + request);
    }

    private ModifyBroker() {
        this.maps[0] = this.masking = new HashMap();
        this.maps[1] = this.ports = new HashMap();
        this.maps[2] = this.volumes = new HashMap();
        this.maps[3] = this.pools = new HashMap();
        this.maps[4] = this.configService = new HashMap();
        this.maps[5] = this.jobs = new HashMap();
        this.maps[6] = this.cluster = new HashMap();
        this.maps[7] = this.controller = new HashMap();
        this.maps[8] = this.networkSettings = new HashMap();
        this.maps[9] = this.timeSettings = new HashMap();
        this.storageSetting = new ModifyStorageSetting();
    }

    public static void addArray(ArrayObject array) {
        ModifyBroker.getInstance().innerAddArray(array);
    }

    public static void removeArray(ArrayObject array) {
        ModifyBroker.getInstance().innerRemoveArray(array);
    }

    private synchronized void innerAddArray(ArrayObject array) {
        String hostname = array.getHost();
        try {
            this.masking.put(hostname, new ModifyMasking(array));
            this.ports.put(hostname, new ModifyPorts(array));
            this.volumes.put(hostname, new ModifyVolumes(array));
            this.pools.put(hostname, new ModifyPools(array));
            this.configService.put(hostname, new ModifyConfigService(array));
            this.jobs.put(hostname, new ModifyJobs(array));
            this.cluster.put(hostname, new ModifyCluster(array));
            this.controller.put(hostname, new ModifyControllerSystem(array));
            this.networkSettings.put(hostname, new ModifyNetworkSettings(array));
            this.timeSettings.put(hostname, new ModifyTimeSettings(array));
        }
        catch (Exception ex) {
            WBEMDebug.trace1((String)(CLASSNAME + " : Error in initializing "), (Throwable)ex);
        }
    }

    private synchronized void innerRemoveArray(ArrayObject array) {
        int i = 0;
        while (i < this.maps.length) {
            try {
                ModifyModule mod = (ModifyModule)this.maps[i].remove(array.getHost());
                mod.shutdown();
            }
            catch (Exception e) {
                WBEMDebug.trace1((String)(CLASSNAME + " : Error shutting down maps[" + i + "]"), (Throwable)e);
            }
            ++i;
        }
    }
}

