/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.se6120.internal;

import com.sun.netstorage.array.mgmt.se6120.internal.CIMUtils;
import java.io.IOException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import org.apache.xalan.transformer.TrAXFilter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class ModelXMLFilter
extends XMLFilterImpl {
    protected static String DATA = "data";
    protected static String MODEL = "model";
    protected boolean inData = false;
    protected boolean inModel = false;
    protected boolean inTransform = false;
    protected TemplatesHandler templatesHandler;
    protected ContentHandler origContentHandler;
    protected TrAXFilter traxFilter = null;
    protected static SAXTransformerFactory traxFactory;

    public ModelXMLFilter() {
    }

    public ModelXMLFilter(XMLReader parent) {
        super(parent);
    }

    public void startDocument() throws SAXException {
        this.inData = false;
        this.inTransform = false;
        this.inModel = false;
        super.startDocument();
        this.origContentHandler = super.getContentHandler();
    }

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes atts) throws SAXException {
        super.startElement(namespaceURI, localName, qualifiedName, atts);
        if (localName.equals(DATA)) {
            this.inData = true;
        }
        if (localName.equals(MODEL)) {
            try {
                this.inModel = true;
                this.origContentHandler = super.getContentHandler();
                this.templatesHandler = traxFactory.newTemplatesHandler();
                super.setContentHandler(this.templatesHandler);
                this.templatesHandler.startDocument();
                CIMUtils.trace("In model");
            }
            catch (TransformerConfigurationException tce) {
                throw new SAXException("Provider XML Configuration Problem", tce);
            }
        }
    }

    public void parse(InputSource input) throws SAXException, IOException {
        if (!this.inTransform) {
            super.parse(input);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals(DATA)) {
            this.inData = false;
            super.endElement(uri, localName, qName);
            super.endDocument();
            super.setContentHandler(this.origContentHandler);
        }
        if (localName.equals(MODEL)) {
            try {
                this.inModel = false;
                this.templatesHandler.endDocument();
                CIMUtils.trace("End Model, closed templates doc: " + this.templatesHandler.toString());
                this.traxFilter = new TrAXFilter(this.templatesHandler.getTemplates());
                super.setContentHandler((ContentHandler)this.traxFilter);
                this.traxFilter.setParent((XMLReader)this);
                this.traxFilter.setContentHandler(this.origContentHandler);
                this.inTransform = true;
                try {
                    this.traxFilter.parse(new InputSource(""));
                    super.startDocument();
                }
                catch (IOException ioe) {
                    throw new SAXException(ioe);
                }
                CIMUtils.trace("Now transforming model");
            }
            catch (TransformerConfigurationException tce) {
                throw new SAXException("Provider XML Configuration Problem", tce);
            }
        }
        super.endElement(uri, localName, qName);
    }

    static {
        try {
            traxFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
        }
        catch (TransformerFactoryConfigurationError tfce) {}
    }
}

