/*
 * Decompiled with CFR 0.152.
 */
package auth.utauthd;

import auth.admin.Admin;
import auth.admin.SmartCardConfigFile;
import auth.sdk.Log;
import auth.utauthd.SmartCardConfigTokenizer;
import auth.utauthd.SmartCardWordException;
import auth.utauthd.SmartCardWordsImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class SmartCardConfigData {
    public static final String id = "SmartCardConfigData";
    public static final String ConfigTokensSourceKey = "ConfigTokensSourceKey";
    public static final String ConfigTokensSourceLDAP = "LDAP";
    public static final String ConfigFilesBaseDir = "/etc/opt/SUNWut/smartcard";

    private SmartCardConfigData() {
    }

    public static boolean init(Vector vector, String string) {
        if (string == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        boolean bl = false;
        while (!bl && stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(ConfigTokensSourceLDAP)) {
                if (!SmartCardConfigData.initFromLDAP(vector, string2)) continue;
                bl = true;
                continue;
            }
            if (!SmartCardConfigData.initFromFiles(vector, string2)) continue;
            bl = true;
        }
        return bl;
    }

    private static boolean initFromFiles(Vector vector, String string) {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        Vector<String> vector2 = new Vector<String>();
        string = "/etc/opt/SUNWut/smartcard/" + string;
        try {
            String string2;
            object3 = new BufferedReader(new FileReader(string));
            while ((string2 = ((BufferedReader)object3).readLine()) != null) {
                string2.trim();
                if (string2.trim().startsWith("#") || string2.length() <= 0) continue;
                vector2.add("/etc/opt/SUNWut/smartcard/" + string2);
            }
            Log.notice((String)("SmartCardConfigData: read " + vector2.size() + " smartcard configuration " + "files from directory file: " + string));
        }
        catch (Exception exception) {
            Log.configError((String)("SmartCardConfigData: unable to read directory file: " + string));
            return false;
        }
        object3 = new Vector();
        int n = 0;
        int n2 = 1;
        int n3 = 0;
        while (n3 < vector2.size()) {
            block13: {
                serializable = new File((String)vector2.get(n3));
                object2 = ((File)serializable).getPath();
                if (!((File)serializable).canRead()) {
                    Log.configError((String)("SmartCardConfigData: unable to read smart card config file: " + (String)object2));
                } else {
                    object = new Vector();
                    try {
                        ((Vector)object).add(n, ((File)serializable).getPath());
                        ((Vector)object).add(n2, new FileInputStream((File)serializable));
                        ((Vector)object3).add(object);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        Log.configError((String)("SmartCardConfigData: unable to access smart card config file: " + (String)object2));
                        if (object == null) break block13;
                        ((Vector)object3).remove(object);
                    }
                }
            }
            ++n3;
        }
        serializable = new Hashtable();
        object2 = new SmartCardWordsImpl((Hashtable)serializable);
        object = new SmartCardConfigTokenizer((Hashtable)serializable);
        int n4 = 0;
        int n5 = 1;
        ((SmartCardConfigTokenizer)object).setLabelsIndex(n4);
        ((SmartCardConfigTokenizer)object).setFirstTokenIndex(n5);
        boolean bl = false;
        Enumeration enumeration = ((Vector)object3).elements();
        while (enumeration.hasMoreElements()) {
            Vector vector3 = (Vector)enumeration.nextElement();
            String string3 = (String)vector3.get(n);
            FileInputStream fileInputStream = (FileInputStream)vector3.get(n2);
            Vector vector4 = new Vector();
            try {
                if (((SmartCardConfigTokenizer)object).tokenize(fileInputStream, vector4)) {
                    int n6 = vector4.size() - n5;
                    Log.notice((String)("SmartCardConfigData: " + string3 + ": " + n6 + " tokens processed"));
                    vector.add(vector4);
                    Hashtable hashtable = (Hashtable)vector4.get(n4);
                    hashtable.put(ConfigTokensSourceKey, string3);
                    if (n6 <= 0) continue;
                    bl = true;
                    continue;
                }
                Log.configError((String)("SmartCardConfigData: " + string3 + ": error tokenizing input"));
            }
            catch (SmartCardWordException smartCardWordException) {
                Log.configError((String)("SmartCardConfigData: " + string3 + ": " + smartCardWordException.getMessage()));
                vector.remove(vector4);
            }
        }
        if (!bl) {
            Log.notice((String)"SmartCardConfigData: none of the smartcard configuration files contained valid configuration information");
        }
        return bl;
    }

    private static boolean initFromLDAP(Vector vector, String string) {
        Admin admin = Admin.getAdmin();
        if (admin == null) {
            Log.notice((String)("SmartCardConfigData: " + string + " not configured for server side smartcard identification"));
            return false;
        }
        SmartCardConfigFile[] smartCardConfigFileArray = admin.getConfigFiles();
        if (smartCardConfigFileArray == null) {
            Log.notice((String)("SmartCardConfigData: " + string + " contains no smartcard configuration files"));
            return false;
        }
        Log.notice((String)("SmartCardConfigData: read " + smartCardConfigFileArray.length + " smartcard configuration " + "files from " + string));
        Hashtable hashtable = new Hashtable();
        SmartCardWordsImpl smartCardWordsImpl = new SmartCardWordsImpl(hashtable);
        SmartCardConfigTokenizer smartCardConfigTokenizer = new SmartCardConfigTokenizer(hashtable);
        int n = 0;
        int n2 = 1;
        smartCardConfigTokenizer.setLabelsIndex(n);
        smartCardConfigTokenizer.setFirstTokenIndex(n2);
        boolean bl = false;
        int n3 = 0;
        while (n3 < smartCardConfigFileArray.length) {
            String string2 = smartCardConfigFileArray[n3].name;
            byte[] byArray = smartCardConfigFileArray[n3].file.getBytes();
            Vector vector2 = new Vector();
            try {
                if (smartCardConfigTokenizer.tokenize(byArray, vector2)) {
                    int n4 = vector2.size() - n2;
                    Log.notice((String)("SmartCardConfigData: " + string2 + ": " + n4 + " tokens processed"));
                    vector.add(vector2);
                    Hashtable hashtable2 = (Hashtable)vector2.get(n);
                    hashtable2.put(ConfigTokensSourceKey, string2);
                    if (n4 > 0) {
                        bl = true;
                    }
                } else {
                    Log.configError((String)("SmartCardConfigData: " + string2 + ": error tokenizing input"));
                }
            }
            catch (SmartCardWordException smartCardWordException) {
                Log.configError((String)("SmartCardConfigData: " + string2 + ": " + smartCardWordException.getMessage()));
                vector.remove(vector2);
            }
            ++n3;
        }
        if (!bl) {
            Log.notice((String)"SmartCardConfigData: none of the smartcard configuration files contained valid configuration information");
        }
        return bl;
    }
}

