/*
 * Decompiled with CFR 0.152.
 */
package auth.utauthd;

import auth.sdk.Log;
import auth.utauthd.AuthRecord;
import auth.utauthd.Configuration;
import auth.utauthd.Controller;
import auth.utauthd.GroupManager;
import auth.utauthd.Terminal;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

class Control
implements Controller {
    private BufferedReader in = null;
    private PrintWriter out = null;
    private AuthRecord ar = null;
    private Terminal terminal = null;
    private String tag;
    private Object waitMonitor = new Object();
    private boolean notified = false;

    private Control() {
    }

    public Control(BufferedReader bufferedReader, BufferedWriter bufferedWriter, AuthRecord authRecord) throws Exception {
        Object var5_4;
        this.in = bufferedReader;
        this.ar = authRecord;
        this.out = new PrintWriter((Writer)bufferedWriter, true);
        if (this.in == null || this.out == null) {
            Log.unexpectedError((String)"Control():  null in/out");
            throw new IOException("no IO");
        }
        if (this.ar == null) {
            Log.unexpectedError((String)"Control(): null ar");
            throw new Exception("no auth record");
        }
        while (true) {
            this.terminal = this.ar.getTerminal();
            if (this.terminal == null) {
                throw new Exception("no terminal found");
            }
            this.terminal.lock();
            if (this.terminal == this.ar.getTerminal()) break;
            try {
                if (this.ar.getTerminal() == null) {
                    throw new Exception("no terminal found");
                }
                var5_4 = null;
                this.terminal.unlock();
            }
            catch (Throwable throwable) {
                var5_4 = null;
                this.terminal.unlock();
                throw throwable;
            }
        }
        try {
            try {
                this.tag = this.terminal.getUniqueTag();
                this.ar.setController(this.tag, this);
            }
            catch (Exception exception) {
                Log.unexpectedError((String)("Control(): cannot set controller in auth record " + exception));
                throw new Exception("cannot set controller");
            }
            var5_4 = null;
            this.terminal.unlock();
        }
        catch (Throwable throwable) {
            var5_4 = null;
            this.terminal.unlock();
            throw throwable;
        }
    }

    private boolean altdisp(Hashtable hashtable) {
        hashtable.put("command", "altdisp");
        this.ar.send("controlInf", hashtable);
        return true;
    }

    private boolean annotate(Hashtable hashtable) {
        String string;
        String string2;
        String string3;
        boolean bl = false;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            string2 = (String)hashtable.get(string3);
            string = !string3.startsWith("x_") ? "x_" + string3 : string3;
            if (string.equals("x_idle")) {
                if (string2.equals("true") || string2.equals("false")) continue;
                Log.unexpectedError((String)("Control.annotate: bad value: " + string3 + "=" + string2));
                bl = true;
                continue;
            }
            if (!Configuration.allowAnnotations) continue;
            Log.unexpectedError((String)("Control.annotate: bad key: " + string3));
            bl = true;
        }
        if (!bl) {
            Enumeration enumeration2 = hashtable.keys();
            while (enumeration2.hasMoreElements()) {
                string3 = (String)enumeration2.nextElement();
                string2 = (String)hashtable.get(string3);
                string = !string3.startsWith("x_") ? "x_" + string3 : string3;
                this.ar.annotate(string, string2);
            }
        }
        return false;
    }

    private boolean authenticated(Hashtable hashtable) {
        String string = (String)hashtable.get("cookie");
        if (string == null || !this.ar.compareCookie(string)) {
            return false;
        }
        Hashtable hashtable2 = this.terminal.getStoredParams();
        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
        try {
            hashtable2.put("auth", hashtable.get("auth"));
        }
        catch (NullPointerException nullPointerException) {
            Log.unexpectedError((String)"Expected values not received after  authentication.  Rejecting this callback..");
            return false;
        }
        if (hashtable.get("id") != null) {
            hashtable2.put("id", hashtable.get("id"));
        }
        if (hashtable.get("type") != null) {
            hashtable2.put("type", hashtable.get("type"));
        }
        if (hashtable.get("username") != null) {
            hashtable2.put("username", hashtable.get("username"));
        } else {
            hashtable2.put("username", "");
        }
        if (hashtable.get("quicklogin") != null) {
            hashtable2.put("quicklogin", hashtable.get("quicklogin"));
        } else {
            hashtable2.put("quicklogin", "true");
        }
        hashtable2.put("currentMod", new Integer(this.ar.getCurrentMod()));
        this.terminal.disable();
        this.terminal.setActionPending(true);
        this.terminal.setStoredParams(hashtable2);
        hashtable3.put("done", "true");
        this.response(hashtable3);
        return false;
    }

    private boolean catc_uht(Hashtable hashtable) {
        int n = 0;
        int n2 = Integer.parseInt((String)hashtable.get("test"));
        if (n2 != 0 && n2 != 1) {
            Log.unexpectedError((String)"Control.catc_uht: invalid test param");
            return false;
        }
        ++n;
        int n3 = Integer.parseInt((String)hashtable.get("channel"));
        if (n3 < 0 || n3 > 4) {
            Log.unexpectedError((String)"Control.catc_uht: invalid channel param");
            return false;
        }
        ++n;
        int n4 = Integer.parseInt((String)hashtable.get("amp"));
        if (n4 < 0 || n4 > 8) {
            Log.unexpectedError((String)"Control.catc_uht: invalid amp param");
            return false;
        }
        ++n;
        String string = (String)hashtable.get("tag");
        if (string == null) {
            Log.unexpectedError((String)"Control.catc_uht: invalid tag param");
            return false;
        }
        if (hashtable.size() != ++n) {
            Log.unexpectedError((String)("Control.catc_uht: extraneous parameters: " + hashtable));
            return false;
        }
        hashtable.put("command", "catc_uht");
        this.ar.send("controlInf", hashtable);
        return true;
    }

    public void destroy() {
        Log.debug((String)"Control:: in destroy");
        if (this.ar != null) {
            try {
                this.ar.setController(this.tag, null);
            }
            catch (Exception exception) {}
            this.ar = null;
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.in = null;
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.out = null;
        }
    }

    private boolean dispsha1(Hashtable hashtable) {
        hashtable.put("command", "dispsha1");
        this.ar.send("controlInf", hashtable);
        return true;
    }

    private boolean doDisconnect(Hashtable hashtable) {
        boolean bl = true;
        String string = (String)hashtable.get("tokenRestart");
        if (string != null && string.equals("false")) {
            bl = false;
        }
        this.ar.disconnect("doDisconnect", bl);
        return false;
    }

    public void execute() {
        String string = this.getCommand();
        Log.debug((String)"Control :: execute command locking");
        this.terminal.lock();
        if (this.processCommand(string)) {
            Log.debug((String)"Control :: execute command unlocking and continuing");
            this.terminal.unlock();
            Object object = this.waitMonitor;
            synchronized (object) {
                try {
                    Log.debug((String)"Control: go into wait");
                    this.waitMonitor.wait(60000L);
                }
                catch (InterruptedException interruptedException) {
                    Log.notice((String)("Interupted in control.execute()" + interruptedException));
                }
            }
            if (!this.notified) {
                if (this.out != null) {
                    Log.debug((String)"Control.exec() wait timed out. Socket close.");
                }
            } else {
                Log.debug((String)"Control: notified.");
            }
            Log.debug((String)"Control :: locking again for destroy");
            this.terminal.lock();
        }
        try {
            this.destroy();
        }
        finally {
            Object var3_5 = null;
            Log.debug((String)"Control :: execute command unlocking and returning");
            this.terminal.unlock();
        }
    }

    private String getCommand() {
        String string;
        try {
            string = Control.recv(this.in);
        }
        catch (Exception exception) {
            Log.unexpectedError((String)("Control: recv " + exception));
            return null;
        }
        Log.debug((String)("Control.getCommand: line = " + string));
        return string;
    }

    private boolean load(Hashtable hashtable) {
        if (!Configuration.allowFWLoad) {
            String string = "utload command is disabled";
            Log.unexpectedError((String)("Control.load: " + string));
            if (this.out != null) {
                this.out.println("error: " + string);
            }
            return false;
        }
        String string = (String)hashtable.get("tag");
        if (string == null) {
            Log.unexpectedError((String)"Control.load: invalid tag param");
            return false;
        }
        string = (String)hashtable.get("flash");
        if (string != null && !string.equals("true") && !string.equals("false")) {
            Log.unexpectedError((String)"Control.load: invalid flash param");
            return false;
        }
        string = (String)hashtable.get("file");
        if (string == null) {
            Log.unexpectedError((String)"Control.load: invalid file param");
            return false;
        }
        hashtable.put("command", "load");
        this.ar.load(hashtable);
        return false;
    }

    private Hashtable parse(BufferedReader bufferedReader) throws IOException {
        String string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>(3);
        while ((string = Control.recv(bufferedReader)) != null && !string.equals("end")) {
            int n = string.indexOf(61);
            if (n <= 0) {
                Log.unexpectedError((String)"Control.parse: invalid parameter");
                return null;
            }
            String string2 = string;
            string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            hashtable.put(string2, string3);
            Log.debug((String)("Control.parse: " + string2 + "=" + string3));
        }
        return hashtable;
    }

    private boolean processCommand(String string) {
        boolean bl;
        Hashtable hashtable;
        String string2;
        if (string == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        try {
            string2 = stringTokenizer.nextToken();
        }
        catch (Exception exception) {
            return true;
        }
        if (string2.equals("quit")) {
            return false;
        }
        if (!string2.equals("request")) {
            Log.unexpectedError((String)("Control: unknown command: " + string2));
            return false;
        }
        try {
            string2 = stringTokenizer.nextToken();
        }
        catch (Exception exception) {
            Log.unexpectedError((String)("Control: input error: " + exception));
            return false;
        }
        try {
            hashtable = this.parse(this.in);
        }
        catch (Exception exception) {
            Log.debug((String)("Control.processCommand: while reading parameters: " + exception));
            return false;
        }
        if (hashtable == null) {
            Log.unexpectedError((String)"Control: invalid parameters");
            return false;
        }
        hashtable.put("tag", this.tag);
        if (string2.equals("load")) {
            bl = this.load(hashtable);
        } else if (string2.equals("catc_uht")) {
            bl = this.catc_uht(hashtable);
        } else if (string2.equals("dispsha1")) {
            bl = this.dispsha1(hashtable);
        } else if (string2.equals("annotate")) {
            bl = this.annotate(hashtable);
        } else if (string2.equals("redirect")) {
            bl = this.redirect(hashtable);
        } else if (string2.equals("disconnect")) {
            bl = this.doDisconnect(hashtable);
        } else if (string2.equals("altdisp")) {
            bl = this.altdisp(hashtable);
        } else if (string2.equals("authenticated")) {
            bl = this.authenticated(hashtable);
        } else if (string2.equals("properties")) {
            bl = this.properties(hashtable);
        } else {
            Log.unexpectedError((String)("Control: unknown command: " + string2));
            return false;
        }
        if (bl) {
            if (this.out != null) {
                this.out.println("ok");
            }
            return true;
        }
        return false;
    }

    private boolean properties(Hashtable hashtable) {
        Hashtable hashtable2 = this.terminal.getStoredParams();
        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
        Object v = null;
        Object v2 = hashtable2.get("auth");
        v = v2;
        if (v2 != null) {
            hashtable3.put("auth", (String)v);
        } else {
            hashtable3.put("auth", "false");
        }
        Object v3 = hashtable2.get("username");
        v = v3;
        if (v3 != null) {
            hashtable3.put("username", (String)v);
        }
        Object v4 = hashtable2.get("quicklogin");
        v = v4;
        if (v4 != null) {
            hashtable3.put("quicklogin", (String)v);
        }
        this.response(hashtable3);
        return false;
    }

    private static String recv(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        return string;
    }

    private boolean redirect(Hashtable hashtable) {
        boolean bl = false;
        String string = (String)hashtable.get("authipa");
        String string2 = (String)hashtable.get("authtoken");
        Log.notice((String)("redirect: " + hashtable));
        if (string == null && string2 == null) {
            Log.unexpectedError((String)"Control.redirect: missing authipa and token params");
            return false;
        }
        String string3 = this.ar.tokenName;
        if (string == null) {
            string = "";
            if (string2.length() == 0) {
                string2 = string3;
                Log.notice((String)("redirect: ar token = " + string2));
            }
        }
        if (string2 == null) {
            string2 = "";
        }
        if ((string = GroupManager.whichServer(string2, this.ar.insertToken, this.ar.getIPAddress(), string)).length() == 0) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        String string4 = stringTokenizer.nextToken();
        hashtable.put("authipa", string4);
        boolean bl2 = Boolean.valueOf(stringTokenizer.nextToken());
        string = (String)hashtable.get("authport");
        if (string == null) {
            hashtable.put("authport", new Integer(Configuration.port).toString());
        }
        this.ar.redirect(hashtable, bl2);
        return false;
    }

    public void response(Hashtable hashtable) {
        Object object;
        Log.debug((String)"Control:: writting out response");
        if (this.out != null) {
            this.out.println("begin response");
            if (hashtable != null) {
                object = hashtable.keys();
                while (object.hasMoreElements()) {
                    String string = (String)object.nextElement();
                    String string2 = (String)hashtable.get(string);
                    if (string2 == null) {
                        string2 = "\"\"";
                    }
                    this.out.println(String.valueOf(string) + "=" + string2);
                }
            }
            this.out.println("end");
        } else {
            Log.unexpectedError((String)"Control.response: out=null");
            Log.notice((String)("discarding response: " + hashtable));
        }
        object = this.waitMonitor;
        synchronized (object) {
            this.notified = true;
            this.waitMonitor.notifyAll();
        }
    }
}

