/*
 * Decompiled with CFR 0.152.
 */
package auth.module.StartSession;

import auth.module.StartSession.StartSessionClient;
import auth.sdk.AccessControl;
import auth.sdk.Authentication;
import auth.sdk.AuthenticationClient;
import auth.sdk.Log;
import auth.sdk.ParseOptions;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class StartSession
implements Authentication {
    protected String instanceName;
    protected Hashtable policy = new Hashtable();
    protected String sessionType = null;
    protected String sessionOptions = null;
    protected static String version = new String("@(#) StartSession.java 1.5@(#)");
    private static String name = new String("StartSession");
    protected final String RAW_TOKEN = "raw";
    protected final String CURRENT_TOKEN = "current";
    protected String whichInsertToken = "current";
    protected String whichRedirectToken = "current";
    protected String tokenType = null;
    protected String property = null;

    public StartSession() {
        this.instanceName = "--BOGUS--";
        Log.unexpectedError((String)"AuthmoduleOK BOGUS constructor called");
    }

    public StartSession(String instanceName, String arg) {
        this.instanceName = instanceName;
        boolean specifiedAccept = false;
        ParseOptions options = new ParseOptions(arg, "a:r:s:pt:T:o:c:");
        Enumeration e = options.keys();
        block10: while (e.hasMoreElements()) {
            Character flag = (Character)e.nextElement();
            Object value = options.getValue(flag);
            switch (flag.charValue()) {
                case 'a': {
                    String type;
                    specifiedAccept = true;
                    StringTokenizer st = new StringTokenizer((String)value, ",");
                    while (st.hasMoreTokens()) {
                        type = st.nextToken();
                        this.policy.put(type, "accept");
                        Log.debug((String)(String.valueOf(instanceName) + " policy " + type + "=accept"));
                    }
                    continue block10;
                }
                case 'r': {
                    String type;
                    StringTokenizer st = new StringTokenizer((String)value, ",");
                    while (st.hasMoreTokens()) {
                        type = st.nextToken();
                        this.policy.put(type, "reject");
                    }
                    continue block10;
                }
                case 's': {
                    this.sessionType = (String)value;
                    break;
                }
                case 'p': {
                    this.sessionOptions = "-p";
                    break;
                }
                case 't': {
                    this.whichInsertToken = (String)value;
                    break;
                }
                case 'T': {
                    this.whichRedirectToken = (String)value;
                    break;
                }
                case 'o': {
                    this.tokenType = (String)value;
                    break;
                }
                case 'c': {
                    this.property = (String)value;
                    break;
                }
                default: {
                    StartSession.usage(String.valueOf(instanceName) + ": invalid option: '" + flag + "'");
                    break;
                }
            }
        }
        if (!this.policy.containsKey("default")) {
            Log.debug((String)(String.valueOf(instanceName) + " !policy.containsKey(\"default\") is true"));
            if (specifiedAccept) {
                this.policy.put("default", "reject");
            } else {
                this.policy.put("default", "accept");
            }
        }
        Log.debug((String)(String.valueOf(instanceName) + " policy=" + this.policy));
    }

    public static Authentication getAuthenticationObject(String instanceName, String opt) {
        StartSession za = new StartSession(instanceName, opt);
        return za;
    }

    public String getName() {
        return new String(this.instanceName);
    }

    public String getVersion() {
        if (version.equals("%A%")) {
            version = "Development";
        }
        return version;
    }

    /*
     * Enabled aggressive block sorting
     */
    public AuthenticationClient isMyTokenType(Hashtable attrib, AccessControl access) {
        StartSessionClient client;
        String id;
        Log.debug((String)"StartSession:In isMyTokenType");
        String event = (String)attrib.get("event");
        if (event == null || !event.equals("insert")) {
            return null;
        }
        String type = (String)attrib.get("type");
        if (type == null) {
            type = "noType";
        }
        if ((id = (String)attrib.get("id")) == null) {
            id = "noId";
        }
        String rawType = (String)attrib.get("rawType");
        String rawId = (String)attrib.get("rawId");
        String cause = (String)attrib.get("cause");
        if (cause == null) {
            cause = "nocause";
        }
        String action = null;
        if (cause.equals("redirect")) {
            if (this.whichRedirectToken.equals("raw")) {
                action = (String)this.policy.get(rawType);
            } else {
                if (!this.whichRedirectToken.equals("current")) {
                    Log.notice((String)("StartSession: Invalid token type specified: " + this.whichRedirectToken));
                    return null;
                }
                action = (String)this.policy.get(type);
            }
        } else if (this.whichInsertToken.equals("raw")) {
            action = (String)this.policy.get(rawType);
        } else {
            if (!this.whichInsertToken.equals("current")) {
                Log.notice((String)("StartSession: Invalid token type specified: " + this.whichInsertToken));
                return null;
            }
            action = (String)this.policy.get(type);
        }
        if (action == null) {
            action = (String)this.policy.get("default");
        }
        if (action == null) {
            action = "reject";
        }
        if (!action.equals("accept")) {
            return null;
        }
        if (type.equals("mondex") && id.startsWith("0x")) {
            Long mid = new Long(Long.parseLong(id.substring(2), 16));
            id = mid.toString();
        }
        if ((client = new StartSessionClient(access, this, String.valueOf(rawType) + "." + rawId, String.valueOf(type) + "." + id, this.sessionType, this.sessionOptions)) == null) {
            return null;
        }
        return client;
    }

    protected static void usage(String message) {
        Log.configError((String)message);
        Log.configError((String)"usage: [-a acceptTokenType[,type,...]][-r rejectTokenType[,type,...]] [-s sessionType] [-t whichtoken]");
        System.exit(1);
    }
}

