#
# the functions from old server.prc to perform server and data func
#


proc on_connect { newsock clientAddress clientPort } {
    fconfigure $newsock -blocking 0   
    fileevent $newsock readable [ list get_input $newsock ]
}
    
proc startserver {} {


     global persisdir
     global fileseparator
     global ipFilter

     set persisdir ??PERSISDIR??
     set fileseparator ??FILESEPARATOR??

     set ipFilter [ getModuleParam ipFilter "" ]
     set rmTopo [ getModuleParam rmTopo "" ]

     if { $rmTopo } { 
         cleartopo
     } else {
	 resetseverity
     }
     clearalarm

     if [ catch { socket -server on_connect 18055 } result ] {
              vwait v
     } else {
              vwait v
     }
     
}


proc get_input { f } {
  
    global persisdir
    global fileseparator

    global ErrorCode

    if {[eof $f]} {
         fileevent $f readable { }
         close $f
         return
    }

# initialize ErrorCode
    set ErrorCode 0
   
# initialize content-length
    set conlen 0
# first judge if it is POST method
    set inputline [ gets $f ]
    if { [ string match "*POST*" $inputline ] } {
       while { ![ eof $f ] } {
          set inputline [ gets $f ]   
          if { [ string match "Content-Length*" $inputline ] } {
             scan $inputline "%s %u" ss conlen
          } elseif { [ string length $inputline ] == 0 } {
            break             
          }
       }
     set filename "inputcontent"
     set fullpathname "$persisdir$fileseparator$filename"
     set filesock [ open $fullpathname {w+} ]
#     set filelog  [ open /tmp/inputlog {a+} ]

     set rs [ read $f ]
     puts $filesock $rs
#     puts $filelog $rs
     close $filesock
#     close $filelog
    }
    if [ catch { parse_input } result ] {
	set fname "log"
	set filename "$persisdir$fileseparator$fname"
	set log [ open $filename {a+} ]
	puts $log "get internal error: $result"
        close $log
        set ErrorCode 999
    }
    feedback $f 
    close $f
}


proc feedback { f } {

# ErrorCode:  0 OK; 1 message format error; 2 invalid source IP; 999 server internal error; 
# (To do)     3 cannot node/module to add alarm; 4 cannot find node/module to delete;

     global ErrorCode
     if { $ErrorCode == 0 } {
	puts $f "HTTP/1.0 200 OK\r\n\r\n"
     } elseif { $ErrorCode == 1 } {
        puts $f "HTTP/1.0 400 Incoming Message Error 1\r\n\r\n"
     } elseif { $ErrorCode == 2 } {
        puts $f "HTTP/1.0 400 Incoming Message Error 2\r\n\r\n"
     } else {
	puts $f "HTTP/1.0 500 Server Internal Error\r\n\r\n"
     }
     return
}

proc parse_input {} {
     global node
     global module
     global con
     global group
     global alarm
     global persisdir
     global fileseparator
     global ipFilter
     global ErrorCode

     set filename "inputcontent"
     set fullpathname "$persisdir$fileseparator$filename"
   
     set f [ open $fullpathname {RDWR CREAT} ]
     
# initialize ErrorCode (it's error until it's right)
     set ErrorCode 1

# for correct ip source
    set PassIpFilter 0
    set stationline ""
    set start 0

# to parse xml formatted command
    
     while { ![ eof $f ] } {

      if { $PassIpFilter == 0 } {
               set tmpline [ gets $f ]
               if { [ string match *<srs_station_message* $tmpline ] } {
		    set stationline [ append stationline $tmpline ]
                    set start 1
	       } elseif { $start == 1 } {                
                     set stationline [ append stationline $tmpline ]
                     if { [ string first > $tmpline ] != -1 } {
                        set stationIp [ get_variable $stationline "sourceIP" ] 
                        if { $stationIp == $ipFilter } {
		            set PassIpFilter 1
                        } else {
                            set ErrorCode 2
                            break
			}
                      }
	       }
       }        

       if { $PassIpFilter == 1 } { 
       
          set commandline [ gets $f ]
          if { [ string match *<topology* $commandline ] } {
              set index 0
	      set type [ get_variable $commandline "type" ]
              while { ![ eof $f ] } {
                   set innerline [ gets $f ]
                    if { [ string match "*</topology>*" $innerline ] } {
			set ErrorCode 0                     
                        process_topology $index $type
			break                    
                    }   else {
                        set con($index) $innerline
                        incr index
                    }
              }

          } elseif { [ string match *<alarm* $commandline ] } {
              set index 0
              set con($index) $commandline
              incr index
              while { ![ eof $f ] } {
                   set innerline [ gets $f ]
                    if { [ string match "*</alarm>*" $innerline ] } {
                        set ErrorCode 0
                        set con($index) $innerline
                        incr index                     
                        process_alarm $index
			break                    
                    }   else {
                        set con($index) $innerline
                        incr index
                    }
              }
           
          } elseif { [ string match *<heartbeat* $commandline ] } {
# don't do anything so far for heartbeat event
		  set ErrorCode 0
	  }
	}
         
     }

}


proc process_topology { index type } {
     global node
     global module
     global con
     global group
     global ErrorCode

     set group(number) 0
     set group(processing) 0

#  since default type=FULL, remove the old topology files first.
#  but for type=INCREMENTAL, don't do it.

     if { $type == "FULL" } {
        cleartopo
     }

     for {set i 0} {$i < $index} {incr i} {

        set stop 0
        set parseline ""
        while { $stop == 0 } {
              if { $i == $index } {
                    return
              }             
              if { [ string first > $con($i) ] != -1 } {
                    set stop 1
              } 
              set parseline [ append parseline $con($i) ]
            
              incr i       
        }
 
        incr i -1

        if { [ string match "*<group*" $parseline ] } {              
              
              incr group(number)
              set group(processing) 1
              set group(name) [ get_variable $parseline "name" ]
              set group(type) [ get_variable $parseline "type" ]

        } elseif { [ string match "*<node*" $parseline ] } {

              set node(action) [ get_variable $parseline "action" ]   
              set node(address) [ get_variable $parseline "address" ]
              set node(name) [ strReplace [ get_variable $parseline "name" ] "." "-" ]

              set node(model) [ get_variable $parseline "model" ]
              set node(serial) [ get_variable $parseline "serial" ]
              set node(alarm) [ findalarm 0 ]
              process_node
              buildindex                      

        } elseif { [ string match "*<module*" $parseline ] && $node(action) == "ADD" } {

              set module(name)  [ strReplace [ get_variable $parseline "name" ] "." "-" ]

# remove this one, and still keep full name
#              set dn [ string first . $module(name) ]
#              if { $dn != -1 } {
#                 incr dn -1
#                 set module(name) [ string range $module(name) 0 $dn ]
#              }

              set module(vendor)  [ get_variable $parseline "vendor" ]
              set module(model)  [ get_variable $parseline "model" ]
              set module(serial)  [ get_variable $parseline "serial" ]
              set module(version)  [ get_variable $parseline "version" ]
              set module(description)  [ get_variable $parseline "description" ]
              set module(alarm) [ findalarm 1 ]
              addmodule

        } elseif { [ string match "*</group*" $parseline ] } {
              set group(processing) 0
        } 
         
     }  

}


proc process_alarm { index } {
        
     global con
     global alarm
     global ErrorCode

     for {set i 0} {$i < $index} {incr i} {

        set stop 0
        set parseline ""
        while { $stop == 0 } {
              if { $i == $index } {
                    return
              }             
              if { [ string first > $con($i) ] != -1 } {
                    set stop 1
              } 
              set parseline [ append parseline $con($i) ]
            
              incr i       
        }
 
        incr i -1

        if { [ string match "*<alarm*" $parseline ] } {

              set alarm(source)  [ get_variable $parseline "source" ]
              set alarm(provider)  [ get_variable $parseline "provider" ]
              set alarm(timestamp)  [ get_variable $parseline "timestamp" ]
              set alarm(module)  [ strReplace [ get_variable $parseline "module" ] "." "-" ]
              set alarm(alarm_id)  [ get_variable $parseline "alarm_id" ]           
              set alarm(state)  [ get_variable $parseline "state" ]
              set alarm(severity)  [ get_variable $parseline "severity" ]
              set alarm(type)  [ get_variable $parseline "type" ]
             
        } elseif { [ string match "*</alarm*" $parseline ] } {
              set inp [ string first </alarm> $parseline ]
              incr inp -1
              set description [ string range $parseline 0 $inp ]
              set alarm(description)  [ string trim $description ]
              cleanalarm
              addalarm
	      logalarm
              changealarm
        }

    }
}

proc changealarm { } {
     
     global alarm

     global persisdir
     global fileseparator
     global ErrorCode

#    to find which group
  
     set fname index
     set filename "$persisdir$fileseparator$fname"

     set hname group
     set file_head "$persisdir$fileseparator$hname"
     set groupname -1   

     #         read existed list
     
          if [ catch { set f [ open $filename {RDONLY} ] } result ] {

          } else {
            while { ![ eof $f ] } {
               set str [ gets $f ]
               if { [ string length $str ] == 0 } {
                  continue
               }
               scan $str "%s %s %s" ip g n
               if { $ip == $alarm(source) } {
                   set groupname $g
                   set nname $n
                   break
               }            
            }

            close $f

          }

          if { $groupname == -1 } {
            return
          }

          
          if { $alarm(module) == $nname } {
              set filename [ format "%s-%s" $file_head $groupname ] 
              set key1 "name=\"$nname\""
              set rep  "severity=\"$alarm(severity)\""
              replace $filename $key1 noneed 1 3 $rep                 

          } else {
              set filename [ format "%s-%s-modules" $file_head $groupname ] 
              set key1 "nodename=\"$nname\""
              set key2 "modulename=\"$alarm(module)\""
              set rep  "severity=\"$alarm(severity)\""
              replace $filename $key1 $key2 2 4 $rep   
          }


}

# clean alarm will clean old alarms (5 minutes old) to keep the size of alarm DB
proc cleanalarm { } {
     global alarm

     global persisdir
     global fileseparator
     global ErrorCode

     set currentTime [ clock seconds ]    
     set fname alarm
     set filename "$persisdir$fileseparator$fname"
     set alarm_list ""

#         read existed list and filter old ones
     
     if [ catch { set f [ open $filename {RDONLY} ] } result ] {

     } else {

        while { ![ eof $f ] } {
           set str [ gets $f ]
           if { [ string length $str ] == 0 } {
               continue
           }
           scan $str "%s %s %s" tt ip m
           if { $tt > $currentTime - 300 } {
               lappend alarm_list $str
           }
	}

        close $f
     }   

#   write new list

      
     set index [ llength $alarm_list ]
          
     set f [ open $filename {w+} ]
     for {set i 0} {$i < $index} {incr i} {
        puts $f [ lindex $alarm_list $i ]
     } 
     close $f
}


# add alarm just appends a new alarm to the end of file

proc addalarm { } {
     global alarm

     global persisdir
     global fileseparator
     global ErrorCode

     set time [ clock seconds ]

     set alarmmes "type=\"$alarm(type)\" severity=\"$alarm(severity)\" description=\"$alarm(description)\" " 
     set alarmstr "$time $alarm(source) $alarm(module) $alarm(severity) $alarm(alarm_id) $alarmmes"

     set fname alarm
     set filename "$persisdir$fileseparator$fname"
     set f [ open $filename {a+} ]
     puts $f $alarmstr
     close $f
}

# log alarm will replace the old alarm

proc logalarm { } {
     global alarm

     global persisdir
     global fileseparator
     global ErrorCode
     set time [ clock seconds ]

     set alarmmes "type=\"$alarm(type)\" severity=\"$alarm(severity)\" description=\"$alarm(description)\" " 
     set alarmstr "$time $alarm(source) $alarm(module) $alarm(severity) $alarm(alarm_id) $alarmmes"

     set fname alarm-log
     set filename "$persisdir$fileseparator$fname"
     set limit 1
     set index 0
     set count 0

     #         read existed list
     
          if [ catch { set f [ open $filename {RDONLY} ] } result ] {

          } else {

            while { ![ eof $f ] } {
               set str [ gets $f ]
               if { [ string length $str ] == 0 } {
                  continue
               }
               scan $str "%s %s %s" tt ip m
               if { $ip == $alarm(source) && $m == $alarm(module) } {
                   set record($count) $index
                   incr count
               }
               lappend alarm_list $str
               incr index
            }
            close $f

      #  remove first one if overlimit

            if { $count == $limit } {                             
                 set alarm_list [ lreplace $alarm_list $record(0) $record(0) ]              
            }

	  }
         
          
     #   write new list

          lappend alarm_list $alarmstr    
          set index [ llength $alarm_list ]
          
          set f [ open $filename {w+} ]
          for {set i 0} {$i < $index-1} {incr i} {
              puts $f [ lindex $alarm_list $i ]
	  } 
          puts -nonewline $f [ lindex $alarm_list $i ]
          close $f
      
}



proc buildindex {} {
     global node
     global group

     global persisdir
     global fileseparator
     global ErrorCode

     set fname index
     set index_file "$persisdir$fileseparator$fname"
     
     if { $group(processing) == 1 } {
           set index_str "$node(address) $group(name) $node(name)"
     } else {
           set index_str "$node(address) others $node(name)"
     }

#         read existed list
          set index_list ""
          if [ catch { set f [ open $index_file {RDONLY} ] } result ] {

          } else {

            while { ![ eof $f ] } {
               set str [ gets $f ]
               if { [ string length $str ] != 0 } {
		    scan $str "%s %s %s" ip g thisName
		    if { $node(name) != $thisName } {
			lappend index_list $str
	            } else {

			if { $node(action) == "ADD" } {
# for ADD, if node existed, do nothing and return
			    close $f
			    return
			} elseif { $node(action) == "REMOVE" } {		     
# for REMOVE, if node existed, just don't add it to write list

			}
			
		    }
               }
            }
            close $f
	  }
         
          
#         write new list

# for ADD, add new index
	  if { $node(action) == "ADD" } {
          	lappend index_list $index_str 
	  }   

          set index [ llength $index_list ]
          
          set f [ open $index_file {WRONLY CREAT TRUNC} ]
          for {set i 0} {$i < $index-1} {incr i} {
              puts $f [ lindex $index_list $i ]
	  } 
          puts -nonewline $f [ lindex $index_list $i ]
          close $f

}


# findalarm will find alarms and return last alarm severity

proc findalarm { mode } {
     global node
     global module

     global persisdir
     global fileseparator
     global ErrorCode     

     set count 0
     set ret 0

     set fname alarm-log
     set filename "$persisdir$fileseparator$fname"

     if [ catch { set f [ open $filename {RDONLY} ] } result ] {

     } else {

         while { ![ eof $f ] } {
               set str [ gets $f ]
               if { [ string length $str ] == 0 } {
                  continue
               }
               scan $str "%s %s %s %s" tt ip m l               
               if { $mode == 1  } {
                   if { $ip == $node(address) && $m == $module(name) } {
                       set record($count) $l
                       incr count
                   }
               } elseif { $mode == 0 } {
                   if { $ip == $node(address) &&  $m == $node(name) } {
                       set record($count) $l
                       incr count
                   }

               }
          }

          close $f 

     }

# work to here about how to return alarm

#     for {set i 0} {$i < $count} {incr i} {
#          if { $record($i) > $ret  } {
#              set ret $record($i) 
#          }             
#     } 

# return the last one here

     if { $count == 0 } {
	return 0
     } else {
        incr count -1
        set ret $record($count)     
        return $ret
     }
 
}


proc removemodule { } {
      global node
      global module
      global group

      global ErrorCode 
      global persisdir
      global fileseparator
     
    
      set hname group-
      set head_name "$persisdir$fileseparator$hname"


      if { $group(processing) == 1 } {
           append module_file "$head_name" "$group(name)" "-modules"
      } else {
           append module_file "$head_name" "others-modules"
      }


#         read existed list
	  set module_list ""    

          if [ catch { set f [ open $module_file {RDONLY} ] } result ] {

          } else {

            while { ![ eof $f ] } {
               set str [ gets $f ]
               if { [ string length $str ] != 0 } {
                  set thisName [ get_variable $str "nodename" ]
		  if { $thisName != $node(name) } {		  
                      lappend module_list $str
		  }
               }
            }
            close $f
	  }
         
          
#         write new list

          set module_sort_list [ lsort $module_list ]
          set index [ llength $module_sort_list ]
          
          set f [ open $module_file {WRONLY CREAT TRUNC} ]
          for {set i 0} {$i < $index-1} {incr i} {
              puts $f [ lindex $module_sort_list $i ]
	  } 
          puts -nonewline $f [ lindex $module_sort_list $i ]
          close $f
}


proc addmodule { } {
      global node
      global module
      global group

      global persisdir
      global fileseparator
      global ErrorCode    
    
      set hname group-
      set head_name "$persisdir$fileseparator$hname"

      set module_str [ format "nodename=\"%s\" modulename=\"%s\" address=\"%s\" severity=\"%s\" model=\"%s\" serial=\"%s\" description=\"%s\"" $node(name) $module(name) $node(address) $module(alarm) $module(model) $module(serial) $module(description) ]
    
      if { $group(processing) == 1 } {
           append module_file "$head_name" "$group(name)" "-modules"
      } else {
           append module_file "$head_name" "others-modules"
#           set module_file "/tmp/group-others-modules"
      }
   

#         read existed list
          set module_list ""
          if [ catch { set f [ open $module_file {RDONLY} ] } result ] {

          } else {

            while { ![ eof $f ] } {
               set str [ gets $f ]
               if { [ string length $str ] != 0 } {		  
                  lappend module_list $str
               }
            }
            close $f
	  }
         
          
#         write new list

          lappend module_list $module_str    
          set module_sort_list [ lsort $module_list ]
          set index [ llength $module_sort_list ]
          
          set f [ open $module_file {WRONLY CREAT TRUNC} ]
          for {set i 0} {$i < $index-1} {incr i} {
              puts $f [ lindex $module_sort_list $i ]
	  } 
          puts -nonewline $f [ lindex $module_sort_list $i ]
          close $f
      
}

proc process_node { } {

      global node
      global module
      global group

      global persisdir
      global fileseparator
      global ErrorCode  
    
      set hname group-
      set head_name "$persisdir$fileseparator$hname"
        
      set node_str [ format "name=\"%s\" address=\"%s\" severity=\"%s\" model=\"%s\" serial=\"%s\"" $node(name) $node(address) $node(alarm) $node(model) $node(serial) ]

      if { $group(processing) == 1 } {
           append node_file "$head_name" "$group(name)"
      } else {
           append node_file "$head_name" "others"
      }
   
  
#         read existed list & check if the node is existed
          set node_list ""
          if [ catch { set f [ open $node_file {RDONLY} ] } result ] {

          } else {

            while { ![ eof $f ] } {
               set str [ gets $f ]
               if { [ string length $str ] != 0 } {
		  set thisName [ get_variable $str "name" ]
		  if { $node(name) != $thisName } {
			lappend node_list $str
	          } else {
			if { $node(action) == "ADD" } {
# for ADD, if node existed, do nothing and return
			    close $f
			    return
			} elseif { $node(action) == "REMOVE" } {		     
# for REMOVE, if node existed, just don't add it to write list

			}
		 }                 
               }
            }
            close $f
	  }
         
#         write new list

# for ADD, add new node

          if { $node(action) == "ADD" } {
          	lappend node_list $node_str  
	  }

          set node_sort_list [ lsort $node_list ]
          set index [ llength $node_sort_list ]         
          set f [ open $node_file {WRONLY CREAT TRUNC} ]
          for {set i 0} {$i < $index-1} {incr i} {
              puts $f [ lindex $node_sort_list $i ]
	  }
              puts -nonewline $f [ lindex $node_sort_list $i ]
          close $f
     
# for REMOVE, remove modules of this node here

          if { $node(action) == "REMOVE" } {
          	removemodule  
	  }	

}


proc get_variable {str key} {

    set key_index [ string first $key $str ]
    set str_length [ string length $str ]
    set key_length [ string length $key ]
   
    set start_record 0
    set value ""
 
    if { $key_index != -1 } {
        incr key_index $key_length
        for {set i $key_index} {$i < $str_length} {incr i} {
            set c [ string index $str $i ]
           
            if { $c == "\""  } {
                if { $start_record == 0 } {
                    set start_record 1
		} else {
		    set start_record 0
                    break	
		}
            } elseif  { $start_record == 1 } {
                append value $c
            }        

	}
    }

    return $value
}

proc resetseverity {} {
   global persisdir
   global fileseparator
   global ErrorCode   
 
   set rep "severity=\"0\""

   set hname group
   set group_file_head "$persisdir$fileseparator$hname"

   lappend typelist others SAN_T3 SAN_Switch SAN_VE SAN_Storage SAN_SE_Series

   foreach type $typelist {
      set node_file "$group_file_head-$type"
      set module_file "$group_file_head-$type-modules"
 
      replace $node_file noneed noneed 4 3 $rep 
      replace $node_file noneed noneed 4 4 $rep 

   }    
}


proc cleartopo {} {

   global persisdir
   global fileseparator
   global ErrorCode   
 
   set fname index 
   set index_file "$persisdir$fileseparator$fname"

   set hname group
   set group_file_head "$persisdir$fileseparator$hname"

   lappend typelist others SAN_T3 SAN_Switch SAN_VE SAN_Storage SAN_SE_Series

   foreach type $typelist {
      set node_file "$group_file_head-$type"
      set module_file "$group_file_head-$type-modules"
 
      set f [ open $node_file {w+} ]
      close $f

      set f [ open $module_file {w+} ]
      close $f 

   }
  
   set f [ open $index_file {w+} ]
   close $f 
     

}


proc clearalarm {} {

   global persisdir
   global fileseparator
   global ErrorCode  

   set fname "alarm"
   set file "$persisdir$fileseparator$fname"
   set f [ open $file {w+} ]
   close $f

   set fname "alarm-log"
   set file "$persisdir$fileseparator$fname"
   set f [ open $file {w+} ]
   close $f

}

proc strReplace { str key rep } {

   set list [ split $str $key ] 
   set num [ llength $list ]  
   if { $num == 1 } {
       return $str;
   } else {
       for {set i 0} {$i < $num - 1 } {incr i} {
	 append changestr [ lindex $list $i ] $rep
       }
       append changestr [ lindex $list $i ]
       return $changestr
   }
}

proc replace { filename key1 key2 mode index value } {

#  mode 1: use key 1 to search
#  mode 2: use key 1&2 to search
#  mode 3: use key 1 to search, if no, attach it
#  mode 4: don't use key1&2, just replace all
     set changed 0

     #         read existed list
     
     if [ catch { set f [ open $filename {RDONLY} ] } result ] {

     } else {
 
       while { ![ eof $f ] } {
                set str [ gets $f ]
       
                set num [ scan $str "%s %s %s %s %s %s %s %s %s" n(1) n(2) n(3) n(4) n(5) n(6) n(7) n(8) n(9) ] 
 
                if { $num < 2 || $num < $index } {
                    break
                }

                if {  $mode == 1  } {
                    if {  $n(1) == $key1 } {
                       set n($index) $value                         
                       for {set i 1} {$i <= $num} {incr i} {
                             append changestr $n($i) " "
	               } 
                       set str $changestr
                       set changestr ""
                    }
                 } elseif { $mode == 2  } {
                    if {  $n(1) == $key1  &&  $n(2) == $key2  } {
                       set n($index) $value                      
                       for {set i 1} {$i <= $num} {incr i} {
                             append changestr $n($i) " "
	               } 
                       set str $changestr
                       set changestr ""
                    }
                 } elseif { $mode == 3  } {
                    if {  $n(1) == $key1 } {
                       set n($index) $value                         
                       for {set i 1} {$i <= $num} {incr i} {
                             append changestr $n($i) " "
	               } 
                       set str $changestr
                       set changestr ""

                       set changed 1
                    }
                 } elseif { $mode == 4 } {		   
                       set n($index) $value                      
                       for {set i 1} {$i <= $num} {incr i} {
                             append changestr $n($i) " "
	               } 
                       set str $changestr
                       set changestr ""
		 }

                 lappend mlist $str
            
         }
         close $f
     }


      

#         write new list
          if { $mode == 3 && $changed == 0 } {
                 lappend mlist $changestr
          }         

      if { [info exists mlist] } {
          set index [ llength $mlist ]          
          set f [ open $filename {w+} ]
          for {set i 0} {$i < $index-1} {incr i} {
              puts $f [ lindex $mlist $i ]
	  } 
          puts -nonewline $f [ lindex $mlist $i ]
          close $f
      }

}

 
#
# the functions from old acquire.prc to query database
#

proc node { par } {

 # note: why don't set global here? Since the global in server isn't effective until
 # server is loaded. All acquire functions are indepedent.

 set persisdir ??PERSISDIR??
 set fileseparator ??FILESEPARATOR??

 set fname "group-$par"
 set filename "$persisdir$fileseparator$fname"
 set ret ""

 if { [ file exists $filename ] } {
    set f [ open $filename {RDONLY} ]
     while { ![ eof $f ] } {
             set str [ gets $f ]
             if { [ string length $str ] == 0 } {
                  break
             }
             set a [ get_variable $str name ]
             set b [ get_variable $str address ]
             set c [ get_variable $str severity ]
	     set d [ get_variable $str model ]
	     set e [ get_variable $str serial ]
             lappend ret  $a $b $c $d $e              

    }
            close $f

  }

  return $ret

}
 


proc module { par } {

 set persisdir ??PERSISDIR??
 set fileseparator ??FILESEPARATOR??

 append fname "group-" "$par" "-modules"
 set filename "$persisdir$fileseparator$fname"
 set ret ""

 if { [ file exists $filename ] } {
    set f [ open $filename {RDONLY} ]
     while { ![ eof $f ] } {
             set str [ gets $f ]
             if { [ string length $str ] == 0 } {
                  break
             }
             set a [ get_variable $str nodename ]
             set b [ get_variable $str modulename ]
             set c [ get_variable $str address ]
             set d [ get_variable $str severity ]
             set e [ get_variable $str model ]
             set g [ get_variable $str serial ]
             set h [ get_variable $str description ]

             lappend ret  $a $b $c $d $e $g $h            

    }
            close $f

  }

  return $ret
        

}

proc get_variable {str key} {

    set key_index [ string first $key $str ]
    set str_length [ string length $str ]
    set key_length [ string length $key ]
   
    set start_record 0
    set value ""
 
    if { $key_index != -1 } {
        incr key_index $key_length
        for {set i $key_index} {$i < $str_length} {incr i} {
            set c [ string index $str $i ]
           
            if { $c == "\""  } {
                if { $start_record == 0 } {
                    set start_record 1
		} else {
		    set start_record 0
                    break	
		}
            } elseif  { $start_record == 1 } {
                append value $c
            }        

	}
    }

    return $value
}

proc checknode { par } {

 set persisdir ??PERSISDIR?? 
 set fileseparator ??FILESEPARATOR??

 set fname "group-$par"
 set filename "$persisdir$fileseparator$fname"
 set ret ""

 if { [ file exists $filename ] } {
	set ret [ file mtime $filename ]
 }

 return $ret

}

proc checkmodule { par } {

 set persisdir ??PERSISDIR??
 set fileseparator ??FILESEPARATOR??

 append fname "group-" "$par" "-modules"
 set filename "$persisdir$fileseparator$fname"
 set ret ""

 if { [ file exists $filename ] } {
	set ret [ file mtime $filename ]
 }

 return $ret

}




