# Device State library
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

package State;

use Util;
#use Time::HiRes qw (usleep);
use strict;
use System;
use Debug;

use vars qw($STATE $state_changed);

# read state file and push to master, must write first.
#
sub push {
  my($class, $master, $force) = @_;
  $master = Util->findMaster;
  require Util::Http;

  my($renv) = System->get_renv();
  my($F) = System->get_home() . "/DATA/state/" . $renv->{hostname} . ".slave";
  $force = 1 if (-f $F);

  return if (!$master);
  return if (!$state_changed && !$force);

  open(O, $F);
  my(@a)  = <O>; close(O);
  Debug->print2("  State: push State to master");

  my($err, $ans)  = Util::Http->appendFile($master, "state/$renv->{hostname}.push",
                              join("", @a), 20);

  if ($ans !~ /OK/) {
     Debug->errNoRepeat(HTTP_STATE => undef, 2, "$err: $ans");
  } else {
     unlink $F;
  }
}

#
# will merge from a list of hosts and returned a merged state object.
#
sub mergeC {
  my($class, $STATE, $key, $sev1, $date, $mess, $name, $avail, $summ) = @_;

  if (exists $STATE->{C}{$key}) {
     my($sev0) = $STATE->{C}{$key}[0];

     if ($sev1 == 0 || $sev1 > $sev0) {
        $STATE->{C}{$key} = [$sev1, "$date $mess", $name, $avail, $summ];
     }
  } else {
     $STATE->{C}{$key}    = [$sev1, "$date $mess", $name, $avail, $summ];
  }
}

sub mergeL {
  my($class, $STATE, $host, $key, $sev1, $date, $desc, $summ) = @_;

  if (exists $STATE->{L}{$key}) {
     my($o) = $STATE->{L}{$key};
     $STATE->{L}{$key} = [$sev1, "$date $desc", $summ, $o->[3] + 1, $host];
  } else {
     $STATE->{L}{$key} = [$sev1, "$date $desc", $summ, 1, $host];
  }
}


sub init {
  my($class) = @_;
  my($master) = Util->findMaster;
  my($D)      = System->get_home() . "/DATA/state";
  my($renv)   = System->get_renv();
  my $host    = $renv->{hostname};

}



sub linkLog {
  my($class, $host, $key) = @_;
  my($renv) = System->get_renv();
  require Util::Http;
  my($q);
  if ($renv->{hostname} eq $host) {
     $q = {key => $key};
     return &get_linkLog($q);
  } else {
     print "accessing $host..<br>\n";
     my $data = Util::Http->getCommand($host, "State::linkLog&key=$key&HTML=1", 30);
     return $data;
  }
}

sub get_linkLog {
  my($q) = @_;
  my($key)  = $q->{key};
  my($out, $l, $x);
  my(@A);
  my $MAX = 3;
  open(O, System->get_home() . "/DATA/LinkStateLog");
  my $in = 0;
  my $cnt = -1;
  while ($l = <O>) {
    chop($l);
    if (substr($l,0,1) eq "L") {
      my @a = split(/\t/, $l);
      $in = ($a[1] eq $key);
      if ($in) {
         my $ii = index($a[4], ")");
         $cnt++;
         $cnt = 0 if ($cnt > $MAX);
         if ($ii > 0) {
           $A[$cnt] = "<b>$a[3]</b> " . substr($a[4],0,$ii+1) . "\n";
         } else {
           $A[$cnt] = "<b>$a[3]</b> $a[4]\n";
         }
      }
    } elsif ($in) {
      $A[$cnt] .= "$l\n";
    }
  }
  close(O);
  for ($x = $cnt; $x >= 0; $x--) {
    $out .= $A[$x] . "\n";
  }
  for ($x = $MAX ; $x > $cnt; $x--) {
    $out .= $A[$x] . "\n";
  }

  if ($q->{HTML}) {
     print $out;
  } else {
     return $out;
  }
}


sub compare {
  my($k, $comp, $DB) = @_;
  if ($comp->[0] > $DB->{$k}[0]) {
     $DB->{$k} = $comp;
  } elsif ($comp->[0] == $DB->{$k}[0]) {
     if ($comp->[1] gt $DB->{$k}[1]) {
        $DB->{$k} = $comp;
     }
  }
}


sub read_sev_summary {
  my($class) = @_;
  open(O2, System->get_home() . "/DATA/health_sev_summary");
  my $l = <O2>; 
  chomp($l);
  my @SEV = split(/\|/, $l);
  if (wantarray) {
    my(@stats) = stat(O2);
    close(O2);
    return (\@SEV, Util->get_today($stats[9]));
  } else {
    close(O2);
    return \@SEV;
  }
}

# only count 1 per device, no links
sub sev_summary {
  my($class) = @_;

  State->read() if (!$STATE);
  my $Comp = $STATE->components();
  my (@SEV, %MAP);

  foreach my $q (keys %$Comp) {
     my($t, $key, $rest) = split(/\:/, $q);
     my $sev = int($Comp->{$q}[0] + 0.5);
     $MAP{$key} = $sev if ($sev > $MAP{$key});
  }
  my $Links = $STATE->links();
  foreach my $el (keys %$Links) {
     my $sev = int($Links->{$el}[0] + 0.5);
     my($k1, $k2) = split(/\|/, $el);
     my($t, $key, $rest) = split(/\:/, $k1);
     $MAP{$key} = $sev if ($sev > $MAP{$key});
     my($t, $key, $rest) = split(/\:/, $k2);
     $MAP{$key} = $sev if ($sev > $MAP{$key});
  }
  
  foreach my $k (keys %MAP) {
     $SEV[$MAP{$k}]++;
  }
  open(O, ">" . System->get_home() . "/DATA/health_sev_summary");
  print O "$SEV[0]|$SEV[1]|$SEV[2]|$SEV[3]\n";
  close(O);
}

#
# sends a hash with the highest severity problem for each component
# return $DB : $DB->{"t3:key"} = [highest-sev,desc];
# includeLinks=1, links are attached to both enclosures
# includeLinks=2, links are attached to key=LINK
#
sub getComponentState {
  my($class, $includeLinks) = @_;

  State->read() if (!$STATE);
  my $Comp = $STATE->components();
  my %DB = ();

  foreach my $q (keys %$Comp) {
     my $sev = int($Comp->{$q}[0] + 0.5);
     if ($sev >= 1) {
       my($t, $n, $p) = split(/:/, $q);
       my $k = "$t:$n";
       &compare($k, $Comp->{$q}, \%DB);
     }
  }
  if ($includeLinks) {
     my $Links = $STATE->links();
     foreach my $el (keys %$Links) {
        my($f1,$f2) = split(/\|/, $el);
        my($t,$n,$p) = split(/:/, $f1);
        my $k = $includeLinks == 2? "LINK" : "$t:$n";
        &compare($k, $Links->{$el}, \%DB);

        ($t,$n,$p) = split(/:/, $f2);
        $k = $includeLinks == 2? "LINK" : "$t:$n";
        &compare($k, $Links->{$el}, \%DB);
     }
  }
  return \%DB;
}

sub getStateList {
  my($class) = @_;

  State->read() if (!$STATE);
  my $Comp = $STATE->components();
  my @ERR;
  foreach my $q (sort keys %$Comp) {
     my $sev = int($Comp->{$q}[0] + 0.5);
     next if ($sev < 1);
     my $el = $Comp->{$q};
     #                      dev        desc       name      avail  ev_summ
     push(@ERR, ['C', $sev, $q, undef, $el->[1] , $el->[2], $el->[3], $el->[4]]);
  }
  my $Links = $STATE->links();
  foreach my $el (keys %$Links) {
     my $sev = int($Links->{$el}[0] + 0.5);
     next if ($sev < 1);
     my($f1,$f2) = split(/\|/, $el);
     push(@ERR, ['L', $sev, $f1, $f2, $Links->{$el}[1]] );
  }
     
  return \@ERR;
}

sub current {
  my($class) = @_;
  return $STATE if ($STATE);
  return $class->read();
}

#
# read from a state file on a foreign host
sub readFromDevice {
  my($class, $ip, $filename) = @_;
  require Util::Http;
  my $VAR1 = {};
  my($err, $rc) = Util::Http->readFile($ip, "/state/$filename");
  eval $rc;
  bless($VAR1, 'State');
  return $VAR1;
}
  
# jive the health with the devices/hosts.

sub cleanState {
  my($class) = @_;
  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
  State->read() if (!$STATE);
  my %KEY;
  foreach my $d (@$devs) {
     $KEY{"$d->{type}:$d->{key}"} = 1;
  }
  $KEY{"host:$renv->{hostname}"} = 1;
  foreach my $d (@$hosts) {
     $KEY{"host:$d->{hostname}"} = 1;
  }
  my $write;
  my $Comp = $STATE->components();
  my @ERR;
  foreach my $el (sort keys %$Comp) {
     my($type, $key, $rest) = split(/\:/, $el);
     if (!exists $KEY{"$type:$key"}) {
       delete $Comp->{$el};
     }
  }
  my $Links = $STATE->links();
  foreach my $el (keys %$Links) {
     my($f1,$f2) = split(/\|/, $el);
     my($type1, $key1, $rest1) = split(/\:/, $f1);
     my($type2, $key2, $rest2) = split(/\:/, $f2);
     if (!exists $KEY{"$type1:$key1"} || !exists $KEY{"$type2:$key2"} ) {
       delete $Links->{$el};
     }
  }
}
 

#
#  read state for a master/slave host
#
sub read {
  my($class, $host) = @_;
  my($l);
  my($D) = System->get_home() . "/DATA/state";
  my($master) = Util->findMaster;

  my($renv) = System->get_renv();
  $host = $renv->{hostname};
  my($VAR1, @a);
  if (open(O, "$D/$host")) {
    @a = <O>; 
    close(O);
  }
  eval "@a";
  $STATE = $VAR1 || {};

  if ($master) {
     bless($STATE, 'State');
     return $STATE;  
  }

# MASTER: merge all state files into one, the master's 

  opendir(O, $D);
  my @states = readdir(O); closedir(O);

  my $in = 0;
  my ($last);
  foreach my $st (@states) {
    next if ($st !~ /\.push$/);
    rename "$D/$st", "$D/$st.2";
#    usleep (50000);   # wait 0.05 second
    open(O, "$D/$st.2");
    my $host = substr($st, 0, -5);
    while ($l = <O>) {
       chop($l);
       $in = 1;
       my(@x) = split(/\t/, $l);
       # "C\t$cat:$keyval:$comp\t$sev\t$date\t$mess\t$name\t$avail\n";
       if ($x[0] eq "C") {
          $class->mergeC($STATE, $x[1], $x[2], $x[3], $x[4], $x[5], $x[6], $x[7]);

       } elsif ($x[0] eq "L") {
       # "L\t$key\t$sev\t$date\t$desc\t$pc\t$ra\n";
          $class->mergeL($STATE, $host, $x[1], $x[2], $x[3], $x[4], $x[5], $x[6]);

       } elsif ($x[0] eq "R" || $x[0] eq "W") {
       }
      
    }
    close(O);
  }

  $class->write() if ($in);
  bless($STATE, 'State');
  return $STATE;
}

# 'a5k:5080020000084168:disk_rear.6' => [
#      '0',
#      '08-08 16:44:45 \'disk_rear.6\'(20000020375ba56d) in A5K d (wwn=5080020000084168) is now Available (status-state changed from \'No_path_found-On\' to \'OK-On\'):',
#      'd'
#    ],
#
#   $comps = $state->components();
#   foreach $cname (keys %$comps) {
#      $c = $comps->{$cname};
#      $c->[0]   : state
#      $c->[1]   : message
#      $c->[2]   : enclosure name

sub components {
  my($class) = @_;
  my $comp;
  if ($class eq "State") {
     $class->read() if (!$STATE);
     $class = $STATE;
  }
     
  if (exists($class->{C})) {
    $comp = $class->{C};
  } else {
    $comp = {};
  }
  bless ($comp, "ST_comp");
  return $comp;
}


sub links {
  my($class) = @_;
  if ($class eq "State") {
     $class->read() if (!$STATE);
     $class = $STATE;
  }
 
  return $class->{L};
}

#
#  CLEAR EVENTS: only called from GUI on MASTER
#
sub queue {
  my($class, $val) = @_;
  if (open(OO3, ">>" . System->get_home() . "/DATA/health_queue")) {
    print OO3 "$val\n";
    close(OO3);
  } else {
    print "Error writing to health_queue: $!<br>\n";
  }
}

# returns tstamp if it's the oldest date  and it exists.
# else return creation date of pid file.
# else returns now.

sub now {
  my($tstamp) = @_;
  my $F = System->get_home() . "/DATA/pid";
  my $pid_time = Util->get_file_created($F) || Util->get_today();
  
  return ($tstamp && ($tstamp lt $pid_time) ) ? $tstamp : $pid_time;
}

sub clearAllComponents {
  my($class, $sev, $pattern, $tstamp) = @_;
  $class->read() if (!$STATE);
  $sev = "ANY" if (! defined($sev));
  $tstamp = &now($tstamp);
  $class->queue("clearAllComponents\t$sev\t$pattern\t$tstamp");
}

sub clearAllLinks {
  my($class, $sev, $pattern, $tstamp) = @_;
  $class->read() if (!$STATE);
  $sev = "ANY" if (! defined($sev));
  $tstamp = &now($tstamp);
  $class->queue("clearAllLinks\t$sev\t$pattern\t$tstamp");
}

sub clearComponent {
  my($class, $obj, $tstamp) = @_;
  $class->read() if (!$STATE);
  $tstamp = &now($tstamp);
  $class->queue("clearComponent\t$obj\t\t$tstamp");
}

sub clear {
  my($class, $obj, $tstamp) = @_;
  $class->read() if (!$STATE);
  $tstamp = &now($tstamp);
  $class->queue("clear\t$obj\t\t$tstamp");
}

sub clearLink {
  my($class, $obj, $tstamp) = @_;
  $class->read() if (!$STATE);
  $tstamp = &now($tstamp);
  $class->queue("clearLink\t$obj\t\t$tstamp");
}

sub flush_queue {

  my $queue_f = System->get_home() . "/DATA/health_queue";
  my $cnt2;
  if (-f $queue_f) {
     rename $queue_f, "$queue_f.$$";
     open(OO2, "$queue_f.$$");
     my $l;
     while ($l = <OO2>) {
       chop($l);
       my($id, $obj, $pattern, $tstamp) = split(/\t/, $l, 4);
    
       if ($id eq "clearLink") {
         if (exists($STATE->{L}{$obj}) && $STATE->{L}{$obj}[1] lt $tstamp) {
           delete $STATE->{L}{$obj}; $cnt2++;
         }
    
       } elsif ($id eq "clear") {
         if (exists($STATE->{C}{$obj}) && $STATE->{C}{$obj}[1] lt $tstamp) {
           delete $STATE->{C}{$obj}; $cnt2++;
         }
    
       } elsif ($id eq "clearComponent") {
         my $C = $STATE->{C};
         foreach my $k (keys %$C) {
           if (substr($k,0,length($obj)) eq $obj && $STATE->{C}{$k}[1] lt $tstamp) {
                delete $STATE->{C}{$k}; $cnt2++;
           }
         }
       } elsif ($id eq "clearAllLinks") {
         my $L = $STATE->{L};
         foreach my $k (keys %$L) {
           next if ($pattern && index($k, $pattern) < 0);
           my $sev = int($STATE->{L}{$k}[0] + 0.5);
           if ($obj eq "ANY" || $sev == $obj) { # severity
             if ($STATE->{L}{$k}[1] lt $tstamp) {
               delete $STATE->{L}{$k}; $cnt2++;
             }
           }
         }
       } elsif ($id eq "clearAllComponents") {
         my $C = $STATE->{C};
         foreach my $k (keys %$C) {
           next if ($pattern && index($k, $pattern) < 0);
           my $sev = int($STATE->{C}{$k}[0] + 0.5);
           if ($obj eq "ANY" || $sev == $obj) {
             if ($STATE->{C}{$k}[1] lt $tstamp) {
               delete $STATE->{C}{$k}; $cnt2++;
             }
           }
         }
       }
     }
     close(OO2);
     unlink("$queue_f.$$");
  }
  State->sev_summary();
  return $cnt2;
}



#
# only writes local state table.
#
sub write {
  my($class, $from_agent) = @_;

  return if (!$STATE);
  # write from GUI only if agent is not running.
  # BUG , should look for process itself.
  if (!$from_agent && -f System->get_home() . "/DATA/pid") {
    my $G = Labels->read();
    print $G->{health_clear_request};
    return;
  }
  my $del = &flush_queue();

  my($renv) = System->get_renv();
  my($F) = System->get_home() . "/DATA/state/" . $renv->{hostname};
  open(O, ">$F");
  require Data::Dumper;
  $Data::Dumper::Indent = 1;
  print O Data::Dumper::Dumper($STATE);
  close(O);
  return $del;
}


# this runs on the host that has data-path access.

# State->saveLinkState($type1, $key1, $type2, $key2,
#         Message::SEVERITY_WARNING, $desc, $reads, $writes, $pc, $ra);
# probable cause, recomm actions

sub saveLinkState {
  my($class, $cat1, $node1, $cat2, $node2, $sev, $desc, $reads, $writes, $ev) = @_;

  $cat1 = lc($cat1);
  $cat2 = lc($cat2);
  my($key) = "$node1|$node2";
  my($data, $x, $summ);
  if ($ev) {
    $summ = "EventType="  . $ev->value("EventType") . 
            "| Target="    . $ev->value("Target") .
            "| Actionable=". $ev->value("Actionable") .
            "| GridCode="  . $ev->value("GridCode");
  }

  my($master) = Util->findMaster;
  my($D)      = System->get_home() . "/DATA/state/";
  my($renv)   = System->get_renv();
  my $host    = $renv->{hostname};
  my $date    = Util->today("YMDH");
  $desc       =~ s/[\|,]/ /g;
  $state_changed = 1;

# 
# SAVE LOCAL LINK LOG INFO
#
  my $stateLog = System->get_home() . "/DATA/LinkStateLog";
  open(W, ">>$stateLog");
  print W "L\t$node1|$node2\t$sev\t$date\t$desc\n";

  for ($x=0; $x <= $#$reads && $x < 10; $x++) {
    print W "R\t$reads->[$x]\n";
  }
  for ($x=0; $x <= $#$writes && $x < 10; $x++) {
    print W "W\t$writes->[$x]\n";
  }
  close(O);
  Debug->truncate($stateLog, 1);

# SLAVE
  if ($master) {
     open(O, ">>$D/$host.slave");
     print O "L\t$key\t$sev\t$date\t$desc\t$summ\n";
     close(O);
     #return;
  }

# MASTER or SLAVE

  if (!$STATE) {
     $class->read();
  }
  my($sev0)  = $STATE->{L}{$key}[0];
  my($cnt)   = $STATE->{L}{$key}[3];

  $STATE->{L}{$key} =
     [$sev,"$date $desc", $summ, $cnt+1, $host];  # 0=ok, 1=w, 2=err,3=down
}

# ->saveState($cat, $name, $keyval,
#         Message::SEVERITY_DOWN, "Lost Communication");
#            4=notpresent, 3=down, 2=error,1=warn,0=ok
#  this runs on the host that has instrumentation agent running.

sub saveState {
  my($class, $cat, $keyval, $comp, $name, $sev, $mess, $avail, $ev, $arg) = @_;

  my $summ;
  $cat = lc($cat);
  my $abs = $arg->{absolute};  # use sev as is, no comparison with current.
  $name = $keyval if (!$name);
  $comp = "e" if (!$comp);  # enclosure
  if ($ev) {
    $summ = "EventType="  . $ev->value("EventType") . 
            "|Target="    . $ev->value("Target") .
            "|TargetName=". $ev->value("TargetName") .
            "|Caption="   . $ev->value("Caption") .
            "|Actionable=". $ev->value("Actionable") .
            "|GridCode="  . $ev->value("GridCode") .
            "|SourceIP="  . $ev->value("SourceIP") .
            "|Severity="  . $ev->value("Severity") .
            "|PriorState="    . $ev->valueq("PriorState") .
            "|CurrentState="  . $ev->valueq("CurrentState");

    my $org = State->eventHash($ev->valueq("OriginalEvent"));
    if ($org->{Target}) {
      $summ .= "|OrigEventType="  . $org->{EventType}  .
               "|OrigTarget="     . $org->{Target}     .
               "|OrigTargetName=" . $org->{TargetName} .
               "|OrigCaption="    . $org->{Caption};
    } else {
      $summ .= "|CurrentValue="  . $ev->valueq("CurrentValue");
    }
  }

  my($master) = Util->findMaster;
  my($D)      = System->get_home() . "/DATA/state";
  my($renv)   = System->get_renv();
  my $host    = $renv->{hostname};
  my $date    = Util->today("YMDH");

  if ($master) { # a slave
     $state_changed = 1;
     open(O, ">>$D/$host.slave");
     print O "C\t$cat:$keyval:$comp\t$sev\t$date\t$mess\t$name\t$avail\t$summ\n";
     close(O);
     #return;
  }
  if (!$STATE) {
     $class->read();
  }
  # &flush_queue() if (!$master);

  my $sev0 = $STATE->{C}{"$cat:$keyval:$comp"}[0];

  if ($sev == 0 || $sev >= $sev0 || $abs) {
    $state_changed = 1;
    $mess =~ s/[\|,\n]/ /g;
                                        # 0=ok, 1=w, 2=err,3=d own
    $STATE->{C}{"$cat:$keyval:$comp"} = [$sev,"$date $mess", $name, $avail, $summ];  
  }
  $comp = $comp;
}

sub eventHash {
  my($class, $comp, $del) = @_;
  my (%H, @L);
  if ($del) {
    @L= split(/$del/, $comp);
  } else {
    @L= split(/\|/, $comp);
  }
  foreach my $el (@L) {
    my $ix = index($el, "=");
    $H{substr($el,0,$ix)} = substr($el,$ix+1) if ($ix > 0);
  }
  return \%H;
}


sub isChanged {
  return $state_changed;
}

package ST_comp;

#  ($List, $others) = $Comp->summary("t3:key", ["power|disk.power","fan","controller"], ["disk"]);
#  $List->[0][0] = power_sev,  
#  $List->[0][1] = power_text 

sub summary {
  my($comps, $name, $vals, $exclude) = @_;
  
  my (@F, $x);
  my $other = undef;
  foreach my $k (keys %$comps) {
     my($type, $key, $rest) = split(/\:/, $k, 3);
     next if ("$type:$key" ne $name);
     my $found = 0;
     my $f = $comps->{$k};
     for ($x=0; $x <= $#$vals; $x++) {
         my $v = $vals->[$x];
         if ($rest eq $v) {
            $found = 1;
         } elsif (index($v,"|") > 0 && index("|$v|", "|$rest|") >= 0) {
            $found = 1;
 
         } elsif (substr($v,-1) eq "*" && substr($rest,0,length($v)) eq substr($v,0,-1) . ".") {
            $found = 1;
         }
         if ($found) {
            if (!$F[$x] || $f->[0] > $F[$x][0]) {
               $F[$x][0] = $f->[0];
               $F[$x][1] = $f->[1];
               last;
            }
         } 
      }
      if (!$found && (!$other || $f->[0] > $other->[0])) {
         my $skip =0;
         foreach my $e (@$exclude) {
             if (substr($rest, 0, length($e)) eq $e) {
                $skip = 1; last;
             }
         }
         if (!$skip) {
           $other->[0] = $f->[0];
           $other->[1] = $f->[1];
         }
      }
   }
   my ($o, $o2);
   for ($x=0; $x <= $#$vals; $x++) {
        $o .= "$F[$x][0],";
        $o2 .= "$F[$x][1],";
   }
   $o .= $other->[0];
   $o2 .= $other->[1];
   return ($o,$o2);
}


#  a star at the end means exact match or '.' and more
sub value {
  my($comp, $val, $ix) = @_;

  if (substr($val,-1) eq "*") {
     my $current = [-2];
     my $found;
     chop($val);
     my $l2 = length($val);
     foreach my $el (keys %$comp) {
         if ($el eq $val || substr($el,0,$l2+1) eq "$val.") {
             my $f = $comp->{$el};
             if ($f->[0] > $current->[0]) {
               $current = $f ; $found = 1;
             }
         }
     }
     if ($found) {
        if (defined($ix)) {
          return $current->[$ix];
        } else {
          return $current;
        }
     }   
     if (defined($ix)) {
       return undef;
     } else {
       return [];
     }
  } 

  if (exists($comp->{$val})) {
    if (defined($ix)) {
      return $comp->{$val}[$ix];
    } else {
      return $comp->{$val};
    }
  }
  if (defined($ix)) {
    return undef;
  } else {
    return [];
  }
}





1;



