package Provider::Email;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>


#  $Id: Email.pm,v 1.80 2003/05/19 22:04:09 ccadieux Exp $

use PDM;
use Carp;
use Message;
use Grid;
use Util;
use strict;
use MaxEvents;
use Net::SMTP;
use Filters;
use Mail;

use base 'Provider';
sub revision {'$Revision: 1.80 $'}

sub new {
  my($self, $pdm)  = @_;

  my($p) = { pdm => $pdm };

  bless($p,'Provider::Email');
  return $p;
}

sub RUN {
  my($pro) = @_;
  my($notifs, $notif, $p, $ed, $id, $cat, $sev, $admin, $eventType);
  my(%EMAILS) = (); my(%COUNT) = ();
  my($ed_desc, $email_text);
  my($edocs) = PDM->getMessages;
  my($hostname) = System->hostname();

  my(%OUT);
  my $L = Labels->read('Provider')->section('email');

  my($renv, $devices, $hosts, $notifs, $Config) = PDM::ConfigFile->read();
  $DB::single = 1;

  my $timeout = $renv->{'timeout.email'} || 20;
  my($acronym) = $renv->{GSV_ACRONYM};
  my $EMAIL_PER_EVENT = $renv->{email_per_event};   # hotmail

  my($version) = $renv->{version};
  my($mailer) = $renv->{mailer} || "/usr/bin/mail";
  if (!-x $mailer) {
    $mailer = "/bin/mail";
    return if (!-x $mailer);
  }
  my($st_found);
  if (System->get_stFound()) {
     $st_found = "*** $L->{diag}: " . System->get_stFound() . "\n";
  }
  my $max_email = $renv->{max_daily_email} || 8;
  my $MAX = MaxEvents->new("email");
  my $exclude = $renv->{email_exclude_list};
  my $groups = $Config->adminGroups();  # hash
  my $filters = Filters->new();

  foreach $notif (@$notifs) {  # Each notification.
     $admin = Util->rtrim($notif->{email});

     $eventType = Util->rtrim($notif->{event});  # discovery|stateChange|..
     my $L = Labels->read('Provider')->section('email');

     $p = $notif->{priority};
     foreach $ed (@$edocs) {   # Each Message.
       next if ($ed->type() eq Message::TYPE_ALERT); # Skip alerts
       $cat = $ed->id("category"); # A5/T3 ...
       next if ($ed->id("active") eq "N"); # no email if quiesced
       my($ev)     = $ed->instances()->[0];
       $sev        = $ev->value("Severity");
       next if ($ed->id("inAggregate")  && $notif->{skip_agg});
       my $mgmtLevel  = $ev->value("MgmtLevel") ;
       my $solid;
       if ($mgmtLevel eq "DS") {
         $solid = $ev->value("SolutionId");
         my $ix = index($solid, ".");
         $solid = substr($solid,0, $ix) if ($ix > 0);
       }
       if ($mgmtLevel eq "DS") {
          next if (index($notif->{email_type}, "S") < 0);
       } elsif ($mgmtLevel eq "C") {
          next if (index($notif->{email_type}, "C") < 0);
       }
       my($agent)  = $ed->instances()->[1];
       my($source) = $agent->value('IdentificationCode') if ($agent);
       my($etype0) = $ev->value('EventType');
       my $g_code  = $ev->value("GridCode");
       my $g_no    = $ev->value("GridNo");
       my $sourceIP= $ev->value("SourceIP");
       next if ($exclude && index(",$exclude,", ",$g_no,") >= 0);

       my $caption    = $ev->value('Caption');
       my $actionable = $ev->value('Actionable');
       my $target     =  $ev->value('Target');

       # FILTERS
       if ($notif->{apply_filters} eq "Y") {
          my $new_sev = $filters->severity($g_no, $cat, $ev->value("Description") );
          if (defined $new_sev) {
             next if ($new_sev == 9);
             $sev = $new_sev; $actionable = "FALSE";
          }
       }

       # ADMIN-GROUP
       if ($notif->{groups}) {
         if (substr($target,0,6) eq "agent:") {
           next if (index("|$notif->{groups}|", "|SYSTEM|") < 0);
         } else {
           my($targ1,$targ2,$targ3) = split(/\:/, $target, 3);
           my $targ = "$targ1:$targ2";
           next if (exists $groups->{$targ} && 
                  index("|$notif->{groups}|", "|$groups->{$targ}|") < 0);
         }
       }
       my $targetName =  $ev->value('TargetName') || $target;
       my ($last, $last_email);

       # MAX-EVENTS
       if ($target && $max_email) {
          ($last, $last_email) = $MAX->maxEvents($ev, $admin|"NA", $max_email, 8);
          if ($last_email) {
             $last_email = $L->{last_email};
          }
          next if ($last);
       }

       my($etype)  = $etype0;
       my($ix) = index($etype0, '.');
       $renv->{language} = $notif->{language};
       my ($gridInfo, $x);
       if ($etype0 !~ "AggregatedEvent" && $notif->{no_grid} ne "Y") {
         my @Lb = ($L->{info}, $L->{cause}, $L->{action});
         my @Is = Grid->getInfoString($etype0, $caption, $g_code);
         for ($x=0; $x <= 2; $x++) {
           if ($Is[$x]) {
             $Is[$x] =~ s/\n/\n /g;
             $gridInfo .= "\n$Lb[$x]:\n $Is[$x]";
           }
         }
       }

       if ($ix > 0) {
         $etype = substr($etype0, $ix+1);
         $cat   = substr($etype0, 0, $ix);
       }
       next if ((index($notif->{device},"*")          < 0) && 
                 index(lc($notif->{device}),lc($cat)) < 0);

       next if (($eventType ne "*") && index(lc($eventType),lc($etype)) < 0 );
       my $run = 0;
       if ($p eq "*") {
          $run = 1;
       } elsif ($p == 91 && $actionable eq "TRUE") {
          $run = 1;
       } elsif ($p == 9 && $sev >= 1) {
          $run = 1;
       } elsif ($p == $sev) {
          $run = 1;
       }
       next if (!$run);

       $ed_desc = $ed->eventData("Description");
       my($eid) = $ed->eventData('EventId');
       my($etime) = $ed->eventTime();
       my($data);
       if ($ed_desc =~ /:$/) {
            $data = $ev->propertyByName('Data')->value;
            $data =~ s/ \|\| /\n /g;
       }
       my $sev_txt = $Message::SEV_MAP{$sev} || $sev;
       $sev_txt .= " (Actionable)" if ($actionable eq "TRUE");

       if ($notif->{script} && -x $notif->{script} ) {
          my $dd = $ed_desc; $dd =~ s/\"//g;
          my $tt = $target || $source;
          my $com = "$notif->{script} -C \"$cat\" -G \"$g_no\" -S $sev -T \"$tt\" -N \"$targetName\" -E \"$etype.$caption\"  -D \"$dd\" -A \"$actionable\" ";
          $com .= " -I \"$sourceIP\"" if ($sourceIP);
          Util->run_command($com, "command", 20);
       }

       my $ss = ($sev >= 2) ? "E": ($sev == 1? "W":"I");
       $OUT{"${admin}:$ss"}{type} = $notif->{type};

       my $cat2 = Util->abb("$cat.medium") || uc($cat);
       my $content = 
                "$L->{site} $renv->{site_name} $renv->{site_city} $renv->{site_state} \n".
                "$L->{source} $source\n"         .
                "$L->{sev} $sev_txt \n"          .
                 $L->{cat} . " $cat2 $solid\n".
                "$L->{devid} $targetName\n"          .
                "$L->{type} $etype.$caption\n"   .
                "$L->{code} $g_no\n"           .
                "$L->{time} $etime\n$last_email\n"          .
                "$L->{descr}\n$ed_desc\n\n$data\n" . 
                "$gridInfo\n\n";

       next if (!$admin);
       if ($EMAIL_PER_EVENT) {
             my $sub = "$hostname: $cat.$etype $ed_desc";
             Mail->mail($admin, $acronym, 
                        $sub, 
                        $L->expand('requested', $hostname) .  
                            "\n$st_found\n" . $content,
                        20);
             Debug->print2("Email $etype to $admin");
       } else {
             $OUT{"${admin}:$ss"}{desc}    .= $ed_desc;
             $OUT{"${admin}:$ss"}{content} .= $content;
             $OUT{"${admin}:$ss"}{content} .= "\n" . "-" x 70 . "\n";
       }
    }
  }
  $MAX->serialize();

  my %S = ( W => $L->{warn}, E => $L->{err}, I => $L->{not});

  if (!$EMAIL_PER_EVENT) {
    foreach my $admin0 (keys %OUT) {
      my $type = $OUT{$admin0}{type};
      my($admin, $ss) = split(/\:/, $admin0);
      my $sev_txt = $S{$ss};

      if ($type eq "Email") {

        Debug->print1("Emailing to $admin");
        my $err = &send(0, $admin, $acronym,
                   "$sev_txt from '$hostname' ($version)",
                   $L->expand('requested', $hostname) .
                  "\n$st_found\n" . $OUT{$admin0}{content},
                   $timeout);

      } elsif ($type eq "Pager") {

        Debug->print1("Paging $admin");
        my $err = &send(1, $admin, $hostname, "", 
               substr($OUT{$admin0}{desc}, 0, 250) , $timeout);
      }
    }
  }
}

sub send {
  my($pager, $to, $from, $subject, $data, $timeout) = @_;
  my $renv = System->get_renv();

  my $sendmailServer = $renv->{sendmail_server} || "localhost";

  my $smtp = Net::SMTP->new($sendmailServer, Timeout => $timeout);
  if (!$smtp) {
     Debug->print2("Cannot create SMTP handle (timeout=$timeout)");
     Debug->errNoRepeat(MAIL_FAILED =>  $sendmailServer, 8);
     return;
  }
  my $ct = "Content-Type: text/plain; charset=us-ascii";

  my $text;
  my $ef = $renv->{email_from};
  if ($ef) {
    if ($ef =~ /\@/) {
       $from = $ef;
    } else {
       $from .= "\@$ef";
    }
  }
  if ($pager) {
    $text = "From: $from\n$ct\n\n$data";
  } else {
    $text = "From: $from\nTo: $to\nSubject: $subject\n\n$data";
  }

  if ($smtp->mail($to) && $smtp->to($to)) {
     $smtp->data();
     $smtp->datasend($text);
     $smtp->dataend;
     $smtp->quit;
     return undef;
  } else {
     my $err = $smtp->message();
     $smtp->quit;
     return $err;
  }
}
  
  
1;
