package MaxEvents;
use System;
use Util;
use strict;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>
#
#  $Id: MaxEvents.pm,v 1.25 2003/05/14 00:26:31 ccadieux Exp $

# Package contains logic to keep tracks of the number of time 
# an event occured in a certain number of hours.
#  $MAX = MaxEvents("topic");
#  $MAX->maxEvents(target, caption, $max, $hours)
#  $MAX->serialize();
#  will use the time of the first event to count 8 hours from.
#  so if events are generated every hour, it will never stop.


sub new {
  my($class, $subject) = @_;

  my $MAX = Util->deserialize("Max_$subject") || {};

  my $obj = {MAX => $MAX, subject => $subject};

  bless($obj, 'MaxEvents');
  return $obj;
}

sub clean {
  my($object) = @_;
  my $MAX = $object->{MAX};
  my $today = int(time / 60);
  foreach my $el (keys %$MAX) {
     if ($today - $MAX->{$el}[1] > (7 * 24 * 60)) {   # one week old
        delete($MAX->{$el});
     }
  }
}

# check if the database has been removed while the agent was running.

sub checkIfRemoved {
  my($object) = @_;
  my $subject = $object->{subject};
  my $F = System->get_home() . "/DATA/Max_$subject";

  if (!-f $F) {
     $object->{MAX} = {};
     Util->serialize("Max_$subject", {});
  }
}


sub serialize {
  my($obj) = @_;
  my $subject = $obj->{subject};
  $obj->clean();

  Util->serialize("Max_$subject", $obj->{MAX});
}

# if actionable ==1 , only count actionable events
sub maxEvents {
  my($object, $ev, $user, $max, $hours) = @_;
  $user =~ s/\:/_/g if ($user);
  return (0,0) if (System->get_eventMaxOff());

  $object->checkIfRemoved();

  my $target  = $ev->value('Target');
  my $et      = $ev->value('EventType');
  my $caption = $ev->value('Component') || $ev->value('Caption');
  my $act     = $ev->value('Actionable');
  my $MAX = $object->{MAX};
  $hours = 8 if (!$hours);
  my $last_email;

  my $caption0 = $caption;
  if (substr($target,0,5) eq "host:" && index($caption, "lun.") >= 0) {
     $caption0 = "lun";

  } elsif (substr($caption0,0,2) eq "M." ||
           substr($caption0,0,2) eq "P." ||
           substr($caption0,0,2) eq "X.") {
     $caption0 = substr($caption0,2);
  }
  my $email_key = "$user:$target:$caption0:$act"; # separate count for actionable and non-act.

  if ($max) {
    my $today = int(time / 60);
    if ( exists($MAX->{$email_key}) ) {
       if ($today - $MAX->{$email_key}[1] > ($hours * 60)) {   # COMPARE TO LAST EVENT
          delete($MAX->{$email_key});
       }
       if ($MAX->{$email_key}[0] == $max) {
         $last_email = 1;
         $MAX->{$email_key}[2] = Util->get_today();             # END OF WINDOW
       }
       if ( $MAX->{$email_key}[0] > $max) {  # INC counter, no DATA change
         $MAX->{$email_key}[0]++;
         return (1, $last_email);
       }
    }
    $MAX->{$email_key}[1] = $today;                             # DATE OF LAST EVENT
    $MAX->{$email_key}[3] = $today if (!$MAX->{$email_key}[1]); # START OF WINDOW
    $MAX->{$email_key}[0]++;
  }
  return (0,$last_email);
}


1;
  

