package Luxadm;

#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Id: Luxadm.pm,v 1.3 2003/04/01 00:49:34 ccadieux Exp $

use strict;
use PDM;
use Util;
use Timer;
use Carp;
use vars qw($AUTOLOAD);
use System;
#use Scheduler;
use Timelapse;
use Debug;


use vars qw(%_FIELDS %LOGFILES %DEVICES %CACHES $WWNINFO $ERROR);

%_FIELDS = ('can_be_turned_off', undef);



##########################
#   FIND DISKS paths
#  Agent->luxadmDiskPaths({ type => "Tape"})
##########################

sub luxadmDiskPaths {
  my($class, $arg) = @_;
  my @PATHS;
  my($renv) = System->get_renv();
  my($TO) = $renv->{'timeout.luxadm'};
  my $flag   = 0;
  my $type = $arg->{type} || "Disk";

  my($lux) = "/usr/sbin/luxadm";
  my ($err,$probe) = Util->run_command("$lux probe -p","", $TO);

  $ERROR = $err;
  return undef if ($err);
  my($in, $l);
  my($hbalist, $ix, $h2, $h3);

  for ($ix=0; $ix <= $#$probe; $ix++) {
      $l = $probe->[$ix];
      if ($l =~ / Node WWN:(.+)\s+Device Type:$type/) { # t3 or internal..
         my($wwn) = Util->trim($1);
         my $path;
         if ($probe->[$ix+1] =~ /Logical Path:(.*)/) {
             $path = $1;
         }
         push(@PATHS, [$path, $wwn]);
      }
   }
   return \@PATHS;
}


sub luxadmDisplay {
  my($class, $path) = @_;
  my @DIS;
  my($renv) = System->get_renv();
  my($TO) = $renv->{'timeout.luxadm'};
  my $flag   = 0;

  my($lux) = "/usr/sbin/luxadm";
  my ($err,$probe) = Util->run_command("$lux display $path","", $TO);

  return undef if ($err);
  my $ix = -1;
  my ($current, $x);
  my $statport = "A";
  if ("@$probe" =~ /WWN\(Node\)/) {  # OLD FORMAT
    for ($x=0; $x <= $#$probe; $x++) {
      my $l = $probe->[$x];
      if ($l =~ /DEVICE PROPERTIES/) {
          $ix++;
      } elsif (index("Status,Vendor,Produc,WWN(No,Revisi,Serial,", substr($l,2,6)) >= 0) {
         $l =~ /\s+([^:]+)\:\s+(.+)/;
         my $name = $1; 
         next if (!$name);
         my $val = $2;
         $name =~ s/[\(\)]//g;
         $name =~ s/ //g;
         $DIS[$ix]{$name} = Util->trim($val);
      } elsif ($l =~ /^  \/dev/) {
         if (exists($DIS[$ix]{logical})) {
           $DIS[$ix]{physical}  = Util->ltrim($l);
         } else {
           $DIS[$ix]{logical}  = Util->ltrim($l);
         }
      }elsif ($l =~ /Device Address\s+(.*),(.*)/) {
         
         $DIS[$ix]{"WWNPort"} = $1;
	 $DIS[$ix]{"WWNPORTID"} = $2;
      }elsif ($l =~ /WWN\(Port .*\):\s+(.*)/) {
         $DIS[$ix]{"WWNPort"} = $1;
      }elsif ($l =~ /Class\s+(.*)/) {
         $DIS[$ix]{"Class"} = $1;
	 if($1 =~ /secondary/){
    	    $statport = "B";
	 }else{
	    $statport = "A";
	 }
      } elsif ($l =~ /State\s+(.*)/) {
         $DIS[$ix]{"StatusPort$statport"} = $1;
      }

    }
  } else {
    my (%SAVE, $status);
    my $statport = "A";
    for ($x=0; $x <= $#$probe; $x++) {
      my $l = $probe->[$x];
      if ($l =~ /DEVICE PROPERTIES/) {
          $ix++; $status = 0;
          %SAVE = ();
      } elsif (index("Vendor,Produc,Revisi,Serial,", substr($l,2,6)) >= 0) {
         $l =~ /\s+([^:]+)\:\s+(.+)/;
         my $name = $1; 
         next if (!$name);
         my $val = $2;
         $name =~ s/[\(\)]//g;
         $name =~ s/ //g;
         $SAVE{$name} = Util->trim($val);
         $DIS[$ix]{$name} = Util->trim($val);

      } elsif ($l =~ /^  \/dev/) {
         if ($status && $l =~ /\/dev\// ) {
           $ix++  ;
           $DIS[$ix]{ProductID} = $SAVE{ProductID};
           $DIS[$ix]{Vendor}    = $SAVE{Vendor};
           $DIS[$ix]{Revision}  = $SAVE{Revision};
         }
         if (exists($DIS[$ix]{logical})) {
           $DIS[$ix]{physical}  = Util->ltrim($l);
         } else {
           $DIS[$ix]{logical}  = Util->ltrim($l);
         }
      } elsif ($l =~ /LUN path port WWN:\s+(.*)/) {
         $DIS[$ix]{"WWNPort"} = $1;
      }elsif ($l =~ /Device Address\s+(.*),(.*)/) {
         
         $DIS[$ix]{"WWNPort"} = $1;
	 $DIS[$ix]{"WWNPORTID"} = $2;
      } elsif ($l =~ /Host controller port WWN:\s+(.*)/) {
         $DIS[$ix]{"WWNNode"} = $1;
      } elsif ($l =~ /Host controller port WWN\s+(.*)/) {
         $DIS[$ix]{"WWNNode"} = $1;
      } elsif ($l =~ /Path status:\s+(.*)/) {
         $DIS[$ix]{"StatusPortA"} = $1;
         $status = 1;
      }elsif ($l =~ /Class\s+(.*)/) {
         $DIS[$ix]{"Class"} = $1;
	 if($1 =~ /secondary/){
    	    $statport = "B";
	 }else{
	    $statport = "A";
	 }

      } elsif ($l =~ /State\s+(.*)/) {
         $DIS[$ix]{"StatusPort$statport"} = $1;
         $status = 1;
      }
    }
  }
  
  return \@DIS;
}
  

sub luxadmA5KPaths {
  my($class, $arg) = @_;

  my($renv) = System->get_renv();
  my($TO) = $renv->{'timeout.luxadm'};

  my($encs)   = $arg->{encs};
  my($lux)    = "/usr/sbin/luxadm";
  my($err,$probe, $l);

#
# Find ENCLOSURES AND PATHS with PROBE
#
  ($err,$probe) = Util->run_command("$lux probe -p","luxprobe", $TO);

  my($hbalist, $ix, $a5);
  my($MPX, $in);
  my(%WWN2E, %ENC, @HBA);

  for ($ix=0; $ix <= $#$probe; $ix++) {
      $l = $probe->[$ix];
      if ($l =~ /Found/) {
        $in = 1;
      } elsif ($in) {
        if ($l =~ / Name:(.+)\s+Node WWN:([^\s]+)/) {
          my($off) = 2;
          my($name) = Util->trim($1);
          my($wwn) = Util->trim($2);
          $off = 1 if ($l =~ /Logical Path/);
          if ($encs && index(",$encs,", ",$name,") >= 0) {
            $WWN2E{$wwn} = $name;
            $ENC{$wwn} = 1;
          } else {
            $WWN2E{$wwn} = $name;
            $ENC{$wwn} = 1;
          }

          while ($probe->[$ix+$off] =~ /Physical Path:(.*)/ &&
                  $probe->[$ix+1] !~ /Node WWN:/ ) {
             my($hba) = $1;
             if ($hba =~ /\/devices\/scsi_/) { # MPX
               $MPX = 1;
             } else {
               my($ix2) = rindex($hba, "/");
               $hba = substr($hba,0, $ix2);
               if (index($hbalist, "$hba,") < 0) {
                 push(@HBA, $hba);
                 $hbalist .= "$hba,";
               }
             }
             $ix+= $off;
          }
        }
      }
  }

  return (\@HBA, \%ENC, \%WWN2E, $MPX, $hbalist);
}



#  OLD FORMAT
#  luxadm display /dev/rdsk/c1t29000060220041F96257354230303068d0s2
#  DEVICE PROPERTIES for disk: /dev/rdsk/c1t29000060220041F96257354230303068d0s2
#    Status(Port A):       O.K.
#    Status(Port B):       O.K.
#    Vendor:               SUN     
#    Product ID:           SESS01          
#    WWN(Node):            2a000060220041f9
#    WWN(Port A):          2b000060220041f9
#    WWN(Port B):          2b000060220041f4
#    Revision:             0811
#    Serial Num:           Unsupported
#    Unformatted capacity: 121856.000 MBytes
#    Write Cache:          Enabled
#    Read Cache:           Enabled
#      Minimum prefetch:   0x0
#      Maximum prefetch:   0x0
#    Device Type:          Disk device
#    Path(s):
#    /dev/rdsk/c1t29000060220041F96257354230303068d0s2
#    /devices/scsi_vhci/ssd@g29000060220041f96257354230303068:c,raw
#     Controller           /devices/pci@c,2000/pci@2/SUNW,qlc@5/fp@0,0
#       Device Address     2b000060220041f9,4
#       Class              primary
#       State              ONLINE
#     Controller           /devices/pci@f,2000/pci@2/SUNW,qlc@5/fp@0,0
#       Device Address     2b000060220041f4,4
#       Class              primary
#       State              ONLINE
#
# NEW FORMAT NON MPXIO
#  
#  DEVICE PROPERTIES for disk: /dev/rdsk/c15t2B00006022004188d1s2
#    Vendor:               SUN     
#    Product ID:           SESS01          
#    Revision:             0811
#    Serial Num:           Unsupported
#    Unformatted capacity: 1073.742 MBytes
#    Write Cache:          Enabled
#    Read Cache:           Enabled
#      Minimum prefetch:   0x0
#      Maximum prefetch:   0x0
#    Device Type:          Disk device
#    Path(s):
#  
#    /dev/rdsk/c15t2B00006022004188d1s2
#    /devices/sbus@8,0/SUNW,qlc@1,30000/fp@0,0/ssd@w2b00006022004188,1:c,raw
#      LUN path port WWN:          2b00006022004188
#      Host controller port WWN:   210000e08b049858
#      Path status:                O.K.
#    /dev/rdsk/c18t2B00006022004193d1s2
#    /devices/sbus@9,0/SUNW,qlc@0,30400/fp@0,0/ssd@w2b00006022004193,1:c,raw
#      LUN path port WWN:          2b00006022004193
#      Host controller port WWN:   210000e08b249758
#      Path status:                O.K.
#    /dev/rdsk/c19t2B00006022004188d1s2
#    /devices/pci@e,2000/pci@2/SUNW,qlc@4/fp@0,0/ssd@w2b00006022004188,1:c,raw
#      LUN path port WWN:          2b00006022004188
#      Host controller port WWN:   210000e08b01608d
#      Path status:                O.K.
#  
# NEW FORMAT MPXIO ENBALED
#
#/opt/SUNWstade/lib: luxadm display /dev/rdsk/c1t60020F20000001463DF59656000501B8d0s2
#DEVICE PROPERTIES for disk: /dev/rdsk/c1t60020F20000001463DF59656000501B8d0s2
#  Vendor:               SUN     
#  Product ID:           T4              
#  Revision:             0300
#  Serial Num:           Unsupported
#  Unformatted capacity: 5372.117 MBytes
#  Write Cache:          Enabled
#  Read Cache:           Enabled
#    Minimum prefetch:   0x0
#    Maximum prefetch:   0x0
#  Device Type:          Disk device
#  Path(s):
#
#  /dev/rdsk/c1t60020F200000DE063DAD4A02000B2266d0s2
#  /devices/scsi_vhci/ssd@g60020f20000001463df59656000501b8:c,raw
#   Controller           /devices/pci@b,2000/SUNW,qlc@2,1/fp@0,0
#    Device Address              20030003ba27d7a2,36
#    Host controller port WWN    210100e08b27f0b3
#    Class                       secondary
#    State                       OFFLINE
#    I/Os disabled on this OFFLINE path
#
#   Controller           /devices/pci@8,2000/SUNW,qlc@2/fp@0,0
#    Device Address              20030003ba202db3,36
#    Host controller port WWN    210000e08b07d3a6
#    Class                       primary
#    State                       ONLINE



   

1;
