package Logic::9900;

use Util;
use strict;
use Agent::9900;
use Logic;

sub addToConfig {
   my($class, $q) = @_;
   my ($err, $ipno, $active, $x);
   $active = "Y";
   my @nodes;

   while (1) {
     if (!$q->{ip}) {
        $err = Error->error(103);
        last;
     } else {
        if (!($ipno = Util->testIp($q->{ip}))) {
           $err = Error->warning("cannot_ping",  $q->{ip});
           $active = "N";
        }
        my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
        my $rc = Agent::9900->getWWN($q->{ip});

        my $key = $rc->{key};
        if (!$key) {
           $err = Error->warning("cannot_discover",  "with snmp on $q->{ip}");
           last;
        }

        my %THERE;
        foreach $x (@$devs) {
          if (index("9900", $x->{type}) >= 0) {
             $THERE{$x->{key}} = 1;
          }
        }
        if (!$THERE{$key}) {
           $x = $#$devs + 1;
           $devs->[$x]{_name}    = "device" . ($x+1);
           $devs->[$x]{type}     = $rc->{type};
           $devs->[$x]{class}    = "storage." . $rc->{type};
           $devs->[$x]{key}      = $key;
           $devs->[$x]{wwn}      = $rc->{wwn};
           $devs->[$x]{name}     = $q->{name} || $q->{ip};
           $devs->[$x]{active}   = $active;
           $devs->[$x]{ip}       = $q->{ip};
           $devs->[$x]{ipno}     = $ipno;
           $devs->[$x]{host}     = $q->{host};
           Logic->clearSlave($q->{host}, $hosts);
           push(@nodes, $devs->[$x]);

           if (!PDM::ConfigFile->write( $renv, $devs, $hosts,$notifs)) {
             $err = Error->error(101);
           }
        }
     }
     last;
    }
out:
    return ($err, \@nodes);
}

1;

