package Logic::3310;

use Util;
use strict;
use Agent::3310;
use Logic;

sub addToConfig {
   my($class, $q) = @_;
   my ($err, $ipno, $active, $x);
   $active = "Y";
   my @nodes;

   while (1) {
     if (!$q->{ip}) {
        $err = Error->error(103);
        last;
     } else {
        if (!($ipno = Util->testIp($q->{ip}))) {
           $err = Error->warning("cannot_ping",  $q->{ip});
           $active = "N";
        }
        my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
        my $rc = Agent::3310->getWWN($q->{ip});
        if (!$rc->{key}) {
           $err = Error->error(no_device => $q->{ip});
           last;
        }
        my $key = $rc->{key};

        my %THERE;
        foreach $x (@$devs) {
          if (index("3310,3510", $x->{type}) >= 0) {
             $THERE{$x->{key}} = 1;
          }
        }
        if (!$THERE{$key}) {
           $x = $#$devs + 1;
           $devs->[$x]{_name}    = "device" . ($x+1);
           $devs->[$x]{type}     = $rc->{type};
           $devs->[$x]{class}    = "storage." . $rc->{type};
           $devs->[$x]{key}      = $key;
           $devs->[$x]{wwn}      = $rc->{wwn};
           $devs->[$x]{wwn2}     = $rc->{wwn2} if ($rc->{wwn2});
           $devs->[$x]{wwn3}     = $rc->{wwn3} if ($rc->{wwn3});
           $devs->[$x]{wwn4}     = $rc->{wwn4} if ($rc->{wwn4});
           $devs->[$x]{wwns}     = $rc->{wwns};
           $devs->[$x]{name}     = $q->{name} || $q->{ip};
           $devs->[$x]{active}   = $active;
           $devs->[$x]{userLabel}= $q->{userLabel};
           $devs->[$x]{ip}       = $q->{ip};
           $devs->[$x]{ipno}     = $ipno;
           $devs->[$x]{host}     = $q->{host};
           Logic->clearSlave($q->{host}, $hosts);
           push(@nodes, $devs->[$x]);

           if (!PDM::ConfigFile->write( $renv, $devs, $hosts,$notifs)) {
             $err = Error->error(101);
           }
        }
     }
     last;
    }
out:
    return ($err, \@nodes);
}

sub discover {
  my($class, $SELECT, $desc2, $html) = @_;

 my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
  my $G = Labels->read();
  my %F;
  my($cnt) = 0;
  foreach my $d (@$devs) {
     if (index("3310,3510", $d->{type}) >= 0) {
        $cnt++;
        $F{$d->{key}} = 1;
     }
  }
  print "<pre>" if ($html);
  print "1 - " . $G->expand('find_already', "$cnt $desc2") . " $SELECT...\n";

  if (!$SELECT || $SELECT eq "local") {
    print "2 - " . $G->expand('find_local', $desc2) . "\n";
    my $locals = Agent::3310::discover();
 
    my($skipit, $j, $addit) = 0;
 
    my($new_dev) = $#$devs;
 
    foreach my $l (@$locals) {
       my $key  = $l->{key};
       my $name = $l->{name};
       my $path = $l->{path};
       next if (!$key);
       if (!$F{$key}) {
         $cnt++;
         print $G->expand('found_new',  "$path/$key") . "\n";
         $new_dev++;
         $devs->[$new_dev]{_name}    = "device" . $new_dev;
         $devs->[$new_dev]{type}     = $l->{type};
         $devs->[$new_dev]{class}    = "storage." . $l->{type};
         $devs->[$new_dev]{name}     = $l->{type} . "-" . substr($key,-6);
         $devs->[$new_dev]{ipno}     = $l->{ip};
         $devs->[$new_dev]{ip}       = $l->{ip};
  
         $devs->[$new_dev]{path}     = $path;
         $devs->[$new_dev]{wwn}      = $l->{wwn};
         $devs->[$new_dev]{wwn2}     = $l->{wwn2} if ($l->{wwn2});
         $devs->[$new_dev]{wwn3}     = $l->{wwn2} if ($l->{wwn3});
         $devs->[$new_dev]{wwn4}     = $l->{wwn2} if ($l->{wwn4});
         $devs->[$new_dev]{key}      = $key;
         $devs->[$new_dev]{active}   = 'Y';
         $devs->[$new_dev]{host}     = "";
       } else {
         print "   $G->{already_exist} $path/$key \n";
       }
    }
  }
 my($data, $d2, $file, $h, $url, $hbano);
  my($TO) = 20;
  print "3 - " . $G->expand('find_slave', $desc2) . "\n";
  my($new_dev) = $#$devs;

  foreach $h (@$hosts) {
    next if($h->{dh} eq "Y");

    if (!$SELECT || $SELECT eq $h->{hostname}) {
      print "  - " . $G->expand('querying_host', "$h->{hostname} / $h->{ip}") .
"\n";

      my $data = Agent::3310->discover($h->{ipno});
      foreach my $d2 (@$data) {
        my $key  = $d2->{key};
        my $name = $d2->{name};
        my $path = $d2->{path};
        next if (!$key);
        if (!$F{$key}) {
          $F{$key} =1;
          $cnt++;
          print "    ". $G->expand('found_new', "$path/ $key") . "\n";
          $new_dev++;
          $devs->[$new_dev]{_name}    = "device" . $new_dev;
          $devs->[$new_dev]{type}     = $d2->{type};
          $devs->[$new_dev]{class}    = "storage." . $d2->{type};
          $devs->[$new_dev]{name}     = $name;
          $devs->[$new_dev]{wwn}      = $key;
          $devs->[$new_dev]{key}      = $key;
          $devs->[$new_dev]{path}     = $path;
          $devs->[$new_dev]{active}   = 'Y';
          $devs->[$new_dev]{host}     = $h->{hostname};
        }
      }
    }
  }
  print $G->expand('fount_cnt_dev', $cnt,  $desc2) . "\n";
  if ($cnt) {
     PDM::ConfigFile->write( $renv, $devs, $hosts,$notifs);
  }
}


1;

