package Html::SqlForm;

use Sql;
use Html::List;
use System;
use strict;

# EXAMPLE:
# sub INFO {
#   return {
#     name        => "SLO",
#     header2     => "admin.slo",
#     table       => "SLO",
#     function    => "UC::SLO",
#     add_function => "ldap_find", # special add function
#     list_sql    => "select join ..."
# 
#     sort        => "name",
#     update_id   => "slo_id",
#     update_url  => "name",
# 
#     page_size   => 20,
# 
#     form      => [
#     #  type  name           desc       size/select   mand, list
#       [ t => "name",        "Slo",        20,         1,   1    ],
#       [ t => "description", "Description",50,         1,   1    ],
#       [ t => "class",       "Class",      10,         1,   1    ],
#       [ n => "multiplier",  "Multiplier", 10,         1,   1    ],
#       [ l => "Labvel"]
#       [ s => "search"]
#     ]
#     };
# }


sub LIST {
 my($class, $q) = @_;
 
  print Html->body();
  my $lda = Sql->connect();
  my $info = $class->INFO();

  if ($q->{ACTION_del}) {
    my($in);
    foreach my $e (keys %$q) {
       if (substr($e,0,4) eq "del_") {
          $in .= substr($e,4) . ",";
       }
    }
    chop($in) if ($in);
    if ($in) {
      my $sql = "delete from $info->{table} where $info->{update_id} in ($in)";
      $lda->query($sql);
      if ($lda->is_error()) {
        print Html->error($lda->get_error_message());
      } else {
        print Html->info("Record(s) deleted!");
      }
    }

  } elsif ($q->{ACTION_add}) {
     if ($info->{add_function}) {
       my $f = $info->{add_function};
       $class->$f($q);
     } else {
       $class->ADD($q);
     }
     return;
  }
  print Html->header2($info->{header2});
  my $list;
  my $f = $class->FORM();
  my ($upd_id,$upd_url, @L0);
  my (@S1, @S2, @S3);
  my $ix = 0;

  foreach my $el (@$f) {
     if ($el->[5] || ($el->[1] eq $info->{update_id})) {
       $upd_id  = $ix if ($el->[1] eq $info->{update_id});
       $upd_url = $ix if ($el->[1] eq $info->{update_url});
       $list .= "$el->[1],";
       if ($el->[5]) {
         push(@L0, $ix);
         push(@S1, $el->[2]);
         my $just = $el->[0] eq 'n' ? 'r' : 'l';
         push(@S2, $just);
         push(@S3, '+');
       }
       $ix++;
     }
  }
  if (index(",$list,", ",$info->{update_id},") < 0) {
    $list .= "$info->{update_id},";
    $upd_id = $ix;
  }
  chop($list) if ($list);

  my $sql;
  if ($info->{list_sql}) {
    $sql = $info->{list_sql};
  } else {
    $sql = "select $list from $info->{table}";
    $sql .= " order by $info->{sort}" if ($info->{sort});
  }

  $lda->query($sql);
  if ($lda->is_error()) {
     print Html->error($lda->get_error_message());
     return;
  }

  my $csr = $lda->cursor();

  my (@TABLE);
  while (my $r = $csr->each()) {
     my(@row);
     foreach my $x (@L0){
        if ($x == $upd_url) {
          my $url = "<a href=\"/rashttp?GO=$info->{function}->UPDATE&$info->{update_id}=$r->[$upd_id]\">$r->[$x]</a>";
          push(@row, $url);
        } else {
          push(@row, $r->[$x]);
        }
     }
     push(@row, "<input type=checkbox name=del_" . $r->[$upd_id] . ">");
     push(@TABLE, \@row);
  }
  push(@S1,"Delete");
  push(@S2,"c");
  push(@S3,"");
  $q->{GO} = $info->{function} . "->LIST";
  my($pageInfo, $list) = Html::List->makeList($q,
                        \@TABLE, \@S1, \@S2, \@S3 ,
                       {pageSize => $info->{page_size} || 40, interactive => 1});

   my $lb = "Add " . $info->{name};
   print "
   <form><input type=hidden name=GO value=\"$info->{function}->LIST\">
  <table border=1 cellspacing=0 cellpadding=0 width=90% bgcolor=white>
    $list
  </table>
  <table border=0><tr><td></table>
  <table border=0 width=90%>
     <tr><td>$pageInfo</td> 
         <td><center><b>
          <input type=submit name=ACTION_add value=\"$lb\">
         <td align=right><b>
           <input type=submit name=ACTION_del value=\"Delete Selected\">
  </table>
  </form>
  ";

}



sub ADD {
 my($class, $q) = @_;

  print Html->body();
  my $info = $class->INFO();
  my $lda = Sql->connect();
  my $list;

  if ($q->{ACTION_LIST}) {
    $class->LIST($q);
    return;
  } elsif ($q->{ACTION_NEW}) {
    my $f = $class->FORM();
    my($vals, $list, $mand);
    foreach my $el (@$f) {
      $list .= "$el->[1]," if ($el->[0] ne "l");
      my $v = $q->{$el->[1]};
      if ($el->[4] && !$v) {
         $mand .= "$el->[2], ";
      }
      $vals .= "'$q->{$el->[1]}',";
    }
    chop($list); chop($vals);
    if ($mand) { 
      print Html->error("Mandatory fields: $mand");
    } else {
      my $sql = "insert into $info->{table} ($list) values ($vals)";
      $lda->query($sql);
      if ($lda->is_error()) {
        print Html->error($lda->get_error_message());
      } else {
        print Html->info("$info->{name} added!");
        $class->LIST($q);
        return;
      }
    }
  }
  print Html->header2($info->{header2}, undef, "Add");
 
  $class->_form("ADD", $info, $q);
}



sub _form {
  my($class, $type, $info, $q) = @_;

  my $label = $type eq "ADD" ? "Add " : "Update ";
  $label .= $info->{name};
  my $f = $class->FORM();

  print "<form>
  <input type=hidden name=GO value=\"$info->{function}->$type\">
  <table border=1 cellspacing=0 width=90% bgcolor=white>
  <tr><td colspan=2 bgcolor=$Style::DARK><font color=white><b>$label</td>  
  ";
  foreach my $el (@$f) {
     my $type = $el->[0];
     my ( $v);
     if ($type eq "l") {
       print "<tr><td bgcolor=$Style::LIGHT colspan=2>&nbsp;$el->[1]</td>";
       next;

     } elsif ($type eq "s") { # SELECT
       my $list;
       $list = "=[Select]|" if (!$el->[4]);
       $list .= $el->[3];
       $v = Html->makeSelect($el->[1],$list, $q->{$el->[1]});
     } else {
       my $s = $el->[3] || 30;
       my $val = $q->{$el->[1]};
       $v = "<input type=text size=$s name=$el->[1] value=\"$val\">";
     }
     my $mand = "<font color=red><b>*</b></font>" if ($el->[4]);
     my $info = $el->[6]{info};
     print "<tr><td bgcolor=$Style::LIGHT align=right width=40%>&nbsp;$el->[2]: </td>
           <td>$v&nbsp;$mand&nbsp;$info";
  }
  print "</table><b>
  <input type=hidden name=$info->{update_id} value=\"$q->{$info->{update_id}}\">
  <input type=submit name=ACTION_NEW value=\"Submit\">&nbsp;
  <input type=submit name=ACTION_LIST value=\"Back to List\">
  </form>";

}


sub UPDATE {
  my($class, $q) = @_;

  print Html->body();
  my $info = $class->INFO();
  my $lda = Sql->connect();
  my $list;
  my $f = $class->FORM();

  if ($q->{ACTION_LIST}) {
    $class->LIST($q);
    return;
  } elsif ($q->{ACTION_NEW}) {
    my($vals, $list, $mand);
    foreach my $el (@$f) {
      next if ($el->[0] eq "l");
      my $v = $q->{$el->[1]};
      if ($el->[4] && !$v) {
         $mand .= "$el->[2], ";
      }
      $list .= "$el->[1] = '$v',";
    }
    chop($list); 
    if ($mand) { 
      print Html->error("Mandatory fields: $mand");
    } else {
      my $sql = "update $info->{table} set $list where $info->{update_id} = $q->{$info->{update_id}}";
      $lda->query($sql);
      if ($lda->is_error()) {
        print Html->error($lda->get_error_message());
      } else {
        print Html->info("$info->{name} updated!");
        $class->LIST($q);
        return;
      }
    }
  }
  print Html->header2($info->{header2}, undef, "Update");
  
  
  my $list = "$info->{update_id},";
  foreach my $el (@$f) {
    if ($el->[0] ne "l") {
       $list .= "$el->[1],";
    }
  }
  chop($list);
  my $sql = "select $list from $info->{table} where $info->{update_id} = $q->{$info->{update_id}}";
  $lda->query($sql);

  if ($lda->is_error()) {
       print Html->error($lda->get_error_message());
       return;
  }
  my $csr = $lda->cursor();
  my $r   = $csr->each($list);

  $class->_form("UPDATE", $info, $r);



}

1;
