package Health::SVE2;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: SVE2.pm,v 1.7 2003/02/11 23:27:52 ccadieux Exp $


use base 'Health';
use NWS::SVE2;
use Ilist;
use Message;
use Report;
use Catalog;
use Events;
use strict;
use Debug;

sub revision {'$Revision: 1.7 $'}

sub new {
  my($hm, $pdm) = @_;

  my($self) = {pdm => $pdm};
  bless ($self, 'Health::SVE2');

# Specify each callback
#                            HM  Callback,  Filters
  $pdm->reportRequest($self, 'all_logic' , {category => Report::CAT_SVE2});
  return $self;
}

#####################################################

sub all_logic {
  my($hm, $report) = @_;
  my($pdm) = $hm->{pdm};
  my($ev, $ed, $pertains, $x ,$y, $contain, $sd);
  my($orep, $key);
  my $rep      = $report->content;
  my $oreport  = PDM->getOldReport($report->fileKey);
  my $ip       = $report->id('ip');
  my $name     = $report->name;
  my $wwn      = $report->id('deviceName');
  my $id       = $report->id('display');

  my $mgmtLevel = $report->value('id.mgmtLevel') || 'D';
  if (!$wwn) {
     Debug->err(ERROR => "This SVE2 \"$name\" ($ip) cannot be identified");
     return;
  }

  CIM->version("1.1");
  $DB::single = 1;

  return if ($hm->connectionEvent($wwn, $report, {method => 2} ));
  my $freq  = System->get_renv()->{audit_freq} || 7;
  my $audit = System->get_audit() ? "YES" : Timer->isXdays("Audit$wwn", $freq);

  if (!$oreport || $audit eq "YES" ) {  

     my($etype) = $audit eq "YES" ? "sve2.AuditEvent" : "sve2.DiscoveryEvent";
     my($title) = $audit eq "YES" ? "Auditing a":"Discovered a new";
     my($dt)    = "A" if (!$audit);
     Grid->setCode($etype);
     $ev = CIM::Instance->new('NWS_Event', [
                  [ EventType   => $etype ],
                  [ EventId     => $pdm->getEventSequence  ],
                  [ Target      => "sve2:$wwn" ],
                  [ TargetName  => $id],
                  [ SourceIP    => $ip  ],
                  [ MgmtLevel   => $mgmtLevel],
                  [ Description => "$title SVE2 called $id"],
                         ]);

     $sd = Events->sourceDetector({ event => $ev , host => 1, rep => $rep});
      
     my($p) = NWS::SVE2->newSystem($rep);

     $pertains = CIM::Instance->new('NWS_EventPertainsToSystem', [
                  [ Event       => $ev  ],
                  [ Element     => $p->[0] ],
                  [ DiscoveryType => $dt],
                    ]);

     my($monitors) = CIM::Instance->new('NWS_AgentMonitors', [
                  [ Agent       => $sd->[0]  ],
                  [ Element     => $p->[0] ],
                    ]);

     $ed = Message->new( { id        => $report->id,
                            instances => [$ev, @$sd,  @$p, $monitors, $pertains ],
                            severity  => Message::SEVERITY_NORMAL });

     $pdm->saveMessage($ed);
  }

  $orep = ($oreport)? $oreport->content() : $rep;

  foreach my $el ('A', 'B') {
      Grid->setCode("sve2.AlarmEvent.power");
      $hm->alarm($report, $orep, "SVE2", "power.$el", "state", $id, $id, $wwn, "powerState");
  }

  $hm->locationChangeEvent($report, $rep, $orep, $wwn);

  my($physicalFrame) = CIM::Key->new( ['CIM_PhysicalFrame',   # key of the frame
                        Tag               => $rep->get("id.wwn") ,
                        CreationClassName => 'CIM_PhysicalFrame' ]);

  my $PORTS = $rep->get('info.port_cnt');
  my($comp);

  for ($x=0; $x < $PORTS; $x++) {
     $comp = "port.$x";
     Grid->setCode("sve2.StateChangeEvent.port");
     $hm->stateEvent($comp, $report, $rep, $orep, 'CIM_Card', $comp, $wwn);
  }

# CHASSIS

  foreach my $el (keys %$rep) {
     if ($el =~ /chassis\.(.*)\.state/) {
        my $comp = $1;
        Grid->setCode("sve2.AlarmEvent.chassis");
        $hm->alarm($report, $orep, "SVE2", "chassis.$comp", "state", $id, $id, $wwn, "chassisStatus",
                     {info => $rep->{"chassis.$comp.Name"}}  );
     }
  }
}

sub status {
   my($hm, $rep, $orep, $comp) = @_;
   my($pdm) = $hm->{pdm};
   my($map) = $pdm->getDeviceStateMap("sve2.availability");

   my($status, $ostatus, $old, $new, $sev, $act);

   $ostatus = $orep->getState("$comp.PortState");
   $status  = $rep->getState("$comp.PortState");
   ($old, $new, $sev, $act) = $map->transition("portState.$ostatus", "portState.$status", $orep, $rep);
   return ($ostatus, $status, $old, $new, $sev, $act );

}






1;

