package Health::GUI;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: GUI.pm,v 1.21 2003/05/14 17:27:30 ccadieux Exp $

 
#             CREATION
####################################################
 
use Health;
use PDM;
use Carp;
use Data::Dumper;
use Catalog;
use Report;
use strict;
use CIM::Instance;
use Message;
use CIM::Key;
use Events;
use Debug;
  
use base 'Health';
 
sub revision {'$Revision: 1.21 $'}
sub new {
  my($hm, $pdm) = @_;

  my($self) = {pdm => $pdm};
  bless ($self, 'Health::GUI');

# Specify each callback
#                            HM  Callback,  Filters
  $pdm->reportRequest($self, 'all_logic' , {INITIAL => 1});
  return $self;
}                     

#####################################################


sub all_logic {
  my($hm ) = @_;
  my($pdm) = $hm->{pdm};
  my($ev,  $x, $h);
  my($l, $s, $rc, $url, $ed, $VAR1);
  my($sd, $pertains, $type, $name, $key);
  CIM->version("1.1");
  $DB::single = 1;


 my $Config = PDM::ConfigFile->read();
 my $renv = $Config->renv();
 my $ip   = Util->name2ip();
 
 my($rep) = {};
 Agent::addIdentification({renv => $renv}, $rep);
 $rep = ReportContent->new($rep);

 #  find out about removed hosts and removed devices frm the GUI

 my($f) = System->get_home() . "/DATA/gui_events";
 if (-f $f) {
    rename $f, "$f.wrk";
    open(O, "$f.wrk");
    while ($l = <O>) {
      chop($l);    
      my(@a) = split(/\t/, $l);
      if (substr($a[0],0,2) eq "AM") {  # Alternate master took over
          my $desc = ($a[0] eq "AM+") ? 
                  "Master on $a[2] is down, Alternate-master on $a[1] taking over" :
                  "Master on $a[2] is back, Alternate-master $a[1] releasing";
          Grid->setCode("agent.AlternateMaster");
          $ev = CIM::Instance->new('NWS_Event', [
                  [ EventType   => 'agent.AlternateMaster'  ],
                  [ EventId     => $pdm->getEventSequence  ],
                  [ Severity    => Message::SEVERITY_WARNING ],
                  [ Caption     => "host"],
                  [ Target      => "host:$renv->{hostname}"],
                  [ Description => $desc ],
                   ]);
          $sd = Events->sourceDetector({ event => $ev , host => 1, rep => $rep});
          $pertains = CIM::Instance->new('NWS_EventPertainsToSoftwareElement', [
                  [ Event         => $ev      ],
                  [ Element       => $sd->[0] ],
                  [ DiscoveryType => "D"      ],
                    ]);
          $ed = Message->new( { id        => { deviceName => $renv->{hostname} },
                            instances => [$ev, @$sd, $pertains ],
                            severity  => Message::SEVERITY_ERROR});
          $pdm->saveMessage($ed);

      } elsif ($a[0] eq "HR") {  # Host rename Event
          my $desc = "This host was renamed from $a[2] to $a[3]";

      } elsif ($a[0] eq "DH") {  # AgentDeinstall
          Grid->setCode("agent.AgentDeinstallEvent");
          $ev = CIM::Instance->new('NWS_Event', [
                  [ EventType   => 'agent.AgentDeinstallEvent'  ],
                  [ EventId     => $pdm->getEventSequence  ],
                  [ Caption     => "host"],
                  [ Target      => "host:$renv->{hostname}"],
                  [ Description => "Agent '$a[1]' was deleted from the configuration of $renv->{hostname}/$ip"],
                   ]);
          $sd = Events->sourceDetector({ event => $ev , host => 1, rep => $rep});
          $pertains = CIM::Instance->new('NWS_EventPertainsToSoftwareElement', [
                  [ Event         => $ev      ],
                  [ Element       => $sd->[0] ],
                  [ DiscoveryType => "D"      ],
                    ]);
          $ed = Message->new( { id        => { deviceName => $renv->{hostname} },
                            instances => [$ev, @$sd, $pertains ],
                            severity  => Message::SEVERITY_WARNING});
          $pdm->saveMessage($ed);

      } elsif ($a[0] eq "PRO") {  # Provider was activated
          Grid->setCode("agent.ProviderEvent");
          my $act = $a[2] eq "Y" ? "turned on" : "turned off";
          $ev = CIM::Instance->new('NWS_Event', [
                  [ EventType   => 'agent.ProviderEvent'  ],
                  [ EventId     => $pdm->getEventSequence  ],
                  [ Severity    => Message::SEVERITY_WARNING ],
                  [ Actionable  => 0     ],
                  [ Caption     => "host"],
                  [ Target      => "host:$renv->{hostname}"],
                  [ Description => "Provider '$a[1]' was $act at the request of '$a[3]'"],
                   ]);
          $sd = Events->sourceDetector({ event => $ev , host => 1, rep => $rep});
          $pertains = CIM::Instance->new('NWS_EventPertainsToSoftwareElement', [
                  [ Event         => $ev      ],
                  [ Element       => $sd->[0] ],
                  [ DiscoveryType => "A"      ],
                    ]);
          $ed = Message->new( { id        => { deviceName => $renv->{hostname} },
                            instances => [$ev, @$sd, $pertains ],
                            severity  => Message::SEVERITY_NORMAL });
          $pdm->saveMessage($ed);


      } elsif ($a[0] eq "CFG") {  # Solution Comfigure Device
          Grid->setCode("agent.ConfigureEvent");
          $ev = CIM::Instance->new('NWS_Event', [
                  [ EventType   => 'agent.ConfigureEvent'  ],
                  [ EventId     => $pdm->getEventSequence  ],
                  [ Severity    => Message::SEVERITY_WARNING ],
                  [ Actionable  => 0     ],
                  [ Caption     => "host"],
                  [ Target      => "host:$renv->{hostname}"],
                  [ Description => "$a[1] $a[2] at $renv->{hostname}"],
                   ]);
          $sd = Events->sourceDetector({ event => $ev , host => 1, rep => $rep});
          $pertains = CIM::Instance->new('NWS_EventPertainsToSoftwareElement', [
                  [ Event         => $ev      ],
                  [ Element       => $sd->[0] ],
                  [ DiscoveryType => "A"      ],
                    ]);
          $ed = Message->new( { id        => { deviceName => $renv->{hostname} },
                            instances => [$ev, @$sd, $pertains ],
                            severity  => Message::SEVERITY_NORMAL });
          $pdm->saveMessage($ed);

      } elsif ($a[0] eq "AH") {  # AgentInstall
          Grid->setCode("agent.AgentInstallEvent");
          $ev = CIM::Instance->new('NWS_Event', [
                  [ EventType   => 'agent.AgentInstallEvent'  ],
                  [ EventId     => $pdm->getEventSequence  ],
                  [ Caption     => "host"],
                  [ Target      => "host:$renv->{hostname}"],
                  [ Description => "Agent '$a[2]' was added to the configuration of $renv->{hostname}/$ip"],
                   ]);
          $sd = Events->sourceDetector({ event => $ev , host => 1, rep => $rep});
          $pertains = CIM::Instance->new('NWS_EventPertainsToSoftwareElement', [
                  [ Event         => $ev      ],
                  [ Element       => $sd->[0] ],
                  [ DiscoveryType => "A"      ],
                    ]);
          $ed = Message->new( { id        => { deviceName => $renv->{hostname} },
                            instances => [$ev, @$sd, $pertains ],
                            severity  => Message::SEVERITY_NORMAL });
          $pdm->saveMessage($ed);

      } elsif (substr($a[0],0,1) eq "Q") {
          $type = $a[1]; 
          my $wwn = $a[2];
          my $dev = $Config->deviceByKey($wwn);
          if ($wwn) {
               my($code);
               if (substr($a[0],1,1) eq "S") {
                  $code = "Start";
                  Grid->setCode(lc($type) . ".QuiesceStartEvent");
               } else {
                  $code = "End";
                  Grid->setCode(lc($type) . ".QuiesceEndEvent");
               }
              
               $ev = CIM::Instance->new('NWS_Event', [
                    [ EventType   => lc($type) . ".Quiesce${code}Event"  ],
                    [ EventId     => $pdm->getEventSequence  ],
                    [ Target      => "host:$renv->{hostname}"],
                    [ Description => "Quiesce $code on device " . uc($type) . " $wwn / $dev->{name}"],
                     ]);
               $sd = Events->sourceDetector({ event => $ev });
  
               $key = CIM::Key->new( ['NWS_System',
                     'Name'       => $wwn,
                      CreationClassName => 'NWS_System']);
  
               $pertains = CIM::Instance->new('NWS_EventPertainsToSystem', [
                    [ Event       => $ev  ],
                    [ Element     => $key ],
                      ]);
  
               $ed = Message->new( { id        => { deviceName => $renv->{hostname} },
                              instances => [$ev, @$sd, $pertains ],
                              severity  => Message::SEVERITY_NORMAL });

               $pdm->saveMessage($ed);
           }

      } elsif ($a[0] eq "DD") {
          my($name) = $a[2];
          $type = $a[1]; 
          my $wwn    = Catalog->deviceRead("",Catalog::Name, $name, Catalog::Key);
          if ($wwn) {
               Grid->setCode(lc($type) . ".RemovalEvent");
               $ev = CIM::Instance->new('NWS_Event', [
                    [ EventType   => lc($type) . ".RemovalEvent"  ],
                    [ EventId     => $pdm->getEventSequence  ],
                    [ Target      => "host:$renv->{hostname}"],
                    [ Description => "Monitoring of " . uc($type) . " device ($wwn-$name) ended"],
                     ]);
               $sd = Events->sourceDetector({ event => $ev , host => 1, rep => $rep});
  
               $key = CIM::Key->new( ['NWS_System',
                     'Name'       => $wwn,
                      CreationClassName => 'NWS_System']);
  
               my($monitors) = CIM::Instance->new('NWS_AgentMonitors', [
                  [ Agent       => $sd->[0]  ],
                  [ Element     => $key ],
                    ]);
 
               $pertains = CIM::Instance->new('NWS_EventPertainsToMonitor', [
                    [ Event       => $ev  ],
                    [ Association => $monitors ],
                    [ DiscoveryType => "D"],
                      ]) ;
  
               $ed = Message->new( { id        => {deviceName => $renv->{hostname} },
                              instances => [$ev, @$sd, $monitors, $pertains ],
                              severity  => Message::SEVERITY_WARNING});
  
               
#               $pdm->deleteLastReport(Report->makeFileKey('t300',$wwn) );  not needed
               $pdm->saveMessage($ed);
          }
      }
    }
    close(O);
    unlink "$f.wrk";
 }

#
# grab test events
#
 my($f) = System->get_home() . "/DATA/testInfo.log";
 if (-f $f) {
    rename $f, "$f.wrk";
    open(O, "$f.wrk");
    while ($l = <O>) {
      chop($l);    
      eval "$l";
      my $ifile = $VAR1;
      my $desc;
      my $i = $ifile->{info};
      my $type = $i->{dev_type};
      my $command = $ifile->{command};
      my $host = $ifile->{host};
      if ($i->{target2}) {
        $desc = "$command ($host) between $i->{target} and $i->{target2} ";
      } else {
        $desc = "$command ($host) on $i->{target} ";
      }
      my ($sev, $sign);
      if ($ifile->{rc} =~ /^[0,]+$/) {
         $sev  = 0;
         $sign = "P";
         $desc .= "succeeded";
      } else {
         $sev  = 2;
         $sign = "M";
         $desc .= "failed";
      }
      $desc .= ":";

      my $data .= " #OPTIONS -------------------\n";
      my $clean_opt = $ifile->{opts};
      $clean_opt =~ s/passwd=[^\s\=\|]+//;
      $data    .= $clean_opt;
      $data    .= "\n";
      my $ofile = $ifile->{pfile};
      $ofile    =~ s/\t/\n /g;
      $data    .= " $ofile";

      Grid->setCode("$type.DiagnosticTest");
      $ev = CIM::Instance->new('NWS_DiagnosticTestComplete', [
                  [ EventType   => "$type.DiagnosticTest"  ],
                  [ EventId     => $pdm->getEventSequence  ],
                  [ Severity    => Message::SEVERITY_WARNING ],
                  [ Caption     => "$sign.$command"],
                  [ FailureCode => $ifile->{rc}],
                  [ Target      => "$type:$i->{key}" ],
                  [ Actionable  => 0 ],
                  [ Severity    => $sev ],
                  [ StartDate   => $ifile->{start_date}],
                  [ EndDate     => $ifile->{end_date}],
                  [ Description => $desc ],
                  [ Data        => $data ],
                   ]);

      $sd = Events->sourceDetector({ event => $ev , host => 1, rep => $rep});
      $pertains = CIM::Instance->new('NWS_EventPertainsToSoftwareElement', [
                  [ Event         => $ev      ],
                  [ Element       => $sd->[0] ],
                  [ DiscoveryType => "D"      ],
                    ]);
      $ed = Message->new( { id        => {deviceName => $i->{key} },
                            instances => [$ev, @$sd, $pertains ],
                            severity  => Message::SEVERITY_ERROR});
      $pdm->saveMessage($ed);
      
    }
    close(O);
    unlink "$f.wrk";
 }


}

1;
