package GUIAdmin::9900;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>



use PDM;
use Util;
use Agent;
use Agent::9900;
use strict;
use Logic::9900;
use Debug;
use Carp;
use GUIAdmin;
use GUI::Devices;
use GUI::Discover;
use base 'GUIAdmin';

sub isDevice {1}
sub description {'Sun 9900'};

sub ipRequired {1}


sub updDevice {
  my($class, $q) = @_;
  my($ho, $o);
  my($name, $err, $ip, $ipno);
  my($renv, $devs, $host,$notifs, $x, $D, $type, $key, $h1, $h, $sel, $active);
  my $G = Labels->read();

  my $deny = Roles->verifyRole($q, "admin");
  my $desc2 = &description();

  print Html->body();
  require "GUI/Devices.pm";

  if ($q->{ACTION_back}) {
   my($hostname) = System->hostname();
   GUI::Devices::list($q);
   return;

  } elsif ($q->{ACTION_update}) {
    ($renv, $devs, $host,$notifs) =PDM::ConfigFile->read;
    $x = $q->{no};
    $D = $devs->[$x];

    $devs->[$x]{host} = $q->{host};
    $devs->[$x]{name} = $q->{name};
    $devs->[$x]{path}  =  $q->{path};

    GUIAdmin->clearSlave($q->{host}, $host);

    PDM::ConfigFile->write( $renv, $devs, $host,$notifs);
    $err = Html->info($G->expand('device_updated', $name));

  } elsif ($q->{ACTION_delete}) {
    ($renv, $devs, $host,$notifs) =PDM::ConfigFile->read;
    $x = $q->{no};
    $type = $devs->[$x]{type};
    $key =  $devs->[$x]{ip};
    GUIAdmin->clearSlave($q->{host}, $host);

    Events->saveEvent("DD", $type,  $key) if ($key);
    $devs->[$x]{_name} = "";
    $name = $devs->[$x]{name} . "/ " . $devs->[$x]{ip};
    PDM::ConfigFile->write( $renv, $devs, $host,$notifs);
    &main::log_change($G->expand('device_deleted',$name));

    $q->{ERR} = Html->error($G->expand('device_deleted',$name));
    GUI::Devices::list($q);
    return;
  }
out:
 $h1 = Html->header2("admin.gen_maint.maint_device", undef, $desc2," ");

  ($renv, $devs, $host,$notifs) = PDM::ConfigFile->read;
  $h = $devs->[$q->{no}];

  $sel = ($h->{host})? "":"selected";

  $ho = "<select name=host><option value=\"\" $sel>$G->{local}</option>";
  foreach $h1 (@$host) {
       $sel = ($h1->{hostname} eq $h->{host}) ? "selected":"";
       $ho .= "<option name=$h1->{hostname} $sel>$h1->{hostname}</option>";
  }
  $ho .= "</select>";

  $active = ($h->{active} eq "Y") ? "On":"Off";
  my $ty = $h->{userLabel} || $h->{type};
  $o =<<EOF;
<form  method=get>
 <input type=hidden name=GO value="GUIAdmin::9900->updDevice">
 <input type=hidden name=no value=$q->{no}>
<center>
$h1
$err
<table border=1 cellspacing=0 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr>
<td colspan=2 bgcolor=$Style::DARK><b><font color=white>&nbsp;$G->{enter_device_info}</td>

<tr><td bgcolor=$Style::LIGHT align=right>$G->{device_type}:</td>
    <td>
      <table border=0 cellspacing=0 width=100%> <tr>
        <td><b>&nbsp;$ty</td>
        <td bgcolor=$Style::LIGHT align=right>$G->{monitoring}:</td>
        <td ><b>&nbsp;$active</td>
      </table>

<tr><td bgcolor=$Style::LIGHT width=30% align=right>$G->{device_name}:</td>
    <td><input type=text name=name size=20 maxlength=40 value="$h->{name}">

<tr><td bgcolor=$Style::LIGHT align=right>WWN :</td>
    <td><b>$h->{wwn}</td>

<tr><td bgcolor=$Style::LIGHT align=right>IP :</td>
    <td><b>$h->{ipno}</td>

<tr><td bgcolor=$Style::LIGHT align=right>$G->{primary_host}:</td>
   <td><b>$ho</td>

</table>
</table>
<b>
EOF

  if (!$deny) {
     $o .= "<input type=submit name=ACTION_update value=\"$G->{submit_update}\">&nbsp;
           <input type=submit name=ACTION_delete value=\"$G->{submit_delete}\">&nbsp;";
  }
  $o .= " <input type=submit name=ACTION_back value=\"$G->{submit_back}\"></form>";
  print $o;
}



sub addDevice {
  my($class, $q) = @_;
  my($ho, $o, $err, $ipno, $x, $info);
  my($renv, $dev, $host,$notifs, $sel, $warn);

  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read("GUIAdmin::default")->section("add");
  my $desc2 = &description();

  require "GUI/Devices.pm";
  print Html->body();
  if ($q->{ACTION_back}) {
    GUI::Devices::add($q);
    return;

  } elsif ($q->{ACTION_add}) {
    my($active) = "Y";
    my($err, $dev) = Logic::9900->addToConfig($q);
    if ($err) {
       $info = $err->toHtml();
    } elsif ($dev) {
       print Html->info($G->{device_added});
       GUI::Devices::list($q);
       return;
    }
  }

  print GUI::Devices::add0($q);

  my $h = Html->header2("admin.gen_maint.add_device", undef, $desc2," ", {nocrumb => 1});

  ($renv, $dev, $host,$notifs) =PDM::ConfigFile->read;
  $sel = ($q->{host} eq "")? "selected":"";


  my($phost) = "<select name=host><option value=\"\">[Select]</option>".
              "<option value=\"\" $sel>Local</option>";

  foreach $x (@$host) {
    next if($x->{dh} eq "Y");
    $sel = ($q->{host} eq $x->{hostname})? "selected":"";
    $phost .= "<option value=" . $x->{hostname} . " $sel>" . $x->{hostname} ."</option>";
  }
  $phost .= "</select>";

  my($phostD) = "<select name=datahost>".  "<option value=\"\" $sel>Same Host</option>";
  my $l1 = {hostname => System->hostname(), ip => System->hostname()};
  foreach $x (@$host, $l1) {
    next if($x->{dh} eq "Y");

    $sel = ($q->{datahost} eq $x->{ip})? "selected":"";
    $phostD .= "<option value=\"" . $x->{ip} . "\" $sel>" . $x->{hostname} ."</option>";
  }
  $phostD .= "<option value=\"*None\">*None</option></select>";

  $o =<<EOF;
<form  method=get>
 <input type=hidden name=GO value="GUIAdmin::9900->addDevice">
 <input type=hidden name=ADD value=9900>
<center>
$h
$info
<table border=1 cellspacing=0 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr><td colspan=2 bgcolor=$Style::DARK><b><font color=white>&nbsp;$L->{enter}</td>

<tr><td bgcolor=$Style::LIGHT width=30% align=right>$L->{dev_name}:</td>
    <td><input type=text name=name size=15 maxlength=35 value="$q->{name}">

<tr><td bgcolor=$Style::LIGHT align=right>$L->{primary}:</td>
    <td>$phost</td>
<tr><td bgcolor=$Style::LIGHT width=30% nowrap align=right>$L->{ip}:</td>
    <td><input type=text name=ip size=40 maxlength=40 value="$q->{ip}">

</table>
</table>
<b>
EOF

  print $o;
  if (!$deny) {
     print "<input type=submit name=ACTION_add value=$L->{submit_add}>";
  }
  print "<input type=submit name=ACTION_back value=$L->{submit_back}></form>";


}

1;
