package GUI::Stats;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>


use System;
use Util;
use Timelapse;
use strict;
use MaxEvents;

sub email {
  my($q) = @_;
  my $L = Labels->read("GUI::Stats");
  print Html->body();
  print Html->header2("report.system.email_stats", "90%");
  if ($q->{ACTION_email}) {
     unlink System->get_home() . "/DATA/Max_email";
  } elsif ($q->{ACTION_events}) {
     unlink System->get_home() . "/DATA/Max_events";
  }

  my $renv = System->get_renv();
  my $Config = PDM::ConfigFile->read();
  print "<form><input type=hidden name=GO value=GUI::Stats::email>";

  print &email2($Config, "events", "Events", 8);
  print "&nbsp;";

  print &email2($Config, "email",  "Email", $renv->{max_daily_email});

  print "</form>";
}

sub email2 {
  my($Config, $id, $title, $max_daily) = @_;

  my $L = Labels->read("GUI::Stats");
  my $G = Labels->read();

  my $out = "<table border=1 cellspacing=0 bgcolor=white width=90%>
   <tr bgcolor=$Style::DARK><td colspan=6><b><font color=white>&nbsp;$title $L->{max} ($G->{max}=$max_daily)
   <tr bgcolor=$Style::LIGHT>
      <th>$L->{dev}
      <th>$L->{user}
      <th>$L->{name}
      <th>$L->{comp}
      <th>$L->{last} $title
      <th>${title}(s) $L->{not}
   ";
  my $MAX = MaxEvents->new($id);
  my $max = $MAX->{MAX};
  my $cnt;
  foreach my $el (sort keys %$max) {
     my($user, $type, $key, $topic,$act) = split(/\:/, $el);
     my $e = $max->{$el};
     my $dev = $Config->deviceByKey($key);
     my $name = $dev ? $dev->{name} : $key;

     my $lastdate = $e->[2];
     my $tot      = $e->[0] - $max_daily;
     next if (!$lastdate);
     $out .= "<tr><td>&nbsp;$key</td><td>&nbsp;" . ($user||"All") . "</td>".
             "<td>&nbsp;$type:$name</td><td>&nbsp;$topic</td>
              <td><center>$lastdate&nbsp;</td><td><center>$tot</td>";
     $cnt++;
  }
  if (!$cnt) {
    $out .= "<tr><td colspan=6>$L->{no_dev}</td></table>";
  } else {
    my $l1 = $L->expand(clear => $title);
    $out .=<<EOF;
       </table>
       <table border=0 width=90%><tr><td align=right>
       <b><input type=submit name=ACTION_$id value=\"$l1\">
       </table>
EOF
  }
  return $out;
}


sub agent {
  my($q) = @_;
  my($v, %M, $tt, $mins, %X, $secs, $out, $x, %TOT);

  my $L = Labels->read("GUI::Stats");
  print "\n<body bgcolor=$Style::BGCOLOR>";
  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();

  if ($q->{ACTION} eq "clear") {
     Timelapse->clear();
     foreach my $h (@$hosts) {
       Timelapse->clear($h->{ipno});
     }
  }

  my $a = Timelapse->readAll();

  foreach $x (keys %$a) {
     $v = $a->{$x}{avg};
     my $x0 = $x; $x0 =~ s/\w+\:\://;
     next if (!$v->[3]);
     $M{$renv->{hostname}}{$x0}{min} =  $v->[2];
     $M{$renv->{hostname}}{$x0}{max} =  $v->[3];
     $M{$renv->{hostname}}{$x0}{cnt} =  $v->[0];
     $M{$renv->{hostname}}{$x0}{avg} =  $v->[1] / $v->[0];

     $TOT{$x0}{cnt} += $v->[0];
     $TOT{$x0}{tot} += $v->[1];
     $TOT{$x0}{min}  = $v->[2] if ($TOT{$x0}{min} > $v->[2]);
     $TOT{$x0}{max}  = $v->[3] if ($TOT{$x0}{max} < $v->[3]);
  }


  foreach my $h (@$hosts) {
     print "Calling $h->{hostname}..<br>\n";
     $a = Timelapse->readAll($h->{hostname});
     foreach $x (keys %$a) {
        $v = $a->{$x}{avg};
        my $x0 = $x; $x0 =~ s/\w+\:\://;
        next if (!$v->[3]);
        $M{$h->{hostname}}{$x0}{min} =  $v->[2];
        $M{$h->{hostname}}{$x0}{max} =  $v->[3];
        $M{$h->{hostname}}{$x0}{cnt} =  $v->[0];
        $M{$h->{hostname}}{$x0}{avg} = $v->[1] / $v->[0];

        $TOT{$x0}{cnt} += $v->[0];
        $TOT{$x0}{tot} += $v->[1];
        $TOT{$x0}{min}  = $v->[2] if ($TOT{$x0}{min} > $v->[2]);
        $TOT{$x0}{max}  = $v->[3] if ($TOT{$x0}{max} < $v->[3]);
     }
  }
  foreach my $e (keys %TOT) {
     my $v = $TOT{$e};
     $v->{avg} = $v->{tot} / $v->{cnt};
  }
  
  my $cnt =2;
  foreach $x (keys %X) { $cnt++}

  print "<center>";
  print Html->header2("report.system.agent_stats", "90%");

  $out = "<table border=1 cellspacing=0 cellpadding=1 width=90% bgcolor=white>
   <tr bgcolor=$Style::DARK>
     <td colspan=6><table border=0 cellspacing=0 width=100%>
      <tr><td><font color=white><b>$L->{title}</td>
          <td align=right><font color=white>[ <a href=$Http::WEBPROC?GO=GUI::Stats::agent&ACTION=clear><font color=white>$L->{clear1}</font></a> ]
      </table>
   <tr bgcolor=#F0F0F0><td><b>&nbsp;$L->{host}</td>
         <td><b>&nbsp;$L->{device}</td>
         <td><b><center>$L->{count}</td>
         <td><b>&nbsp;$L->{min}</td>
         <td><b>&nbsp;$L->{max}</td>
         <td><b>&nbsp;$L->{average}</td>";

  my(%AV,$last);

  foreach my $h (keys %M) {
     if ($h ne $last) {
        $out .= "<tr><td></td>";
        $out .= "<tr bgcolor=$Style::LIGHT><td colspan=6>&nbsp;<b>$h</td>";
        $last = $h;
     }
     $out .= &display($M{$h});
  }
  if ( (keys %TOT) ) {
     $out .= "<tr bgcolor=$Style::LIGHT><td colspan=6 ><b>&nbsp;All Hosts</td>";
     $out .= &display(\%TOT);
  } else {
     $out .= "<tr bgcolor=$Style::LIGHT><td colspan=6 ><b>$L->{none}</td>";
  }
  print "$out</table>&nbsp;<p>";
}

sub display {
  my($v) = @_;
  my($out);
  foreach my $m (sort keys %$v) {
     my $name = Util->abb(lc($m) . ".medium") || $m;
     $out .= "<tr><td></td><td>&nbsp;$name</td><td align=right>$v->{$m}{cnt}&nbsp;</td>";
     $out .= &cell($v->{$m}{min}) . &cell($v->{$m}{max}) . &cell($v->{$m}{avg});
  }
  return $out;
}
     

sub cell {
  my($v1) = @_;
  my $mins = int($v1/60);
  my $secs = $v1 % 60;
  return $secs ? "<td>&nbsp;" . sprintf("%2.2d:%2.2d", $mins,$secs) . "</td>" : "<td>&nbsp;</td>";
}

1;
