package GUI::State;
use Html;
use System;
use strict;
use State;



sub clear {
  my($q) = @_;

   my $G = Labels->read();
   my $L = Labels->read('GUI::State');
   my $ruser = System->get_ruser();
   my $Config = PDM::ConfigFile->read();
   my (%LINK, %ERR);
   print Html->body();
   print  Html->header2("monitor.utilities.errors");
   if ($q->{ACTION_del_sel}) {
       print $L->{clear_1} . "...<br>";
       foreach my $e (keys %$q) {
         if (substr($e,0,4) eq "del_") {
           my $v = substr($e, 4);
           State->clearAllLinks(undef, $v);
           State->clearComponent($v);
           State->write();
         }
       }
 
   } elsif ($q->{ACTION_del_links}) {
       print $L->{clear_2} . "...<br>";
       State->clearAllLinks();
       State->write();

   } elsif ($q->{ACTION_del_green}) {
       print $L->{clear_4} . "...<br>";
       State->clearAllComponents(0);
       State->clearAllLinks(0);
       State->write();

   } elsif ($q->{ACTION_del_yellow}) {
       print $L->{clear_5} . "...<br>";
       State->clearAllComponents(1);
       State->clearAllLinks(1);
       State->write();

   } elsif ($q->{ACTION_del_err}) {
       print $L->{clear_3} . "...<br>";
       State->clearAllComponents();
       State->clearAllLinks();
       State->write();
  
   }
   my @Map = ('al_ok3','al_alert3','al_crit3','al_down3');
   
   my $State = State->read();
   my $links = $State->links();
   my $comps = $State->components();
   foreach my $e (keys %$links) {
       my($v1, $v2) = split(/\|/, $e);
       my($t1,$k1, $p1) = split(/\:/, $v1);

       my $err = $links->{$e};
       my $er = {sev => $err->[0], desc => $err->[1], key => $e};
       push(@{$LINK{$k1}}, $er);
   }
   foreach my $e (keys %$comps) {
     my $v = $comps->{$e};
     my($type, $k, $comp) = split(/\:/, $e);
     my $dev = $Config->deviceByKey($k);
     my $sev = int($v->[0]+0.5);
     next if ($sev < 0);
     my $desc = $v->[1];
     my $target = $v->[2];
     my $name = $dev->{name} || $k;
     my $er = { name => $name, sev => $sev, comp => $comp, desc => $v->[1], type => $type, key => $e , dev => $dev , k => $k};
     push(@{$ERR{$name}}, $er);
   }
#use Data::Dumper;
#$Data::Dumper::Indent = 1;
#print "<pre></center>" . Dumper(\%ERR);
     

   my $out = "<table border=1 cellspacing=0 width=90% bgcolor=white>
   <form><input type=hidden name=GO value=GUI::State::clear>
   <tr><td colspan=6 bgcolor=$Style::DARK><font color=white><b>$L->{title}</td>
   <tr bgcolor=$Style::LIGHT>
       <th>$L->{delete}</th>
       <th>$L->{device}</th>
       <th>$L->{comp}</th>
       <th>$L->{sev}</th>
       <th>$L->{desc}</th>
   ";
   my $last;
   my $lastn;
   my $cnt;
   foreach my $e (sort keys %ERR) {
      my $errs = $ERR{$e};      
      foreach my $err (@$errs) {
        my $sev = "<img src=/gif/$Map[$err->{sev}].gif>";
        if ($last ne $err->{k}) {
           $out .= &show_links($last, \%LINK, \@Map,$Config);
           $last = $err->{k};
        }
        my $nn = "$err->{type}:$err->{name}";
        $nn =~ s/\./. /;
        my $del = "&nbsp;";
        if ($lastn ne $nn) {
            $lastn = $nn;
            $nn = "<b>$nn";
            my $d = $err->{type} . ":" . $err->{k};
            $del = "<input type=checkbox name=del_$d>";
            $out .= "<tr><td></td>";
        } 
        $cnt++;
        $out .= "<tr>
         <td><center>$del</td>
         <td>$nn</td>
         <td>$err->{comp}</td>
         <td><center>$sev</td>
         <td><small>$err->{desc}</td>
          ";
      }
   }
   $out .= "<tr><td colspan=5><b>$L->{no_error}" if (!$cnt);
   $out .= &show_links($last, \%LINK, \@Map, $Config);

   $out .= "</table>
      <table border=0 cellspacing=0 width=90%>
        <tr><td valign=top><b>
             <input type=submit name=ACTION_del_sel value=\"$L->{del_sel}\">
          </td>
          <td align=right><center><b>
              <input type=submit name=ACTION_del_green value=\"$L->{del_green}\">&nbsp;
              <input type=submit name=ACTION_del_yellow value=\"$L->{del_yellow}\">
              <input type=submit name=ACTION_del_links value=\"$L->{del_links}\"><br>
              <input type=submit name=ACTION_del_err value=\"$L->{del_errs}\">
          </td>
      </table>
      </form>
    ";
   print $out;
}

sub show_links {
  my($last, $LINK, $Map, $Config) = @_;
  my $out;
  if ($last && exists($LINK->{$last}) ) {
     my $links = $LINK->{$last};
     foreach my $link (@$links) {
        next if ($link->{sev} < 0);
        my $sev = "<img src=/gif/$Map->[$link->{sev}].gif>";
        my($v1, $v2) = split(/\|/, $link->{key});
        my($t1,$k1, $p1) = split(/\:/, $v1);
        my($t2,$k2, $p2) = split(/\:/, $v2);
        my $dev = $Config->deviceByKey($k2);
        my $name2 = $dev->{name} || $k2;
        my $txt = "port$p1 -> $name2 port$p2";
        $out .= "<tr>
         <td>&nbsp;
         <td>&nbsp;
         <td><font color=navy>LinkAlert $txt
         <td><center>$sev
         <td><small>$link->{desc}
               ";
     }
  }
  return $out;
}


1;


