package GUI::SenseKey;

use strict;
use System;
use Html::List;


sub asc {
  my($q) = @_;

  my $db = Util->deserialize("System/asc.db", 0, 1);
  my $x;
  print Html->body();
  print Html->header2("report.service.ascq");
  my $info = $db->{map}; 
  my $asc = $db->{asc};
  my ($cnt, @REP);
  $q->{SORT} = 5 if (!$q->{SORT});
  foreach my $k (sort keys %$asc) {
     my($a, $b) = split(/\./, $k);
     my $el = $asc->{$k};
     my $opts = $el->{opt};
     my $desc = $el->{desc};
     next if (!$desc);
     my $extra;
     #if (length($opts) > 0) {
     #  for ($x=0; $x <= length($opts); $x++) {
     #     my $i = substr($opts, $x,1);
     #     $extra .= "<br>" if ($extra);
     #     $extra .= lc($info->{$i}) ;
     #  }
     #}
     my $code;
     if (index($opts, "A") >= 0) {
        $code = "A";
     } elsif (index($opts, "D") >= 0) {
        $code = "D";
     } elsif (index($opts, "T") >= 0) {
        $code = "T";
     } elsif (index($opts, "E") >= 0) {
        $code = "E";
     } else {
        $code = "Z";
     }

     push(@REP, [$a, $b, $desc, $opts, $code]);
     last if ($q->{DOC} && $cnt++ > 20);
  }
  my($pageInfo, $list) = Html::List->makeList($q, \@REP,
        [ 'ASC', 'ASCQ', 'Description','Applies to', 'Group'],
        [  'l',   'l',    'l',         'l', 'l' ],
        [ '+',    '+',    '+',         '+', '+' ],
        {pageSize => 600, interactive => 1} );

  print "<table border=1 cellspacing=0 cellpadding=0 width=90% bgcolor=white>
         <tr><td colspan=5 bgcolor=$Style::DARK>
             <font color=white><b>Additional Sense Key Info</td>";
  print "$list</table>";
  if ($q->{DOC}) {
     print "Note: The complete report can be seen using the StorA.D.E. GUI.<br>";
  }
  print "<table border=0 cellpadding=3 width=90%><tr><td>$pageInfo</table>";
  print "&nbsp;<table border=1 bgcolor=white cellspacing=0 cellpadding=3>
      <tr><td colspan=2 bgcolor=$Style::LIGHT><b>Applies to</td>";
  foreach my $el (keys %$info) {
    print "<tr><td>$el</td><td>$info->{$el}</td>";
  }
  print "</table>&nbsp;<p>";


  
}


1;
