package GUI::ReadMess;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use strict;
use System;
use Util;
use Data::Dumper;
use FC;

#lnk fail    sync loss   signal loss   sequence err   invalid word   CRC

#Feb 21 09:27:28 invader scsi: [ID 107833 kern.warning] WARNING: /pci@6,2000/pci@2/SUNW,qlc@4/fp@0,0/ssd@w220000203722c4bd,0 (ssd251):
# invader genunix: [ID 408114 kern.info] /pci@6,2000/pci@2/SUNW,qlc@5/fp@0,0/ssd@w22000020371b6583,0 (ssd93) offline

sub processA5K {
  my($com, $DB, $ENC, $WWN) = @_;
  my($enc, $in, $num, $x, $wwn, $state, $status);

  foreach my $l (@$com) {
     if ($l =~ /Node WWN:(.+) Enclosure Name:(.*)/) {
        $enc = Util->rtrim($2);
        $enc = $1 if (!$enc);
        last;
     }
  }
  my($slot);
  foreach my $l (@$com) {
     if ($l =~ /^SLOT/) {
       $in = "slot";
     } elsif ($in eq "slot") {
        if (substr($l,0,1) =~ /\d/) {
          $num =  substr($l,0,2) + 0;
          $x = substr($l,7,13);
          $x =~ /([ \w]+)(.*)/;
          $wwn = lc(substr($l,25,16));
          $slot = sprintf("f%2.2d",$num);
          $DB->{substr($wwn,2)} = [$enc,$slot];
          $WWN->{"$enc.$slot"} = $wwn;
          $ENC->{$enc}{total} = $num if ($num > $ENC->{$enc}{total});

          $x = substr($l,45,13);
          $x =~ /(\w+)(.*)/;
          $wwn = lc(substr($l,63,16));
          $slot = sprintf("r%2.2d",$num);
          $WWN->{"$enc.$slot"} = $wwn;
          $DB->{substr($wwn,2)} = [$enc,$slot];
        }
     }
  }
}

sub short {
  my($p) = @_;
  my $last = $p;
  my $ix = rindex($p, "/");
  $last = substr($p , 0, $ix) if ($ix > 0);
  return $last;
}

sub try {
  my($q);
  $q->{a5}   = "/opt/ras21/Test/doug3/luxadm.all";
  $q->{dump} = "/opt/ras21/Test/doug3/sbus";
  $q->{dir}  = "/opt/ras21/Test/doug3";
  $q->{"file_messages.all"} = 1;

  &read_mess($q);
}

sub read_mess {
  my($q) = @_;
  print "\n<body bgcolor=$Style::BGCOLOR></center><pre>";
  my(@com, $l, $wwn, $name);
  my($DB) ={};
  my $ENC = {};
  my $WWN = {};
  my $count = 0;
  if ($q->{a5}) {
     if (!open(O, $q->{a5})) {
        print "<h3>Error: $q->{a5}: $!";
        return;
     }
     while ($l = <O>) {
        chop($l);
        if ($l =~ /^\s+SENA/) {
          if ($count > 0) {
             &processA5K(\@com, $DB, $ENC, $WWN);    
             @com = ();
          }
          $count++;
        } else {
          push(@com, $l);
        }
     }
     close(O);
     &processA5K(\@com, $DB, $ENC, $WWN);    
     @com = ();
  } else {
     my($err, $out) = Util->run_command("/usr/sbin/luxadm probe", "test",100);
     foreach $l (@$out) {
        if ($l =~ /Name:(.*) Node WWN:(.+)/) {
           $wwn = $2;
           print "luxadm display on $wwn...<br>\n";
           my($err, $com) = Util->run_command("/usr/sbin/luxadm display $wwn", "test",100);
           &processA5K($com, $DB, $ENC, $WWN);
        }
     }
  }
  my (%DUMP);
  if ($q->{dump}) {
     my $ix = rindex($q->{dump}, "/");
     my $dir1 = substr($q->{dump},0,$ix);
     my $pat = substr($q->{dump},$ix+1);
     opendir(O, $dir1);
     my @files = readdir(O); closedir(O);
     foreach my $f (@files) {
       next if (substr($f,0,1) eq ".");
       next if ($f !~ /^$pat/);
       my $in = 0;
       open(O, "$dir1/$f");
       while ($l = <O>) {
          chop($l);
          if ($l =~ /Pos AL_PA/) {
             $in = 1;
          } elsif ($in) {
             my(@a) = split(/\s+/, $l);
             my $wwn = substr($a[4],2);
             my $e = $DB->{$wwn};
             if ($e) {
                $DUMP{$f} .= $e->[0] . ":$e->[1],";
             }
          }
       }
       close(O);
     }
  } else {
     my($err, $paths) = Util->run_command("/usr/sbin/luxadm probe -p", "test",100);
     my($x ,$list);
     for ($x=0; $x <= $#$paths; $x++) {
       if ($paths->[$x] =~ /Physical Path:/) {
         $x++ if (index($paths->[$x], "/") < 0);
         my $f1 = index($paths->[$x], "/");
         my $f2 = rindex($paths->[$x], "/");
         my $pa = substr($paths->[$x], $f1, $f2-$f1);
         next if (index($list, $pa) >= 0);
         $list .= "$pa,";
         print "luxadm dump_map on $pa ...<br>\n";

         my($err, $out) = Util->run_command("/usr/sbin/luxadm -e dump_map $pa", "test",100);
         my($in,$e);
         foreach $l (@$out) {
            if ($l =~ /Pos AL_PA/) {
               $in = 1;
            } elsif ($in) {
               my(@a) = split(/\s+/, $l);
               my $wwn = substr($a[4],2);
               $e = $DB->{$wwn};
               if ($e) {
                  $DUMP{$pa} .= $e->[0] . ":$e->[1],";
               }
            }
         }
       }
     } 
  }
     
  my %M = (); 
  my %REASON = ();
  my %NF;
  my %ASCDESC;
  my $no_read2 = 0;
  my $pop;
  my($last_wwn, $last_path, $asc,$ascq, $asc_desc);

  my $DIR = $q->{dir} || "/var/adm";
  my($no_read, $no_write, $cnt);
  my $found;
  foreach my $x (keys %$q) {
     next if (substr($x,0,5) ne "file_");
     my $file = substr($x,5);
     print "Reading '$file'..\n";
     open(O, "$DIR/$file");
     $cnt++;
     my($l0);
     while (1) {
         last if (!($l0 = <O>));
         my $date0 = substr($l0, 0, 15);
         my @A;
         if ($pop) {
           push(@A, $pop);
           $pop = undef;
         }
         push(@A,$l0);
         my $done = 1;
         while ($l = <O>) {
            if (substr($l,0,15) eq $date0) {
               push(@A, $l);
            } else {
               $pop = $l;
               $done = 0; last;
            }
         }
         last if ($done);

         my($x, $x1, $reason, $v1);
         for ($x=0; $x <= $#A; $x++) {
           if ($A[$x] =~ /Transport error.*Channel CRC/) {
              $last_path = $wwn = $reason = "";
              for ($x1=0; $x1 <= $#A; $x1++) {
                  if ($A[$x1] =~ /WARNING: (.*)\@[wg]([0-9a-f]+).*\(ssd/) {
                      if (!$wwn) {
                        $last_path = &short($1);
                        $wwn = substr($2,2); 
                      }
                  } elsif ($A[$x1] =~ /SCSI transport failed: reason \'([^\']+)/) {
                      $reason = $1;
                  }
              }
              if ($wwn) {
                $v1 = $DB->{$wwn};
                if ($v1) {
                  $found++;
                  $M{$last_path}{$v1->[0]}{$v1->[1]}[0]++;             # read
                  $REASON{$last_path}{$v1->[0]}{$v1->[1]}{$reason}++;  # save reason
                } else {
                  $no_read++;
                  $NF{$last_wwn} = 1;
                }
              }
              last;

           } elsif ($A[$x] =~ /Error for Command: write/) {
              $wwn = $last_path = $asc  = $ascq = "";
              for ($x1=0; $x1  <= $#A; $x1++) {

                  if ($A[$x1] =~ /WARNING: (.*)\@[wg]([0-9a-f]+).*\(ssd/) {
                      if (!$wwn || $x1 < $x) {
                        $last_path = &short($1);
                        $wwn = substr($2,2);
                      }
                  } elsif ($A[$x1] =~ /ASC: 0x(\d+) \((.*)\), ASCQ: 0x([0-9a-fx]+)/) {
                      $asc = sprintf("%2.2d", $1);
                      $ascq = sprintf("%2.2d", $3);
                      my $desc = $2; $desc =~ s/<//g;
                      $ASCDESC{"$asc-$ascq"} = $desc;
                  }
              }
              if ($wwn) {
                $v1 = $DB->{$wwn};
                if ($v1) {
                  $found++;
                  if ($asc eq "47") {
                    $M{$last_path}{$v1->[0]}{$v1->[1]}[1]++;             # write
                  } else {
                    $M{$last_path}{$v1->[0]}{$v1->[1]}[2]++;             # asc++
                  }
                  $REASON{$last_path}{$v1->[0]}{$v1->[1]}{"$asc-$ascq"}++;  # 
                } else {
                  $no_write++;
                  $NF{$last_wwn} = 1;
                }
              } else {
                print "wwn not found for $A[$x]<br>";
              }
              last;

           } elsif ($A[$x] =~ /Error for Command: read\(/) {
              $wwn = $last_path = $ascq = $asc = $asc_desc = "";
              for ($x1=0; $x1 <= $#A; $x1++) {
                  if ($A[$x1] =~ /WARNING: (.*)\@[gw]([0-9a-f]+).*\(ssd/) {
                      $last_path = &short($1);
                      $wwn = substr($2,2);
                  } elsif ($A[$x1] =~ /ASC: 0x(\d+) \((.*)\), ASCQ: 0x([0-9a-fx]+)/) {
                      $asc = sprintf("%2.2d", $1);
                      $ascq = sprintf("%2.2d", $3);
                      my $desc = $2; $desc =~ s/<//g;
                      $ASCDESC{"$asc-$ascq"} = $desc;
                  }
              }
              if ($wwn) {
                $v1 = $DB->{$wwn};
                if ($v1) {
                  $found++;
                  $M{$last_path}{$v1->[0]}{$v1->[1]}[2]++;             # asc++
                  $REASON{$last_path}{$v1->[0]}{$v1->[1]}{"$asc-$ascq"}++;  # 
                } else {
                  $no_read2++;
                }
              }
              last;
           }
         }
     }
     close(O);
  }
  $Data::Dumper::Indent = 1;

  my($D2) = System->get_home() . "/DATA/tmp/RW";
  mkdir $D2, 0777 if (!-d $D2);

  open(O, ">$D2/current");
  print O Dumper({wwn => $WWN, enc => $ENC, data => \%M, reason => \%REASON, 
                  dump => \%DUMP, ascdesc => \%ASCDESC, 
                  missing => [$no_read, $no_write, $no_read2], notFound => \%NF});
  close(O);

  if ($found) {
    &graph($q);
  } else {
    print "<font color=red><b>No FC Error found in message files!</b></font><br>";
  }

  print "Done.";
  
}

sub delete {
  my($q) = @_;
  unlink(System->get_home() . "/DATA/tmp/RW/$q->{report}");
  &mess({});
}


sub mess {
  my($q) = @_;
  my($err2, $VAR1, $DIR);

  print "\n<body bgcolor=$Style::BGCOLOR><center>";
  my $mach = Util->select_hosts("GUI::ReadMess::mess");
  my $hostname = System->shortHostname();

  print Html->header("A5K Loop Analysis (on $hostname)", "90%", $mach,
           'fcutil', 'fc_readwrite');

  if ($q->{dir}) {
    $DIR = $q->{dir};
  } else {
    $DIR = "/var/adm";
  }
     
  if ($q->{ACTION} eq "Save" ) {
     my($D2) = System->get_home() . "/DATA/tmp/RW/current";
     open(O, $D2);
     my @a = <O>; close(O);
     eval "@a";
     $VAR1->{description} = $q->{desc};

     my($D3) = System->get_home() . "/DATA/tmp/RW/$q->{report}.rpt";
     open(W, ">$D3");
     $Data::Dumper::Indent = 1;
     print W Dumper($VAR1);
     close(W);

     &graph({report => $q->{report}});
     return;
     
  } elsif ($q->{ACTION} eq "Delete" ) {
     print "<b><font color=red>Report $q->{report} deleted!</font></b><br>";
     unlink(System->get_home() . "/DATA/tmp/RW/$q->{report}.rpt");


  } elsif ($q->{ACTION} eq "ReadDetails" ) {
        &details($q);
        return;
  } elsif ($q->{ACTION} eq "Re-Display" ) {
     if ($q->{report}) {
        &graph($q);
        return;
     }
  } elsif ($q->{ACTION} eq "Run") {  # display graph after hba selection
     &graph($q);
     return;

  } elsif ($q->{ACTION} eq "LoopOrder") {  # display graph after hba selection
     &graph($q);
     return;

  } elsif ($q->{ACTION} eq "Analyze") {
     my $cnt=0;
     foreach my $x (keys %$q) {
       if (substr($x,0,5) eq "file_") {
          $cnt++;
       }
     }
     if ($cnt) {
       &read_mess($q);
       return;
     } else {
       $err2 = "<tr><td colspan=5>
         <font color=red><b>Error: Select at least one Message File!</b></font></td>";
     }
  }
  opendir(O, $DIR);
  my @a = readdir(O); closedir(O);
  opendir(O, System->get_home() . "/DATA/tmp/RW");
  my @b = readdir(O); closedir(O);
  my $reports = "<select name=report><option value=\"\">[Select]";
  foreach my $l (sort @b) {
     next if (substr($l,-4) ne ".rpt");
     next if (substr($l,0,1) eq ".");
     $reports .= "<option>" . substr($l,0,-4);
  }
  $reports .= "</select>";
  
  print "
  <form><input type=hidden name=GO value=GUI::ReadMess::mess>
   <table border=1 cellspacing=0 bgcolor=white width=90%>
  <tr bgcolor=$Style::DARK><td colspan=5><font color=white><b>Display Old Report</td>
   <tr><td colspan=1 bgcolor=#DDDDFF align=right><b>Select Report:</td>
       <td colspan=4>$reports &nbsp;<b>
             <input type=submit name=ACTION value=Re-Display></td>
  <tr bgcolor=$Style::DARK><td colspan=5><font color=white><b>Run New A5K FC R/W Report</td>
   <tr><td colspan=5><center>
      <table border=0 width=95%><tr ><td>
         - Select the Message-file directory (or use the usual /var/adm).<br>
         - Enter the name of a file that contains the output of 'luxadm display' for
         each enclosure monitored in the message file.<br>
         - Enter the name of a file that contains the output of all 'luxadm -e dump_map'
           (optional).<br>
         When missing , the program will run luxadm automatically , 
         enclosures need to be visible from the current host.
      </table>
   <tr><td colspan=1 align=right bgcolor=#DDDDFF><b>Message File Dir:</td>
       <td colspan=4><input type=text name=dir value=\"$q->{dir}\" size=40> 
               <b><input type=submit name=ACTION value=ChangeDir></td>
   <tr><td colspan=1 align=right bgcolor=#DDDDFF><b>Luxadm File Name:</td>
       <td colspan=4><input type=text name=a5 size=50 value=\"$q->{a5}\"></td>
   <tr><td colspan=1 align=right bgcolor=#DDDDFF><b>Dump_Map File Prefix:</td>
       <td colspan=4><input type=text name=dump size=50 value=\"$q->{dump}\"></td>

  <tr bgcolor=$Style::DARK><td colspan=5><font color=white><b>Select Message Files in $DIR</td>
  <tr bgcolor=#DDDDFF><th>Select
      <th>File
      <th>Size
      <th>First Access
      <th>Last Access
   $err2
  ";
  my $today = Util->today("YMDH");
  my($created, $size, $first, $year, $month, $day, $firstD) ;
  foreach my $f (@a) {
    if (substr($f,0,8) eq "messages") {
      next if ($f =~ /t3/);
      $created = Util->get_file_created("$DIR/$f");
      my(@stats) = stat("$DIR/$f");
      $size = sprintf("%.1f", $stats[7] / 1000000);
      open(O, "$DIR/$f");
      $first = <O>; close(O);
      ($year, $month, $day) = &get_date($first);

      $firstD = sprintf("%d-%2.2d-%2.2d", $year, $month,$day);
      print "<tr><td><center><input type=checkbox name=file_$f>
                 <td>&nbsp;$f
                 <td>&nbsp;$size Meg
                 <td>&nbsp;$firstD
                 <td>&nbsp;$created</td>";
    }
  }
  print "</table><b>";
  print "<input type=submit name=ACTION value=Analyze>
 </form>";
}

sub get_date {
  my($first) = @_;
  my(@b) = split(/\s+/, $first);
  my $today = Util->today("YMDH");
  my($month) = $Util::MTH{$b[0]};
  my($day)   = $b[1];
  my($year)  = ($month <= substr($today,5,2)) ? 2001:2000;
  return ($year, $month, $day);
}



sub details {
  my($q) = @_;
  my(%X, %R, @a, $Q, $VAR1, $ENC, $REASON, $ascdesc, $hba, $p, $p1, $enc, $disk);
  my($p2, $reason, $cnt, $reasons);
  my $r = $q->{report}? "$q->{report}.rpt" : "current";
  my($D2) = System->get_home() . "/DATA/tmp/RW/$r";

  open(O, $D2); @a = <O>; close(O); eval "@a";

  $Q      = $VAR1->{data};
  $ENC    = $VAR1->{enc};
  $REASON = $VAR1->{reason};
  $ascdesc= $VAR1->{ascdesc};
  my $missing = $VAR1->{missing};
  my $wwns    = $VAR1->{wwn};
  
  foreach $hba (sort keys %$REASON) {
      $p = $REASON->{$hba};
      foreach $enc (sort keys %$p) {
          $p1 = $p->{$enc};
          foreach $disk (sort keys %$p1) {
             $p2 = $p1->{$disk};
             foreach $reason (sort keys %$p2) {
                 $R{$reason} = 1;
                 $X{$hba}{"$enc.$disk"}{$reason} += $p2->{$reason};
             }
          }
      }
  }
  $cnt=2;
  my @X;
  $reasons = "";
  foreach $r (sort keys %R) {
      $reasons .= "<td align=right><b>$r&nbsp;";
      $cnt++;
  }
  my $cnt0 = $cnt-1;
  my $out = "<table border=1 cellspacing=0 cellpadding=1 width=90% bgcolor=white>
    <tr bgcolor=$Style::DARK><td colspan=$cnt0>
          <font color=white><b>Read Error Details (by reason)
        <td align=right>
         <table border=0><tr><td>
             <b><font color=white>[ <a href=$Http::WEBPROC?GO=GUI::ReadMess::mess><font color=white>Back</font></a> ]
         </table></td>
    <tr bgcolor=$Style::BGCOLOR><td><b>&nbsp;Enclosure-Device
    <td><b>WWN</td></td>$reasons";

  my(%SUM, $last, $dev, $l1, $bg);
  foreach $hba (sort keys %X) {
      $out .= "<tr bgcolor=#F0F0C0><td colspan=$cnt><b>&nbsp;HBA: $hba</td>";
      $p = $X{$hba};
      $last = "";
      foreach $dev (sort keys %$p) {
          my $wwn = $wwns->{$dev};
          $l1= substr($dev,0,index($dev,"."));
          $bg = ""; $b = "";
          if ($l1 ne $last) {
            $bg = "bgcolor=#F0F0F0"; $b = "<b>";
            $last = $l1;
          }
          $out .= "<tr $bg><td>$b&nbsp;$dev<td>&nbsp;$wwn";
          $p1 = $p->{$dev};
          foreach $r (sort keys %R) {
              $out .= "<td align=right>$p1->{$r}&nbsp;";
              $SUM{$r} += $p1->{$r};
          }
      }
  }
  $out .= "<tr><td colspan=2 align=right><b>Total</td>";
  foreach $r (sort keys %R) {
      $out .= "<td align=right><b>$SUM{$r}&nbsp;</td>";
  }
  $out .= "</table>&nbsp;<br>";
  $out .= "<table border=1 bgcolor=white cellspacing=0 width=50%>
    <tr bgcolor=$Style::DARK><td colspan=2><font color=white><b>ASC Description";
  foreach my $asc (keys %$ascdesc) {
     $out .= "<tr><td>&nbsp;<b>$asc<td>$ascdesc->{$asc}";
  }
  $out .= "</table>";
  print $out;

}

sub samples {
  my($q) = @_;
  my(@b);
  my($D) = System->get_home() . "/htdocs/FC_gifs";
  print "\n<body bgcolor=$Style::BGCOLOR><center>&nbsp;";
  opendir(O, $D);
  my @a = readdir(O); closedir(O);
  my $cnt = 1;
  if ($q->{gif}) {
     print "<table border=1 cellspacing=0 cellpadding=2 bgcolor=white width=50%>";
     print "<tr bgcolor=$Style::DARK><td><table border=0><tr><td><font color=white><b>Graph Sample </table></td>";
    my $name = $q->{gif};
    if (open(O, "$D/$name.txt")) {
         @b = <O>; close(O);
    }
    my $n0;
    if ( -f "$D/$name.gif") {
        $n0 = "$name.gif";
    } else {
        $n0 = "$name.jpg";
    }
    print "<tr><td>&nbsp;<b>$name:</b> @b [ <a href=$Http::WEBPROC?GO=GUI::ReadMess::samples>Back</a> ]</td>
     <tr><td><img src=/FC_gifs/$n0>
     ";

  } else {
     print "<table border=1 cellspacing=0 cellpadding=2 bgcolor=white width=90%>";
    print "<tr bgcolor=$Style::DARK><td colspan=3>
     <table border=0><tr><td><font color=white><b>Sample Output List</table></td>
     <tr bgcolor=$Style::BGCOLOR><td><b>#<td><b>Name<td><b>Description</td>";
    foreach my $x (@a) {
       my $ix = index($x, ".");
       my $name = substr($x,0,$ix);
       if ($x =~ /\.txt/) {
          open(O, "$D/$name.txt"); @b = <O>; close(O);
          print "<tr><td>$cnt<td><a href=$Http::WEBPROC?GO=GUI::ReadMess::samples&gif=$name>$name</a>
            <td>@b</td>";
       }
    }
  } 
  print "</table>";

}
 

sub graph {
  my($q) = @_;
  my($VAR1, $ENC, $REASON, $title, @a);
  print "</pre></center>\n";
  my($D2) = System->get_home() . "/DATA/tmp/RW/current";

  if ($q->{report}) {
    $D2 = System->get_home() . "/DATA/tmp/RW/$q->{report}.rpt";
  }
  open(O, $D2); @a = <O>; close(O); eval "@a";

  my $Q      = $VAR1->{data};
  $ENC    = $VAR1->{enc};
  $REASON = $VAR1->{reason};
  my $missing = $VAR1->{missing};
  my $nf  = $VAR1->{notFound};
  my $dump  = $VAR1->{dump};

  $q->{hba} = 1 if (!$q->{hba});
  my $cnt = 1;
  my $select = "";
  my $select;
  foreach my $path (sort keys %$Q) {
     my $sel = (index("\t$q->{hba}\t", "\t$cnt\t") >= 0) ? "selected":"";
     $select .= "<option $sel value=$cnt>$cnt=$path</option>";
     $cnt++;
  }
  my $mul = ($cnt==2)? 1:2;
  $select = "<select name=hba multiple size=$mul>$select</select>";

  my ($s1, $s2);
  if ($q->{report}) {
    $s1 = "<input type=submit name=ACTION value=Delete>";
  } else {
    $s2 = "<tr><td colspan=3 nowrap><b>&nbsp;Save Report: </b>
             Name:<input type=text name=report size=25>&nbsp;
             Desc:<input type=text name=desc size=30>&nbsp;
             <b><input type=submit name=ACTION value=Save></td>
          ";
  }
  my $t2 = " LoopOrder" if ($q->{ACTION} eq "LoopOrder");
  print 
  "<table border=0 cellspacing=0 cellpadding=0 bgcolor=white width=100%>
   <form><input type=hidden name=GO value=GUI::ReadMess::mess>
     <input type=hidden name=report value=\"$q->{report}\">
   <tr bgcolor=$Style::DARK><td colspan=3>
       <table border=0 cellspacing=0 cellpadding=0 width=100%>
            <tr><td><font color=white><b>&nbsp;A5K FC R/W Graph$t2- $q->{report}<br>&nbsp;$VAR1->{description}</td>
            <td align=right><font color=white>
              $s1 &nbsp;
              <input type=submit name=ACTION value=ReadDetails>&nbsp;
              <input type=submit name=ACTION value=Back>&nbsp;
       </table>
   <tr><td colspan=3 nowrap>
      <table border=0 cellspacing=0 cellpadding=0>
         <tr><td><b>&nbsp;&nbsp;&nbsp;Select Hba: </td>
             <td><b>$select</td>
             <td>&nbsp;&nbsp;<b><input type=submit name=ACTION value=Run>
                 &nbsp;<input type=submit name=ACTION value=LoopOrder>
      </table></td>
   $s2
   </form>
   </table>";
  my(@X, $xvalues);
  @X = ();
  my $max = 0;
  my($hba, $short_hba);
  $hba = "";

  if ($q->{ACTION} eq "LoopOrder") {
     $cnt= 0;
     foreach my $h (sort keys %$Q) {
       $cnt++;
       if ($cnt == $q->{hba}) {
          $hba = $h; last; 
       }
     }
     my $order;
     foreach my $p (keys %$dump) {  # find the dump for this hba
         if ($hba =~ /$p/ || "/devices$hba" =~ /$p/) {
            $order = $dump->{$p};
            $short_hba = $p;
            if (length($short_hba) >= 10) {
               $short_hba =~ /(\@\d+)/; $short_hba = $1;
            }
            last;
         }
     }
     if (!$order) {
        print "&nbsp;<p><b><font color=red>Cannot find a loop order for $hba</font></b>";
        return;
     }
     my @devs = split(/,/, $order);
     my $p = $Q->{$hba};
     my $stack_cnt = 1; my $gc = 1;

     my($r_data, $w_data, $m_data);
     my $tail = "<table width=100% border=0 cellspacing=0 bgcolor=#505050><tr><td>&nbsp;&nbsp;</td>";
     my($list, $p1) ;
     $cnt = 0;
     foreach my $dev (@devs) {
        my($enc, $dev) = split(/\:/, $dev);
        my $fr = uc(substr($dev,0,1));
        my $dev0 = substr($dev,0,1) . (substr($dev,1)+0);
        $xvalues .= $dev0 . "=$enc-" . uc($dev) . ",";
        $p1 = $p->{$enc}{$dev};
        if (index($list, "$enc:$fr") < 0) {
           $tail .= "<td><center><font color=white><b>$enc:$fr</td>";
           $list .= "$enc:$fr,";
        }

        $r_data  .= $p1->[0] . ",";
        $w_data  .= $p1->[1] . ",";
        $m_data  .= $p1->[2] . ",";
     }
     $tail .= "<td>&nbsp;&nbsp;&nbsp;&nbsp;</td></table>";
     my $applet;
     $applet = &get_applet(250, $xvalues);
     $applet .= "<param name=title1 value=\"$short_hba\">";
     $applet .= &get_parms(\$gc, \$stack_cnt, $r_data, $w_data, $m_data);
     $applet .= "</applet>\n";
     
     print &display_all($tail, $applet, $missing, $nf, $dump);
     
     return;
  } 

#
# OLD GRAPH
#

  foreach my $enc (keys %$ENC) {
     if ($ENC->{$enc}{total} > $max) {
       $max = $ENC->{$enc}{total};
     }
  }
  my($x1, $slot, $e0);
  foreach my $e ('f','r') {
     for ($x1=0; $x1 <= $max; $x1++) {
        $slot = sprintf("$e%2.2d", $x1);
        push(@X, $slot);
        $title = ($e eq "f")? "front":"rear";
        $e0=uc($e);
        $xvalues .= sprintf("$e0%2.2d=$title disk $x1,", $x1);
     }
   }

   $cnt= 0; 
   my $enc_cnt = 0;

   foreach $hba (sort keys %$Q) {
       $cnt++;
       next if (index("\t$q->{hba}\t", "\t$cnt\t") < 0);
       my $p = $Q->{$hba};
       for my $enc (keys %$p) {
          $enc_cnt++;
       }
   }
   my($height);
   if ($enc_cnt <= 2) { 
     $height = 400;
   } else {
     $height = $enc_cnt * 100;
   }

#  var a_height =  window.innerHeight * 0.80;

  my $applet = &get_applet($height, $xvalues);

   my($line, @b, @c,  $gc, $enc, $disk, @HBA, @ENC2, $p1);
   my(%H, %HBA, $p);
   my($hba_cnt) = 0;
   my $stack_cnt = 1; $gc = 1;

   $hba_cnt = 0;
   foreach $hba (sort keys %$Q) {
       $hba_cnt++;
       next if (index("\t$q->{hba}\t", "\t$hba_cnt\t") < 0);
       $p = $Q->{$hba};

       foreach $enc (keys %$p) {
          $applet .= "<param name=title$stack_cnt value=\"$hba_cnt-$enc=$enc on $hba\">";

          $p1 = $p->{$enc};
          my($r_data, $w_data,$m_data);
          foreach $disk (@X) {
              $r_data  .= $p1->{$disk}[0] . ",";
              $w_data  .= $p1->{$disk}[1] . ",";
              $m_data  .= $p1->{$disk}[2] . ",";
          }
          $applet .= &get_parms(\$gc, \$stack_cnt, $r_data, $w_data, $m_data);
       }
   }
       
   $applet .= "</applet>\n";

   print &display_all("",$applet, $missing, $nf, $dump);
}


sub display_all {
  my($tail, $applet, $missing, $nf, $dump) = @_;
  my($o);

  $missing->[1] += 0;
  $missing->[0] += 0;
  $missing->[2] += 0;

  $o = "<table border=0 cellspacing=0 cellpadding=0 width=100% bgcolor=black>
    <tr><td>$tail</td>
    <tr><td>$applet
    <tr><td>
   </table>
   </form>
   missing_CRC: $missing->[0], missing_write: $missing->[1], missing_read(10): $missing->[2]<br>
    ";

   my $flag = 0;
   foreach my $nf0 (keys %$nf) {
     if (!$flag) {
       $o .= "<b>WWN not found (probably replaced): </b>";
       $flag = 1;
     }
     $o .= "$nf0, ";
   }

     $o .= "<p>
 <table border=1 cellspacing=0 bgcolor=white width=80%>
 <tr bgcolor=#DDDDFF><td colspan=1><b>Loop Order (One path per line)</td>";
     foreach my $path (keys %$dump) {
       my $v = $dump->{$path};
       my @x = split(/,/, $v);
       my $v0;
       foreach my $x1 (@x) {
         if ($x1 =~ /f00/ || $x1 =~ /r00/) {
             $v0 .= "$x1, ";
         }
       }
       $o .= "<tr><td><b>$path:</b>&nbsp;$v0";
     }
     $o .= "</table>";
   return $o;
}
         

sub get_applet {
  my($height, $xvalues) = @_;

  my $sc0 = "<applet  $FC::APPLET height=200 width=600>";
  my $sc =<<EOF;
  <script>
  var a_width =  window.innerWidth - 15;
  var a_height =  $height;
  window.document.writeln(
   '<applet  $FC::APPLET height=' + a_height + ' width=' + a_width + '>');
  </script>
EOF
  my $applet =<<EOF;
$sc
<param name=xTitle value="Front / Rear disks">
<param name=nostyles value=0>
<param name=printCb value=1>
<PARAM name=backColor value="0,0,0">
<param name=showYvalues value=3>
<param name=browser value="sun">
<param name=fontsize value=11>
<param name=Yfontsize value=10>
<param name=minY value=0>
<param name=decimalsY value=-1>
<xparam name=maxY value=20>
<param name=hideXvalues value=0>
<xparam name=urlColor value="white">
<param name=logY value=2>
<param name=gridCntY value=5>
<param name=vertSpace value=3>
<PARAM NAME=fontColor value="250,250,250">
<PARAM name=Grid value=1>
<param name=graphType value=40>
<param name=urlX value="$Http::WEBPROC?GO=FibreGUI::test2&option=2&">
<param name=urlY value="$Http::WEBPROC?GO=FibreGUI::test2&option=2&">
<param name=xurlTarget value="">
<param name=statusInfo value="select,disk,enclosure">
<param name=ySuffix value="">
<param name=hlColor value="250,250,100">
<PARAM name=xValues value="$xvalues">
<xparam name=minX value=1>
<xparam name=maxX value=9>
EOF

   return $applet;
}

sub get_parms {
  my($gc,  $stack_cnt, $r_data, $w_data, $m_data) = @_;
  my($o);
  my $st = $$stack_cnt;

  $o .=<<EOF;
<PARAM name=graphColor$$gc value="yellow">
<param name=graph$$gc value="$r_data">
<PARAM name=label$$gc value="R(CRC-error)">
<PARAM name=yOffset$$gc value="0">
<param name=stack$$gc value=$st>
<param name=active$$gc value="1">
EOF
  $$gc = $$gc + 1;

  $o .=<<EOF;
<PARAM name=graphColor$$gc value="red">
<param name=graph$$gc value="$w_data">
<PARAM name=label$$gc value="W(SCSI-parity)">
<PARAM name=yOffset$$gc value="0">
<param name=stack$$gc value=$st>
<param name=active$$gc value="1">
EOF
  $$gc = $$gc + 1;

  $o .=<<EOF;
<PARAM name=graphColor$$gc value="blue">
<param name=graph$$gc value="$m_data">
<PARAM name=label$$gc value="Media-Error">
<PARAM name=yOffset$$gc value="0">
<param name=stack$$gc value=$st>
<param name=active$$gc value="0">
EOF
  $$gc = $$gc + 1;

  $$stack_cnt = $$stack_cnt + 1;

  return $o;
}

sub save {
  my($q) = @_;
  my($D) = System->get_home() . "/DATA/tmp/RW";
  my($l);
  if ($q->{report}) {
     $q->{report} =~ s/ /_/g;
     mkdir $D, 0777;
     open(O,  System->get_home() . "/DATA/tmp/save_rw");
     open(W, ">$D/$q->{report}.rpt");
     while ($l = <O>) {
       print W $l;
     }
     close(O);
     close(W);
     print "<b><font color=green>Report saved!</font>";
     &mess($q);
  }
}

1;

