package GUI::Process;
#
# used to track reports coming from Revision Checking, FCCheck and other programs that run in
# the background. need ID and NAME as argument to find the right directories.

use Process;
use System;
use PDM::ConfigFile;
use strict;

# ID = Revision | FCCheck

sub list {
  my($q) = @_;
  my $ID = $q->{ID};
  my $NAME = $q->{NAME};
  my $deny = Roles->verifyRole($q, "admin");
  print Html->body();
  my $L = Labels->read("GUI::Process");
  my ($run, $l);
  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read;

  if ($q->{ACTION_save}) {
    my $save_cnt = 0;
    foreach my $x (keys %$q) {
      if (substr($x,0,4) eq "sel_") {
         $save_cnt++ ;
         my $name = substr($x,4);
         print "$name <br>\n";
         if ($name eq "local") {
            my $F = System->get_home() . "/DATA/tmp/$ID";
            my $date1 = Util->get_file_created($F);
            $date1 =~ s/ /_/g;
            open(R, $F);
            my $w = $renv->{hostname} . ".$date1";
            print "copying $w <br>\n";
            open(W, ">" . System->get_home() . "/DATA/${ID}_history/$w");
            while ($l = <R>) {
                print W $l;
            }
            close(R); close(W);
         } else {
            my $rc = Util::Http->readFile($name, "tmp/$ID");
            my $date1 = Util->get_today();
            $date1 =~ s/ /_/g;
            my $w = "$name.$date1";
            print "copying $w <br>\n";
            open(W1, ">" . System->get_home() . "/DATA/${ID}_history/$w");
            if ($rc) {
              print W1 $rc;
            }
            close(W1);
         }
      }
    }
    if (! $save_cnt ) {
        print"<font color=red><b>$L->{nothing}</b></font>";
    }
  }
  my $out = "<center><table border=0><tr><td></table>";

  $out .= Html->header2(($q->{ID} eq "FCCheck") ? 
                        "diagnose.tools.fc_report": "diagnose.revision.report", "95%");

  $out .= "<table border=0><tr><td></table>";
  $out .= "<table border=1 cellspacing=0 width=95% bgcolor=white>
  <tr><td colspan=4 bgcolor=$Style::DARK>
    <form>
       <input type=hidden name=GO value=GUI::Process::list>
       <input type=hidden name=ID value=$ID>
       <input type=hidden name=NAME value=\"$NAME\">
    <font color=white><b>$L->{monitor} $NAME</td>
  <tr bgcolor=$Style::LIGHT>
          <th>$L->{host}</th>
          <th>$L->{last}</th>
          <th>$L->{status}</th>
          <th>$L->{select}</th>
  ";
  my $st = Process->status("", $ID);
  my ($url, $sel);
  $sel = "&nbsp;";
  if ($st =~ /Done/) {
     $url = "<a href=$Http::WEBPROC?GO=GUI::${ID}::readLastReport&host=>$L->{display}</a>";
     $sel = "<input type=checkbox name=sel_local>";
  } else {
     $url = $L->{noreport};
  }
  $run =1 if ($st =~ /Running/);
  $out .= "<tr><td>&nbsp;$L->{local}</td><td><center>&nbsp;$url</td><td><center>&nbsp;$st</td><td><center>$sel</td>";

  foreach my $h (@$hosts) {
     my $st=  Process->status($h->{ipno} || $h->{hostname}, $ID);
     my $sel = "&nbsp;";
     if ($st =~ /Done/) {
        my $ip = $h->{ipno} || $h->{hostname};
        $url = "<a href=$Http::WEBPROC?GO=GUI::${ID}::readLastReport&host=$ip&hostname=$h->{hostname}>Display Report</a>";
        $sel = "<input type=checkbox name=sel_$h->{hostname}>";
     } else {
        $url = $L->{noreport};
     }
     $run =1 if ($st =~ /Running/);
     $out .= "<tr><td>&nbsp;$h->{hostname}</td><td><center>&nbsp;$url</td><td><center>&nbsp;$st</td><td><center>$sel</td>";
  }
  $out .= "</table>";
  if (!$deny) {
    $out .= "<table border=0 width=95%>
         <tr><td align=right><b><input type=submit name=ACTION_save value=\"$L->{save}\">
         </table>";
  }
  $out .= "</form>";
  print "<meta http-equiv=Refresh content=\"30;URL=$Http::WEBPROC?GO=GUI::Process::list&ID=$ID&NAME=$NAME\">" if ($run);
  print $out;

}

sub history {
  my($q) = @_;
  my $ID = $q->{ID};
  my $NAME = $q->{NAME};
  my $L = Labels->read("GUI::Process");
  my $deny = Roles->verifyRole($q, "admin");

  print Html->body();
  print "<center>&nbsp;";
  my $dirz = System->get_home() . "/DATA/${ID}_history/";
  if (!-d $dirz) { 
     print "Cannot find dir $dirz!<br>";
     return;
  }

  if ($q->{ACTION_del}) {
     my $del_cnt;
    foreach my $x (keys %$q) {
         if (substr ($x,0,4) eq "del_") {
            $del_cnt++;
            unlink "$dirz" . substr($x,4);
        }
    }
    if (!$del_cnt){
       print "<font color=red><b>$L->{nothing2}</b></font>";
    }
  }

  if ($q->{delete}) {
    unlink System->get_home() . "/DATA/${ID}_history/$q->{delete}";
    print " $q->{delete} deleted.<br>\n";
  }
  if($q->{ID} =~ /FCCheck/){
     print Html->header2("diagnose.tools.fc_history", "95%");
  } else {
     print Html->header2("diagnose.revision.history", "95%", $q->{ID});
  }
  print "<table border=0><tr><td></table>";



  my $D = System->get_home() . "/DATA/${ID}_history";
  opendir(O, $D);
  my @L = readdir(O); closedir(O);

  print "<table border=1 cellspacing=0 cellpadding=2 width=95% bgcolor=white>
  <tr><td colspan=3 bgcolor=$Style::DARK>
    <form>
      <input type=hidden name=GO value=GUI::Process::history>
      <input type=hidden name=ID value=$ID>
      <input type=hidden name=NAME value=\"$NAME\">
  <font color=white><b>$L->{select}</td>
  <tr bgcolor=$Style::LIGHT>
     <th>$L->{host}</th>
     <th>$L->{report}</th>
     <th>$L->{select}</th>
  ";
  my $last;
  my $cnt;
  my $sta;
 foreach my $h (sort @L) {
    next if (substr($h,0,1) eq ".");
    my $ix = rindex($h, ".");
    my $host = substr($h,0,$ix);
    my $date = substr($h,$ix+1);
    my $sel = "&nbsp;";
    my $del = "&nbsp;";
    # if ($host ne $last) {
       print "<tr><td width=20%>$host</td>";
    #    $last = $host;
    #}
     print "<td><center>";
     print "<a href=$Http::WEBPROC?GO=GUI::${ID}::readLastReport&hist=$h&hostname=$host>$date</a> ";
     print "</td>";
     # $sel = "<input type=checkbox name=sel_$host value=$date>";
      $del = "<input type=checkbox name=del_$h value=$date>";
     print "<td><center>$del</td>";
     $cnt++;

  }
  if (!$cnt) {
     print "<tr><td colspan=2><b>$L->{nohistory}</td>";
  }
  print "</table>";
  if (!$deny) {
    print "<table border=0 width=95%>
         <tr><td align=right><b><input type=submit name=ACTION_del value=$L->{delete}
         onclick = \"return confirm('$L->{sure}')\"> </table>";
  }

  print "</form>";

}




1;

