package GUI::Perf;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>


use Roles;
use Util;
use strict 'vars';
use GUI::SAN;
use System;
use Data::Dumper;
use Perf;
use vars qw ($MAX $REFRESH);
$MAX=8;
$REFRESH=60;  # real time refresh rate


sub array {
  my($q) = @_;
  my(%D, $applet, $x, $summ, @X, $xvalues, $reset, $created, $x0);
  my($title, $x, $report_list, %DEV_MAP);

  print Html->body();
  my $LB = Labels->read("GUI::Perf");

  my $hostname = System->shortHostname();
  my @reports = (0, $LB->{summ}, $LB->{hour}, $LB->{day}, $LB->{real});
  for ($x=1; $x <= $#reports; $x++) {
     $report_list .= "$x=$reports[$x]|";
  }
  chop($report_list);

  my($debug) = 0;
  my($cache) = 0;
  my $Config = PDM::ConfigFile->read();
  my $devices = $Config->devices();
  foreach my $d (@$devices) {
     $DEV_MAP{$d->{name}} = 1;
  }
  my $error;
  my $dev;
  my $today = Util->get_today();

  my @T = (0,    'MB per secs(R)'   , 'MB per secs(W)'  , 
                 'I/O per seconds', 0,
                 'CacheReadMiss', 'CacheWriteMiss' , 
                 'CacheReadHit' , 'CacheWriteHit'
           );

  my @COL = (0,'cyan','red','blue','green','yellow','white','orange','pink');
  my (%ALL_ARR, %ARR_NAMES, $left, $right, $center, $meta);
  $q->{report} = 1 if (!$q->{report});
  my $tot_lines;
  if ($q->{report} == 1) {

     $applet = &applet_head($q, "u1v1,u1v2,u2v1,u2v2,");
     my $D = Perf->read("stat1");
     my $D2 = {};

     # SUMMARIZE in D2
     foreach my $enc (sort keys %$D) {
       my($f1, $name, $vol) = split(/\./, $enc);
       next if (!$DEV_MAP{$name});
       $ALL_ARR{$name} = 1;
       $name = "MERGE" if ($q->{D2} eq "MERGE");
       $ARR_NAMES{$name} = 1;
       &summ($D2, $D->{$enc}, "$f1.$name.$vol");
     }

     my $gc        = 1; 
     my $stack_cnt = 1;

     foreach my $name (sort keys %ARR_NAMES) {
       next if ($q->{D2} && $name ne $q->{D2});
       $applet .= "\n<param name=title$stack_cnt value=\"$name\">";
       my @C;
       foreach my $vol ('u1v1','u1v2','u2v1','u2v2') {
           my $v = $D2->{"total.$name.$vol"} || [1,0,0];
           $C[1] .= int($v->[1]/2048) . ",";
           $C[2] .= int($v->[2]/2048) . ",";
           $C[3] .= ($v->[3]+$v->[4]) . ",";
           for ($x=5; $x <= 8; $x++) {
              $C[$x] .= $v->[$x] . ",";
           }    
           $tot_lines++;
       }
       foreach my $x (1,2,3,5,6,7,8) {
         my $on = ($x <= 3)  ? 1 : 0;
         $applet .= &applet_line($COL[$x], $gc, $C[$x], $T[$x], $stack_cnt, $on);
         $gc++;
       }
       $stack_cnt++;
     }
     $left = $LB->{vol};

  } elsif ($q->{report} == 3) { # DAILY

     my $D = Perf->read("stat2");
     my $D2 = {};
     my $today = Util->get_today();
     my $today_jd = Util->julian(substr($today, 0, 4), substr($today, 5, 2), substr($today, 8, 2));

     my ($hl, %DAY);
     # SUMMARIZE in D2
     foreach my $enc (sort keys %$D) {
       my($jd, $name, $vol) = split(/\./, $enc);
       next if ($today_jd - $jd > 32);
       next if (!$DEV_MAP{$name});
       my ($year,$month, $day) = Util->fromJulian($jd);
       $DAY{$jd} = 1;
       $hl .= "$day,";
       $ALL_ARR{$name} = 1;
       $name = "MERGE" if ($q->{D2} eq "MERGE");
       $ARR_NAMES{$name} = 1;
       &summ($D2, $D->{$enc}, "$jd.$name");
     }
     $applet = &applet_head($q, $hl);
     $center = "Day of Month";

     my $gc        = 1; 
     my $stack_cnt = 1;
     foreach my $name (sort keys %ARR_NAMES) {
       $applet .= "\n<param name=title$stack_cnt value=\"$name\">";
       my (@C, $x, $hx );
       next if ($q->{D2} && $name ne $q->{D2});
       foreach my $jd (sort keys %DAY) {
           my $v = (exists $D2->{"$jd.$name"}) ? $D2->{"$jd.$name"} : [1,0,0,0];
           $C[1] .= int($v->[1]/2048) . ",";
           $C[2] .= int($v->[2]/2048) . ",";
           $C[3] .= ($v->[3]+$v->[4]) . ",";
           for ($x=5; $x <= 8; $x++) {
              $C[$x] .= $v->[$x] . ",";
           }    
           $tot_lines++;
       }
       foreach my $x (1,2,3,5,6,7,8) {
         my $on = ($x <= 3)  ? 1 : 0;
         $applet .= &applet_line($COL[$x], $gc, $C[$x], $T[$x], $stack_cnt, $on);
         $gc++;
       }
       $stack_cnt++;
     }

  } elsif ($q->{report} == 2) { # HOURLY

     my $hl = "06,07,08,09,10,11,12,13,14,15,16,17,19,20,21,22,23,24,01,02,03,04,05";
     my @hs = split(/\,/, $hl);
     $applet = &applet_head($q, $hl);
     my $D = Perf->read("stat3");
     my $D2 = {};

     # SUMMARIZE in D2
     foreach my $enc (sort keys %$D) {
       my($hour, $name, $vol) = split(/\./, $enc);
       next if (!$DEV_MAP{$name});
       $ALL_ARR{$name} = 1;
       $name = "MERGE" if ($q->{D2} eq "MERGE");
       $ARR_NAMES{$name} = 1;
       &summ($D2, $D->{$enc}, "$hour.$name");
     }
     $left = "AM"; $center = "Hours 06AM -> 05PM"; 

     my $gc        = 1; 
     my $stack_cnt = 1;
     foreach my $name (sort keys %ARR_NAMES) {
       $applet .= "\n<param name=title$stack_cnt value=\"$name\">";
       my (@C, $hour0, $x, $hx );
       next if ($q->{D2} && $name ne $q->{D2});
       for ($hx=0; $hx <= $#hs; $hx++) {
           my $hour = $hs[$hx];
           my $v = (exists $D2->{"$hour.$name"}) ? $D2->{"$hour.$name"} : [1,0,0,0];
           $C[1] .= int($v->[1]/2048) . ",";
           $C[2] .= int($v->[2]/2048) . ",";
           $C[3] .= ($v->[3]+$v->[4]) . ",";
           for ($x=5; $x <= 8; $x++) {
              $C[$x] .= $v->[$x] . ",";
           }    
           $tot_lines++;
       }
       foreach my $x (1,2,3,5,6,7,8) {
         my $on = ($x <= 3) ? 1: 0;
         $applet .= &applet_line($COL[$x], $gc, $C[$x], $T[$x], $stack_cnt, $on);
         $gc++;
       }
       $stack_cnt++;
     }
  } elsif ($q->{report} == 4) { # REAL Time EVERY 2 MINUTE
        my $D = Perf->read("rt");
        my $info = Util->deserialize("Perf/rt.info");
        my $period = $info->{period} || 1;
        my $freq   = $info->{frequency};
        my $D2 = {};
        my ( $low_min, $high_min);
        $low_min = 99000000;
        # SUMMARIZE in D2
        foreach my $enc (sort keys %$D) {
          my($min, $name, $vol) = split(/\./, $enc);
          next if (!$DEV_MAP{$name});
          $low_min = $min if ($min < $low_min);
          $high_min = $min if ($min > $high_min);
          $ALL_ARR{$name} = 1;
          $name = "MERGE" if ($q->{D2} eq "MERGE");
          $ARR_NAMES{$name} = 1;
          &summ($D2, $D->{$enc}, "$min.$name");
        }
        my $hl;
        $low_min = $high_min - 40 if ($low_min < $high_min - 40); # 30 buckets max
        my $min_cnt = $high_min - $low_min;
        for ($x=$min_cnt; $x >= 0; $x--) {
           $hl .= ($x * $period) . ",";
        }
        chop($hl);
        $applet = &applet_head($q, $hl, 20, 2);
        $left = "Last " . ($min_cnt*$period) . " minutes";
        $center = "Refreshing display $REFRESH seconds, probing every $freq secs.";
   
        my $gc        = 1; 
        my $stack_cnt = 1;
        foreach my $name (sort keys %ARR_NAMES) {
          $applet .= "\n<param name=title$stack_cnt value=\"$name\">";
          my (@C, $hour0, $x, $hx );
          next if ($q->{D2} && $name ne $q->{D2});
          for ($hx=$low_min; $hx <= $high_min; $hx++) {
              my $v = (exists $D2->{"$hx.$name"}) ? $D2->{"$hx.$name"} : 
                                                    $D2->{($hx-1) . ".$name"};
              $C[1] .= int($v->[1]/2048) . ",";
              $C[2] .= int($v->[2]/2048) . ",";
              $C[3] .= ($v->[3]+$v->[4]) . ",";
              for ($x=5; $x <= 8; $x++) {
                 $C[$x] .= $v->[$x] . ",";
              }    
              $tot_lines++;
          }
          foreach my $x (1,2,3,5,6,7,8) {
            my $on = ($x <= 3) ? 1 : 0;
            $applet .= &applet_line($COL[$x], $gc, $C[$x], $T[$x], $stack_cnt, $on);
            $gc++;
          }
          $stack_cnt++;
           
        }
        $meta = "<meta http-equiv=Refresh content=\"$REFRESH;URL=$Http::WEBPROC?GO=GUI::Perf::array&report=$q->{report}&D2=$q->{D2}&RUNNING=1\">" if (!$q->{ACTION_stop});
  }

  $applet .= "</applet>";
  my $array_list = "=$LB->{all}|";
  foreach my $k (keys %ALL_ARR) {
    $array_list .= "$k|";
  }
  $array_list .= "MERGE=$LB->{combine}|";
 
  my $sel_report = Html->makeSelect("report", $report_list, $q->{report});
  chop($array_list) if ($array_list);
  my $sel_array  = Html->makeSelect("D2", $array_list,             $q->{D2});
  my $sel_display= Html->makeSelect("D3", "1=By Array|2=By Volume",$q->{D3});

  my $title = $reports[$q->{report}] . " $LB->{per_second}";
  print $meta;
  print Html->header2("report.general.parray", "99%" ,$title, {noDoc => 1});

  print "
    <table border=0 width=100% bgcolor=black cellpadding=0 cellspacing=0>
    <tr bgcolor=white>
      <td><form>
           <input type=hidden name=GO value=GUI::Perf::array><b>
           <input type=hidden name=RUNNING value=$q->{RUNNING}>
          &nbsp; Report:$sel_report &nbsp;
          Array:$sel_array &nbsp;
          <input type=submit name=ACTION value=GO>
          <input type=submit name=ACTION_stop value=\"$LB->{stop}\">
       </td>
       <td align=right>$today&nbsp;</td>
     ";
  if ($tot_lines) {
    print "
    <tr><td colspan=2>$applet
    <tr><td colspan=2 bgcolor=white>
          <table border=0 cellspacing=0 width=100%>
            <tr><td width=10%>&nbsp;</td>
                <td>$left&nbsp;</td>
                <td>$center&nbsp;</td>
                <td align=right>$right&nbsp;</td>
                <td width=10%>&nbsp;</td>
          </table>
    </table></form>";
  } else {
    print "</table></form>";
    print Html->warning($LB->{no_data});
  }
  open(O, ">/tmp/graph_applet"); print O $applet; close(O);
  
}

sub summ {
  my($NEW, $val, $key) = @_;
  my($x, $val2);
  for ($x=1; $x <= $MAX; $x++) {
    $val2->[$x] = int($val->[$x] / $val->[0]);
  }
  if (exists $NEW->{$key}) {
     for($x = 1; $x <= $MAX; $x++) {
        $NEW->{$key}[$x] += $val2->[$x];
     }
  } else {
     $NEW->{$key} = $val2;
  }
}

sub applet_line {
  my($col, $gc, $data, $txt, $stack_cnt, $on) = @_;
  return "
    <param name=graphColor$gc value=\"$col\">
    <param name=graph$gc value=\"$data\">
    <param name=label$gc value=\"$txt\">
    <param name=yOffset$gc value=\"0\">
    <param name=active$gc value=$on>
    <param name=stack$gc value=\"$stack_cnt\">
   ";
}


#<xapplet code="RasGraph2.class" codebase="/Chart2" archive="rasapplet.jar"  height=441 width=700>

sub applet_head {
  my($q, $xvalues, $graphType, $showY, $ysuffix) = @_;
  $graphType = 40 if (!$graphType);
  $showY = 3 if (!defined $showY);
  return "<img src=/gif/perf_sample.gif>" if ($q->{DOC});
  my $h = System->appletHeader("$FC::APPLET", 45, 100);

  my $o =<<EOF;
     $h
<Xparam name=xTitle value="">
<param name=nostyles value=0>
<param name=printCb value=1>
<PARAM name=backColor value="0,0,0">
<param name=showYvalues value=$showY>
<param name=browser value="sun">
<param name=fontsize value=11>
<param name=Yfontsize value=10>
<param name=minY value=0>
<param name=decimalsY value=-1>
<param name=hideXvalues value=0>
<param name=logY value=2>
<param name=gridCntY value=5>
<param name=vertSpace value=3>
<PARAM NAME=fontColor value="250,250,250">
<PARAM name=Grid value=1>
<param name=graphType value=$graphType>
<param name=urlX value="">
<param name=urlY value="">
<param name=xurlTarget value="">
<param name=statusInfo value="select,disk,enclosure">
<param name=ySuffix value="$ysuffix">
<param name=hlColor value="250,250,100">
<PARAM name=xValues value="$xvalues">
EOF
   return $o;
}



1;
