package GUI::Layout;
use strict;
use System;
use TO;
use Layout;
use GUI::Graph;

sub run {
  my($q) = @_;
  my($x, $layout); 
  my $topo_name = $q->{topo} || "MERGE-MASTER";
  my $filter    = $q->{FILTER} || "*";
  my $layout = $q->{Layout};
  my $LB = Labels->read("GUI::Layout");

  if ($layout) {
     my $to = TO->readTopo($topo_name);
     if ($q->{width}) {
       Layout->shortest_route($topo_name, $to, $filter, 0, 
                $q->{width}, $q->{height}, $layout, $q->{row_size});
       GUI::Graph::run3({topo => $topo_name, FILTER => $filter});
       return;    
     } else {
       print Html->body();
       print "</center><pre>";
       Layout->shortest_route($topo_name, $to, $filter, 1, 
                $q->{width}, $q->{height}, $layout, $q->{row_size});
       $topo_name =~ s/MERGE-//;
       print "</pre>";
       print Html->info("$LB->{new_layout}: '$topo_name'");
     }
  }
  print Html->body();
  print "<table border=0><tr><td></table>";
  print Html->header2("monitor.utilities.wiz");

  my $n = $topo_name;
  $n =~ s/MERGE-//;

  print "<table border=0 cellpadding=2 cellspacing=1 width=90% bgcolor=white>
     <tr><td bgcolor=$Style::DARK colspan=2>
     <table border=0 cellspacing=0 width=100%><tr><td>
     <form><input type=hidden name=GO value=GUI::Layout::run>
           <input type=hidden name=topo value=\"$topo_name\">
           <input type=hidden name=FILTER value=\"$filter\">
           <input type=hidden name=width value=\"$q->{width}\">
           <input type=hidden name=height value=\"$q->{height}\">
        <b><font color=white>$LB->{select}</td>
        <td align=right><font color=white>$LB->{topo}: $n / $filter </table></td>
  <tr><td><center><b>Layout1:
          <input type=radio name=Layout value=1 checked><br>
          <img src=/gif/layout1.gif>
      <td><center><b>Layout2:
          <input type=radio name=Layout value=2><br>
          <img src=/gif/layout2.gif>
  <tr><td><center><b>Layout3:
          <input type=radio name=Layout value=3>
          <br>
          <img src=/gif/layout3.gif>
      <td><center><b>Layout4:
          <input type=radio name=Layout value=4>
          <br>
          <img src=/gif/layout4.gif>
  <tr><td colspan=2 align=right><center>$LB->{number}:
      <select name=row_size>
            <option value=\"\">$LB->{auto}
            <option>2</option>
            <option>3</option>
            <option>4</option>
            <option>5</option>
            <option>6</option>
            <option>7</option>
            <option>8</option>
            <option>9</option>
            <option>10</option>
            <option>11</option></select>
       </td>

  </table>
  <b><input type=submit name=ACTION_submit value=\" $LB->{submit} \">
  </form>
  ";
}
1;
