package GUI::Labels;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>


use TO;
use Util;
use System;


sub run {
  my($q) = @_;
  $h = "nsccdemo.central.sun.com";
  
  $to = TO->readTopo($h);

  my($hosts) = $to->hostList();
  my($switches) = $to->switchList();
  my($storages) = $to->storageList();

  print Html->body();
  print "<pre><h3>Labels for topology $h</h3>\n";

  $host = $hosts->[0];
  ($type, $name) = split(/:/, $host->{info}{name});
  print "01 Platform $host->{info}{model}/$name\n";
  print "\n";

  $hbas =  $host->portInfo();
  for ($hba=0; $hba <= $#$hbas; $hba++) {
    $hb = $hbas->[$hba];
    $x = $hb->{path};
    $x =~ /pci\@(\d+)\/.*qlc\@(\d+)/;
    $pci = $1; $port = $2;
    $port = $port % 2;
    $s = substr($host->{info}{name},5);
    $ix = index($s,".");
    $s = substr($s,0,$ix) if ($ix > 0);
    $key = $host->{info}{name} . ":" . $hba;
    $KEY{$key} =  "$s/pci-$pci/port-$port";
  }
  $cnt = 2;

  foreach $sw (@$storages) {
     print sprintf("%2.2d", $cnt) . " Storage  $sw->{info}{type}/$sw->{info}{BoxName}\n";
     $cnt++;
     $KEY{$sw->{info}{name}} = $sw->{info}{BoxName};
  }
  print "\n";
 
  foreach $sw (@$switches) {
     $name = $sw->{info}{sw_ipAddr};
     $ix = rindex($name, ".");
     $name = "sw-" . substr($name,$ix+1);
     $type = $sw->{info}{ProductID};
     print sprintf("%2.2d", $cnt) . " Switch   $type/$name   \n";
     $KEY{"$sw->{info}{name}"} = $name;
     $cnt++;
  }
  print "\n";

  $ports =  $host->port();

  for ($p=0; $p <= $#$ports; $p++) {
     my($type, $wwn, $port) = split(/:/, $ports->[$p]);
     next if (!$type);
     $key = "$type:$wwn";
     print sprintf("%2.2d", $cnt) . " Cable    platform/" . $KEY{$host->{info}{name} . ":$p"}  . 
           " $type/" . $KEY{$key} . "/$port\n";
     $cnt++;
 
  }
  %MAP = ();
  foreach $sw (@$switches) {
     $name = $sw->{info}{sw_ipAddr};
     $ix = rindex($name, ".");
     $name = "sw-" . substr($name,$ix+1);
     my($ports) = $sw->port();

     for ($p=1; $p <= $#$ports; $p++) {
        my($type, $wwn, $port) = split(/:/, $ports->[$p]);
        $key = "$type:$wwn";
        next if (!$type || $type eq "host");
        if ($type eq "host") {
           $v1 = "switch/$name/port-$p";
           $v2 = "platform/" . $KEY{"$key:$port"};
        } else {
           $v1 = "switch/$name/port-$p";
           $v2 = "$type/" . $KEY{$key} . "/port-" . &port($type, $port);
        }
        $k1 = "$v1$v2";
        $k1 = "$v2$v1" if ($v2 lt $v1);
        next if ($MAP{$k1});
        $MAP{$k1} = 1;

        print sprintf("%2.2d", $cnt) . " Cable    $v1  $v2\n";
        $cnt++;
     }
  }
  

  foreach $st (@$storages) {
     my($ports) = $st->port();

     for ($p=1; $p <= $#$ports; $p++) {
        my($type, $wwn, $port) = split(/:/, $ports->[$p]);
        next if ($type ne "host");
      
     }
  }

}

sub port {
  my($type, $port) = @_;
 
  if ($type eq "t3") {
     return ($port == 0)? "1":"2";
  } elsif ($type eq "a5k") {
     return ($port == 0)? "A":"B";
  } else {
     return $port;
  }
}

1;
