package GUI::Islands;
use strict;
use System;
use Util;
use TO;
use vars qw($INC_I $INC_J $PER_ROW $ALT $ROW_CNT $COL_CNT $ALT_X $EXT );


sub empty_node {
  my($x) = @_;
    my $en = {empty => $x, info => {}, port => []};
    bless($en, 'TO::Node');
    return $en;  
}

sub debug {
  my($str, $all_nodes, $x, $y) = @_;
  my $n1 = $all_nodes->[$x];
  my $n2 = $all_nodes->[$y];
  my $name1 = (exists $n1->{empty}) ? " **EMPTY:$n1->{empty}" : $n1->id();
  my $name2 = (exists $n2->{empty}) ? " **EMPTY:$n2->{empty}" : $n2->id();
  print "$str $name1 with $name2 \n";
}




sub print {
  my($q) = @_;
  my $BAGS2 = Util->deserialize("island_list");
  my $renv = System->get_renv();
  print Html->body() . "</center>";
  my($x);
  my $to = TO->readExistingTopo("MERGE-MASTER");
  print "<table border=0 width=100%>
   <tr><td>
      <b><big><font color=navy>Topology Islands Report : $renv->{customer}</td>
    <td align=right>[ <a href=javascript:close()>Close Window</a> ]</table>
   ";
  for ($x=0;$x <= $#$BAGS2; $x++) {
     my @list = split(/\, /, $BAGS2->[$x]);
     $q->{topo} = 'MERGE-MASTER';
     $q->{FILTER} = "island:$x";
     my $cnt = $#list+1;
     my ($parms, $to, $dev_cnt) = TO::Applet->genAppletData($q, undef, undef, $to);
     my $F0 = "island$x.png";
     my $F = System->get_home() . "/DATA/Web/$F0";
     my $Coords = TO::Graph->display($parms, $F, {zoom => 3, width=> 940, height => "MAX"});
     print "<table border=1 cellspacing=0 cellpadding=3 width=95% bgcolor=white>
           <tr><td><b><big><font color=navy>&nbsp;Island-$x :&nbsp; $cnt devices</font></big></b>
             <br><img src=/Web/$F0>";
     print "<pre>" .  $to->toC2(1, "island:$x") . "</table>&nbsp;<p>&nbsp;<p>";
  }
}

# CREATE AND DISPLAY ISLANDS
#
sub report {
  my($q) = @_;
  my ($to, $node_set, $y, $x);
  my $LB = Labels->read("GUI::Island");
  print Html->body();
  my $D = System->get_home() . "/DATA";

  if ($q->{ACTION} eq "group") {
     Grouping->group_islands();
     print "Added Island Grouping!<br>";
  } elsif ($q->{ACTION} eq "regen") {
     unlink "$D/island_list";
  }

  my $island_age  = (stat("$D/island_list"))[9];
  my $merge_age   = (stat("$D/topo/MERGE-MASTER"))[9];
  my ($x,$BAGS2);
  $to = TO->readTopo("MERGE-MASTER");

  if ($merge_age > $island_age || (time - $island_age > 60*60*8) ) {
    my (@BAGS, @all_nodes);
    for ($y=0; $y <= 3; $y++) {
       $node_set = $to->[$y];
       foreach my $el (values %$node_set ) {
         next if ($el->info("mgmtLevel") eq "DS");
         push(@all_nodes, $el) ;
       }
    }
    
    
    foreach my $el (@all_nodes) {
       my $bagno = &findbag($el->name(), \@BAGS);
       my $ports = $el->port();
       foreach my $port (@$ports) {
         my($type,$key,$port) = split(/\:/, $port);
         if ($key && index($BAGS[$bagno], "$type:$key, ") < 0) {
           $BAGS[$bagno] .= "$type:$key, ";
         }
       }
    }
    while (1) {
      my $more = 0;
      for ($x=0; $x <= $#BAGS; $x++) {
         next if ($BAGS[$x] eq "X");
         my @l1 = split(/, /, $BAGS[$x]);
         foreach my $el (@l1) {
           for ($y=0; $y <= $#BAGS; $y++) {
             next if ($y == $x || $BAGS[$y] eq "X");
             if (index($BAGS[$y], "$el,") >= 0) {
                my @B = split(/, /, $BAGS[$y]);
                foreach my $e (@B) {
                   $BAGS[$x] .= "$e, " if (index($BAGS[$x], "$e,") < 0);
                }
                $BAGS[$y] = "X"; $more = 1;
                last;
             }
           }
         }
      }
      last if (!$more);
    }
    my (@BAGS2, @SORT, $others);
    for ($x=0; $x <= $#BAGS; $x++) {
       next if ($BAGS[$x] eq "X");
       my @list = split(/\, /, $BAGS[$x]);
       if ($#list > 0) {
         push(@SORT, sprintf("%4.4d-%d", $#list, $x)) ;
       } else {
         $others .= $BAGS[$x];
       }
    }
    foreach my $e (reverse sort @SORT) {
       my $x = substr($e,5) + 0;
       push(@BAGS2, $BAGS[$x]);
    }
    push(@BAGS2, $others);
    $BAGS2 = \@BAGS2;
    Util->serialize("island_list", $BAGS2);
  } else {
    $BAGS2 = Util->deserialize("island_list");
  }

  my $group = "<a href=$Http::WEBPROC?GO=GUI::Islands::report&ACTION=group>$LB->{group}</a>";
  my $regen = "<a href=$Http::WEBPROC?GO=GUI::Islands::report&ACTION=regen>$LB->{re}</a>";
  my $right = "$group | $regen | <a href=$Http::WEBPROC?GO=GUI::Islands::print target=pr2>$LB->{print}</a>";

  print Html->header2("monitor.islands","95%",undef,undef,{right => $right} );

  my $out = "<table border=1 cellspacing=0 bgcolor=white width=95%>
   <tr bgcolor=$Style::LIGHT>
       <th>$LB->{island} <th>$LB->{member}<th>$LB->{members}";

  my $ino = 0;
  for ($x=0;$x <= $#$BAGS2; $x++) {
     my @list = split(/\, /, $BAGS2->[$x]);
     my $url = "<a href=$Http::WEBPROC?GO=GUI::Graph::run3&topo=MERGE-MASTER&FILTER=island:$x target=main>Island-$x</a>";
     my @list = split(/\, /, $BAGS2->[$x]);
     next if ($#list < 0);
     $out .= "<tr><td><center>$url</td>";
     $out .= "<td><center>" . ($#list+1) ."</td><td>";
     $out .= "<small>" if ($#list > 20);
     foreach my $n (@list) {
       if (substr($n,0,3) ne "hub") {   
          my $node = $to->nodeByName($n);
          $out .= $node ? $node->id()  . ", " : "$n, ";
       } else {
          $out .= "hub '" . substr($n,-6) . "', ";
       }
     }
  }
  $out .= "</table>";
  print $out;
  print "<table border=0 width=60%><tr><td>&nbsp;<br>$LB->{info}</table>";
}

sub findbag {
  my($k, $BAGS) = @_;
  my $x;
  for ($x=0; $x <= $#$BAGS; $x++) {
     if (index($BAGS->[$x], "$k, ") >= 0){
        return $x;
     }
  }
  push(@$BAGS, "$k, ");
  return $#$BAGS;
}


1;

