package GUI::Hosts;

#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Id: Hosts.pm,v 1.125 2003/04/23 18:41:13 ccadieux Exp $

use Labels;
use Net::Ping;
use AdminGroup;
use Util::Http;
use Agent;
use System;
use GUI::Config;
use GUIAdmin;
use Events;
use GUI;
use Logic::Slave;

# new one is pushSlaves, old is push_slaves

sub pushSlaves {
  my($q) = @_;
  my ($x);
  my $G = Labels->read();
  my $L = Labels->read('GUI::Hosts');
  print Html->body();

  if (my $deny = Roles->verifyRole($q, "admin")) {
     print $deny;
     return;
  }
  my ($renv, $dev, $hosts,$notifs) = PDM::ConfigFile->read;

  if ($q->{ACTION_u} || $q->{ACTION_a} ) {
     my $list = ",";
     foreach my $x (keys %$q) {
        if (substr($x,0,4) eq "sel_") {
          $list .= substr($x,4) . ",";
        }
     }
     %T = (C => $L->expand('push.p_c'), M => $L->expand('push.p_m'), 
           B => $L->expand('push.p_b') );
     my $cntS = 0;
     foreach my $h (@$hosts) {
        next if ($h->{dh} eq "Y");
        if ($q->{ACTION_a} || index($list, ",$h->{hostname},") >= 0) {
           print "'$T{$q->{action}}' :  $h->{hostname} /$h->{ip} ... <br>";
           $cntS++;
           if ($q->{action} eq "C" || $q->{action} eq "B") {
             my $rc = Logic::Slave->push($h) ;
             print substr($rc,3) if ($rc);
           }
           if ($q->{action} eq "M" || $q->{action} eq "B") {
              if ($q->{master}) {
                Util::Http->saveFile($h->{ipno} || $h->{hostname}, "MASTER", $q->{master});
                print $L->expand('push.err_1', $q->{master}, $h->{hostname});
              } else {
                print $L->expand('push.err_2', $h->{hostname});
              }
           }
        }
     }
     if ($cntS) {
       PDM::ConfigFile->write($renv, $dev, $hosts, $notifs);
     } else {
       print " <b><font color=red>--> $G->{nothing_sel}</font></b><br>\n";
     }
  }
  print Html->header2("admin.gen_maint.push" );

  if ($#$hosts < 0) {
    print "<center><h2><font color=red>$G->{no_slave}";
    return;
  }

  my $m = System->ifconfigs();
  my $master_list = "<select name=master><option value=\"\">[$G->{no_change}]";
  foreach my $x (@$m) {
     next if ($x->[1] eq "127.0.0.1");
     $master_list .= "<option value=\"$x->[1]\">$x->[0]: $x->[1]</option>";
  }
  $master_list .= "</select>";
  my $S = Util->makeSelect("action", 
        "C=$L->{'push.p_c'}|M=$L->{'push.p_m'}|B=$L->{'push.p_b'}", $q->{action});

  print "<table border=1 cellspacing=0 bgcolor=white width=90%>
  <form><input type=hidden name=GO value=GUI::Hosts::pushSlaves>
  <tr><td colspan=2 bgcolor=$Style::DARK><font color=white><b>$G->{select_action}
  <tr><td colspan=2>
    <table border=0 cellpadding=4 cellspacing=1 bgcolor=$Style::LIGHT width=100%>
       <tr><td><b> $S </td>
       <td><b>$L->{'push.l1'}:
             <td><b>$master_list</td>
    </table>
  <tr><td colspan=2 bgcolor=$Style::DARK><b><font color=white>$L->{'push.l2'}</td>";

  my $tot;
  my ($col2, @L);
  foreach $h (@$hosts) {
     $tot++;
    if ($h->{dh} eq "Y"){
       $col2 .= "&nbsp;N/A DataHost: $h->{hostname}<br>"; 
    }else{
       push(@L, $h->{hostname});
       $col2 .= "<input type=checkbox name=sel_$h->{hostname}> $h->{hostname}<br>";
    }

  }
  @L = sort @L;

  if ($tot > 0) {
    print "<tr><td>$col2&nbsp;</td>";
  }  else {
    print "<tr><td colspan=2><b>&nbsp;<font color=red>$L->{'push.err_3'}</td>";
  }

  print "</table>
   <table border=0 width=90%>
   <tr><td><b><input type=submit name=ACTION_u value=\"$L->{'push.submit1'}\">
       <td align=right><b><input type=submit name=ACTION_a value=\"$L->{'push.submit2'}\">
   </table>
        ";
  
}


sub list {
  my($q) = @_;
  my($ho, $o);

  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read('GUI::Hosts');

  print Html->body();
  if ( Util->findMaster()) {
    print "\n<body bgcolor=white><h1><center>$G->{e_101}";
    return;
  }
  my $ruser = System->get_ruser();
  $q->{GROUP} = $ruser->{adm_group} if (!exists $q->{GROUP} && $ruser->{adm_group});
 
  my $groups = AdminGroup->new();

  if ($q->{ACTION_upd2} || $q->{ACTION_upd}) {
     my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
     my ($err, $done, %MAP) ;
     foreach my $e (keys %$q) {
       if (substr($e,0,6) eq "group_") {
          my $no = substr($e,6);
          my $val = Util->trim($q->{$e});
          #next if (!$val);
          if ($val && (!exists $groups->{$val}) ) {
            $err .= "$val, ";
          } elsif ($no == 0) {
            $renv->{adm_group} = $val;
            $MAP{""} = $val;
            $done++;
          } else {
            $hosts->[$no-1]{adm_group} = $val;
            $MAP{$hosts->[$no-1]{hostname}} = $val;
            $done++;
          }
       }
     }
     if ($q->{ACTION_upd2}) {
       foreach my $dev (@$devs) {
          $dev->{adm_group} = $MAP{$dev->{host}} if (exists $MAP{$dev->{host}});
       }
     }
     PDM::ConfigFile->write($renv, $devs, $hosts, $notifs) if ($done);
     print Html->warning("Invalid group(s): $err") if ($err);

  } elsif ($q->{ACTION_1}) {
     &add($q);
     return;
  } elsif ($q->{ACTION_3}) {
     &pushSlaves($q);
     return;
  }
  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  if (!$renv->{site_country}) {
     $q->{SITE_FIRST} = 1;
     GUI::Config::site($q);
     return;
  }
  my($ping) = ($q->{ACTION_2})? 1:0;

  $head  = Html->header2("admin.gen_maint.maintain_hosts");

  my(%CNT);

  for ($x=0; $x <= $#$dev; $x++) {
    $h = $dev->[$x];
    $CNT{$h->{host} || "LOCAL"}++;
    if (!$h->{host}) {
       $dev_cnt++;
    }
  }
  my @H;

  for ($x=0; $x <= $#$host; $x++) {
     next if ($q->{GROUP} && ($host->[$x]{adm_group} ne $q->{GROUP}));
     push(@H, "$host->[$x]{hostname} | $x");
  } 
  foreach my $h2 (sort @H) {
    my ($name1, $x) = split(/ \| /, $h2);
    my ($hostid, $version);
    $h = $host->[$x];
    $lnk = "<a href=$Http::WEBPROC?GO=GUI::Hosts::upd&no=$x><b>$h->{hostname}</b></a>";
    use Net::Ping;
    $p = Net::Ping->new();

    $alive = "";
    if ($ping) {
      if ($h->{active} eq "N") {
        $alive = "(Inactive)";
      } else {
        print "Pinging $h->{ip}...<br>";
        $ix = index($h->{ip}, ":");
        $ip = ($ix > 0)? substr($h->{ip},0,$ix) : $h->{ip};
        eval {
          $alive   = ($p->ping($ip,4))? $L->{alive} : $L->{unaccessible};
        };
        my $ss = Util::Http->getCommand($h->{ip},"INFO1", 30) || "Error";
        if ($ss ne "Error") {
          ($hostid, $version) = split(/ *\| */, $ss);
          $h->{hostid} = $hostid if (!$h->{hostid});
        }
      }
    }
    $cnt = $CNT{$h->{hostname}} + 0;
#    use POSIX2;
#    if ($h->{last_push}) {
#       $push .= POSIX::strftime("%b", 0,0,0,0,substr($h->{last_push},0,2),0) 
#                . substr($h->{last_push},2);
#    }
    $active = $h->{active} || "N";
    my $c1 = ($active eq "N")? "bgcolor=#FFC0C0":"";
    $active = $active eq "Y" ? $G->{yes} : $G->{no};
    $x2 = "&nbsp;$alive";
    $x2 .= "/ $hostid - $version" if ($hostid);
    $am = $h->{role} eq "AM" ? $G->{alt}: $G->{slave}; 
    $am = " $G->{dh}" if ($h->{dh} eq "Y");
    my $sol= "SE-".$h->{solution_model} if ($h->{solution} ne "N");

    $push = $h->{last_push};
    if ($push =~ /FAILED/) {
      $push = "<td nowrap bgcolor=#F0D0D0>&nbsp;$push</td>";
    } else {
      $push = "<td nowrap>&nbsp;$push</td>";
    }
    my $gr2 = $h->{adm_group} ; 
       #"<input type=text size=8 maxlength=8 name=group_" . ($x+1) . " value=\"$h->{adm_group}\">";

    $ho .= "<tr>
                <td>&nbsp;$lnk</td>
                <td>&nbsp;$am $sol</td>
                <td align=right>$cnt&nbsp;</td>
                <td>&nbsp;$h->{ipno}</td>
                <td $c1><center>$active</td>
                <td>$x2</td>
                <td><center>$gr2&nbsp;</td>
          ";
  }
  if ($ping) {
      PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
  }
  $comment = GUI->needToPush($host);

  $hid   =  System->hostid(); 
  $hname = System->hostname();
  my $IPS = System->ifconfigs();
  $ip = "";
  foreach my $i (@$IPS) {
     $ip .= " $i->[1]," if ($i->[1] ne "127.0.0.1");
  }
  chop($ip) if ($ip);

  if ($#$host < 0 && $renv->{solution} eq "N") {
     $ho .= "<tr><td colspan=7>&nbsp;$L->{'hosts.no_sl'}</td>";
  }
  $local_active = (-f System->get_home() . "/DATA/start")? "Y":"N";
  my $c1 = ($local_active eq "N")? "bgcolor=#FFC0C0":"";
  my $sol= "SE-".$renv->{solution_model} if ($renv->{solution} ne "N");

  my $groupsD = $groups->select("GROUP", $q->{GROUP}, $L->{'hosts.all_groups'});
  my $gr2 = $renv->{adm_group} ;
     #"<input type=text size=8 maxlength=8 name=group_0 value=\"$renv->{adm_group}\">";
  my $all_hosts = "[ <a href=$Http::WEBPROC?GO=GUI::Hosts::updAll>$L->{'hosts.l2'}</a> ]" if ($renv->{solution} eq "N");
  $o =<<EOF;

<body bgcolor=$Style::BGCOLOR>
<form  method=get>
 <input type=hidden name=GO value=GUI::Hosts::list>
<center>
$head
$q->{ERR}
 $comment
<table border=0 cellspacing=0 width=90%><tr><td align=right> $all_hosts </table>
  
<table border=1 cellspacing=0 cellpadding=2 width=90% bgcolor=white>
<tr><td colspan=7 bgcolor=$Style::DARK>
  <table border=0 cellspacing=0 width=100% cellpadding=2><tr>
    <td><b><font color=white>&nbsp;$L->{'hosts.l1'}</td>
    <td align=right><b>
          <font color=white>$L->{'hosts.ag'}: $groupsD
          <input type=submit name=ACTION_grp value=GO>
  </table>
<tr>
    <td bgcolor=$Style::LIGHT><center><b>$L->{'hosts.l3'}</td>
    <td bgcolor=$Style::LIGHT><center><b>$L->{'hosts.type'}</td>
    <td bgcolor=$Style::LIGHT><center><b>$L->{'hosts.l4'}</td>
    <td bgcolor=$Style::LIGHT><center><b>$L->{'hosts.l5'}</td>
    <td bgcolor=$Style::LIGHT><center><b>$L->{'hosts.l7'}</td>
    <td bgcolor=$Style::LIGHT><center><b>$L->{'hosts.l8'}</td>
    <td bgcolor=$Style::LIGHT><center><b>$L->{'hosts.group'}</td>
<tr>
    <td><b>&nbsp;<a href=$Http::WEBPROC?GO=GUI::Config::upd>$hname</a></td>
    <td><b>&nbsp;$G->{master} $sol</td>
    <td align=right>$CNT{LOCAL}&nbsp;</td>
    <td>&nbsp;$ip</td>
    <td $c1><center>$G->{$local_active}</td>
    <td>&nbsp;</td>
    <td><center>$gr2&nbsp;</td>
$ho
</table>
&nbsp;<br>
<b>
EOF
   print $o;
   if (!$deny && $renv->{solution} eq "N") {
      print <<EOF;
 <table border=0 cellspacing=0 width=90%>
  <tr><td valign=top><center><b>
    <input type=submit name=ACTION_1 value="$L->{'hosts.submit1'}">
    <input type=submit name=ACTION_2 value="$L->{'hosts.submit2'}">
  <td align=right><b>
 </table>
</form>
EOF
   } 
}
#    <input type=submit name=ACTION_upd value="$L->{'hosts.submit_gr'}"><br>
#    <input type=submit name=ACTION_upd2 value="$L->{'hosts.submit_gr2'}"><br></b>
#     ($L->{'hosts.include_dev'})


sub push_slaves {
  my($q, $hostlist) = @_;

  ($renv, $dev, $hosts,$notifs) = PDM::ConfigFile->read();
  foreach $h (@$hosts) {
     next if ($hostlist and index(",$hostlist," , ",$h->{hostname},") < 0);
     print "Pushing Config to $h->{hostname} /$h->{ip} ... <br>";
     my $rc = Logic::Slave->push($h);
     print substr($rc,3) if ($rc);
  }
  PDM::ConfigFile->write($renv, $dev, $hosts, $notifs);
}



sub add {
  my($q) = @_;
  my($ho, $o, $err, $cat, $err1);

  print Html->body();
  my($categories) = Agent->findSelectableAgents();
  my $G = Labels->read();
  my $L = Labels->read('GUI::Hosts');

  if ($q->{ACTION_back}) {
    &list($q);
    return;

  } elsif ($q->{ACTION_add}) {
    $q->{hostid} = lc($q->{hostid});
    while (1) {
     if ($q->{hostid} eq System->hostid) {
        $err = $L->expand('host_add.err_1') . "<br>";
        last;
     } elsif ($err1) {
        $err1 = "<font color=red>$err1</font>";
        $err .=  $L->expand('host_add.err_1') ;
        last;
     } elsif (!$q->{hostname}) {
        $err .=  $L->expand('host_add.err_3') ;
        last;
     } else {
        $done = 0;
        if (index($q->{hostname} , ".") < 0) {
           $save = $q->{hostname};
           $q->{hostname} .= "." . lc(System->domain());
           $ipno = Util->name2ip($q->{hostname});
           if (!$ipno) {
             $q->{hostname} = $save;
           } else {
             $done = 1;
           }
        }
        if (!$done) {
          $ipno = Util->name2ip($q->{hostname});
          if (!$ipno) {
             $err .= $G->expand("host_add.e_111", $q->{hostname});
             last;
          }
        }
        my $sp_info = Util->rasInfo($ipno);
        if ($sp_info->{solution} =~ /se/) {
           $err .= "Cannot add a Sun Solution ($sp_info->{solutionModel}) as a host!";
           last;
        }
   
        ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
        my %EXIST;
        foreach $x (@$host) {
          $EXIST{$x->{ipno}}= 1; 
        }
        if ($EXIST{$ipno}) {
           print Html->error($L->expand('host_add.err_4', "IPNO"));
           last;
        }
        $x = $#$host + 1;
        $cat = "";
        foreach my $c (@$categories) {
          my(@bb) = split(/=/, $c);
          $cat .= "$bb[0]|" if ($q->{$bb[0]});
        }
        my $hostid = $sp_info->{hostid};

        if ($hostid ne "Error") {
           $host->[$x]{hostid}   = $hostid;
        } else {
           if ($q->{hostid} !~ /^\w\w\w\w\w\w\w\w$/ && lc(System->os) !~ /linux/) {
             $err .= $L->expand('host_add.err_5') . "<br>";
             last;
           }
           $host->[$x]{hostid}   = $q->{hostid};
        }
        if ($sp_info->{master} =~ /=Y/) {
            print Html->warning($L->expand('host_add.err_6', $q->{hostname}));
        }

        chop($cat) if ($cat);
        $host->[$x]{categories} = $cat;
        $host->[$x]{_name}    = "host" . ($x+1);
        $host->[$x]{hostname} = $q->{hostname};
        $host->[$x]{ip}       = $q->{hostname};
        $host->[$x]{active}   = "N";
        $host->[$x]{role}     = $q->{role}? "AM" : "S";
        $host->[$x]{ipno}     = Util->name2ip($q->{hostname});
        $host->[$x]{datahost} = $q->{inBandDataPath} ? "Y":"N";
        
        $host->[$x]{show_monitored_only} = $q->{show_monitored_only}? "Y":"N";
        $host->[$x]{frequency}= $q->{frequency} || 10;
        $host->[$x]{contract} = $q->{contract} if ($q->{contract});
        $host->[$x]{logfile}  = "/var/adm/messages";
        $host->[$x]{t300logfile} = $q->{t300logfile} ;
#        $q->{ping} =~ s/ *[\|\:\#]+ */#/g;
#        $q->{ping} =~ s/ *[\n\r]+ */|/g;
#        $host->[$x]{ping}       = $q->{ping};

        GUIAdmin->clearSlave($q->{hostname}, $host);
        unlink System->get_home() . "/DATA/snapshot_db";

        Util::Http->saveFile($host->[$x]{ipno}, "MASTER", $renv->{hostname});

        if (!PDM::ConfigFile->write( $renv, $dev, $host,$notifs)) {
           print Error->error(101, $CONF)->toHtml();
           
        } else {
           $info = Html->error($L->expand('host_add.added'));
#           &main::save_event("AH", $q->{hostid});
           print $L->expand('host_add.added');
        }
        &list($q);
        return;
      }
    }
  }


  $h = Html->header2("admin.gen_maint.add_hosts");
  print Html->error($err) if ($err);

  $q->{logfile}     = "/var/adm/messages";
  $q->{hostid}      = "12345678" if (!$q->{hostid});

  my($modules_html) = "<table border=0 cellspacing=2 bgcolor=#F0F0F0 width=100%><tr><td>
   <table border=0 cellspacing=0 cellpadding=0 >";
  my $cnt = -1;
  foreach my $mod (@$categories) {
     $modules_html .= "</table></td><td valign=top><table border=0 cellspacing=0 cellpadding=0 >" if (++$cnt % 8 == 0);
     my(@bb) = split(/=/, $mod);
     my($ck) = "checked" if ($q->{$bb[0]});
     $modules_html .= "<tr><td valign=top><input type=checkbox name=$bb[0] $ck>:</td><td nowrap>$bb[1]";
  }
  $modules_html .= "</table></table>";
  $frequency = Html->select_frequency($q, $L->{'hosts.select'});

  $o =<<EOF;
<body bgcolor=#F0F0F0>
<form  method=get>
 <input type=hidden name=GO value=GUI::Hosts::add>
<center>
$h
<script>
function win1(a) {
  var O = window.open('tradenames.html','err','menubar=no,resizable=yes,scrollbars=yes,width=400,height=500');
  O.focus();
}
</script>

<table border=1 cellspacing=0 cellpadding=2 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr><td colspan=4 bgcolor=$Style::DARK><b><font color=white>&nbsp;$L->{'host_add.title'}</td>
<tr><td bgcolor=$Style::LIGHT align=right width=30%>$L->{'host_add.l1'}:</td>
    <td colspan=3><input type=text name=hostid size=8 maxlength=8 value="$q->{hostid}">
<tr><td bgcolor=$Style::LIGHT  align=right width=30%>$L->{'host_add.l2'}:</td>
    <td colspan=3><input type=text name=hostname size=40 maxlength=40 value="$q->{hostname}">

<tr><td bgcolor=$Style::LIGHT align=right nowrap>$L->{'host_add.l3'}:</td>
    <td colspan=3><input type=ip size=20 maxlength=20 name=contract value="$q->{contract}">

<tr><td bgcolor=$Style::LIGHT align=right>
     &nbsp;$L->{'host_add.l4'}<br><a href=javascript:win1()>$L->{'host_add.l5'}</td>
 <td colspan=3>
   $modules_html
 </td>
<tr><td bgcolor=$Style::LIGHT align=right>
     &nbsp;$L->{'host_add.l6'}: </td>
    <td colspan=3>$frequency</td>
<tr><td bgcolor=$Style::LIGHT align=right>$L->{'host_add.l7'}: </td>
    <td colspan=3>&nbsp;<input type=checkbox name=role></td>
<tr>
    <td bgcolor=$Style::LIGHT align=right>$L->{'host_add.l9'}: </td>
    <td>&nbsp;<input type=checkbox name=inBandDataPath></td>
<tr><td align=right bgcolor=$Style::LIGHT>
     $L->{'host_add.l10'}: </td>
    <td>&nbsp;<input type=checkbox name=show_monitored_only>


<tr><td colspan=4 bgcolor=silver><b>&nbsp;$L->{'host_add.l11'}</td>

<tr><td bgcolor=$Style::LIGHT align=right>$L->{'host_add.l12'}:</td>
    <td colspan=3><table border=1 cellspacing=0><tr><td>$q->{logfile}</table></td>
<tr><td bgcolor=$Style::LIGHT align=right>$L->{'host_add.l13'}:</td>
    <td colspan=3><input type=text name=t300logfile size=50 maxlength=60 value="$q->{t300logfile}">



</table>
</table>
<b>
<input type=submit name=ACTION_add value=\"$L->{'host_add.submit1'}\">
<input type=submit name=ACTION_back value=\"$L->{'host_add.submit2'}\">
</form>
EOF

  print $o;

}

sub dh_upd {
  my($q) = @_;
  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read('GUI::Hosts')->section('host_upd');
  print Html->body();

  if ($q->{ACTION_back}) {
    &list($q);
    return;

  } elsif ($q->{ACTION_delete}) {
    &delete_host($q);
    &list($q);
    return;
  }
  my($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;

  my $h = $host->[$q->{no}];
  if (open(O, System->get_home() . "/DATA/DataHost/$h->{hostname}.info")) {
     while ($l = <O>) {
        chop($l);
        my ($a, $b) = split(/\=/, $l, 2);
        $h->{$a} = $b;
     }
     close(O);
  }

  $active = ($h->{active} eq "Y")? $L->{host_on} : $L->{host_off} ;

  print Html->header2("admin.gen_maint.maintain_host", undef, undef, "data_host_upd");

  $o =<<EOF;

<form  method=get>
 <input type=hidden name=GO value=GUI::Hosts::dh_upd>
 <input type=hidden name=no value=$q->{no}>
 <input type=hidden name=hostid value=$h->{hostid}>
<center>
<table border=1 cellspacing=0 cellpadding=2 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100% cellpadding=3>
<tr><td colspan=4 bgcolor=$Style::DARK><b><font color=white>&nbsp;$L->{dh_label}</td>
<tr><td bgcolor=$Style::LIGHT width=20% align=right>$L->{hostid}:</td>
    <td ><table border=1 cellspacing=0><tr><td>$h->{hostid}&nbsp;</table></td>
    <td colspan=2 align=right><b>$active</td>
<tr><td bgcolor=$Style::LIGHT width=20% align=right>$L->{name}:</td>
    <td colspan=3><b>&nbsp;$h->{hostname}

<tr><td bgcolor=$Style::LIGHT align=right >$L->{ip}:</td>
    <td colspan=3><b>&nbsp;$h->{ipno}

<tr><td bgcolor=$Style::LIGHT align=right>
     $L->{freq}: </td>
    <td colspan=3>$h->{frequency}</td>
<tr><td bgcolor=$Style::LIGHT align=right>$G->{dh}: </td>
    <td>DataHost Slave</td>

<tr><td align=right bgcolor=$Style::LIGHT width=40%>
     $L->{push_only}: </td>
    <td>Yes</td>

<tr><td align=right bgcolor=$Style::LIGHT width=40%>
     Admin_Email: </td>
    <td>$h->{admin_email}</td>

<tr><td bgcolor=$Style::LIGHT align=right>$L->{log1}:</td>
    <td colspan=3><table border=1 cellspacing=0><tr><td>$h->{logfile}</table></td>

</table>
</table>
<b>
EOF
   print $o;
   if (!$deny) {
     print <<EOF;
<input type=submit name=ACTION_delete value="$G->{submit_delete}">
<input type=submit name=ACTION_back value="$G->{submit_back}">
EOF
   }
   print "</form>";

}

#<tr><td colspan=2 bgcolor=silver><b>&nbsp;Enter DataPing Directories (One dir/file per line)</td>
#<tr><td colspan=2>$err1
#      <textarea name=ping cols=60 rows=12>$q->{ping}</textarea></td>

sub delete_host {
  my($q) = @_;

  my $G = Labels->read();
  my $L = Labels->read('GUI::Hosts')->section('host_upd');

  my($renv, $dev, $host,$notifs) = PDM::ConfigFile->read();
  my $x = $q->{no};
  my $hostid = $host->[$x]{hostid};
  my $hn = $host->[$x]{hostname};
  unlink(System->get_home() . "/DATA/topo/$hn") if ($hn);
  State->clearComponent("host:$hn");
  State->write();
  $host->[$x]{_name} = "";
  unlink System->get_home() . "/DATA/REMOTE_LISTS/$hn";

  $name = $host->[$x]{hostname} . "/ " . $host->[$x]{ip};
  my $del;
  foreach my $d (@$dev) {
      if ($d->{host} eq $hn) {
          $del++;
          delete $d->{_name};
      }
  }
  PDM::ConfigFile->write( $renv, $dev, $host,$notifs);

  &main::log_change($L->expand('deleted',  $name));
  my $n = " (with $del devices)" if ($del);
  $q->{ERR} = Html->error($L->expand('deleted', $name, $n )); 
  Events->saveEvent("DH", $hn);
  $rc = Util::Http->getCommand($host->[$x]{ip}, "DELET&file=start",  30);
}

sub upd {
  my($q) = @_;
  my($ho, $o, $err2);
  my($name, $err);
  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read('GUI::Hosts')->section('host_upd');

  my($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  my $h = $host->[$q->{no}];
  if ($h->{dh} eq "Y") {
    &dh_upd($q);
    return;
  }
  print Html->body();
  my($categories) = Agent->findSelectableAgents($h->{solution} );

  if ($q->{ACTION_back}) {
    &list($q);
    return;
  } elsif ($q->{ACTION_delete}) {
    &delete_host($q);
    &list($q);
    return;

  } elsif ($q->{ACTION_update}) {
    $q->{hostid} = lc($q->{hostid});
    while (1) {
#     if ($q->{ping}) {
#        @a = split(/ *[\n\r]+ */, $q->{ping});
#        $err1 = "";
#        foreach $p (@a) {
#           @l = split(/ *[\:\|\#] */, $p);
#           if (!(-d $l[0] || -f $l[0])) {
#              $err1 .= "Cannot read path: $l[0]<br>";
#           }
#        }
#     }
     if ($err1) {
        $err1 = "<font color=red>$err1</font>";
        $err = Html->error($L->{err_1});
        last;
     } elsif ($q->{hostid} eq System->hostid) {
        $err = Html->error($L->{err_2});
        last;
     } else {
        $x = $q->{no};
        $cat = "";
        foreach my $h (@$host) {
             $h->{role} = "S" if ($q->{role});
        }
        foreach my $c (@$categories) {
          my(@bb) = split(/=/, $c);
          $cat .= "$bb[0]|" if ($q->{$bb[0]});
        }
        chop($cat) if ($cat);
        my($H) = $host->[$x];

        if ($H->{categories} ne $cat) {
          &main::log_change($L->expand('err_3',$H->{hostname}, $H->{categories}, $cat) );
        }
        $host->[$x]{categories} = $cat;

        $host->[$x]{role}     = $q->{role} ? "AM" : "S";
        if (!$host->[$x]{ipno}) {
           $host->[$x]{ipno} = Util->name2ip($host->[$x]{hostname});
        }
        $host->[$x]{last_push}  = "";
        $host->[$x]{contract} = $q->{contract};
        if ($H->{frequency} ne $q->{frequency}) {
           &main::log_change($L->expand('err_4', $H->{hostame}, $H->{frequency}, $q->{frequency}));
        }
        $host->[$x]{frequency}= $q->{frequency} || 5;
        $host->[$x]{datahost} = $q->{inBandDataPath} ? "Y":"N";
        $host->[$x]{dh}       = $q->{dh} ? "Y":"N";
        $host->[$x]{show_monitored_only} = $q->{show_monitored_only}? "Y":"N";
        $host->[$x]{logfile}  = "/var/adm/messages";
        my $t3l =  $q->{t300logfile};
        $t3l =~ s/[\n\r]/ /;
        $t3l =~ s/\s+/ /;
        $host->[$x]{t300logfile} = $t3l;
#        $q->{ping} =~ s/ *[\|\:\#] */#/g;
#        $q->{ping} =~ s/ *[\n\r]+ */|/g;
#         $host->[$x]{ping}       = $q->{ping};

        GUIAdmin->clearSlave($host->[$x]{hostname}, $host);

        if (!PDM::ConfigFile->write( $renv, $dev, $host,$notifs)) {
           print "Cannot write to ConfigFile $CONF<br>";
        } else {
           $err2 = Html->info($L->{updated_1});
        }
     }
     last;
    }
  }
out:

  $h1 = Html->header2("admin.gen_maint.maintain_host");

  my($modules_html) = "<table border=0 cellspacing=2 bgcolor=#F0F0F0 width=100%><tr>";
  my $cnt;
  foreach my $mod (@$categories) {
     my(@bb) = split(/=/, $mod);
     $modules_html .= "</td><td valign=top>" if ($cnt++ % 8 == 0);
     my($ck) = "checked"  if (index("|$h->{categories}|", "|$bb[0]|" ) >= 0);
     $modules_html .= "<input type=checkbox name=$bb[0] $ck>:$bb[1]<br>";
  }
  $modules_html .= "</table>";
  # my $topoType = Util->makeSelect("topo_type","ib=$G->{inband}|oob=$G->{oob}", $h->{topo_type});
  $ping = $h->{ping};
  $ping =~ s/\|/\n/g;
  $ping =~ s/#/  #/g;
  $frequency = Html->select_frequency($h);

  my $role_ck = "checked" if ($h->{role} eq "AM");

  $active = ($h->{active} eq "Y")? $L->{host_on} : $L->{host_off} ;
  my $inBandDataPath = ($h->{datahost} eq "Y")? "checked":"";



  my $dh = ($h->{dh} eq "Y")? "checked":"";
  my $ck2 = ($h->{show_monitored_only} eq "Y") ? "checked":"";
  $o =<<EOF;

<body bgcolor=$Style::BGCOLOR>
<form  method=get>
 <input type=hidden name=GO value=GUI::Hosts::upd>
 <input type=hidden name=no value=$q->{no}>
 <input type=hidden name=hostid value=$h->{hostid}>
<center>
$h1
$err $err2
<script>
function win1(a) {
  var O = window.open('tradenames.html','err','menubar=no,resizable=yes,scrollbars=yes,width=400,height=500');
  O.focus();
}
</script>
<table border=2 cellspacing=2 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr><td colspan=4 bgcolor=$Style::DARK><b><font color=white>&nbsp;$L->{label}</td>
<tr><td bgcolor=$Style::LIGHT width=20% align=right>$L->{hostid}:</td>
    <td ><table border=0 cellspacing=1><tr><td>$h->{hostid}&nbsp;</table></td>
    <td colspan=2 align=right><b>$active</td>
<tr><td bgcolor=$Style::LIGHT width=20% align=right>$L->{name}:</td>
    <td colspan=3><b>&nbsp;$h->{hostname}

<tr><td bgcolor=$Style::LIGHT align=right >$L->{ip}:</td>
    <td colspan=3><b>&nbsp;$h->{ipno}

<tr><td bgcolor=$Style::LIGHT align=right>$L->{contract}&nbsp;:</td>
    <td colspan=3><input type=ip size=20 maxlength=20 name=contract value="$h->{contract}">

<tr><td bgcolor=$Style::LIGHT align=right>&nbsp;$L->{cat} <br><a href=javascript:win1()>$L->{abb}</td>
    <td colspan=3>
    $modules_html
 </td>
<tr><td bgcolor=$Style::LIGHT align=right>
     $L->{freq}: </td>
    <td colspan=3>$frequency</td>
<tr><td bgcolor=$Style::LIGHT align=right>$L->{alt}: </td>
    <td ><input type=checkbox $role_ck name=role></td>
<tr>
    <td bgcolor=$Style::LIGHT align=right>$L->{inband}: </td>
    <td ><input type=checkbox name=inBandDataPath $inBandDataPath></td>
<tr><td align=right bgcolor=$Style::LIGHT width=40%>
       $L->{show}: </td>
    <td colspan=3><input type=checkbox name=show_monitored_only $ck2></td>


<tr><td colspan=4 bgcolor=silver><b>&nbsp;$L->{label2}</td>
<tr><td bgcolor=$Style::LIGHT align=right>$L->{log1}:</td>
    <td colspan=3><table border=0 cellspacing=2><tr><td>$h->{logfile}</table></td>
<tr><td bgcolor=$Style::LIGHT align=right>$L->{log2}:</td>
    <td colspan=3>
     <textarea name=t300logfile cols=50 rows=3>$h->{t300logfile}</textarea>


</table>
</table>
<b>
EOF
   print $o;
   if (!$deny) {
     print <<EOF;
<input type=submit name=ACTION_update value="$G->{submit_update}">
<input type=submit name=ACTION_delete value="$G->{submit_delete}">
<input type=submit name=ACTION_back value="$G->{submit_back}">
EOF
   }
   print "</form>";

}

sub uniq {
  my($v1, $v2) = @_;
  my @NEW = split(/\|/, $v2);
  foreach my $x (@NEW) {
    if (index("|$v1|", "|$x|") < 0) {
       $v1 .= "|$x";
    }
  }
  return $v1;
}

sub updAll {
  my($q) = @_;
  my($ho, $o, $err, $cat, $err1);

  print Html->body();
  my($categories) = Agent->findSelectableAgents();

  my $LB = Labels->read('GUI::Hosts')->section('all');

  if ($q->{ACTION_back}) {
    &list($q);
    return;

  } elsif ($q->{ACTION_update}) {
    $q->{hostid} = lc($q->{hostid});

    ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;

    foreach my $c (@$categories) {
          my(@bb) = split(/=/, $c);
          if ($q->{$bb[0]}) {
             $cat .= "|" if ($cat);
             $cat .= $bb[0];
          }
    }
    $renv->{categories} = $cat;
    $renv->{frequency}   = $q->{frequency} || 10;
    my %CAT;
    if ($q->{autocheck}) {
      foreach my $d (@$dev)  {
         my $h = $d->{host} || "LOCAL";
         $CAT{$h} .= "$d->{type}|" if (index("|$CAT{$h}|", "|$d->{type}|") < 0);
      } 
      $renv->{categories} = &uniq($cat, $CAT{LOCAL});
    }

    foreach my $h (@$host) {
       if ($q->{autocheck}) {
          $h->{categories} = &uniq($cat, $CAT{$h->{hostname}}) ;
       } else {
          $h->{categories} = $cat;
       }
       $h->{frequency}  = $q->{frequency} || 10;
    }

    if (!PDM::ConfigFile->write( $renv, $dev, $host,$notifs)) {
       print "Cannot write to ConfigFile $CONF<br>";
    } else {
       print "All hosts are updated!";
    }
    &list($q);
    return;
  }
out:

  $h = Html->header($LB->{title});
  $q->{logfile}     = "/var/adm/messages";
#  $q->{t300logfile} = "/var/adm/messages.t3" if (!$q->{t300logfile} && !$err);

  my($modules_html) = "<table border=0 cellspacing=2 bgcolor=#F0F0F0 width=100%><tr>";
  my $cnt;
  foreach my $mod (@$categories) {
     $modules_html .= "</td><td valign=top>" if ($cnt++ % 5 == 0);
     my(@bb) = split(/=/, $mod);
     my($ck) = "checked" if ($q->{$bb[0]});
     $modules_html .= "<input type=checkbox name=$bb[0] $ck>:$bb[1]<br>";
  }
  $modules_html .= "</table>";
  $frequency = Html->select_frequency($q);

  $o =<<EOF;

<body bgcolor=#F0F0F0>
<form  method=get>
 <input type=hidden name=GO value=GUI::Hosts::updAll>
<center>
$h
$err
<script>
function win1(a) {
  var O = window.open('tradenames.html','err','menubar=no,resizable=yes,scrollbars=yes,width=400,height=500');
  O.focus();
}
</script>
<table border=2 cellspacing=2 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>

<tr><td colspan=4 bgcolor=$Style::DARK><b><font color=white>&nbsp;$LB->{all_slaves}</td>

<tr><td bgcolor=$Style::LIGHT align=right>
     &nbsp;$LB->{cat}<br><a href=javascript:win1()>$LB->{abb}</td>
    <td colspan=3>
   $modules_html
 </td>
<tr><td bgcolor=$Style::LIGHT align=right>
     &nbsp;$LB->{also}: </td>
    <td colspan=3><input type=checkbox name=autocheck>
<tr><td bgcolor=$Style::LIGHT align=right>
     &nbsp;$LB->{freq}: </td>
    <td colspan=3>$frequency</td>


</table>
</table>
<b>
<input type=submit name=ACTION_update value="$LB->{submit_update}">
<input type=submit name=ACTION_back value="$LB->{submit_back}">
</form>
EOF

  print $o;

}



#<tr><td colspan=2 bgcolor=silver><b>&nbsp;Enter DataPing Directories (One dir/file per line)</td>
#<tr><td colspan=2>$err1
#      <textarea name=ping cols=60 rows=12>$ping</textarea></td>

#<tr><td colspan=2 bgcolor=silver><b>&nbsp;Enter DataPing Directories (One dir/file per line)</td>
#<tr><td colspan=2>$err1
#      <textarea name=ping cols=60 rows=12>$ping</textarea></td>
1;
