package GUI::ExceptionReport;
use Report;
use Reports;
use Reports::Exception;
use System;
use Html::List;
use strict;
use Modules;
use Process;
use Math;



sub list {
  my($q) = @_;
  my $LB = Labels->read('GUI::ExceptionReport');

  my $LIST = [
    [ "ExConfig.html",   "GUI::ExceptionReport::config", $LB->{report1}],
    ];
  my ($info, $started);
  
  if ($q->{ACTION_new}) {
    my $st = Process->status(undef, "exception_report");
    my $cpid;
    if ($st =~ /Running/) {
       print Html->warning($LB->{running});
    } else {
      $SIG{CHLD} = 'IGNORE';
      if (($cpid = fork()) == 0) {
        Process->start("exception_report");
        close STDIN; close STDOUT; close STDERR;
        Reports::Exception->new(1);
        exit;
      } else {
        sleep(1);
        $info = Html->info($LB->expand(started => $cpid) );
        $started = 1;
      }
    }

  } elsif ($q->{ACTION_email}) {
    if ($q->{email}) {
      Reports->email($q, $q->{email}, "Exception Report", $LIST);
      $info= "Email sent!<br>";
    } else {
      print Html->error($LB->{email});
    }
  }
  my $st = Process->status(undef, "exception_report");
  my($new, $meta);
  if ($st =~ /Running/ || $started) {
    $meta = "<meta http-equiv=Refresh content=\"10;URL=$Http::WEBPROC?GO=GUI::ExceptionReport::list\">" 
  } else {
    $new = "<input type=submit name=ACTION_new value=\"$LB->{submit_new}\">";
  }

  my $date = Util->get_file_created(System->get_home() ."/DATA/tmp/exception_report");
  my ($archive);

  print Html->body();
  print $meta;
  print Html->header2("report.general.ex");
  my $dis1 = $st;
  $dis1 .= "..." if ($st =~ /Running/);
  my $last_run = Util->get_file_created(System->get_home() . '/DATA/tmp/exception_report');
  print "$info
   <form>
   <input type=hidden name=GO value=GUI::ExceptionReport::list>
  <table border=1 cellspacing=0 width=90% bgcolor=white cellpadding=1>
   <tr><td colspan=2 bgcolor=$Style::DARK><font color=white><b>$LB->{create}</td>
   <tr><td bgcolor=$Style::LIGHT align=right>Last Run: </td>
       <td>$last_run&nbsp;</td>
   <tr><td align=right width=45% bgcolor=$Style::LIGHT>
         <table border=0><tr><td>$LB->{report_status}:</table></td><td><b>&nbsp;$dis1</td>
   </table><b>
     $new
     &nbsp;
     $archive
     </b>
  <table border=0><tr><td></table>
   ";

   print Reports->list($q, $LIST, $date);
   print "</form>";


}



sub config {
  my($q) = @_;
  my $out;
  $out .= Html->body();
  $out .= Html->header2("report.general.ex", undef, undef, undef, 
                         {nohelp => $q->{email}, right => Util->get_today(), noDoc => 1});
  if (!$q->{SORT}) {
    $q->{SORT} = 1 ; $q->{SIGN} = 1;
  }
  my $REP = Reports::Exception->new();
  my $LB = Labels->read('GUI::ExceptionReport');

  if (! $REP) {
     print Html->error($LB->{no_report});
     return;
  } 
  my @tt = split(/,/, $LB->{titles2});
  my @REP1;
  foreach my $e (@$REP) {
    my $ix = rindex($e->[3],".");
    my $el = $ix > 0 ? $e->[2] . "." . substr($e->[3],0,$ix) : $e->[3];
    push(@REP1, [$e->[0], $e->[1],$el, $e->[4], $e->[5], $e->[6] ]);
  }

  my($pageInfo, $list) = Html::List->makeList($q, \@REP1, 
        ["Device", "Type", "Fru/Property", "Desc.", "CurrentValue", "DefaultValue" ],
        [  'l',   'l',      'l',  'l',      'l',   'l' ],
        [ '+sn',  '+',      '+' ,  '+',     '+',   '+'],
            {pageSize => 200, interactive => !$q->{email} });

  $out .= "
  <table border=0 cellspacing=0 bgcolor=white cellpadding=4 width=90%>
    <tr><td colspan=7>$LB->{report2}</td>
  </table>
  <table border=1 cellspacing=0 bgcolor=white cellpadding=0 width=90%>

    $list
  ";
  if ($#$REP < 0) {
     $out .= "<tr><td colspan=6><b>No Exception found!</td>";
  }
  $out .= " </table>";
  if ($q->{email}) {
    return $out;
  } else {
    print $out;
  }

}




1;

