package GUI::EventLog;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Id: EventLog.pm,v 1.51 2003/05/16 22:43:40 ccadieux Exp $

use strict;
use Modules;
use System;
use Util::Http;
use Html::Tabs;
use vars qw ($CATEGORY $EVENT);


sub get_categories {

  my $G = Labels->read();
  my $L = Labels->read("GUI::EventLog")->section("events");

  my $out =  "<select name=category>
            <option value=\"\">$G->{all}</option>
            <option value=message.>$L->{message_e}</option>
            <option value=host.>$L->{host_e}</option>
            <option value=topo.>$L->{topo_e}</option>
            <option value=agent.>$L->{agent_e}</option>
            <option value=t3.Log>$L->{t3mess_e}</option>";

   my $mods = Modules->load("Agent");
   my $sel;
   foreach my $ag0 (@$mods) {
       my $ag = lc($ag0);
       my $mod = "Agent::$ag0";
       next if ($mod =~ /Parent/);
       if ($sel = $mod->isSelectable()) {
         $out .= "<option value=$ag.>$sel</option>\n";
       }
    }
    $out .= "</select>";
}

sub get_EVENTS {

  my $G = Labels->read();
  my $L = Labels->read('GUI::EventLog')->section('events');

  return "<select name=event>
            <option value=\"\">$G->{all}</option>
            <option value=.Communication>$L->{comm}</option>
            <option value=.DiscoveryEvent>$L->{disco}</option>
            <option value=.AlarmEvent>$L->{alarm}</option>
            <option value=.RemovalEvent>$L->{remove}</option>
            <option value=.DiagnosticTest>$L->{diag}</option>
            <option value=.TopologyEvent>$L->{topo}</option>
            <option value=.AuditEvent>$L->{audit}</option>
            <option value=.StateChangeEvent>$L->{state}</option>
            <option value=.Agent>$L->{agent}</option>
            <option value=.backup>$L->{backup}</option>
            <option value=.patch>$L->{patch}</option>
            <option value=.LinkEvent>$L->{link}</option>
            <option value=.LocationCh>$L->{location}</option>
            <option value=.Statistics>$L->{stats}</option>
          </select>";
}


#
#  EVENTS
#
sub list {
  my($q) = @_;

  print Html->body();
  print Html->header2("monitor.log.events");

  $q->{ALERT} = 0;
  print &form1($q);
}

#
#  ALERTS
#
sub alerts {
  my($q) = @_;

  print Html->body();
  print Html->header2("monitor.log.alerts");
  $q->{ALERT} = 1;
  print &form1($q);
}

sub form1 {
  my($q) = @_;
  my ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read();
  my $L = Labels->read('GUI::EventLog')->section('events');
  my $G = Labels->read();

  my $sel_hosts = "<select name=hostname><option value=\"\">$G->{all}</option>
   <option value=local>" . $renv->{hostname} . "</option>";

  foreach my $h (@$host) {
    $sel_hosts .= "<option>$h->{hostname}</option>";
  }
  $sel_hosts .= "</select>";
  my $MAX = "<select name=MAXSIZE><option value=25000>25KB<option value=50000>50KB<option value=75000>75KB<option value=100000>100KB</select>";

  my $EVENT = get_EVENTS();
  my $ET = "<select name=eventtype>
      <option value=\"\">$L->{type_all}</option>
      <option value=mgmtLevel:C>$L->{type_sys}</option>
      <option value=mgmtLevel:D>$L->{type_comp}</option>
      </select>";
  $CATEGORY = &get_categories();
  my $o =<<EOF;
<center>
<table border=1 cellspacing=0 width=90% bgcolor=white cellpadding=1><tr>
  <td colspan=5>
<form>
  <input type=hidden name=GO value=GUI::EventLog::display>
  <input type=hidden name=ALERT value=$q->{ALERT}>
  <table border=0 cellspacing=2 width=100% cellpadding=0>
   <tr><td width=30% align=right bgcolor=$Style::LIGHT>&nbsp;<b>$L->{agentHost}: </td>
       <td>$sel_hosts</td>

   <tr><td width=30% align=right bgcolor=$Style::LIGHT>&nbsp;<b>$L->{category}: </td>
       <td>$CATEGORY</td>

   <tr><td width=30% align=right bgcolor=$Style::LIGHT>&nbsp;<b>$L->{severity}: </td>
     <td><select name=sev>
            <option value=\"\">$L->{sev_all}</option>
            <option value=\"Sev:3\">$L->{sev_down}</option>
            <option value=\"Sev:2\">$L->{sev_crit}</option>
            <option value=\"Sev:1\">$L->{sev_alert}</option>
            <option value=\"Sev:0\">$L->{sev_caution}</option>
         </select>

   <tr><td width=30% align=right bgcolor=$Style::LIGHT>&nbsp;<b>$L->{event}: </td>
       <td>$EVENT </td>

   <tr><td width=30% align=right bgcolor=$Style::LIGHT>&nbsp;<b>$L->{eventtype}: </td>
       <td>$ET</td>

   <tr><td width=30% align=right bgcolor=$Style::LIGHT>&nbsp;<b>$L->{maxsize}: </td>
       <td>$MAX</td>

   <tr><td width=30% align=right bgcolor=$Style::LIGHT>&nbsp;<b>$L->{filter1}: </td>
       <td><input type=text name=filter1 size=20></td>


  </table>
EOF

  my($x);
  $o .= "</table><b><input type=submit name=ACTION value=\"$L->{submit_search}\">";
  return $o;

}

sub info {
  my($q) = @_;
  require "Grid.pm";
  my $type = $q->{type};
  my $comp = $q->{comp};
  my $ev = Grid->getInfo($type, $comp, {code => $q->{code}});
  print "<body bgcolor=$Style::BGCOLOR>";

  my $L = Labels->read('GUI::EventLog')->section('info');
  my $G = Labels->read();
  print Html->header($L->{header}, "100%");

  my($actionable, $im, $code2,$desc);
  if ($ev) {
    $actionable = ($ev->{actionable})? "Y":"N";
    my $sev = (exists $q->{sev}) ? $q->{sev} : $ev->{severity};
    $im = Grid->get_sev_image($sev) || "Information";
    $code2 = $ev->{code};
    $desc = $ev->{desc} || "No description available!";
  } else {
    $actionable = "N/A";
    $im = Grid->get_sev_image($q->{sev});
    $code2 = $q->{code} || "N/A";
    $desc = "<center>No Event Advisor information available!";
  }

  my($cat, $rest) = split(/\./, $type, 2);
  my $pattern;
  if (exists $ev->{pattern}) {
    $pattern = " <tr><td align=right >$L->{pattern}:</td>
                <td colspan=3><b>$ev->{pattern}</td>";
  }
  my $type2 = $ev->{type} || $type;
  #$type2 =~ s/Event//;
  my $comp2 = $ev->{comp} || $comp;
  print "
  <table border=1 cellspacing=0 cellpadding=3 width=100% bgcolor=white>
    <tr><td align=right ><form>$L->{event}:</td><td><b>&nbsp;$type2
        <td align=right >$L->{sev}:</td><td>$im</td>
    <tr><td align=right >$L->{comp}:</td><td width=20%>&nbsp;<b>$comp2</td>
        <td align=right >$L->{actionable}:</td><td width=20%><b>$actionable</td>
    <tr><td align=right >$L->{code}:</td><td width=20%>&nbsp;<b>$code2</td>
        <td align=right colspan=2>&nbsp;</td>
    <tr bgcolor=$Style::LIGHT><td colspan=4><b>$L->{sample}</td>
    <tr><td bgcolor=white colspan=4>$desc</td>
   ";
  if (length($ev->{info}) > 1) {
     $ev->{info} =~ s/\n/<br>/g;
     print "<tr bgcolor=$Style::LIGHT><td colspan=4><b>&nbsp;$L->{info}</td>
           <tr bgcolor=white><td colspan=4>$ev->{info}</td>";
  }
  if (length($ev->{cause}) > 1) {
     $ev->{cause} =~ s/\n/<br>/g;
     print "<tr bgcolor=$Style::LIGHT><td colspan=4><b>&nbsp;$L->{cause}</td>
           <tr bgcolor=white><td colspan=4>$ev->{cause}</td>";
  }
  if (length($ev->{action}) > 1) {
     $ev->{action} =~ s/\n/<br>\n/g;
     print "<tr bgcolor=$Style::LIGHT><td colspan=4><b>&nbsp;$L->{action}</td>
           <tr bgcolor=white><td colspan=4>$ev->{action}</td>";
  }
  print "</table>";

}


# from list or alerts

sub display {
  my($q) = @_;
  my(@a, $cnt, $name);
  my $renv = System->get_renv();
  my $L = Labels->read("GUI::EventLog")->section("display");
  my($filter, $tab, $back);
  if ($q->{file}) {
     if ($q->{host}) {
       $q->{"host_" . $q->{host}} = 1;
     } else {
       $q->{host_local} = 1;
     }
     my($c1, $k1) = split(/\:/, $q->{file});
     $q->{filter1} = "Enc:$k1";
  }
  $filter  = "F1 $q->{filter1}, " if ($q->{filter1});
  $filter .= "Cat $q->{category}, " if ($q->{category});
  $filter .= "Event $q->{event}, " if ($q->{event});

  print Html->body();
  if ($q->{ALERT}) {
    $filter .= ($q->{sev} eq "Sev:") ? "$L->{all}, ": "$q->{sev}, ";
    print Html->header2("monitor.log.alerts", undef,undef,undef, {noDoc => 1});
  } elsif (!$q->{Roption}) {
    print Html->header2("monitor.log.events", undef,undef,undef, {noDoc => 1});
  }
  $filter = "All" if (!$filter);
  my($sev) = $q->{sev};
  $filter = substr($filter,0,-2) if (substr($filter,-2) eq ", ");

  $filter =~ s/\\//g;
  my $EV = &get_event_log($q);
  my (@SEV);

# EVENTS
  my $SEV = $q->{option} if ($q->{option}); # used for alerts only
  if ($q->{ALERT}) { 
     foreach my $ev (@$EV) {
        my $l = $ev->[0];
        if ($l =~ /Sev:(\d)/) {
           $SEV[$1]++;
        }
     }
     &sev_header($q, \@SEV);
  }
   print "
   <script>
   function info(sev,a,b, c) {
      var b = '$Http::WEBPROC?GO=GUI::EventLog::info&type=' + a + 
               '&comp=' + b + '&code=' + c + '&sev=' + sev;
      var O = window.open(b,'linfo','menubar=yes,resizable=yes,scrollbars=yes,width=500,height=600');
      O.focus();
   }
   </script>
   <table border=1 cellspacing=0 cellpadding=1 width=100% bgcolor=white>
 <tr bgcolor=$Style::LIGHT>$L->{header}";
   my(@gifs) = ('al_ok3','al_alert3','al_crit3','al_down3');
   my ($lines, $l, $y);
   for ($y=$#$EV; $y >= 0; $y--) {
     my $ev = $EV->[$y];
     $l = $ev->[0];
     next if ($l =~ /AggregatedEvent/);
     my $data = $ev->[1];
     my @O = split(/\t/, $l);
     next if ($#O < 4);
     next if (substr($O[0],0,2) eq "--");
     my $act = substr($O[4],7) eq "TRUE" ? "<br>Act" : "&nbsp;";
     my $sev = substr($O[3],4);
     next if ($SEV && $sev != ($SEV-1));
     my $host = substr($O[7], 7);
     $host = $renv->{hostname} if ($host eq "local");
     my $ix2 = index($host, ".");
     $host = substr($host,0,$ix2) if ($ix2 > 0);
     my $ev = $O[1];  $ev =~ s/ /','/;
     my $ev2 = $O[1]; 
     my $ecode = substr($O[8],6);   # ECode:1.1.1
     $ev2 =~ s/Communication/Comm-/;
     $ev2 =~ s/Event//;
     $ev2 =~ s/\./. /;
     my $url = "<a href=javascript:info('$sev','$ev','$ecode')>$ev2</a>";
     my $sevImg = "<img src=/gif/" . $gifs[$sev] . ".gif alt=$sev>" if ($sev < 4);
     print "<tr><td><small>$O[0] $host<td><center>$sevImg <small>$act<td>$url<br><small>$O[2]";
     $lines++;
     if ($data) {
         chomp($data);
         $data =~ s/\n/<br>/g;
         print "<br>$data";
     }
     print "&nbsp;</td>";
   }
   print "<tr><td colspan=4><b>No Log entries found!</td>" if ($lines == 0);
   print "</table>&nbsp;<p></center>Filter: $filter";

}

sub sev_header {
  my($q, $sev) = @_;
  my ($al, $l);
  $sev->[0] += 0;
  $sev->[1] += 0;
  $sev->[2] += 0;
  $sev->[3] += 0;
  $sev->[4] += 0;
  my $L = Labels->read('GUI::EventLog')->section('events');
  
  my($tt) = ["4=<img src=/gif/al_down.gif border=0 align=$al>$L->{sev_down1} ($sev->[3])",
             "3=<img src=/gif/al_crit.gif border=0 align=$al>$L->{sev_crit1} ($sev->[2])",
             "2=<img src=/gif/al_alert.gif border=0 align=$al>$L->{sev_alert1} ($sev->[1])",
             "1=<img src=/gif/al_ok.gif border=0 align=$al>$L->{sev_caution1} ($sev->[0])",
            ];

  my $tab = Html::Tabs->create(list  =>  $tt,
                       url  => "$Http::WEBPROC?GO=GUI::EventLog::display&ALERT=1",
                     width  => "100%",
             selectedColor  => "white",
         selectedTextColor  => "blue",
           backgroundColor  => $main'LIGHT,
        backgroundTextColor => 'black',
                  selection => $q->{option}
               );
  print "<table border=0><tr><td></table>" . $tab;
}



#
# always pulls local data
#
sub get_event_log {
  my($q) = @_;
  my($out, @EV, $file, $l);
  my $MAXSIZE = $q->{MAXSIZE} || 50000;
  my($grep) = System->get_home() . "/bin/rgrep";
  $file = System->get_home() . "/DATA/Events.log";
  my $ofile = $file;

  if ($q->{ALERT}) {  # alerts have a sev
     $q->{action} = "Action:TRUE";
  }
  if ($q->{hostname}) {  # specific slave host
     $q->{agenth} = "AgentH:$q->{hostname}";
  }
  my $erase;
  if ($q->{filter1} || $q->{filter2} || $q->{category} || $q->{event} ||
      $q->{sev} || $q->{action} || $q->{agenth} || $q->{eventtype}) {
     my($command);
     foreach my $c ('filter1','category','event','sev', 'action', 'agenth',
                    'eventtype') {
        if ($q->{$c}) {
           if ($command) {
              $command .= "|$grep  -p \"$q->{$c}\" -i L";
           } else {
              $command = "$grep -p \"$q->{$c}\" -f $file -i L";
           }
        }
     }
     $ofile = "/tmp/_rasevents.$$";
     system("$command > $ofile");
     $erase = 1;
  }
  if (!open(O, $ofile)) {
      $out .= "ERR Cannot read $ofile: $!<br>";
      return;
  }
  my $fsize = (stat($ofile))[7];
  if ($fsize > $MAXSIZE) {
     seek(O, - $MAXSIZE, 2);
     $l = <O>;
  }

  my $time;
  while ($l = <O>) {
     chop($l);
     my(@b) = split(/\t/, $l);
     if (substr($l, 0, 1) eq "L") {
        $EV[$#EV][1] .= substr($l,1) . "\n" if ($#EV >= 0);
     } else {
       $time = $b[0];
       $time =~ /(\d\d\d\d)(\d\d)(\d\d)(\d\d)(\d\d)(\d\d)/;
#      next if (!$1);
       $time = "$1-$2-$3 $4:$5:$6";
#      next if (!$b[1]);
       # my $type = sprintf("%-25.25s", $b[1]);
#       push(@a, "$time  $type  $b[2] $b[3]\n");
       $EV[$#EV+1][0] =  "$time\t$b[1] $b[2]\t$b[3]\t$b[4]\t$b[5]\t$b[6]\t$b[7]\t$b[8]\t$b[9]";
     }
   }
   close(O);
   unlink $ofile if ($erase);
   return \@EV;
}

1;

