package GUI::AdminGroup;
use strict;
use System;
use AdminGroup;

sub fix {
  my($key, $val, $renv, $hosts, $devs) = @_;

  if ($key eq $renv->{hostname}) {
     $renv->{adm_group} = $val eq "_CLEAR_" ? "" : $val;
     return 1;
  }
  my $done = 0;
  foreach my $h (@$hosts) {
     if ($h->{hostname} eq $key) {
        $h->{adm_group} = $val eq "_CLEAR_" ? "" : $val;
        return 1;
     }
  }
  foreach my $d (@$devs) {
     if ($d->{key} eq $key) {
        $d->{adm_group} = $val eq "_CLEAR_" ? "" : $val;
        return 1;
     }
  }
  return 0;
}

sub sort {
  my($q, $group, $name, $ip, $type) = @_;

  if ($q->{sort} eq "G") {
     return $group || "~";
  } elsif ($q->{sort} eq "T") {
     return $type;
  } else {
     return $name;
  }
}

sub list {
  my($q) = @_;

  print Html->body();
  print Html->header2("admin.gen_maint.adming");
  my $group = AdminGroup->new();
  my $G = Labels->read();
  my $L = Labels->read("GUI::AdminGroup");

  if ($group->count() == 0) {
     my $url = "<a href=$Http::WEBPROC?GO=GUI::Groups::update>$L->{title1}</a>";
     print Html->warning($L->{none} . "<br> $url");
     return;
  }


  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();

  if ($q->{ACTION_group} ) {
     if (!$q->{group}) {
         print Html->warning($L->{select1});
     } else {
       my $new;
       foreach my $x (keys %$q) {
         if (substr($x,0,4) eq "adm_") {
            my $key = substr($x,4);
            $new += &fix($key, $q->{group}, $renv, $hosts, $devs);
         }
       }
       if ($new) {
         PDM::ConfigFile->write($renv, $devs, $hosts, $notifs);
         print "$L->{updated}<br>";
       }
     }
  }

  my $sort = Util->makeSelect("sort", 
                   "H=$L->{sort1}|G=$L->{sort2}|T=$L->{sort3}", $q->{sort});
  my $COLS = 3;
  print <<EOF;
<table border=0 cellspacing=0 cellpadding=0 width=90% bgcolor=#C0C0C0>
<tr><td colspan=$COLS bgcolor=$Style::DARK>
  <table border=0 cellspacing=0 width=100%>
  <tr><td>
   <form method=post>
   <input type=hidden name=GO value=GUI::AdminGroup::list>
   <font color=white><b>$L->{title2}</td>
  </td>
  <td align=right><font color=white>
    $L->{search}: <input type=text name=search size=10 value=\"$q->{search}\"> &nbsp;
    $L->{sort}:$sort <input type=submit name=ACTION value=GO>
  </table>
<tr>
EOF
 
  my $H = "<table border=0 cellspacing=1 cellpadding=0 width=100% bgcolor=white>
           <tr bgcolor=$Style::LIGHT>
              <th>$L->{name}</td>
              <th>$L->{group}</td>
              <th>$L->{sel}</td>
          ";

  my $name = $renv->{hostname};
  my $key  = $renv->{hostname};
  my $sort = &sort($q, $renv->{adm_group}, $renv->{hostname}, Util->name2ip(), "host");

  my(@L, $MAX, $x);
  if (!$q->{search} || index($renv->{hostname}, $q->{search}) >= 0) {
    push(@L, "$sort\t$renv->{hostname}\t0\t$name\t$key\t$renv->{adm_group}");
  }

  foreach my $h (@$hosts) {
    my $name = $h->{hostname};
    my $key  = $h->{hostname};
    next if ($q->{search} && index($name, $q->{search}) < 0);
    my $sort = &sort($q, $h->{adm_group}, $h->{hostname}, $h->{ipno}, "host");
    push(@L, "$sort\t$h->{hostname}\t0\t$name\t$key\t$h->{adm_group}");
  }
  foreach my $d (@$devs) {
    my $name = $d->{name};
    next if ($q->{search} && index($name, $q->{search}) < 0);
    my $key  = $d->{key};
    my $h = $d->{host} || $renv->{hostname};
    my $sort = &sort($q, $d->{adm_group}, $h, $d->{ipno}, $d->{type});

    push(@L, "$sort\t$h\t1\t$d->{type}-$name\t$key\t$d->{adm_group}");
  }
  $MAX = int(($#L + 1) / $COLS)+ 1;
  my $out  = "<td valign=top>$H";
  my $x = 0;
  my $col;
  foreach my $e (sort @L) {
     if ($x && $x % 20 == 0) {
        $col++;
        my $tr;
        if ($col >= $COLS) {
          $col = 0; $tr = "<tr><td></td><tr><td></td><tr>";
        }
        $out .= "</table></td>$tr<td valign=top>$H";
     }
     my($sort, $host, $type, $name, $key, $adm) = split(/\t/, $e);
     my $h = Util->shortHostname($host);
     my $n = Util->shortHostname($name);
     my $type = $type ? "D":"H";
     my $but = "<input type=checkbox name=\"adm_$key\">";
     my $col = "bgcolor=#FFFFD0" if ($adm);
     if ($type eq "H") {
       $out .= "<tr><td><b>&nbsp;-$h</td><td $col>&nbsp;$adm</td><td><center>$but</td>";
     } else {
       $out .= "<tr><td>&nbsp;&nbsp;$n</td><td $col>&nbsp;$adm</td><td><center>$but</td>";
     }
     $x++;
  }
  $out .= "</table></table><table border=0><tr><td></table>";
  print $out;
  my $sel = $group->select("group", undef, $G->{select}, 1);
  print "<table border=1 cellspacing=0 cellpadding=2 bgcolor=$Style::LIGHT>
  <tr><td><center><b>Group selected devices into:$sel
              <input type=submit name=ACTION_group value=\"$L->{submit_update}\">
  </table><p>
  [ <a href=$Http::WEBPROC?GO=GUI::Groups::update>$L->{more}</a> ]
  </form>&nbsp;<p>";
}

1;
