package Discover;
use strict;
use System;

# select: hostname or '' for all hosts.
# ID: deviceIP, fcswitch

sub ras_admin {
  my($class, $select, $command, $renv, $hosts, $ID) = @_;
  my $L = Labels->read("GUIAdmin::default")->section("discover");

  my $DIR = System->get_home() . "/DATA/Discover";
  mkdir $DIR,0777 if (!-d $DIR);

  if ($select eq "local" || !$select) {
     open(O, ">$DIR/$ID.local"); print O "#START\n"; close(O);
     print $L->expand(getting2 => $renv->{hostname}) . "<br>";
     my $com = System->get_home() . "/bin/ras_admin $command";
     my $pid = fork();
     if (!$pid) {
        close(STDIN); close(STDOUT); close(STDERR);
        exec "$com";
     }
  }
  foreach my $h (@$hosts) {
     next if($h->{dh} eq "Y");
     if ($h->{hostname} eq $select || !$select) {
       open(O, ">$DIR/$ID.$h->{hostname}"); print O "#START\n"; close(O);
       print $L->expand(getting2 => $h->{hostname}) . "<br>";
       Util::Http->remoteCommand($h->{ipno}, "ras_admin $command", 20);
     }
  }
}

sub stats {
  my($class) = @_;

  my(%TOT, $l);
  my $D1 = System->get_home() . "/DATA/Discover";
  opendir(O, $D1);
  my @F = readdir(O); closedir(O);
  foreach my $f (@F) {
     next if (-d "$D1/$f");
     next if (substr($f,0,1) eq ".");
     my($a, $b) = split(/\./, $f);
     $TOT{$a}{cnt}++;
     open(O2, "$D1/$f");
     my($start, $stop, $cnt);
     while ($l = <O2>) {
        if (substr($l,0,6) eq "#START") {
           $start++;
        } elsif (substr($l,0,4) eq "#END") {
           $stop = 1;
        } else {
           $stop = 1;
           $cnt++;
        }
     }
     close(O2);
     $TOT{$a}{start} += $start;
     $TOT{$a}{stop}  += $stop;
     $TOT{$a}{lines} += $cnt;
  }
  return \%TOT;
}


1;

