package DevList;
use strict;

use vars qw($D @LIST $MODE);
#
# USED TO CREATE A LIST OF DEVICES THAT SHOULD BE MONITORED
# DEVICES CAN BE ADDED DYNAMICALLY
# getNext WILL fail if the device was monitored recently enough
# getNext WILL fail if the run_len is expired

sub init {
  my($class, $run_len) = @_;

  @LIST             = ();
  $MODE             = 'O';
  $D->{start_time}  = time;
  $D->{run_len}     = $run_len;  # minutes
  my $devs = System->get_configDevices();
  my $renv = System->get_renv();
  foreach my $d (@$devs) {
    next if ($d->{active} eq "N");
    my $h = $d->{host} || $renv->{hostname};
    next if ($h ne $renv->{hostname});
    push(@LIST, ['O',0, $d]);
  }
    
}

#  dev->{type} = 'a5k', ... 'slave'
#  mode = 'O' Original list
#       = 'N' added later because of an event.

sub add {
  my($class, $dev) = @_;
#               mode    done=1     device
  push(@LIST , ['O',    0,         $dev]);
}

# duplicates not allowed

sub addNew {
  my($class, $dev) = @_;
  my $k = $dev->{key};
  foreach my $d0 (@LIST) {
     next if ($d0->[0] ne 'N');
     my $d = $d0->[2];
     return if ($d->{key} eq $k);
  }
  push(@LIST, ['O', 0, $dev]);
}

sub setMode {
  my($class, $mode) = @_;
  $MODE = $mode;
}

#  getNext device of a certain type before the time window expire
#  make sure the device has not been looked at too recently.

sub next {
  my($class, $type) = @_;
  my $renv = System->get_renv();
  my $freq = $renv->{frequency};
  my $LIST = \@LIST;

  return undef if (time - $D->{start_time} > $D->{run_len}*60);

  my ($ok, $next, $x, $node);

  for ($x=0; $x <= $#LIST; $x++) {
    $node  = $LIST->[$x];
    next if ($node->[0] ne $MODE);
    $next  = $node->[2];
    next if ($node->[1] || ($next->{type} ne $type) );  # already served

    my $file = System->get_home() . "/DATA/OLD_REPORTS/$next->{type}:$next->{key}";
    if (!-f $file) {
      $ok = 1;
    } else {
      my @stats  = stat($file);
      my $old_time = $stats[9];
      my $age = time - $old_time;
      $ok = 1 if ($age >= $freq * 60); 
    }
    last if ($ok);
  }
  return undef if (!$ok);
  $node->[1] = 1;   # served
  return $next;
}
  
1;
