package Agent::SE;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: SE.pm,v 1.94 2003/05/20 20:15:18 ccadieux Exp $

use Catalog;
use strict;
use Report;
use Agent;
use State;
use base 'Agent';
use Agent::SWITCH;

sub isSelectable { "Sun 3900/6900" }  # used to control rack as device
sub type         { Report::CAT_SE }

sub revision     {'$Revision: 1.94 $'}
sub arrays       {",t3,6120,"}

use vars qw(%N2IP $ERR);

sub new {
  my($self) = Agent->new();

  bless ($self, 'Agent::SE');
  return $self;
}

sub RUN {
  my($agent,$ras_flag) = @_;
  my($err_lines, $warn_lines,  $out,$device, $connect_errs);
  my($report ,  $id, $lines, $log_err, $type);
  my($onedayold, $wwn, $portWWN, $port2WWN);
  $DB::single = 1;
  my ($renv, $devs, $hosts, $notifs, $Config) = PDM::ConfigFile->read();
  my $se = $agent->type();

#  return if (!$renv->{include_se_device});

  Timelapse->start(ref($agent));

  my($sdt);
  my($dc) = 0;


#   INDY ONLY
#   RUN IF AGENT IS ON THE RACK
#
  if ($renv->{solution} eq $se) {
     my $key = ($renv->{solution_model}||uc($se)) . "." . System->hostid();

     my $report = $agent->INSTRUMENTATION($renv->{solution_model}, $devs, $key);

     my $name = $renv->{solution_model} . "-" . System->shortHostname($renv->{hostname});

     $id =  { 
                deviceName  => $key,
                active      => "Y",
                name        => $name,
                class       => "storage.$se",
                display     => $renv->{solution_model} . " " . $renv->{hostname},
                category    => $se,
                ip          => $renv->{ipno} || $renv->{hostname},
              };
     $report->{"id.name"}        = $renv->{hostname};
     $report->{"id.hostid"}      = System->hostid();
     $report->{"id.ip"}          = $renv->{ip};
     $report->{"id.ipno"}        = Util->name2ip();
     $report->{"id.wwn"}         = $key;
     $report->{'id.mgmtLevel'}   = 'DS';
  
     PDM->saveReport(Report->new($id, $report , ""));

     $agent->sys_state($Config);
  }

#
#  RUN ON CONFIGFILE DEVICES
#
  if (index("|$renv->{categories}|", "|$se|") < 0) {
     Timelapse->stop(ref($agent));
     Debug->print2(" skipping " . uc($se) . "-Series as devices\n");
     return;
  }

  foreach $device ( $agent->deviceList() ) { # get other racks that are yours to monitor 
       next if ($device->{mgmtLevel} ne "D");
       Debug->print1("-> Reading device $device->{name}: $device->{ip}");

       my($err, $report) = Report->readReport($device->{type} . ":" . $device->{key}, 
                                    $device->{ipno}, 20);
       $id = { 
              deviceName  =>  $device->{key},
              active      =>  $device->{active},
              name        =>  $device->{name},
              class       => "storage.$se",
              display     => "$device->{name} (ip=$device->{ipno})",
              category    => $se,
              ip          => $device->{ip},
          };
       if ($err) {
         $report->{'id.connect_errs'} = $err;
         PDM->saveReport(Report->new($id, $report , "", Report::STATUS_CANNOT_CONNECT));
       } else {
         $report = $report->value();
         $report->{"id.name"}        = $device->{name};
         $report->{'id.mgmtLevel'}   = "D";
         $report->{"id.ip"}          = $device->{ip};
         $report->{"id.ipno"}        = $device->{ipno};
         $report->{"id.wwn"}         = $device->{key};
         $agent->copyDev($device, $report);
         PDM->saveReport(Report->new($id, $report, ""));
       }
  }

  Timelapse->stop(ref($agent));
}

sub enclosure {
  my($class, $rep) = @_;
}


#
# SAVE COMPONENT STATE in DATA/sys_state
#
sub sys_state {
  my($class, $Config) = @_;

  my $renv = System->get_renv();

  my $State = State->getComponentState(0); 
  my @SEV = ('OK','WARNING','ERROR','DOWN');
  open(O1, "/etc/hosts");
  my ($sys_state, $l);
  my $WORST = 0;
  while ($l = <O1>) {
      chop($l);
      if ($l =~ /^192\.168\./) {
         my($dev);
         my($ip, $name) = split(/\s+/, $l);
         if ($name eq "sp") {
           $dev = { type => "host", key => $renv->{hostname}};
         } else {
           $dev = $Config->deviceByIP($ip);
         }
         if ($dev) {
            my $sev = 0;
            my $k = "$dev->{type}:$dev->{key}";
            if (exists $State->{$k}) {
               $sev = int($State->{$k}[0] + 0.5);
            }
            $WORST = $sev if ($sev > $WORST);
            $sys_state .= "$name\t$SEV[$sev]\n";
         }
      }
  }
  close(O1);
  open(O1, ">" . System->get_home() . "/DATA/system_state");
  print O1 $sys_state;
  system("/opt/se6x20/bin/vmcfg status -t rack -s $SEV[$WORST]");
  close(O1);
}

#  http or sub call, expect the topo to exist already

sub getLinks {
  my($class, $dev, $to) = @_;
  my $VAR1;
  if ($dev->{mgmtLevel} eq "D") {  # remote
    my ($err, $data) = Util::Http->readFile($dev->{ip}, "se_links");
    if ($err || substr($data,0,20) !~ /VAR1 /) {
       Debug->err(HTTP_ERROR => "$err $data");
       return {};
    }
    eval $data;
    return $VAR1;
  } else {
    return &get_links({ to => $to });
  }
}


# may need to add one argument to specify which rack if there are slaves.
# will change readTopo(<slave>)
#
sub get_links {
  my($q) = @_;
  my (%R, $x);
  my $HTTP = $q->{HTTP};
  my $renv   = System->get_renv();
  my $Config = PDM::ConfigFile->read();
  my $devs   = $Config->devices();

  my $model = $renv->{solution_model};
require TO;
  my $to    = $q->{to} || TO->readExistingTopo();
  my $Comp  = $q->{Comp};
  my $switches = $to->switchList();
  my $storages = $to->storageList();
  my $portCnt = 0;
  my $slotTotal;

  my $wwn_list;
  foreach my $d (@$devs) {
    my $h = $d->{host} || $renv->{hostname};
    next if ($h ne $renv->{hostname});
    $slotTotal++;
    if ($d->{class} !~ /storage.se/) {
      $wwn_list .= "$d->{wwn}|";
      $wwn_list .= "$d->{wwn2}|" if ($d->{wwn2});
    }
  }
  $R{"info.slotTotal"} = $slotTotal;
  $R{"info.wwnList"}   = $wwn_list;

  if ($model eq "3910" || $model eq "3960") {
     foreach my $sw (@$switches) {
        my $name = $sw->name();
        my $rep1 = Report->readNew($name) if (!$HTTP);
        my $pi = $sw->portInfo();
        my $po = $sw->port();
        for ($x=0; $x <= $#$pi; $x++) {
            my $po0 = $po->[$x];
            my $pi0 = $pi->[$x];
            $pi0->{PortWWN} = $rep1->value("port.$x.link_wwn") if ($rep1 && $rep1->value("port.$x.link_wwn")); # fix wwn

            if (ref($pi0) eq "HASH" && defined($pi0->{PortWWN}) && (!$po0 || substr($po0,0,2) ne "t3") ) {
               $R{"fcPort.$portCnt.PortWWN"}      = $pi0->{RemotePortWWN} || $pi0->{PortWWN};
               $R{"fcPort.$portCnt.nodeId"}         = "$name:$x";
               $R{"fcPort.$portCnt.LocalPortWWN"} = $pi0->{LocalPortWWN};
               $R{"fcPort.$portCnt.portType"}     = $sw->type() . "." . $pi0->{sw_PortType};
               $R{"fcPort.$portCnt.encName"}       = $sw->info("BoxName");
               if ($rep1) {
                 $R{"fcPort.$portCnt.PortWWN"}=$rep1->value("port.$x.link_wwn");
                 $R{"fcPort.$portCnt.CRC"}   = $rep1->value("port.$x.error.CRC Errs");
                 $R{"fcPort.$portCnt.ITW"}   = $rep1->value("port.$x.error.InvalidTxWds");
                 $R{"fcPort.$portCnt.SIG"}   = $rep1->value("port.$x.error.loss_of_signal_cnt");
                 $R{"fcPort.$portCnt.SYNC"}  = $rep1->value("port.$x.error.sync_loss");
                 $R{"fcPort.$portCnt.LINK"}  = $rep1->value("port.$x.error.LinkFails");
                 $R{"fcPort.$portCnt.INF"}   = $rep1->value("port.$x.stats.Inframes");
                 $R{"fcPort.$portCnt.OUTF"}  = $rep1->value("port.$x.stats.Outframes");
               }
               &updStatus("fcPort.$portCnt", "$name:port.$x", \%R, $Comp);
               $portCnt++;
            }
        }
     }
  } elsif ($model eq "3900SL" || $model eq "6320") {
     foreach my $st (@$storages) {
        my $name = $st->name();
        next if (index( Agent::SE->arrays, $st->type()) < 0);
        my $rep1 = Report->readNew($name) if (!$HTTP);
        my $pi = $st->portInfo();
        for ($x=0; $x <= $#$pi; $x++) {
          my $pi0 = $pi->[$x];
          if (ref($pi0) eq "HASH" && exists $pi0->{PortWWN}) {
             $R{"fcPort.$portCnt.PortWWN"}      = $pi0->{PortWWN};
             $R{"fcPort.$portCnt.LocalPortWWN"} = $pi0->{PortWWN};
             $R{"fcPort.$portCnt.nodeId"}         = "$name:$x";
             $R{"fcPort.$portCnt.encName"}      = $st->info("BoxName");
             $R{"fcPort.$portCnt.portType"}     = $st->type();
             if ($rep1) {
               $R{"fcPort.$portCnt.status"} = $rep1->value("controller.u" . ($x+1) . "ctr");
               if ( $model eq "6320") {
                 my $e = "fc_stats.unit$x-ctrl" . ($x+1) . "-loop2";
                 $R{"fcPort.$portCnt.CRC"}   = $rep1->value("$e.InvCRCCnt") + 0;
                 $R{"fcPort.$portCnt.ITW"}   = $rep1->value("$e.InvTxWord") + 0;
                 $R{"fcPort.$portCnt.SIG"}   = $rep1->value("$e.LossSignalCnt") + 0;
                 $R{"fcPort.$portCnt.SYNC"}  = $rep1->value("$e.LossSyncCnt") + 0;

               } else {
                 $R{"fcPort.$portCnt.CRC"}   = $rep1->value("port." . ($x+1) . ".CRC");
                 $R{"fcPort.$portCnt.ITW"}   = $rep1->value("port." . ($x+1) . ".ITW");
                 $R{"fcPort.$portCnt.SIG"}   = $rep1->value("port." . ($x+1) . ".SIG");
                 $R{"fcPort.$portCnt.SYNC"}  = $rep1->value("port." . ($x+1) . ".SYNC");
                 $R{"fcPort.$portCnt.LINK"}  = $rep1->value("port." . ($x+1) . ".LINK");
               }
               $R{"fcPort.$portCnt.INF"}   = 0;
               $R{"fcPort.$portCnt.OUTF"}  = 0;
             }
             &updStatus("fcPort.$portCnt", 
                          "$name:controller.u" . ($x+1) . "ctr", , \%R, $Comp);
             $portCnt++;
          }
        }
     }
  } elsif ($model eq "6910" || $model eq "6960") {
     foreach my $sw (@$switches) {
        next if ($sw->type() eq "ve");
        my $ip3 = substr($sw->info('sw_ipAddr'), -2);
        next if ($ip3 ne "30" && $ip3 ne "31");
        my $name = $sw->name();
        my $rep1 = Report->readNew($name) if (!$HTTP);
        my $pi = $sw->portInfo();
        my $po = $sw->port();
        for ($x=0; $x <= $#$pi; $x++) {
            my $po0 = $po->[$x];
            my $pi0 = $pi->[$x];
            $pi0->{PortWWN} = $rep1->value("port.$x.link_wwn") if ($rep1 && $rep1->value("port.$x.link_wwn")); # fix wwn

            if (ref($pi0) eq "HASH" && defined($pi0->{PortWWN}) && (!$po0 || substr($po0,0,2) ne "ve") ) {
               $R{"fcPort.$portCnt.PortWWN"}      = $pi0->{RemotePortWWN} || $pi0->{PortWWN};
               $R{"fcPort.$portCnt.LocalPortWWN"} = $pi0->{LocalPortWWN};
               $R{"fcPort.$portCnt.nodeId"}         = "$name:$x";
               $R{"fcPort.$portCnt.portType"}     = $sw->type() . "." . $pi0->{sw_PortType};
               $R{"fcPort.$portCnt.encName"}      = $sw->info("BoxName");
               if ($rep1) {
                 $R{"fcPort.$portCnt.PortWWN"}=$rep1->value("port.$x.link_wwn");
                 $R{"fcPort.$portCnt.status"}= $rep1->value("port.$x.mode");
                 $R{"fcPort.$portCnt.CRC"}   = $rep1->value("port.$x.error.CRC Errs");
                 $R{"fcPort.$portCnt.ITW"}   = $rep1->value("port.$x.error.InvalidTxWds");
                 $R{"fcPort.$portCnt.SIG"}   = $rep1->value("port.$x.error.loss_of_signal_cnt");
                 $R{"fcPort.$portCnt.SYNC"}  = $rep1->value("port.$x.error.sync_loss");
                 $R{"fcPort.$portCnt.LINK"}  = $rep1->value("port.$x.error.LinkFails");
                 $R{"fcPort.$portCnt.INF"}   = $rep1->value("port.$x.stats.Inframes");
                 $R{"fcPort.$portCnt.OUTF"}  = $rep1->value("port.$x.stats.Outframes");
               }
               &updStatus("fcPort.$portCnt", "$name:port.$x", \%R, $Comp);
               $portCnt++;
            }
        }
     }
  } elsif ($model eq "6910SL" || $model eq "6960SL") {
     foreach my $sw (@$switches) {
        next if ($sw->type() ne "ve");
        my $name = $sw->name();
        my $rep1 = Report->readNew($name) if (!$HTTP);
        my $pi  = $sw->portInfo();
        my $pi0 = $pi->[1];
        if (ref($pi0) eq "HASH" && $pi0->{PortWWN}) {
           $R{"fcPort.$portCnt.nodeId"}         = $sw->{name} . ":1";
           $R{"fcPort.$portCnt.PortWWN"}      = $pi0->{PortWWN};
           $R{"fcPort.$portCnt.LocalPortWWN"} = $pi0->{LocalPortWWN};
           $R{"fcPort.$portCnt.encName"}      = $sw->info("BoxName");
           $R{"fcPort.$portCnt.portType"}     = $sw->type();

           $R{"fcPort.$portCnt.status-sev"}   = 0;
           $R{"fcPort.$portCnt.status-desc"}  = "OK";
           $R{"fcPort.$portCnt.status-avail"} = 1;
           if ($rep1) {
             $R{"fcPort.$portCnt.CRC"}   = $rep1->value("fc.1.crc") + 0;
             $R{"fcPort.$portCnt.ITW"}   = $rep1->value("fc.1.itw") + 0;
             $R{"fcPort.$portCnt.SIG"}   = $rep1->value("fc.1.signal") + 0;
             $R{"fcPort.$portCnt.SYNC"}  = $rep1->value("fc.1.sync") + 0;
             $R{"fcPort.$portCnt.LINK"}  = $rep1->value("fc.1.link") + 0;
             $R{"fcPort.$portCnt.INF"}   = 0;
             $R{"fcPort.$portCnt.OUTF"}  = 0;
           }
           $portCnt++;
        }
     }
  }

  $R{"info.portTotal"} = $portCnt;
  if ($HTTP) {
require Data::Dumper;
     print "OK " . Data::Dumper::Dumper(\%R);
  } else {
     return \%R;
  }
}

sub round {
  my($v) = @_;
  return ($v < 0) ? 0 : int($v+0.5);
}


sub updStatus {
  my($slot, $key, $R, $State) = @_;
  return if (!$State);
  if (exists $State->{$key}) {
     $R->{"$slot.status-sev"}    = &round($State->{$key}[0]);
     $R->{"$slot.status-desc"}   = $State->{$key}[1];
     $R->{"$slot.status-avail"}  = $State->{$key}[3] + 0;
     $R->{"$slot.status-details"}= $State->{$key}[4];
  } else {
     $R->{"$slot.status-sev"}    = 0;
     $R->{"$slot.status-desc"}   = "OK";
     $R->{"$slot.status-avail"}  = 1;
  }
}

#'switch:100000c0dd00b0ce:port.1' => [
#      -2,
#      '08-27 12:06:10 \'port.1\' in SWITCH dvt2-sw1a (ip=192.168.0.30) is now Not-Available (state changed from \'Online\' to \'Offline\'):',
#      'dvt2-sw1a',
#      '0',
#      'EventType=switch.StateChangeEvent|Target=switch:100000c0dd00b0ce|TargetNa me=dvt2-sw1a (ip=192.168.0.30)|Caption=M.port.1|Actionable=TRUE|SourceIP=192.168 .0.30|Severity=2|PriorState=1|CurrentState=0|CurrentValue=Offline'
#    ],

# event with highest severity wins

sub compare {
  my($k, $comp, $sev, $DB) = @_;

  if (!exists($DB->{$k}) ) {
     $DB->{$k} = [@$comp];
     $DB->{$k}[0] = $sev;

  } elsif ($sev > $DB->{$k}[0] ) {
     $DB->{$k} = [@$comp];
     $DB->{$k}[0] = $sev;

  } elsif ($sev == $DB->{$k}[0] ) {
     if ($comp->[1] gt $DB->{$k}[1]) {
        $DB->{$k} = [@$comp];
     }
  }
}
# most recent event wins but highest severity is saved

sub compare2 {
  my($k, $comp, $sev, $DB) = @_;

  if (!exists($DB->{$k}) ) {
     $DB->{$k} = [@$comp];
     $DB->{$k}[0] = $sev;

  } else {
     my $curr_sev = $DB->{$k}[0];
     if ($comp->[1] gt $DB->{$k}[1]) {            # more recent event
       $DB->{$k}    = [@$comp];
     }
     $DB->{$k}[0] = $sev if ( $sev > $curr_sev);  # highest severity
  }

}



sub fruInfo {
  my($class, $rep, $slot) = @_;
  
  my $x;
  my $out = {};
  foreach my $k (keys %$rep) {
     next if ($k !~ /^fru\.(\d+)\./);
     my $fru = $1;
     if ($rep->{"fru.$fru.fruSlot"} == $slot) {
       $out->{$k} = $rep->{$k};
     }
  }
  return $out;
}
     


# state of slot
# down stays down
# errors on ctrl stay
# error on one disk,loop,midplane in one t3 brick -> warning
# more that one disk/loop/mid error in same brick -> error

sub slotStatus {
  my($class, $devs) = @_;
  my $Comps = State->components();
  my (%MAP, %STATUS);
  foreach my $d (@$devs) {
     $MAP{$d->{key}} = 1 if ($d->{mgmtLevel} eq "C");
  }
  foreach my $c (keys %$Comps) {
    my ($type, $wwn, $comp1) = split(/\:/, $c);
    next if (!$MAP{$wwn}); # skip devices that are not rack components.
    my $comp = $Comps->{$c};
    my $sev = $comp->[0];
    &compare("$type:$wwn", $comp, $sev, \%STATUS);
  }
  return \%STATUS;
}



sub slotOrder {
  my($class, $devs, $renv) = @_;
  my (@MAP1, @MAP2, @MAP3, @MAP4);

  foreach my $d (@$devs) {
    next if ($d->{mgmtLevel} ne "C");
    my $h = $d->{host} || $renv->{hostname};
    next if ($h ne $renv->{hostname});
    my $last = substr($d->{ipno},-2);
    if ($last ==30 || $last == 31) {
        push(@MAP1, $d);
    } elsif (substr($last,0,1) eq "2") {
        push(@MAP2, $d);
    } elsif ($last == 32 || $last == 33) {
        push(@MAP3, $d);
    } else {
        push(@MAP4, $d);
    }
  }
  push(@MAP1, @MAP2, @MAP3, @MAP4);
  return (\@MAP1);
}

   
sub INSTRUMENTATION {
  my($class, $model, $devs, $se_key) = @_;
  my (%R, @MAP1, $x);
  my $renv = System->get_renv();
  my $MAP1 = $class->slotOrder($devs, $renv);

  my $rev = System->get_se_version() || "N/A";

  $R{"info.category"}              = "RAID";
  $R{"info.model"}                 =  $model;
  $R{"info.isRedundantController"} = "TRUE";
  $R{"info.supportsLUNMasking"}    = "TRUE";
  $R{"info.HGType"}                = "RAID";
  $R{"info.vendor"}                = "SUN";
  $R{"info.serialNumber"}          = "N/A";
  $R{"info.firmwareLevel"}         = $rev;
  $R{"info.spRevision"}            = $rev;

  $class->enclosure(\%R);
  
  my $first_ve  = 1;
  my $lun       = 1;
  my $slice     = 1;
  my $total_cap = 0;
  my $State =  $class->slotStatus($devs); # State->getComponentState(2);  # with links
  my $Comp  = State->components();
  my $x;
  my $to       = TO->readTopo();

  my $host_info = Agent->hostInfo();

# SERVICE PROCESSOR is slot-0/fru-0

  $R{'slot.0.dev-type'} = 'sp';   # slot0 is SP
  $R{'slot.0.dev-name'} = $host_info->{hostname};
  $R{'slot.0.dev-key'} = $host_info->{hostname};
  $R{'fru.0.fruSlot'}    = 0; 
  $R{'fru.0.fruType'}   = 'sp';
  foreach my $el (keys %$host_info) {
     $R{'fru.0.info-' . $el} = $host_info->{$el};
  }
 
# EXTERNAL PORTS

  my $LINKS = &get_links({ to => $to, Comp => $Comp });
  Util->serialize("se_links", $LINKS);

  foreach my $el (keys %$LINKS) {
     $R{$el} = $LINKS->{$el};
  }

  &updStatus("links", "LINK", \%R, $State);

# DEVICES / SLOTS
  my $fru  = 1;
  my $slot = 1;

  foreach my $dev (@$MAP1) {
    my $key = $dev->{type} . ":" . $dev->{key};
    my $rep1 = Report->readNew($key);
    if (!$rep1) {
      $rep1 = Report->new({deviceName => $se_key}, {});
    }

    foreach my $x (keys %$dev) {
      $R{"slot.$slot.dev-$x"} = $dev->{$x} if (substr($x,0,1) ne "_");
    }
    
    &updStatus("slot.$slot", $key, \%R, $State);

# SWITCH
    if (substr($dev->{type},0,6) eq "switch") {
      $R{"fru.$fru.version-HW"}    = $rep1->value("version.HW");
      $R{"fru.$fru.version-FLASH"} = $rep1->value("version.FLASH");
      $R{"fru.$fru.version-PROM"}  = $rep1->value("version.PROM");
      $R{"fru.$fru.fruSlot"}     = $slot;
      $R{"fru.$fru.fruType"}       = "switch";
      $fru++;

# ARRAY
    } elsif (index(Agent::SE->arrays, $dev->{type}) >= 0) {
      my ($c, $d, $l);
      my $units = $rep1->value("unit.count") || 2;
      my $disks = $rep1->value("disk.count") || 9; 

      for ($c=1; $c <= $units; $c++) {
         my $u = "u$c" . "ctr";
         if ($rep1->value("controller.$u.fruModel")) {
           $R{"slot.$slot.fruId"}       = $u;
           $R{"slot.$slot.fruModel"}    = $rep1->value("controller.$u.fruModel");
           $R{"slot.$slot.fruRevision"} = $rep1->value("controller.$u.fruRevision");
           $R{"slot.$slot.fruSerialNo"} = $rep1->value("controller.$u.fruSerialNo");
           $R{"slot.$slot.fruVendor"}   = $rep1->value("controller.$u.fruVendor");
         }
         $fru = copy($slot, $fru, \%R, "controller.u${c}ctr", $rep1);
         $fru = copy($slot, $fru, \%R, "midplane.u${c}mpn", $rep1);
         $fru = copy($slot, $fru, \%R, "power.u${c}pcu1", $rep1);
         $fru = copy($slot, $fru, \%R, "power.u${c}pcu2", $rep1);
         for ($d=1; $d <= $disks; $d++) {
            $fru = copy($slot, $fru, \%R, "disk.u${c}d$d", $rep1);
         }
         for ($l=1; $l <= 2; $l++) {
            $fru = copy($slot, $fru, \%R, "loopcard.u${c}l$l", $rep1);
         }
      }
      # USE LUNS OF T3/T4
      if (substr($model,0,2) eq "39" || substr($model,0,2) eq "63") { # no vicoms, luns from t3
         my $v;
         for ($x=1; $x <= $units; $x++) {
             for ($v=1; $v <= 10; $v++) {
                my $id = "volume.u${x}vol$v";
                last if (!$rep1->value("$id.volRaidLevel"));
                $R{"lun.$lun.lunIndex"}   = $lun;
                $R{"lun.$lun.lunId"}         = $rep1->value("$id.volId");
                $R{"lun.$lun.volId"}         = $dev->{name} . "-u${x}vol$v";
                $R{"lun.$lun.lunName"}       = $dev->{name} . "-vol$v";
                $R{"lun.$lun.lunWwn"}        = $rep1->value("$id.volWWN");
                $R{"lun.$lun.lunRaidLevel"}  = $rep1->value("$id.volRaidLevel");
                $R{"lun.$lun.lunCapacity"}   = $rep1->value("$id.volCapacity");
                $R{"lun.$lun.lunType"}       = $dev->{type};
                $R{"lun.$lun.lunCacheMode"}  = $rep1->value("$id.volCacheMode");
                $R{"lun.$lun.lunVolName"}    = $rep1->value("$id.volName");
                $R{"lun.$lun.lunStatus"}     = $rep1->value("$id.volStatus");
                #$R{"lun.$lun.lunRemoteCopy"}    = "FALSE";
                #$R{"lun.$lun.lunBeingBackedUp"} = "FALSE";
                $total_cap +=  $R{"lun.$lun.lunCapacity"};
                $lun++;
             }
         }
         for ($x=0; $x < $rep1->value("slice.count"); $x++) {
             $R{"slice.$slice.lunName"}       = $rep1->value("slice.$x.lun-lun");
             $R{"slice.$slice.volId"}         = $rep1->value("slice.$x.volId");
             $R{"slice.$slice.volSliceEnd"}   = $rep1->value("slice.$x.volSliceEnd");
             $R{"slice.$slice.volSliceName"}  = $rep1->value("slice.$x.volSliceName");
             $R{"slice.$slice.volSliceSize"}  = $rep1->value("slice.$x.volSliceSize");
             $R{"slice.$slice.volSliceStart"} = $rep1->value("slice.$x.volSliceStart");
             $slice++;
         }
      }
# VE
    } elsif ($dev->{type} eq "ve") { # luns from vicoms
      $R{"fru.$fru.ipNo"}       = $rep1->id('ip');
      $R{"fru.$fru.version"}    = $rep1->value('initiator.version');
      $R{"fru.$fru.fruSlot"}  = $slot;
      $R{"fru.$fru.fruType"}    = "ve";
      $fru++;
      if ($first_ve) {
        $first_ve = 0;
        $rep1 = $rep1->subset("logical");
        foreach my $ix (keys %$rep1) {
          if ($ix =~ /(\w+)\.capacity/) {
             my $id = $1;
             $R{"lun.$lun.lunIndex"} = $lun;
             $R{"lun.$lun.volId"}       = $dev->{name} . "-vol$lun";
             $R{"lun.$lun.lunName"}     = $dev->{name} . "-vol$lun";            
             $R{"lun.$lun.lunType"}     = $rep1->value("$id.type");
             $R{"lun.$lun.lunCapacity"} = $rep1->value("$id.capacity");
             $R{"lun.$lun.lunId"}       = $rep1->value("$id.name");
             my $ww = $rep1->value("$id.serial");
             $ww =~ s/-//;
             $R{"lun.$lun.lunWwn"}      = $ww;
             $R{"lun.$lun.lunStatus"}   = $rep1->value("$id.status") || "N/A";
             $total_cap +=  $R{"lun.$lun.lunCapacity"};
             $lun++;
          }
        }
      }
    }
    $slot++;
  }
  $R{"info.totalCapacity"} = $total_cap;
  $R{"info.slotTotal"} = $slot;  # slot 0 exists (sp)
  $R{"info.fruTotal"} = $fru;    # fru 0 exists
  $R{"info.lunTotal"} = $lun - 1;
  $R{"info.sliceTotal"} = $slice - 1;

  if (substr($model,0,2) eq "39") {
     $R{"info.supportedRAIDType"}    = "RAID1,RAID5";
  } else {
     $R{"info.supportedRAIDType"}    = "RAID1,RAID5";
  }
  $class->addIdentification(\%R);
  return \%R;
}
sub copy {
   my($slot, $fru, $R, $key, $rep1) = @_;

   $R->{"fru.$fru.fruSlot"} = $slot;
   my $ix = index($key, ".");
   my $key0 = substr($key,$ix+1);
   $R->{"fru.$fru.fruId"} = $key0;
   foreach my $el ('fruType','fruModel','fruRevision','fruSerialNo','fruVendor','fruState','fruStatus') {
      $R->{"fru.$fru.$el"} = $rep1->value("$key.$el");
   }
   $fru++;
   return $fru;
}


sub REPORT {
  my($class, $host, $r, $arg) = @_;

  my($name) = $r->{_id}{name};
  my($comm);
  my($out);
  my $q = $arg->{q};
  my($tableCnt) = $arg->{tableCnt};
  my $G = Labels->read();
  my($host0) = $host || System->hostname();
  $comm = "<br><font color=red>Management-Path Lost!</font>" if ($r->{_status} eq "CC");

  my($v) = $r->{_value};
  my $seq = $v->{'info.power_sequencer.status'} || "N/A";
  $out .= $class->reportHead($v->{'info.model'}, $r);
  $out .= "
   <tr><td bgcolor=#D0D0F0 align=right width=10%><b>Name:</td><td colspan=3>&nbsp;$r->{_id}{display}</td>
   <tr><td bgcolor=#D0D0F0 align=right width=10%><b>Model:</td><td width=25%>&nbsp;$v->{'info.model'}</td>
       <td bgcolor=#D0D0F0 align=right width=10%><b>Capacity:</td><td width=25%>&nbsp;$v->{'info.totalCapacity'}</td>
   <tr>
        <td bgcolor=#D0D0F0 align=right width=10%><b>Revision:</td>
        <td >&nbsp;$v->{'info.firmwareLevel'}</td>
        <td bgcolor=#D0D0F0 align=right width=10%><b>Power Sequencer:</td>
        <td >&nbsp;$seq $v->{'info.power_sequencer.error'}</td>
   <tr><td bgcolor=#D0D0F0 align=right width=10%><b>Totals:</td><td colspan=3>&nbsp;Slots:$v->{'info.slotTotal'}, Volumes: $v->{'info.lunTotal'}, Slices: $v->{'info.sliceTotal'}, Ports: $v->{'info.portTotal'}</td>
  </table>
  <table border=0 cellspacing=0 width=100% bgcolor=white><tr><td></table>
  <table border=1 cellspacing=0 width=95% bgcolor=white>
   <tr bgcolor=#D0D0F0><th>Slot
       <th>Name
       <th>Status
  ";
  my($x);
  my @E   = ('Normal','Warning','<font color=red>Error',
             '<font color=red>Error/Critical');
  my @GIF = ("", "Warning", "<font color=red>Error", "<font color=red>Error/Critical");

  for ($x=0; $x < $v->{'info.slotTotal'}; $x++) {
     my $type = $v->{"slot.$x.dev-type"};
     my $type0 = $type eq "sp" ? "host": $type;
     my $label = $v->{"slot.$x.dev-userLabel"} || $type0;
     my $name = $v->{"slot.$x.dev-name"};
     my $status = $v->{"slot.$x.status-sev"};
     my $info = $v->{"slot.$x.status-desc"};
     my $k    = "$type0:" . $v->{"slot.$x.dev-key"};
     my $h1 =  ($v->{"id.mgmtLevel"} eq "D") ? $v->{"id.ipno"} : $host;
     my $u = "<a href=$Http::WEBPROC?GO=GUI::Instr::rStart&file=$k&host=$h1>$name</a>";
     my $u2 = $GIF[$status] || "Normal";
     $out .= "<tr><td><b>&nbsp;$x-$label<td>&nbsp;$u<td>&nbsp;$u2\n";
     #$out .= "<tr><td colspan=3><small>$info" if (length($info) > 2);
  }
  $out .= "</table>
  <table border=0 cellspacing=0 width=100% bgcolor=white><tr><td></table>
  <table border=1 cellspacing=0 width=95% bgcolor=white>
   <tr bgcolor=#D0D0F0><th>Port
       <th>Id
       <th>WWN
       <th>Status
  ";
  for ($x=0; $x < $v->{'info.portTotal'}; $x++) {
     my $type   = $v->{"fcPort.$x.encName"};
     my $status = $GIF[$v->{"fcPort.$x.status-sev"}] || "Normal";
     my $wwn    = $v->{"fcPort.$x.LocalPortWWN"};
     $out .= "<tr><td>&nbsp;<b>" . ($x+1) . 
                "<td>&nbsp;$type<td>&nbsp;$wwn<td>&nbsp;$status</td>\n";
     my $info = $v->{"fcPort.$x.status-desc"};
     #$out .= "<tr><td colspan=4><small>$info" if ($info);

  }
  my $tot = $v->{'info.fruTotal'};
  $out .= "</table>
  <table border=0 cellspacing=0 width=100% bgcolor=white><tr><td></table>
  <table border=1 cellspacing=0 width=95% bgcolor=white>
   <tr bgcolor=#D0D0F0><th>FRU
       <th>Type
       <th>Name
       <th>Rev
       <th>Status
  ";
  my @ER = ($G->{ok}, $G->{warning}, $G->{error}, $G->{down});
  my ($dev, $last_dev);
  for ($x=0; $x < $tot; $x++) {
     my ($name , $info, $rev, $status);
     my $slot   = $v->{"fru.$x.fruSlot"};
     my $type   = $v->{"slot.$slot.dev-type"};
     my $type2  = $v->{"slot.$slot.dev-userLabel"} || $type;
     if ($type eq "sp") {
       $name  = $v->{"fru.$x.info-model"};
       $rev   = $v->{"fru.$x.info-os_version"};
       $status= "OK";


     } elsif ($type =~ /switch/) {
       $name = $v->{"slot.$slot.dev-name"};
       $rev  = $v->{"fru.$x.version-FLASH"} . "/" . $v->{"fru.$x.version-HW"};
       $status = $ER[$v->{"slot.$slot.status-sev"}];

     } elsif ($type =~ /ve/) {
       $name = $v->{"slot.$slot.dev-name"};
       $rev  = $v->{"fru.$x.version"};
       $status = $ER[$v->{"slot.$slot.status-sev"}];

     } elsif (index(Agent::SE->arrays, $type) >= 0) {
       $dev = $v->{"slot.$slot.dev-name"};
       if ($dev ne $last_dev) {
          $out .= "<tr bgcolor=#FFFFEE><td>&nbsp;<td><b>$type2<td colspan=3><b>&nbsp;$dev\n";
          $last_dev = $dev;
       }
       $name = $v->{"fru.$x.fruId"};
       $rev  = $v->{"fru.$x.fruRevision"};
       $status = $v->{"fru.$x.fruStatus"} . "/" . $v->{"fru.$x.fruState"};
     }

     $out .= "<tr><td center>$slot.<b>$x<td>&nbsp;<td>$name<td>$rev&nbsp;<td><center>$status&nbsp;</td>\n";

  }
  $out .= "</table>";

  $out .= "</table>
  <table border=0 cellspacing=0 width=100% bgcolor=white><tr><td></table>
  <table border=1 cellspacing=0 width=95% bgcolor=white>
   <tr bgcolor=#D0D0F0><td colspan=6 bgcolor=#FFFFEE><b>Volumes / Pools
   <tr bgcolor=#D0D0F0><th>#
       <th>Id
       <th>Name
       <th>Status
       <th>Raid
       <th>Capacity
  ";

  my $tot = $v->{'info.lunTotal'};
  my $last = $tot;
  my $MAX = 130;
  $last = $MAX if ($last > $MAX && !$q->{ALL});
  for ($x=1; $x <= $last; $x++) {
     my $type   = $v->{"lun.$x.lunVolName"};
     my $status = $v->{"lun.$x.lunStatus"};
     my $name   = $v->{"lun.$x.lunName"};
     my $cap    = sprintf("%.3f", $v->{"lun.$x.lunCapacity"} / 1024);
     my $raid   = $v->{"lun.$x.lunRaidLevel"};

     $out .= "<tr><td center>" . ($x-1) . 
            "<td><center>$type</td>
             <td>$name</td>
             <td>$status</td>
             <td>$raid&nbsp;</td>
             <td align=right>$cap GB</td>
             ";

  }
  $out .= "</table>";

  if ($tot > $last) {
    my $key = $r->id("category") . ":" . $r->id("deviceName");
    $out .= "<a href=$Http::WEBPROC?GO=GUI::Instr::rStart&file=$key&Roption=1&ALL=1>[ Show All Luns ($tot)]</a>\n";
  }

  $out .= "
  <table border=0 cellspacing=0 width=100% bgcolor=white><tr><td></table>
  <table border=1 cellspacing=0 width=95% bgcolor=white>
   <tr bgcolor=#D0D0F0><td colspan=4 bgcolor=#FFFFEE><b>Slices / Luns
   <tr bgcolor=#D0D0F0><th>#
       <th>VolId
       <th>Name
       <th>Size
  ";
  my $tot = $v->{'info.sliceTotal'};
  for ($x=1; $x <= $tot; $x++) {
     my $vol   = $v->{"slice.$x.volId"};
     my $size  = sprintf("%.3f", $v->{"slice.$x.volSliceSize"}/1024/1024/2);
     my $n2    = $v->{"slice.$x.volSliceName"};
     my $name  = $v->{"slice.$x.lunName"};

     $out .= "<tr><td center>" . ($x-1) . "
            <td><center>$vol&nbsp;</td>
            <td>$name $n2&nbsp;</td>
            <td align=right>$size GB&nbsp;</td>
             ";

  }
  $out .= "</table>";
  $out .= "&nbsp;<p>&nbsp;";
}
1;
