package Agent::3310;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: 
use strict;
use Agent;
use base 'Agent';

sub isSelectable {"Sun 3310"}
sub revision {'$Revision: 1.62 $'}

sub category {Report::CAT_3310}
use vars qw ($SCCLI_TO);

$SCCLI_TO = 200;

sub new {
  my($self) = Agent->new();

  bless ($self, 'Agent::3310');
  return $self;
}

# translate port to the right  CIM key 

sub getPortKey {
  my($class, $wwn, $port) = @_;
  return "$wwn.$port";
}

sub RUN {
  my($agent) = @_;
  my($HBA, $logfile, $r, @results);
  my($xml, @lux_dif, $dif, $ev, $found);
  my($log_err, $lines);
  my(%DONE, $report, $device, $key, $id, $x, $l, $connect_errs);
  $DB::single=1;
  
  my $renv = System->get_renv();
  my $type = $agent->category();

  Timelapse->start(ref($agent));

  my $today = Util->today("YMDH");


  my($dc) = 0;

  foreach $device ( $agent->deviceList()) {
    next if ($device->{active} eq "N");
    $dc++;
    Debug->print1("-> " . uc($device->{type}) . ": Reading device $device->{name}/$device->{wwn}/$device->{path}");

    my($err, $lines) = $agent->readLog($device, $report);
    my($warn_lines)  = $agent->find_alert($lines, $device);
    if ($warn_lines) {
        $id = {
              deviceName  =>  $device->{key},
              active      => "Y",
              display     => "$device->{name}/ $device->{ipno}",
              name        => $device->{name},
              class       => "storage.$type",  # Report::CAT_3310MESSAGE
              category    => $type . "message",
              ip          => "",
           };
        $report->{"id.name"} = $device->{name};
        PDM->saveReport( Report->new($id, $report , $warn_lines, Report::STATUS_OK));
    }

    ($key, $connect_errs, $report) = $agent->INSTRUMENTATION($device);
    if ($connect_errs eq "BUSY") {
       Debug->print2("Device $device->{name} is busy, skipping!");
       next;
    }

    $key= lc($key);

    $id = {  
              deviceName  => $device->{key},
              active      => $device->{active},
              logFile     => "",
              display     => "$device->{name} (wwn=$device->{key})",
              name        => $device->{name},
              class       => $device->{class},
              category    => $type,
              ip          => "",
           };
     $report = {} if (!$report);
     $agent->copyDev($device, $report);

     $HBA = $device->{hba} || System->get_hba;
     $report->{"id.name"} = $device->{name};
     $report->{"id.ipno"} = System->get_ipno();
     $report->{"id.wwn"}  = $device->{key};

     if ($connect_errs || !$key) {
        $report->{'id.connect_errs'} = $connect_errs;
        PDM->saveReport(
          Report->new($id, $report , undef, Report::STATUS_CANNOT_CONNECT));

     } else {
        PDM->saveReport(Report->new($id, $report , undef));
     }
  } 
  Debug->print2("  No devices found") if (!$dc);
  Timelapse->stop(ref($agent));
}

############################################################################

use vars qw ($ERR);


sub getWWN {
  my($agent, $name, $host) = @_;
  my($wwn);
  $ERR = undef;
  my $TO  = $SCCLI_TO + 5;

  if (!$host) {
     return &get_WWN({name => $name});
  } else {
     my $rc = Util::Http->getCommand($host, "Agent::3310::WWN&name=$name&HTTP=1" , $TO);
     if ($rc !~ /OK /) {
        $ERR = "3310: getWWN: cannot identify $name on $host";
        return undef;
     } else {
        my $VAR1;
        my $ix = index($rc, "OK ");
        eval substr($rc,$ix+3);
        return $VAR1;
     }
  }
}

sub FCCounters {
  my($class, $arg) = @_;
  my(%SW, $x , %X);

  my($renv, $devs, $host,$notifs) = PDM::ConfigFile->read();
  my $type = $class->category();
  foreach my $d (@$devs) {
    next if ($d->{active} eq "N");
    next if ($d->{type} ne $type);
    my $R = {};
    $class->getFC($d, $R);
    for ($x=0; $x < 8; $x++) {
        my $key = "|$d->{key}|port.$x|$type";
        if (exists $R->{"channel.$x.lip"}) {
           $X{$key} = $R->{"channel.$x.error.link"}   . "\t" . 
                      $R->{"channel.$x.error.signal"} . "\t" .
                      $R->{"channel.$x.error.seq"}    . "\t" .
                      $R->{"channel.$x.error.crc"}    . "\t" .
                      $R->{"channel.$x.error.sync"}   . "\t" .
                      $R->{"channel.$x.error.itw"}   ;
        }
    }
  }
  return { data => \%X,  hba => {} };
}

sub getFC {
  my($class, $device, $rep) = @_;
  
  my $TO    = $SCCLI_TO;
  my $sccli = &sccli_path();
  my $w = $device->{path} || $device->{ipno};
  my($err, $com, $chan);
  for ($chan=0; $chan < 8; $chan++) {
    ($err,$com) = Util->run_command("$sccli $w diag error -chan $chan", "chan.txt" , $TO);
    foreach my $el (@$com) {
      last if ($el =~ /Times of/);
      my($el, $v) = split(/\: /, $el, 2);
      if ($el =~ /LIP/){
         $rep->{"channel.$chan.error.lip"} = $v;
      } elsif ($el =~ /Link/) {
         $rep->{"channel.$chan.error.link"} = $v;
      } elsif ($el =~ /Sync/) {
         $rep->{"channel.$chan.error.sync"} = $v;
      } elsif ($el =~ /Signal/) {
         $rep->{"channel.$chan.error.signal"} = $v;
      } elsif ($el =~ /Primitive/) {
         $rep->{"channel.$chan.error.seq"} = $v;
      } elsif ($el =~ /Transmission/) {
         $rep->{"channel.$chan.error.itw"} = $v;
      } elsif ($el =~ /CRC/) {
         $rep->{"channel.$chan.error.crc"} = $v;
      }
    }
  }
}

sub sccli_path {
  return System->get_home() . "/bin/sccli";
}

sub get_WWN {
  my($q) = @_;
  my $report = {};
  Agent::3310->getConfig({ipno => $q->{name} }, $report);
  my $rc;
  my $sn = sprintf("%6.6d", hex($report->{'info.unique_id'}));
  $rc->{key}      = "206000c0ff$sn" if ($report->{'info.unique_id'});

  my $type        = $report->{'info.model'};
  $type           =~ s/StorEdge\s+//;
  $rc->{userLabel} = $type;
  $type           = "3310" if ($type =~ /N/);
  $rc->{type}     = $type || "3510";

  $rc->{model}    = $report->{'info.model'};
  $rc->{units}    = 1;
  $rc->{wwns}     = "";
  $rc->{revision} = $report->{'info.firmware_version'};
  $rc->{serial}   = $report->{'info.primary_sn'};
  $rc->{ip}       = $report->{'info.ip'};
  $rc->{wwn}      = $rc->{key};

  Agent::3310->getPortWWNS({ipno => $q->{name}} , $report);
  my ($x,$wc);
  for ($x=0; $x <= 10; $x++) {
     if (exists( $report->{"port.$x.wwn"} ) ) {
        $rc->{"wwn$wc"} = $report->{"port.$x.wwn"};
        $wc += $wc ? 1 : 2;
     }
  }

  $rc->{report}   = $report;

  if ($q->{HTTP}) {
    $Data::Dumper::Indent = 0;
    print "\nOK " . Data::Dumper($rc) . "\n";
  } else {
    return $rc;
  }

}

sub get_WWN0 {
  my($q) = @_;
  my $name = $q->{name};
  my $sccli = System->get_home() . "/bin/sccli";
  my($err,$com) = Util->run_command("$sccli $name inquiry", 
                          "luxadm.txt" , 30);
  if ($err) {
    $q->{HTTP}? print "\nERR $err" : return $err;
  }
  my $rc = {};
  foreach my $l (@$com) {
     if ($l =~ /Product: StorEdge (.+)/) {
        $rc->{model} = $1;
     } elsif ($l =~ /Revision: (.+)/) {
        $rc->{revision} = $1;
     } elsif ($l =~ /Serial Number: (.+)/) {
        $rc->{serial} = $1;
     } elsif ($l =~ /IP Address: (.+)/) {
        $rc->{ip} = $1;
     }
  }
  $rc->{key}   = "204000c0ff0" . $rc->{serial};
  $rc->{wwn}   = $rc->{key};
  $rc->{type}  = "3310";
  $rc->{units} = 1;
  $rc->{wwns}  = "";

  if ($q->{HTTP}) {
    $Data::Dumper::Indent = 0;
    print "\nOK " . Data::Dumper($rc) . "\n";
  } else {
    return $rc;
  }
}



sub INSTRUMENTATION {
  my($agent, $device) = @_;
  my(@s, %dev, $in, $key, $state, $num);
  my $report = {};
  my $renv = System->get_renv();
  my $ping_to  = $renv->{'timeout.ping'} || 10;

  $report->{'info.ethernet_status'} = "ok";
  if ($device->{ipno} && !Util->testIp($device->{ipno},$ping_to)) {
     $report->{'info.ethernet_errs'} = "Ping failed to $device->{ipno} (timeout=$ping_to)";
     $report->{'info.ethernet_status'} = "ping_failed";
  }
  my $err1 = $agent->getInquiry($device, $report);
  return ($device->{key}, $err1, $report) if ($err1);

  my $err2 = $agent->getConfig($device, $report);
  $err2    = $agent->getFC($device, $report);
  $err2    = $agent->getPortWWNS($device, $report);
  $err2    = $agent->getLunMaps($device, $report);

  return ($device->{key}, "", $report);
}

use Policies;
sub find_alert {
  my($class, $lines, $device) = @_;
  my @err;
  my $policies = Policies->new("3310_policies");
  my($x);
  for ($x = 0; $x <= $#$lines; $x++ ) {
     my $line = $lines->[$x];
     my $comp1 = "other";
     if ($line =~ / Controller /) {
         $comp1  = "controller";
     } elsif ($line =~ / CPU /) {
         $comp1  = "cpu";
     } elsif ($line =~ / PS \d/) {
         $comp1  = "power";
     } elsif ($line =~ / Fan \d/) {
         $comp1  = "fan";
     }
     my $key0 = $device->{type} . ":" . $device->{key};
     my $key  = "$key0:$comp1";
     #                            ix  disk    t3b0             key   
     $policies->run(\@err, $lines,\$x,$comp1, $device->{name}, $key, $device->{ipno}, $key0, 1);
  }
  return ( \@err);

}

sub readLog {
  my($class, $device, $report) = @_;
  my $TO    = $SCCLI_TO;
  my $sccli = &sccli_path();
  my $renv = System->get_renv();
  my $w = $device->{path} || $device->{ipno};
  my @lines;
  my $cache = PDM->getCacheHandle("read_log_file");
  my $last_date = $cache->{START}{$w};

  my($err,$com) = Util->run_command("$sccli $w show events last 500", "luxadm.txt" , $TO);
  return ($err, $com) if ($err);
  my ($date, $x);
  open(O, ">>/var/adm/messages.3310");

  for ($x=0; $x <= $#$com; $x++) {
     my $l = $com->[$x];
     if ($l =~ /(\w+) +(\w+) +(\d+) (\d\d\:\d\d\:\d\d) (\d+)/) {
        my $mth = $Util::MTH{$2};
        my $time = substr($4,0,8);
        $date = sprintf("%2.2d-%2.2d-%2.2d %s", $5, $mth, $3, $time);
        $x++ if ($last_date && $date le $last_date);

     } elsif ($l =~ /\[(\w+)\] \#\d+\: .*SN\#(\w+)/ ) {
         my $ecode = $1;
         my $sn    = $2;
         my $sev   = 0;
         $date = Util->get_today() if (!$date);
         push(@lines, "$date $l");
         print O "$date $w $l\n";    
     }
  }
  $date = &round($date);
  $cache->{START}{$w} = $date;
  Debug->print2("Found " . ($#lines+1) . " entry(s) in 3310/3510 log file.");
  close(O);

  if ($renv->{delete_3300_log}) {
    my($err,$com) = Util->run_command("$sccli $w clear events", "luxadm.txt" , $TO);
  }
  
  return (undef, \@lines);
}


# yyyy-mm-dd hh:mm:ss

sub round {
  my($d) = @_;

  my $secs = substr($d,11,2) * 3600 + substr($d,14,2) * 60 + substr($d,17);
  $secs++;

  my $h = int($secs / 3600);
  $secs -= $h * 3600;
  my $m = int($secs / 60);
  $secs -= $m * 60;
  
  my $d2 = substr($d, 0, 11) . sprintf("%2.2d:%2.2d:%2.2d\n", $h, $m, $secs);
  return $d2;
}



# sccli diag229 show port-wwns 
# sccli: selected se3000://172.20.67.229:58632 [SUN StorEdge 3510 SN#000003]
#Ch  Id   WWPN
#-------------------------
# 0  112  216000C0FF000003
# 1  113  226000C0FF100003
# 4  114  256000C0FF200003
# 5  115  266000C0FF300003


sub getPortWWNS {
  my($class, $device, $report) = @_;

  my $TO    = $SCCLI_TO;
  my $sccli = &sccli_path();
  my $w = $device->{path} || $device->{ipno};

  my($err,$com) = Util->run_command("$sccli $w show port-wwns", "luxadm.txt" , $TO);
  foreach my $l (@$com) {
     $l = Util->ltrim($l);
     if ($l =~ /(\d+)\s+(\d+)\s+(\w+)/) {
         my $port = $1;
         my $id   = $2;
         my $wwn  = $3;
         $report->{"port.$port.id"} = $id;
         $report->{"port.$port.wwn"} = lc($wwn);
     }
  }
}

#sccli diag229 show lun-maps 
#sccli: selected se3000://172.20.67.229:58632 [SUN StorEdge 3510 SN#000003]
#Ch Tgt LUN   ld/lv  ID-Partition  Assigned
#-------------------------------------------
# 0 112   0   ld0    7DE450A8-00   Primary  
# 0 112   3   ld0    7DE450A8-00   Primary  
# 1 113   0   ld1    29947214-00   Secondary
# 4 114   0   ld0    7DE450A8-00   Primary  
# 4 114   1   ld0    7DE450A8-00   Primary  


sub getLunMaps {
  my($class, $device, $report) = @_;

  my $TO    = $SCCLI_TO;
  my $sccli = &sccli_path();
  my $w = $device->{path} || $device->{ipno};

  my($err,$com) = Util->run_command("$sccli $w show lun-maps", "luxadm.txt" , $TO);
  my $lun = 0;
  foreach my $l (@$com) {
     $l = Util->ltrim($l);
     if ($l =~ /(\d+)\s+(\d+)\s+(\d+)\s+(\w+)\s+([^\s]+)\s+(\w+)/) {
         my $ch     = $1;
         my $target = $2;
         my $lun    = $3;
         my $ld     = $4;
         my $part   = $5;
         my $ass    = $6;
         $report->{"lun.$lun.channel"} = $ch;
         $report->{"lun.$lun.target"}  = $target;
         $report->{"lun.$lun.lun"}     = $lun;
         $report->{"lun.$lun.ld"}      = $ld;
         $report->{"lun.$lun.partition"}  = $part;
         $report->{"lun.$lun.assigned"}   = $ass;
         $lun++;
     }
  }
}
  


sub getConfig {
  my($class, $device, $report) = @_;

  my $TO    = $SCCLI_TO;
  my $sccli = &sccli_path();
  my $w = $device->{path} || $device->{ipno};

  my($err,$com) = Util->run_command("$sccli $w show configuration -x", "luxadm.txt" , $TO);

  return $err if ($err);
  while ($com->[$#$com] !~ /raidbaseview/ && $#$com > 10) {
       $#$com--;
  }
  my $in;
  require XML::LibXML;
  my $parser = XML::LibXML->new();
  my $dom;
  eval {
    $dom  = $parser->parse_string("@$com");
  };
  if ($@) {
     Debug->print2("Error parsing XML in 'show configuration': " . substr("@$com", 0, 100));
     return;
  }
  my $elem = $dom->getDocumentElement();
  my @raid = $elem->findnodes("raidsystem");
  my $raid1 = $raid[0];
  &xml2report( $report, $raid1, "", 0);
}



# translate xml to snmp structure.

sub xml2report {
  my( $report, $node, $prefix, $level)  = @_;
  my(%MAP);
  my $prefix0 = "$prefix." if ($prefix);
  require XML::LibXML;

  foreach my $el ($node->getChildNodes()) {
    next if ($el->getType() != &XML::LibXML::ELEMENT_NODE() );
    my $name = $el->getName();
    my $pr;
    my @ch1 = $el->getChildNodes();

    if (index(",fru,channel,logical_drive,disk,partition,", ",$name,") >= 0) {
      $MAP{$name}++;
      $pr = "$prefix0$name." . $MAP{$name};
    } elsif ($level == 0 && $#ch1 == 0) {
      $pr = "info.$name";
    } else {
      $name = "components" if ($name eq "config_components");
      $pr = "$prefix0$name";
    }
    if ($#ch1 == 0) {
       $report->{$pr} = $el->textContent();
    } else {
       &xml2report($report, $el, $pr, $level+1);
    }
  }
}

# returns array of hashes

sub discover {
  my($class, $host) = @_;
  my($rc);
  my $VAR1 = [];
  if (!$host) {
     return &get_discover({});
  } else {
     my $rc = Util::Http->getCommand($host, "Agent::3310:discover&HTTP=1" , 
                                       $SCCLI_TO + 10);
     if (substr($rc,0,3) eq "ERR") {
        $ERR = $rc;
        return [];
     } else {
        eval substr($rc,3);
        return $VAR1;
     }
  }
}

sub get_discover {
  my($q) = @_;
 
  my @disco;
  my $TO    = $SCCLI_TO;
  my $sccli = &sccli_path();

  if (-x $sccli) {
     my ($err, $L) = Util->run_command("$sccli --list", "sccli", $TO);
     foreach my $l (@$L) {
        if ($l =~ /\/dev\/([^ ]+) /) {
           my $path = "/dev/$1";
           my $rc = &get_WWN({name => $path});
           $rc->{path} = $path;
           push(@disco, $rc);
        }
     }
  }
  if ($q->{HTTP}) {
    require Data::Dumper;
    print "OK " . Data::Dumper::Dumper(\@disco);
  } else {
    return \@disco;
  }
}
  

sub getInquiry {
  my($class, $device, $rep) = @_;

  my $TO    = $SCCLI_TO;
  my $sccli = &sccli_path();

  my $w = $device->{path} || $device->{ipno};

  my($err,$com) = Util->run_command("$sccli $w inquiry", "luxadm.txt" , $TO);
  return $err if ($err);
  return "ERR: $device->{name}/$w not responding to sccli inquiry" if ("@$com" =~ /device not found/ || $#$com < 0) ;

  foreach my $l (@$com) {
    if ($l =~ /([^\:]+): (.*)/) {
       my $name = Util->trim($1);
       my $value = Util->trim($2);
       $name =~ s/Page .. //;
       $name =~ s/ /_/g;
       $rep->{"info.$name"}  = $value;
    }
  }
  return undef;
}



sub FRUS {
  my($class, $r, $name) = @_;
  my($v) = $r->{_value};
   my @FRUS;
  my $devtype = $v->{"id.device_userLabel"} || "3310";

  foreach my $el (sort keys %$v) {
     if ($el =~ /components.disk.(\d+).model/) {
        my $ix = $1;
        my $d = "components.disk.$ix";
        my $model  = $v->{"$d.model"};
        my $vendor = $v->{"$d.manufacturer"};
        my $serial = $v->{"$d.serial_number"};
        my $rev    = $v->{"$d.product_revision"};
        my $status = $v->{"$d.status"};

        push(@FRUS, [ $name ,$devtype, "disk", "disk.$ix",
             $vendor || " N/A", $model||" N/A", $serial||" N/A", $rev, $status]);
     }
  }
  return \@FRUS;
}

sub REPORT {
  my($class, $host, $r, $arg) = @_;

  my($v) = $r->{_value};
  my($out);
  my($tableCnt) = $arg->{tableCnt};
  my($host0) = $host || System->hostname();

  $out .= $class->reportHead($v->{'info.product'}, $r);
  my $cnt;
  $out .= "<tr> <td colspan=4><center><b>$v->{'info.name'}</td>";
  foreach my $el (sort keys %$v) {
     if ($el =~ /^info\.(.+)/)  {
       my $n = $1;
       next if (index(",Serial_Number,manufacturer,model,Vendor,name,sccli,unique_id,", ",$n,") >= 0);
       $n =~ s/id_of_//;
       $n =~ s/^total_//;
       $n =~ s/_/_ /;
       $out .= "<tr>" if ($cnt++ % 2 == 0);
       my $v1 = $v->{$el};
       if (length($v1) > 15) {
         $v1 = substr($v1,0,14) . " " . substr($v1,14);
       }
       $out .= "<td bgcolor=$Style::LIGHT align=right>$n:</td>
                   <td>&nbsp;$v1</td>";
     }
  }
  $out .= "</table>";

# CHANNELS

  $out .= "<table border=1 cellspacing=0 width=95% bgcolor=white>
    <tr bgcolor=$Style::DARK><td colspan=7><font color=white><b>Channels</td>
    <tr bgcolor=$Style::LIGHT>
        <th>#
        <th>Port
        <th>Type
        <th>Media
        <th>Speed
        <th>Width
        <th>PID/SID
   ";
  my($x);
  my $port= 0;
  for ($x=1; $x <= 100; $x++) {
     last if (!$v->{"channel.$x.type"});
     my $mode = $v->{"channel.$x.mode"};
     my $p;
     if ($mode eq "Host") {
        $port++;
        $p = $port;
     }
     $out .=<<EOF;
        <tr><td>$v->{"channel.$x.idx"}</td>
         <td>&nbsp;$p</td>
         <td>$mode</td>
         <td><center>$v->{"channel.$x.type"}</td>
         <td><center>$v->{"channel.$x.curclk"} 
         <td><center>$v->{"channel.$x.defwid"}
         <td><center>$v->{"channel.$x.pid"}/$v->{"channel.$x.sid"}&nbsp;
EOF
  }
  $out .= "</table>";

# DISKS

  $out .= "<table border=1 cellspacing=0 width=95% bgcolor=white>
    <tr bgcolor=$Style::DARK><td colspan=6><font color=white><b>Disks</td>
    <tr bgcolor=$Style::LIGHT>
        <th>Ch-Id
        <th>Size(MB)
        <th>Status
        <th>Model / Serial#
        <th>Rev
   ";
  my $x;
  for ($x=1; $x <= 100; $x++) {
     last if (!$v->{"components.disk.$x.model"});
     my $s = $v->{"components.disk.$x.capacity"};
     $s =~ s/MB/M/;
     $s = substr($s,0,-4) . "," . substr($s,-4) if (length($s) > 4);
     $out .=<<EOF;
        <tr><td>$v->{"components.disk.$x.ch"}-$v->{"components.disk.$x.target"}</td>
         <td align=right>$s&nbsp;</td>
         <td><center>$v->{"components.disk.$x.status"}</td>
         <td><small>$v->{"components.disk.$x.model"} / 
                    $v->{"components.disk.$x.serial_number"}&nbsp;
         <td>$v->{"components.disk.$x.product_revision"} 
EOF
  }
  $out .= "</table>";

# FRUS

  $out .= "<table border=1 cellspacing=0 width=95% bgcolor=white>
    <tr bgcolor=$Style::DARK><td colspan=6><font color=white><b>Frus</td>
    <tr bgcolor=$Style::LIGHT>
        <th>#
        <th>Name
        <th>Vendor/Model/Serial
        <th>Rev.
   ";
  my $x;
  for ($x=1; $x <= 100; $x++) {
     last if (!$v->{"fru.$x.model"});
     my $item = $v->{"fru.$x.description"};
     $out .=<<EOF;
        <tr>
              <td>$v->{"fru.$x.idx"}</td>
              <td><small>$item</td>
              <td><small>$v->{"fru.$x.vendor_jedec_id"}/ $v->{"fru.$x.model"}/ $v->{"fru.$x.serial_number"}</td>
              <td><center>$v->{"fru.$x.revision"}</td>
EOF
  }
  $out .= "</table>";

# LOGICAL

  $out .= "<table border=1 cellspacing=0 width=95% bgcolor=white>
    <tr bgcolor=$Style::DARK><td colspan=6><font color=white><b>Logical</td>
    <tr bgcolor=$Style::LIGHT>
        <th>#
        <th>Role
        <th>Drives
        <th>Status
        <th>Size
        <th>Raid
   ";
  my ($x, $y);
  for ($x=1; $x <= 100; $x++) {
     last if (!$v->{"logical_drive.$x.size"});
     my $s = sprintf("%.3f GB", $v->{"logical_drive.$x.size"}/ 1024);

     $out .=<<EOF;
        <tr><td>$v->{"logical_drive.$x.idx"}
            <td>$v->{"logical_drive.$x.assignment"}
            <td><center>$v->{"logical_drive.$x.number_of_drives"}
            <td><center>$v->{"logical_drive.$x.status"}
            <td align=right>$s
            <td>$v->{"logical_drive.$x.raid_level"}
EOF
     my $part = $v->{"logical_drive.$x.total_partitions"};
     my $dr   = $v->{"logical_drive.$x.physical_drive"};
     my $out1 = "<tr><td>&nbsp;</td><td colspan=5>Partition_cnt: $part, physical drive: $dr<br>";
     for ($y=1; $y <= $part; $y++) {
       my $eff = sprintf("%.3f GB", $v->{"logical_drive.$x.partition.$y.effective_size"}/1024);
       $out1 .= "Partition-$y: Effective size: $eff<br>";
     }
     $out .= "$out1</td>";
  }
  $out .= "</table>&nbsp;<p>&nbsp;<p>";

  return $out;

}



1;

