package TO::Graph;
use System;
use strict;

sub leaf { 0 }

use vars qw($zoom $scale $FULL $DISK @iconWidth @iconHeight @iconPort @iconPort $red $black $white $yellow $green $blue $OFF $red2 %portNode $INC_NODES $gdFontHeight $gdFontWidth $font $showLinkHandle $font2 $gdFont2Height $gdFont2Width);

$FULL = 60;
$DISK = 10;  # disk width
$OFF  = 0;
$INC_NODES = ",sw,ho,ve,br,mc,sv,";


@iconWidth  = ($FULL, 50, 40, 30);
@iconPort   = (9,      8,  6,  5);
@iconHeight = (90,    75, 60, 45);


#  args = {zoom, showLinkHandle }
sub display {
  my($class, $parm_s, $png_file, $args) = @_;

  require "GD.pm";
  $showLinkHandle = $args->{showLinkHandle};
  $zoom           = $args->{zoom};
  $scale          = $iconWidth[$zoom] / $FULL;
  my $circle      = $args->{circle};

  my (@edges, @nodes);
  %portNode = ();
  my %POS;
  my @parms = split(/\n/, $parm_s);
  my ($max_height, $p_ix, $max_width, $sw_cnt);
  for ($p_ix=0; $p_ix <= $#parms; $p_ix++) {
     my($no, $type, $category, $label,$x, $y, 
        $status, $portStatus, $diskStatus, $otherStatus, 
        $encInfo, $portInfo, $diskInfo, $otherInfo, $testInfo ) = split(/\|/, $parms[$p_ix]);

     my($name, $label2, $label3, $label4, $zones, $color, $gif);
     ($label, $label2, $label3, $label4) = split(/,/, $label);

     my $ix = index($label, "=");
     if ($ix > 0) {
        $name = substr($label, $ix+1);
        $label = substr($label, 0, $ix);
     } else {
        my $ix2 = index($label, ":");
        $name  = substr($label, $ix2+1);
     }
     my @vec1 = split(/,/, $category);
     $category = $vec1[0];    
     my($maxpos, $maxpos2, $maxpos3, $maxpos4);
     my($orientation, $code, $prefix1, $prefix2, $others, $longPrefix1, $longPrefix2, $longOthers);
     my($ctrlNames, $slotName, $prefix,$diskRows , $prefix2, $prefix3);
     if ($type eq "v") { # node
        $code = $vec1[1]; 
        if ($category eq "g") {
           $maxpos = $vec1[2]+0;  $maxpos2 = 4; 
           $color = "404040";
           ($color, $gif) = split(/\//, $vec1[4]) if ($#vec1 >= 4);

        } elsif ($category eq "s") { # switch
           $sw_cnt++;
           $maxpos2 = $vec1[3]+0;
           $zones = $vec1[2];
           $color = "F0F0C0";
           ($color, $gif) = split(/\//, $vec1[4]) if ($#vec1 >= 4);
           if ($#vec1 >= 5) {
              $others =  $vec1[5];
              $longOthers = $vec1[6];
           }
           if ($#vec1 >= 7) {
              $orientation =  $vec1[7];
           }
        } elsif ($category eq "h") {
           $maxpos = $vec1[2]+0;
           ($color, $gif) = split(/\//, $vec1[4]) if ($#vec1 >= 4);
           if ($#vec1 >= 5) {
              $others =  $vec1[5];
              $longOthers = $vec1[6];
           }
        } elsif ($category eq "a") { # array
           my @ctrl     = split(/\//, $vec1[2]);
           $maxpos      = $ctrl[0]+0;
           $ctrlNames   = $ctrl[1] if ($#ctrl >= 1);
           my @slots    = split(/\//, $vec1[3]); 
           $maxpos2     = $slots[0];  # disks count
           $slotName    = $slots[1] if ($#slots >= 1);
           $prefix      = $vec1[4];
           my @vv       = split(/\//, $prefix);
           $diskRows    = $#vv+1;
           $prefix1     = $prefix;
           $others      = $vec1[5];
           $longOthers  = $vec1[6];
           ($color, $gif) =  split(/\//, $vec1[7]);
        }
        my $node = $class->createNode($category, $code, $color, $gif,
            $prefix1, $prefix2, $prefix3, $longPrefix1, $longPrefix2, $others, $longOthers,
            $maxpos, $maxpos2, $maxpos3, $maxpos4, $x, $y, $orientation, $no,
            $status, $portStatus, $diskStatus, $otherStatus,
            $encInfo, $portInfo, $diskInfo, $otherInfo, $testInfo, $zones, $name,
            $label, $label2, $label3, $ctrlNames, $slotName, $diskRows, 1);
        $POS{$no} = $node;
        push(@nodes, $node);
 
      } elsif ($type eq "e") {  # edge
        my($no, $type, $category, $label, $p1, $p2) = split(/\|/, $parms[$p_ix]);
        my ($v1no, $v1Pos) = split(/,/, $p1);
        my ($v2no, $v2Pos) = split(/,/, $p2);

        $portNode{$v1no}{$v1Pos} = $POS{$v2no};
        $portNode{$v2no}{$v2Pos} = $POS{$v1no};

        $v1Pos++ if (index($INC_NODES, substr($v1no,0,2)) < 0);
        $v2Pos++ if (index($INC_NODES, substr($v2no,0,2)) < 0);

        next if (!$POS{$v1no} || !$POS{$v2no});
          #print "Undefined edge nodes ($v1no, $v2no)!\n";
        my $edge = $class->createEdge($category, $POS{$v1no}, $v1Pos, $POS{$v2no},
                         $v2Pos, $label, $label2, $label3, $label4);
        push(@edges, $edge);
      }
  }
  foreach my $n (@nodes) {
     $n->nodeSize();
     $max_height = $n->{j}+$n->{height} if ($max_height < ($n->{j}+$n->{height}));
     $max_width = $n->{i}+$n->{width}   if ($max_width < ($n->{i}+$n->{width}));
  }
  $max_height += 30;
  $max_width  += 30;
  my $height  = $args->{height} eq "MAX" ? $max_height : ($args->{height} || 700);
  my $width   = $args->{width}  eq "MAX" ? $max_width: ($args->{width} || 700);

  my $g       = new GD::Image($width, $height);
  my $nu      = $g->colorAllocate(1, 0, 0);
  $red        = $g->colorAllocate(255, 0, 0);
  $red2       = $g->colorAllocate(255, 100, 100);
  $black      = $g->colorAllocate(0, 0, 0);
  $white      = $g->colorAllocate(255, 255, 255);
  $yellow     = $g->colorAllocate(255, 255, 0);
  $green      = $g->colorAllocate(0, 255, 0);
  $blue       = $g->colorAllocate(200,200,255);
  my $blue2   = $g->colorAllocate(100,100,100);

  $font       = GD->gdSmallFont;
  $font2      = GD->gdTinyFont;
  $gdFontHeight  = 11;
  $gdFont2Height = 7;
  $gdFont2Width  = 6;

  $g->filledRectangle(0,0,$width, $height, $white);
  #$g->rectangle(0,0,$width-1, $height-1, $black);
  $g->string($font2, 3, $height-10, $args->{text}, $blue2) if ($args->{text});

   # PRINT 
   my %Coords;
   my $map;
   foreach my $node (@nodes) { 
       $node->{g} = $g;
       my $x2 = int($node->{i} + $node->{width});
       my $y2 = int($node->{j} + $node->{height});
       my $xy = int($node->{i}) . "," . int($node->{j}) . ",$x2,$y2";
       $Coords{$node->{no}} = [$xy, $node->{label2} . " " . $node->{name}];
       $node->drawNode();
       if ($node->{no} eq $circle) {
         $g->arc($node->{i}+$node->{width}/2, 
                 $node->{j}+$node->{height}/2, 
                 $node->{width}*1.8, $node->{height}*1.8, 0, 360, $blue);
       }
       if ($args->{url}) {
          $map .= "<area coords=\"$xy\" href=\"$args->{url}$node->{no} $args->{target}\">\n";
       }
   }
   foreach my $edge (@edges) {  
       $edge->{g} = $g;
       $edge->drawEdge();
   }
   if ($png_file && open(O, ">$png_file")) {
      print O $g->png();
      close(O);
   }
      
   return ($map, \%Coords);
}

#################
#  EDGE
#################
sub createEdge {
   my($class, $category, $Node1, $v1Pos, $Node2,  
      $v2Pos, $label, $label2, $label3, $label4) = @_;

   my $edge = {};
   $edge->{start}    = $Node1;
   $edge->{end}      = $Node2;
   $edge->{startPos} = $v1Pos;
   $edge->{endPos}   = $v2Pos;
   $edge->{type}     = substr($category,0,1);
   $edge->{label}    = $label;
   $edge->{label2}   = $label2;
   $edge->{label3}   = $label3;
   $edge->{label4}   = $label4;
   my $severity      = substr($label4,0,1);
   $edge->{severity} = $severity;

   bless($edge, "TO::Graph");
   return $edge;
}

sub calcEdge {
  my($edge, $P1, $P2) = @_;
  my $start = $edge->{start};
  my $end   = $edge->{end};

  my @off1 = $start->portOffset($edge->{startPos});
  my @off2 = $end->portOffset($edge->{endPos});
  return () if ($off1[0] == -1 || $off2[0] == -1) ;
  my ($o1, $o2);

  # float scale = ((float)Node.iconWidth[NodeApplet.zoom]/Node.FULL);

  $P1->[0] = ($start->{i}  + $off1[0] + $start->{portSize} /2);
  $P2->[0] = ($end->{i}    + $off2[0] + $end->{portSize}   /2);
  $P1->[1] = ($start->{j}  + $off1[1] + $start->{portSize} /2);
  $P2->[1] = ($end->{j}    + $off2[1] + $end->{portSize}   /2);
  return 1;
}


sub drawEdge {
   my($edge) = @_;

   my $g      = $edge->{g};
   my $type   = $edge->{type};
   my $start  = $edge->{start};
   my $end    = $edge->{end};
   my $severity = $edge->{severity};
   my $label  = $edge->{label};

   my $P1 = [];
   my $P2 = [];
   my $rc = $edge->calcEdge($P1, $P2);
   return if (!$rc);
   my $w = 15;
   my $h = 8;
   if ($zoom == 2) {
      $w=10; $h=8;
   } elsif ($zoom > 2) {
      $w=10; $h=6;
   }
   if ($type eq 'S') { # SCSI, pale link with text on it
     my $col1 = $g->colorAllocate(210,210,210);
     $g->line($P1->[0],   $P1->[1],   $P2->[0],   $P2->[1], $col1);
     $g->line($P1->[0]+1, $P1->[1],   $P2->[0]+1, $P2->[1], $col1);
     $g->line($P1->[0],   $P1->[1]+1, $P2->[0],   $P2->[1]+1, $col1);
     $g->string($font, ($P1->[0]+ $P2->[0]) / 2, ($P1->[1] + $P2->[1]) / 2, $label, $black);

   } else { # other links
     my $flag =0; my $box = 0;
     my $rx = ($P1->[0] + $P2->[0])/2 - $w/2;
     my $ry = ($P1->[1] + $P2->[1])/2 - $h/2;
     $g->line($P1->[0], $P1->[1], $P2->[0], $P2->[1], $black);
     my $col2;
     if ($type eq 'E') {
        if ($severity eq '2') {
           $col2 = $red2; $flag = 1;
        } elsif ($severity eq '1') {
           $col2 = $yellow; $flag = 1;
        } elsif ($severity eq '0') {
           $col2 = $green; $flag = 1;
        }
        $box = 1;
     } else {
        $box = $showLinkHandle;
     }

     if ($box == 1) {
       my $w2 = $w;
       if ($zoom >= 0 && $zoom < 3) {
           my $temp1 = length($label) * $gdFontWidth + 3;
           $w2 = $temp1 if ($temp1 > $w2) ;
       }
       $g->rectangle($rx, $ry, $rx+$w2, $ry+ $h, $black);
       $g->filledRectangle($rx+1, $ry+1, $rx+$w2-2, $ry+ $h-1, $col2 || "white");
       if ($flag == 0) {
          $g->filledRectangle($rx+1, $ry+1, $w2-2, $h-2, $col2);
       }
       if ($zoom >= 0 && $zoom < 3) {
         #$g->string($font, $rx+1, $ry+$h, $label, $black);
       }
     }
   }
}

#################
#  NODE
#################
sub createNode {
   my($class, $type, $code, $color, $gif, $prefix, $prefix2, $prefix3,
      $longPrefix1, $longPrefix2, $others, $longOthers,
      $max1, $max2, $max3, $max4, $i, $j, $orientation, $number,
      $status, $portStatus0, $diskStatus0, $otherStatus0,
      $encInfo, $portInfo, $diskInfo, $otherInfo, $testInfo, $zones, $name,
      $label, $label2, $label3, $ctrlNames, $slotName, $diskRows) = @_;
   my($x,$y);
   my $node = {};
   bless($node, "TO::Graph");
   my $NodeType = substr($type,0,1);
   my @prefixV = split(/\//, $prefix);
   my $disk_add = $prefix eq "+";
   my $base = 0;
   my $port_rows = ($max1 > 2) ? 2 : $max1;
   if ($max2 < 0) {
        $max2 = -$max2; $max3 = -$max3; $base = 1;
   }
   $orientation = 'v';
   $status = -2 if ($status eq "");
   my @portStatus  = split(/,/, $portStatus0);
   my @diskStatus  = split(/,/, $diskStatus0);
   my @otherStatus = split(/,/, $otherStatus0);
   $node->{status}      = $status;
   $node->{portStatus}  = \@portStatus;
   $node->{diskStatus}  = \@diskStatus;
   $node->{otherStatus} = \@otherStatus;
   $node->{code}        = $code;
   $node->{port_rows}   = $port_rows;
   $node->{others}      = $others;
   $node->{ctrlNames}   = $ctrlNames;
   $node->{NodeType}    = $NodeType;
   $node->{max1}        = $max1;
   $node->{max2}        = $max2;
   $node->{max3}        = $max3;
   $node->{max4}        = $max4;
   $node->{zones}       = $zones;
   $node->{orientation} = $orientation;
   $node->{no}          = $number;
   $node->{diskRows}    = $diskRows;
   $node->{testInfo}    = $testInfo;
   $node->{name}        = $name;
   $node->{label2}      = $label2;
   $node->{color}    = $color;

   $i *= $scale;
   $j *= $scale;
   $node->{i}           = $i;
   $node->{j}           = $j;
   return $node;
}

sub nodeSize {
   my($node) = @_;
   my $NodeType  = $node->{NodeType};
   my $code      = $node->{code};
   my $diskRows  = $node->{diskRows};
   my($width, $height, $portSize);
   my $portMax = 2;

   if ($NodeType eq 'h') {
      $width = $iconWidth[$zoom] * 0.8;
      $node->{portSize} = $portSize = $iconPort[$zoom];
      my @p1 = $node->portOffset(10000);
      $height = $p1[1] + $portSize;
      if ($height < $width) {
         $height = $width + $width / 2;
      }
   } elsif ($NodeType eq 's') {
      $node->{portSize} = $portSize = $iconPort[$zoom]; 
      my $fac=8;
      my @p1 = $node->portOffset(10000);
      ($width, $height) = $node->set_wh($iconWidth[$zoom] * $fac / 10,  $p1[2] + $portSize + $portSize+3);
      $portMax = $p1[1];

   } elsif ($NodeType eq 'g') {
     if ($code eq "rack") {
        $height = $iconWidth[$zoom];
        $height += $height/3;
        $portSize = $iconPort[$zoom];
        $width = $height/2;
        $portSize += $portSize/2;

      } elsif ($code eq "building" || $code eq "room") {
        $width = $iconWidth[$zoom];
        $height = 8 * $width/10;
        $portSize = $iconPort[$zoom];
        $portSize += $portSize/2;

      } elsif ($code eq "cloud") {
        $width = $iconWidth[$zoom] * 12/10;
        $height = 6 * $width/10;
        $portSize = $iconPort[$zoom];
        $portSize += $portSize/2;

      } else {
        $height = $iconWidth[$zoom];
        $height += $height/3;
        $width = 2 * $height/3;
        $portSize = $iconPort[$zoom];
        $portSize += $portSize/2;
      }

   } elsif ($NodeType eq 'a') {
      $portSize = $iconPort[$zoom];
      if (substr($code,0,2) eq "SE") {
        $height = 12 * $portSize;
        $width  = (3+ $diskRows)  * $portSize;

      } elsif ($node->{max3} + $node->{max2} == 0) {
         $height = $iconWidth[$zoom]/3;
         $width = $height * 2;
      } else {
        if ($node->{max1} > 4) { # SE
          $portSize -= 1 if ($zoom == 0);
          $height = $portSize * ($node->{max1}/2 +4);
        } else {
          $height = $iconWidth[$zoom];
        }
        $height += $portSize * ($diskRows-2) if ($diskRows > 2);
        $height += 8 if ($node->{max4} > 0); 

        if ($node->{max2} <= 4) {
          $width = $iconWidth[$zoom];
        } else {
          $width = $portSize * $node->{max2};  # number of disks
        }
      }
   } else {
      $height = $width = $iconWidth[$zoom]/2;
      $portSize = $iconPort[$zoom]/2;
   }
   $node->{portMax}  = $portMax;
   $node->{portSize} = $portSize;
   $node->{height}   = $height;
   $node->{width}    = $width;
   return $node;
}

sub set_wh {
   my($node, $w, $h) = @_;
   my ($width, $height);
   if ($node->{orientation} eq 'h') {
      $height = $w; $width = $h;
   } else {
      $height = $h; $width = $w;
   }
   return ($width, $height);
}


sub drawNode {
   my($node) = @_;

   my $g           = $node->{g};
   my $width       = $node->{width};
   my $height      = $node->{height};
   my $portSize    = $node->{portSize};
   my $portStatus  = $node->{portStatus};
   my $diskStatus  = $node->{diskStatus};
   my $otherStatus = $node->{otherStatus};
   my $others      = $node->{others};
   my $max1        = $node->{max1};
   my $max2        = $node->{max2};
   my $max3        = $node->{max3};
   my $zones       = $node->{zones};
   my $color       = $node->{color};
   my $i           = $node->{i};
   my $j           = $node->{j};
   my $orientation = $node->{orientation};
   my $no          = $node->{no};
   my $status      = $node->{status};
   my $port_rows   = $node->{port_rows};
   my $ctrlNames   = $node->{ctrlNames};
   my $code        = $node->{code};
   my $diskRows    = $node->{diskRows};
   my $portMax     = $node->{portMax};
   my $testInfo    = $node->{testInfo};
   my $name        = $node->{name};
   my $label2      = $node->{label2};
   my $PS          = $portSize;
   my $NodeType    = $node->{NodeType};

   my $im_color = $color ? $g->colorAllocate(hex('0x' . substr($color,0,2)), 
                                       hex('0x' . substr($color,2,2)),
                                       hex('0x' . substr($color,4,2)) ) :
                           $g->colorAllocate(250,250,250);

   my $w = $width; 
   my $e1;
   if ($status == 2 || $status == 3) { # enclosure is red
       $node->drawRect($i-3,$j-2, $w+5,$height+5, $red);
       if ($status == 3) {
           $node->drawRect($i-$PS-3, $j-$PS-3, $PS+1, $PS+1, $im_color, $black);

           $g->line($i-$PS/2-3, $j-$PS-2, $i-$PS/2-3, $j-3, $white);
           $e1 = 1 if ($zoom == 1 || $zoom == 2);
           $g->line($i-$PS-1-$e1, $j-$PS/2-2,   $i-$PS/2-3, $j-3, $white);
           $g->line($i-4, $j-$PS/2-2,   $i-$PS/2-3, $j-3, $white);
       }
       
   } elsif ($status == 1) {
       $node->drawRect( $i-2, $j-2, $w+5, $height+5, $yellow);
       $node->drawRect( $i-3, $j-2, $w+7, $height+5, $yellow);

   } elsif ($status == 0) {
       $node->drawRect($i-2, $j-2, $w+5, $height+5, $green);
       $node->drawRect($i-3, $j-2, $w+7, $height+5, $green);
   }
   if ($NodeType eq 'u') { # hub
       my $col1 = $g->colorAllocate(200,200,100);
       $node->drawRect($i, $j, $w, $height, $black, $col1);

   } elsif ($NodeType eq "g") {
       my $r = $w/2;
       $node->drawRect( $i-1, $j, $w+2, $height, $black , $im_color);
       $g->string($font, $i+ $w/2-5, $j+$height-1, $max1, $black);
       my @p = $node->portOffset(1);
       if ($p[0] != -1) {
           $node->drawRect( $i+ $p[0], $j+ $p[1], $PS, $p[2]);
           $node->displayStatus($portStatus,  1, $i+$p[0], $j+ $p[1], $PS, $p[2],1);
       }
   }  elsif ($NodeType eq 'a') { # array
     $node->drawRect( $i, $j, $w, $height, $black, $im_color, 1);

     my $PS2 = $PS; my $o1=0;
     if ($max1 > 2) {
          $o1 = $PS; $PS2 = $PS;
     }
     my ($x);
     if ($max1 > 4) {  # racks
       for ($x=1; $x <= $max1; $x++) {
         my @p = $node->portOffset($x);
         $node->drawRect($i+$p[0], $j+ $p[1], $PS2, $PS);
         $node->displayStatus($portStatus, $x-1, $i+$p[0], $j+ $p[1], $PS2, $PS,1);
       }
     } else {
       for ($x=1; $x <= $port_rows; $x++) {
         my @p = $node->portOffset($x);
         $node->drawRect($i+$p[0], $j+$p[1], $PS2, $PS);
         $node->displayStatus($portStatus, $x-1, $i+$p[0], $j+$p[1], $PS2,$PS,1);
         if ($max1 > $x+1) {
             $node->drawRect($i+$p[0] +$PS2, $j+$p[1], $PS2, $PS);
             $node->displayStatus($portStatus, $x+1, $i+$p[0]+$PS2, $j+$p[1], $PS2, $PS,1);
         }
         my $ss = substr($ctrlNames, $x-1, 1);

         if ($zoom < 3) {
            if ($p[0] > 0) {
               $g->string($font2, $i+$p[0]- $PS , $j+ $p[1] + $PS - $gdFont2Height, $ss, $black );
            } else {
               $g->string($font2, $i+$p[0]+ $PS +2 + $o1, $j+ $p[1] + $PS - $gdFont2Height, $ss, $black );
            }
         }
       }
     }
     if ($code eq "tape") {
       my $c = $width/2;
       $g->arc($i+1, $j+1, $c-2, $c-2, 0, 360, $im_color );
       $g->arc($i+$c, $j+1, $c-2, $c-2, 0, 360, $im_color );
       $g->line($i+ $c/2, $j+$c, $i+$c+$c/2, $j+$c, $im_color);

     } elsif (substr($code,0,2) eq "SE") {  # racks, 3 columns of slots
       my ($off1, $off2, $row, $y);

       for ($row=1; $row <= $diskRows; $row++) {
         for ($y = 0; $y < $max2; $y++) {
             my $posx = $i+ $width - ($diskRows+1-$row)* $PS;
             my $posy = $j + $PS * $y;
             $node->drawRect($posx, $posy, $PS, $PS, $black);
             $node->displayStatus($diskStatus,  $y + $off2, $posx, $posy, $PS, $PS,1);
           }
           $off1 += $PS;
           $off2 += $max2;
       }

     } else {  # DISKS
       my ($off1, $row, $y); 
       for ($row= $diskRows; $row >= 1; $row--) {
         $g->string($font2, $i+$width+3, $j+$off1, $row, $black);
         for ($y = 0; $y < $max2; $y++) {
           my $posx = $i+ $y * $PS; 
           my $posy = $j + $off1;
           $node->drawRect($posx, $posy, $PS, $PS, $black); # ports
           $node->displayStatus($diskStatus, $y+$max2*($row-1), $posx, $posy, $PS, $PS,1);
         }
         $off1 += $PS;
       }
     }
     # Power, Fan, Backplane supply
     $node->others($i, $j, 'v');

  } elsif ($NodeType eq "h") {
     $node->drawRect( $i, $j, $w, $height, $black, $im_color, 2);
     my ($x);
     my $offset = 0;
     for ($x=0; $x < $max1; $x++){
         my $status = defined $portStatus->[$x] ? $portStatus->[$x] : -2;
         next if ($status == -1);
         my @p = $node->portOffset($x);
         next if ($p[0] == -1);
         my $off;
         $node->drawRect($i+$p[0], $j+$p[1], $PS, $p[2]);
         if ($p[0] == 0) {
             $off = $PS + 2;
         } else {
             $off = $w - $PS- $PS- 3;
             $off += 3 if ($x < 10) ;
         }
         if ($zoom < 2) {
             $g->string($font2, $i+$off, $j+$p[1] + $p[2]- $gdFont2Height, $x, $black);
         }
         $node->displayStatus($portStatus ,$x, $i+$p[0], $j+$p[1], $PS, $p[2],1);
     }
     $node->others($i, $j, 'v');

  } elsif ($NodeType eq "s") {
     $node->drawRect($i, $j, $w, $height, $black, $im_color, 0);

     $node->others($i, $j, $orientation);

     if (index($zones, ":") >= 0 || substr($zones,0,1) eq "Z") {
         $node->portOffset($OFF,$i,$j, $w);

     } else {
       my($x);
       for ($x=$OFF; $x <= $portMax; $x++){
         my @p = $node->portOffset($x);
         next if ($p[0] == -1);
         $node->drawRect($i+$p[0], $j+$p[1], $PS, $portSize );
         $node->displayStatus($portStatus, $x,  $i+$p[0], $j+$p[1], $PS, $portSize,1);
         if ($zoom < 2) {
             if ($x < 0) {
               $g->string($font, $i+$p[0] +$PS+3,  $j+$p[1] + $portSize - $gdFontHeight, $x, $black);
             } else {
               $g->string($font, $i+$p[0] - 12,  $j+$p[1] + $portSize - $gdFontHeight, $x, $black);
             }
         }
       }
     }
  }
  if ($testInfo) {  # DIAG TEST INFO
     my ($open, $ok, $fail)= split(/,/, $testInfo);
     if ($open > 0 || $ok > 0 || $fail > 0) {
       my $py = $j + $height + $gdFontHeight+2;
       my $offx = $i+2;
       my $open_off = length($open) * 10 if ($open);
       my $ok_off   = length($ok)   * 10 if ($ok);
       my $fail_off = length($fail) * 10 if ($fail);
       $node->drawRect($i, $py+1, $open_off + $ok_off + $fail_off + 3, 12, $black, $black);
       if ($open > 0) {
          $g->string($font, $offx, $py, $open, $white);
          $offx += $open_off;
       }
       if ($ok > 0) {
          $g->string($font,$offx, $py, $ok, $green);
          $offx += $ok_off;
       }
       if ($fail > 0) {
          $g->string($font,$offx, $py, $fail, $red2);
          $offx += $fail_off;
       }
     }
  }

  if ($NodeType ne "x") {
    $g->string($font,$i, $j- $gdFontHeight-2, $name, $black) if ($name);
    $g->string($font,$i, $j+$height +1, $label2, $black) if ($label2);
  }
}

#  D = 2 , bold all around, 1=3D
sub drawRect {
  my($node, $i, $j, $w, $h, $edge_col, $fill_col, $D) = @_;
  my $i2 = $i + $w;
  my $j2 = $j + $h;
  my $g = $node->{g};
  $edge_col = $black if (!$edge_col);
  if ($edge_col) {
    $g->rectangle($i, $j, $i2, $j2, $edge_col);
  }
  if ($fill_col) {
    $g->filledRectangle($i+1, $j+1 , $i2-1, $j2-1, $fill_col);
  }
  if ($D==1) {  # 3D
     $g->line($i+$w+1, $j+1, $i+$w+1, $j+$h, $edge_col);
     $g->line($i+1, $j+$h+1, $i+$w+1, $j+$h+1, $edge_col);
  } elsif ($D==2) {
    $g->rectangle($i-1, $j-1, $i2+1, $j2+1, $edge_col);
  }
}


sub displayStatus {
   my($node, $v, $pos, $x, $y, $w, $h, $access) = @_;
   my($tot, $z);
   my $g = $node->{g};
   return -2 if ($pos > $#$v);
   my $status = -2;
   $w = $h = 4 if ($w <= 2);
   my $status = $v->[$pos];
   my $st = int($status+0.5);
                                   
   if ($status eq "") {
      my $nothing = 1;
   } elsif ($status == -1) {    # missing
      $g->line($x+2, $y+2, $x+$w-2, $y+$h-2, $black);  # an 'X' in the box
      $g->line($x+$w-2, $y+2, $x+2, $y+ $h-2, $black);

   } elsif ($st == 2 || $st == 3) { # error or down
      $g->filledRectangle($x+1, $y+1, $x +$w-1, $y + $h-1, $red2);

   } elsif ($st == 1) {       
      $g->filledRectangle($x+1, $y+1, $x +$w-1, $y + $h-1, $yellow);

   } elsif ($st == 0) {                # green
      $g->filledRectangle($x+1, $y+1, $x +$w-1, $y + $h-1, $green);
   }

   if ($access == 1) {
    if ($status eq "") {
      my $nothing = 1;
    } elsif ($st == 1) {
      $g->line($x+$w-2,$y+2, $x+2, $y+$h-2, $black);

    } elsif ($st == 0) {
      $g->line($x+2,$y+$h/2, $x+$w-2, $y+$h/2, $black);

    } elsif ($st == 2) {
      $g->line($x+$w/2, $y+2, $x+$w/2, $y+$h-2, $black);

    } elsif ($st == 3) {
      $g->line($x+$w/2, $y+2, $x+$w/2, $y+$h-2, $black);
    }
   }
   return $status;
}

sub others {
    my($node, $i, $j, $orient) = @_;
    my($x, $y, $y2, $c);
    my $ps = $node->{portSize} + 1;
    my $start;
    my $g      = $node->{g};
    my $list   = $node->{others};
    my $width  = $node->{width};
    my $height = $node->{height};
    my $len    = length($list);

    if ($orient eq 'h') {
        $start = $height/2 - ($len * $ps)/2;
    } else {
        $start = $width/2 - ($len* $ps)/2;
    }

    for ($c = 0; $c < $len; $c++) {
       my ($ex, $oo);
       if ($orient eq 'h') {
          $x = $i + $width - $ps; 
          $y = $j + $start;
          $y2 = $y + $ps -1;
          $start += $ps;
       } else {
          $x = $i + $start; 
          $y = $j+ $height- $ps;
          $y2 = $j+ $height-1;
          $start += $ps;
       }
       if ($orient eq 'h') {
          $node->drawRect($x,$y, $ps, $ps);
       } else {
          $node->drawRect($x, $y-1, $ps, $ps+1); $oo =-1;
       }
       $node->displayStatus($node->{otherStatus}, $c, $x, $y+$oo, $ps, $ps-$oo,0);

       if ($zoom < 2) {
          $g->string($font, $x+2, $y2 +1 - $gdFontHeight, substr($list, $c,1), $black);
       }
    }
}

sub portOffset {
   my($node , $pos, $i ,$j, $w) = @_;

   my $g = $node->{g};
   my $portStatus = $node->{portStatus};

    my ($x3, $offsetMax);
    my $portMax  = 2;
    my $portSize = $node->{portSize};
    my $height   = $node->{height};
    my $width    = $node->{width};
    my $max1     = $node->{max1};
    my $max2     = $node->{max2};
    my $portStatus = $node->{portStatus};
    my $zones    = $node->{zones};
    my $pos_i    = $node->{i};
    my $pos_j    = $node->{j};

    if ($node->{NodeType}  eq 'g') {
        #return new Point3(0, (height - portSize)/2, portSize);
        return ( ($width- $portSize)/2, ($height - $portSize)/2, $portSize);

    } elsif ($node->{NodeType} eq 'u') {
         return ($width/2, $height/2, $portSize);

    } elsif ($node->{NodeType} eq 'a') { #array controller
       my($x, $y, $p1);

       if ($max1 > 4) { #rack
         my $half = $max1 / 2;
         if ($pos <= $half) {
             $x = 0; $p1 = $pos;
         } else {
             $x = $portSize+2; $p1 = $pos - $half;
         }
         $y = $height - $portSize - 2 - $p1 * $portSize;
         return ($x, $y, $portSize);

       } else {
         $x = 0;
         my $pos2 = $pos;
         $pos2 -= 2 if ($pos2 > 2);
         $y = $height - $portSize - 3 - $pos2  * ($portSize+1);
         $y=0 if ($y < 0);
         $x += $portSize  if ($pos > 2) ;
         return ($x, $y, $portSize );
       }

    } elsif ($node->{NodeType} eq  'x') {
         return (5,5,5);

    } elsif ($node->{NodeType} eq 'h') {
       my($x);
       my $posx =0;
       my $posy =2;

       for ($x = 0; $x <= $max1; $x++) {
          $posx = $width- $portSize;
          my $status = 'X';
          next if ($portStatus->[$x] == -1);
          my($v2);
          if ($pos == $x) {
             my $pn = $portNode{$node->{no}}{$x};
             $posx = 0 if (defined($pn) && $pn->{i} < $pos_i) ; # left side
             return ($posx, $posy, $portSize);  # found the port
          }
          $posy += $portSize;
        }
        return (-1, $posy, $portSize);       #max size

    } elsif ($node->{NodeType} eq 's') {
       my($x, $y, $y0, $d1, $d2, $pos0);
       my $plist = ",";
       my @z;
       if (substr($zones,0,1) eq "Z") {  # real zone information present
          my $lefty = 1; my $righty = 1; my $o = 3;

          @z = split(/\//, substr($zones,1));
          my ($posx, $posy);
          for ($x = 0; $x <= $#z; $x++) {
             my @vzone = split(/\-/, $z[$x]);
             for ($y = 0; $y <= $#vzone; $y++) {
                 last if ($vzone[$y] eq "");
                 my $s1 = $vzone[$y];
                 my $p1 = $s1 + 0;
                 my $v2 = $portNode{$node->{no}}{$p1};

                 if ($node->{orientation} eq 'h') {
                    if ($v2 && $v2->{j} > $pos_j) {
                      $posy = $height- $portSize; 
                      $posx = ($lefty-1) * $portSize + $o; # low
                      $lefty++;
                    } else {
                      $posy = 0; $posx = ($righty-1) * $portSize + $o;   # high
                      $righty++;
                    }
                 } else {
                    if ($v2  && $v2->{i} > $pos_i) {
                      $posx = $width- $portSize; $posy = ($righty-1) * $portSize + $o;
                      $righty++;
                    } else {
                      $posx = 0; $posy = ($lefty-1) * $portSize + $o;
                      $lefty++;
                    }
                 }
                 $portMax = $p1 if ($p1 > $portMax);
                 if ($i > 0) {
                    $node->drawPort($p1, $posx, $posy, $i, $j, $w);
                 } elsif ($pos == $p1) {
                    return ($posx, $posy,  $portSize);
                 }
             }
             $righty = $lefty = ($righty > $lefty ? $righty: $lefty); 
             $offsetMax = $lefty if ($lefty > $offsetMax) ;
             $o += 3;

             if ($i > 0) {
                 if ($node->{orientation} eq 'h') {
                   my $xx = $i + ($lefty-1) * $portSize + $o;
                   $g->line($xx-1, $j + $portSize+2, $xx-1,  $j + $height - $portSize -2);
                 } else {
                   my $yy = $j + ($lefty-1) * $portSize + $o;
                   $g->line($i+ $portSize+2, $yy-1, $i+ $w- $portSize-2, $yy-1, $black);
                 }
             }
         }
         $offsetMax = ($offsetMax-1) * $portSize + $o;
      }
   }
   return(-1, $portMax, $offsetMax);
}

sub drawPort {
  my($node, $p, $x, $y, $i, $j, $w) = @_;
  my $g = $node->{g};
  my $portSize = $node->{portSize};

  $g->rectangle( $i+ $x, $j+ $y, $i+$x+$portSize, $j+$y+ $portSize, $black);
  $node->displayStatus($node->{portStatus}, $p, $i+$x, $j+$y, $portSize, $portSize,1);

  if ($zoom <= 2) {
    if ($node->{orientation} eq 'h') {
      my $of = 1;
      $of = -1 if ($p > 9);
      if ($y == 0) {
        $g->string($font2,$i+ $x + $of,  $j+ $y + $portSize*2 - $gdFont2Height, $p, $black);
      } else {
        $g->string($font2,$i+ $x+ $of, $j + $y - $gdFont2Height, $p, $black);
      }
    } else {
      if ($x == 0) {
       $g->string($font2,$i+$x + $portSize+2,  $j+$y + $portSize - $gdFont2Height, $p, $black);
      } else {
       $g->string($font2,$i+ $x - ($gdFont2Width*length($p)) -1,  $j+ $y + $portSize - $gdFont2Height, $p, $black);
      }
    }
  }
}




1;



 
