package System;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: System.pm,v 1.69 2003/05/07 22:01:34 ccadieux Exp $

use Debug;
use strict 'vars';
use vars qw($AUTOLOAD %AUTO); 
use Util;
#use Time::Zone;



#       System->setPassword("guest", "password");
#   encoded : leave encoded
# print System->getPassword("guest");

sub getPassword {
  my($class, $arg, $encoded) = @_;
  require MIME::Base64;
  $arg =~ s/\W/_/g;
  my $HOME = System->get_home() || "/opt/SUNWstade";

  my $D    = "$HOME/System/passwords";
  mkdir $D, 0777 if (!-d $D);

  if (open(OO2, "$D/$arg")) {
    my $pass = <OO2>;
    chomp($pass);
    close(OO2);
    return $encoded ? $pass : MIME::Base64::decode($pass);
  } else {
    return undef;
  }
}

sub setPassword {
  my($class, $arg, $pass) = @_;
  require MIME::Base64;

  $arg =~ s/\W/_/g;
  my $D = System->get_home() . "/System/passwords";
  mkdir $D, 0777 if (!-d $D);
  my $encoded = MIME::Base64::encode($pass);
  if (open(OO1, ">$D/$arg")) {
    print OO1 $encoded;
    close(OO1);
  } else {
    print "Error writing to $arg: $!\n";
  }
}

sub rotate {
  my($class, $file) = @_;
  my $renv = System->get_renv();
  my $max = $renv->{max_event_file_size} || 1;
  my($x);

  my $size = (stat($file))[7];
  if ($size > ($max * 1000000) ) {
     for ($x=9; $x >= 2; $x--) {
         if (-f "$file.$x") {
            rename "$file.$x", "$file." . ($x+1);
         }
     }
     rename $file, "$file.2";
  }
}

sub comma_format {
  my($class, $val) = @_;
  my($out, $l);
  $out = $val;
  $l = length($out);
  if ($l > 9) {
     $out = substr($out,0,$l-9) . "," . substr($out,$l-9,3) . "," .
            substr($out,$l-6,3) . "," . substr($out, $l-3);
  } elsif ($l > 6) {
     $out = substr($out,0,$l-6) . "," .
            substr($out,$l-6,3) . "," . substr($out,$l-3);
  } elsif ($l > 3) {
     $out = substr($out,0,$l-3) . "," . substr($out,$l-3);
  }
  return $out;
}




sub home_dir {
  my($class) = @_;
  my($local_p) = $INC[0];
  my($ix) = rindex($local_p, "/");
  return substr($local_p,0,$ix);
}

# $version = System->get_se_version();
# $version = '2.0.2a1'

sub get_se_version {
  my($class, $all) = @_;
  open(O, "/opt/SUNWsesp/bin/sp_version.file");
  my $l = <O>; 
  close(O);
  return $l if ($all);
  my ($tem, $ver) = split (/\s+/, $l);
  return $ver;
}

sub findProcess {
  my($class, $pro) = @_;

  my $ps = "/usr/bin/ps";
  my $grep = "/usr/bin/grep";
  open(O, "$ps -ef| $grep \"$pro\" | $grep -v grep|");
  my @l = <O>; close(O);
  return \@l;
}

  
sub newPngName {
  my($class) = @_;

  my $rem = $ENV{REMOTE_USER}; $rem =~ s/\./_/g;
  my $t =  "$rem." . (time % 5) . ".png";
  my $D = System->get_home() . "/DATA/Web";
  mkdir $D,0777 if (!-d $D);
  my $F = "$D/$t";
  if (wantarray) {
    return ($t, $F);
  } else {
    return $t;
  }
}

use vars qw( $PATH %COMM %COUNTERS);
$PATH = "/bin:/usr/bin:/usr/sbin";

#
#  System->counter("discovery", "ZERO");
#  System->counter("discovery", 1);
#  System->counter("discovery");
#
sub counter {
  my($class, $tag, $inc) = @_;
  
  if ($inc eq "ZERO") {
     $COUNTERS{$tag} = 0;

  } elsif ($inc) {
     $COUNTERS{$tag} += $inc;
  }
  return $COUNTERS{$tag};
}
sub getConfigPort {
  my($class,$home) = @_;
  $home = "/opt/SUNWstade" if (!$home);

  my $port = 7654;
  if (open(O, "$home/DATA/SECURE")) {
     $port = <O>;
     close(O);
     return $port =~ /\d+/ ? ($port+0) : 7443;
  } 

  open(O,"$home/System/config");
  my($l);
  while ($l = <O>) {
      if ($l =~ /GSV_PORT=(\d+)/) {
         $port = $1;
         last;
      }
  }
  close(O);
  return $port;
}

# $vers = System->getPackageInfo("diag244", "SUNWsecfg", "VERSION", "REV=(.*)" ); # returns REV
# $vers = System->getPackageInfo("","SUNWsecfg", "VERSION");  # returns line
# field = '_ALL_' return a hash

sub getPackageInfo {
  my($class, $host, $package,  $field, $pat) = @_;

  $field = "VERSION" if (!$field);

  my $program = "pkginfo -l $package";
  my $renv = System->get_renv();

  my($err, $com, $rc);
  if (!$host || $host eq $renv->{hostname}) {
    ($err, $com) = Util->run_command("/usr/bin/$program", "test",10);
    return undef if ($err || "@$com" =~ /ERROR/);
  } else {
    ($err, $rc) = Util::Http->runit($host, "/sbin/$program", 20);
    return undef if ($err || $rc =~ /ERROR/);
    my @L = split(/\n/, $rc);
    $com = \@L;
  }
  
  if ($field eq "_ALL_") {
    my %VAL;
    foreach my $l (@$com) {
       if ($l =~ /\s+(\w+):\s+(.*)/) {
          $VAL{$1} = $2;
       }
    }
    return \%VAL;
  }
     
  foreach my $l (@$com) {
     if ($l =~ /\s+$field:\s+(.*)/) {
        my $val = $1;
        if ($pat) {
           if ($val =~ /$pat/) {
              return $1;
           } else {
              return undef;
           }
        } else {
           return $val;
        }
     }
  }
}

sub get_breakFile {
  my($q) = @_;
  my $l;
  my $file = $q->{file};
  my $prefix = $q->{prefix} || "PATCHFILE";
  my($DIR) = System->get_home() ;
  my $cnt;
  if (open(O, "$DIR/DATA/$file")) {
    while ($l = <O>) {
      if ($l =~ /^#$prefix (.*)/) {
         close(W) if ($file);
         $cnt++;
         $file = $1;
         open(W, ">$DIR/$file.new");
      } else {
         print W $l if ($file);
      }
    }
    close(W);
    close(O);
  }
  print "OK files=$cnt\n";
}




sub isRoot {
  my $user_id = $>;
  if ($user_id != 0) {
     return 0;
  }
  return 1;
}

sub srs_time {
  my($class) = @_;

require Date::Format;

  my($o) =  tz_local_offset();

  $o = sprintf("%+03d%02d", int($o / 3600), abs(int($o % 3600)));
  my($s) = Date::Format::time2str('%Y%m%d.%H%M%S', time, 'GMT') . substr($o,0,3);
  return $s;
}


sub appletHeader {
  my($class, $app, $offx, $off)  = @_;

  my $o =<<EOF;
 <script language=JavaScript>
  var a_width;
  var a_height;
  if (navigator.appName.indexOf("Netscape") != -1) {
      a_width = window.innerWidth - $offx;
      a_height = window.innerHeight- $off;
  } else {
      a_width = window.document.body.offsetWidth - $offx;
      a_height = window.document.body.offsetHeight - $off;
  }
  var s = '<applet $app height=' +a_height+ ' width=' +a_width + ' MAYSCRIPT>';
  window.document.writeln(s);
  window.document.writeln('');
  </script>
EOF

 return $o;

}


#
# runs only once then returns the cache value
#
sub run_command {
  my($com) = @_;
  my(@a, $dir, $val);

  return $COMM{$com} if $COMM{$com};

  my($ix)   = index($com, " ");
  my($com0) = ($ix >= 0)? substr($com, 0,$ix) : $com;

  if (substr($com,0,1) eq "/") {
     if (-x "$com0") {
        $val = `$dir/$com`;
        chop($val);
        $COMM{$com} = $val;
        return $val;
     } else {
        return undef;
     }
  }
    
  @a = split(/:/, $PATH);
  foreach $dir (@a) {
     if (-x "$dir/$com0") {
        $val = `$dir/$com`;
        chop($val);
        $COMM{$com} = $val;
        return $val;
     }
  }
  
  return undef;
}

sub grep {
  my($class, $file, $pat) = @_;
  my($l, $ret);

  open(O, $file);
  while ($l = <O>) {
    chop($l);
    if ($l =~ /$pat/) {
      $ret .= "| " if ($ret);
      $ret .= $l;
    }
  }
  close(O);
  return $ret;
}
  

sub get_service_port {
  my($class, $service) = @_;
  my($sport);
  my($x) = `/usr/bin/grep $service /etc/services`;
  if ($x) {
    $x =~ /$service\s+(\d+)/;
    $sport = $1;
  }
  return $sport;
}



sub find_command {
  my($class, $com) = @_;
  my(@a) = split(/:/, $PATH);
  foreach my $dir (@a) {
      return "$dir/$com" if (-x "$dir/$com");
  }
  Debug->err(ERROR => "Cannot find command $com");
  return "echo ";
}
         
sub host_type {
  my($class, $hostname) = @_;
  my($type);
  my($ans) = run_command(System->get_home() . 
                "/snmp/bin/snmpget -t 10 -r 0 $hostname public 1.1.0 2>/dev/null");
  if (!$ans) {
     return "";
  } else {
    my(@a) = split(/\s*=\s*/, $ans);
    $a[1] =~ s/Sun SNMP Agent,//;
    $type = Util->ltrim($a[1]);

    if (substr($type,0,1) eq "\"") {
       $type = substr($type,1,-1);
    }
    return $type;
  }

}

sub bitMode {
  my($class) = @_;
  my($bit);
  if (-x "/usr/bin/isainfo") {
     $bit = run_command('isainfo -b') || 'UNKNOWN';
     return $bit;
  } else {
     return "32";
  }
}
     

#    .       system boot  Apr 12 09:42

sub lastReboot {
  my($class) = @_;

  my $x = run_command('who -b');
  $x =~ /system boot (.*)/;
  $x = Util->trim($1);
  my ($m, $d, $h) = split(/\s/, $x);

  $m = $Util::MTH{$m};
  my $boot = sprintf("%2.2d-%2.2d %s:00", $m, $d, $h);

  my $today = Util->today("YMDH");
  my $today1 = substr($today, 5);

  if ($boot > $today1) {
     my $year = substr($today,0,4) - 1;
     return sprintf("%4.4d-", $year) . $boot
  } else {
     return substr($today,0,5) . $boot;
  }
  
}

# ifconfig -a
# lo0: flags=1000849<UP,LOOPBACK,RUNNING,MULTICAST,IPv4> mtu 8232 index 1
#        inet 127.0.0.1 netmask ff000000 
# dmfe0: flags=1000843<UP,BROADCAST,RUNNING,MULTICAST,IPv4> mtu 1500 index 2
#       inet 172.20.67.235 netmask ffff0000 broadcast 172.20.255.255
#       ether 0:3:ba:6:1b:38 

sub ifconfigs {
  my($class, $id, $name) = @_;
  my @O;
  my ($err, $L) = Util->run_command("/usr/sbin/ifconfig -a","ifc", 15);

  my($last, $inlast, $in, $last_val, $l);

  foreach $l (@$L) {
     if ($l =~ /^(\w+): /) {
        $in = $1;
     }
     if ($in && ($l =~ /\s+inet ([\w\.\,\:]+)/)) {
        push(@O, [$in, $1]);
        $in = 0;
     }
  }
  return \@O;
}

sub ifconfig {
  my($class, $id, $name) = @_;
  $name = "inet" if (!$name);
  my ($err, $L) = Util->run_command("/usr/sbin/ifconfig -a", "ifc", 15);

  my($last, $inlast, $in, $last_val, $l);

  foreach $l (@$L) {
     if ($l =~ /^$id: /) {
        $in = 1;
     } elsif ($l =~ /^(\w+): /) {
        $last = "$l\n";
        $last_val = $1;
        $inlast = 1;
     }  elsif ($inlast) {
        $last .= "$l\n";
     }
     if ($in && ($l =~ /$name ([\w\.\,\:]+)/)) {
         return $1;
     }
  }
  if ($id eq "LAST" && $last) {
    my @L = split(/\n/, $last);
    foreach $l (@L) {
      if ($l =~ /$name ([^\s]+)/) {
         if (wantarray) {
           return($1, $last_val);
         } else {
           return $1;
         }
      }
    }
  }
  return undef;
}

sub os_version {
  my($class) = @_;
  my($os_version);

  return run_command('uname -r') || 'UNKNOWN';
}
  
sub hostid {
  my($class) = @_;
  return  run_command('hostid') || 'UNKNOWN';
}


sub hostinfo {
  my($class) = @_;
  return  run_command('uname -a') || 'UNKNOWN';
}

sub shortHostname {
  my($class) = @_;
  my($h) = run_command('uname -n') || 'UNKNOWN';
  my $i = index($h, ".");
  if ($i > 0) {
     return substr($h,0,$i);
  } else {
     return $h;
  }
}

sub pwd {
  my($class) = @_;
  my $n = $0;
  if (substr($n,0,1) eq ".") {
     my($h) = run_command('pwd');
     return $h;
  } else {
     my $ix = rindex($n, "/");
     return substr($n,0,$ix);
  }
}

#
# return hostname + lc(domainname)
# if fails: shorten the domainname and try again
# unless domain does not work, then stays short
#
sub hostname {
  my($class, $skip_domain) = @_;

  my $renv = System->get_renv();
  my($h) = run_command('uname -n') || 'UNKNOWN';

  my $i = index($h, ".");

  if ($skip_domain || $renv->{skip_domain} ) {
     return $i > 0 ? substr($h,0,$i) : $h;
  }

  if ($i > 0) {
     return substr($h,0,$i) . lc(substr($h,$i));
  } else {
     my $domain = lc(run_command('domainname'));
     if ($domain) {
        my $full = "$h.$domain";
        if (gethostbyname($full)) {
           return $full;
        } else {
           my $i2 = index($domain, ".");
           if ($i2 > 0) {
              $full = $h . substr($domain, $i2);
              if (gethostbyname($full)) {
                return $full;
              }
           }
        }
     }
     return $h;
  }
}

sub os {
  my($class) = @_;

  return run_command('uname -s') || 'UNKNOWN';
}

sub model {
  my($class) = @_;
  my $model;
  my $opt = $^O eq "linux" ? "" : "-i";

  $model = run_command("uname $opt") || 'UNKNOWN';

  # Check for a 420R machine
  my $temp_model = run_command('/usr/platform/sun4u/sbin/prtdiag');
  if($temp_model =~ /Sun Enterprise 420R/){
      $model = "420R";
  }
    
  return $model;

}

sub memory {
  my($class) = @_;
  my($x, $mem);
  $x = run_command('prtconf -v');
  $x =~ /Memory size: (\d+)\s/;
  $mem = $1 || "UNKNOWN";
  return $mem;
}

sub swap {
  my($class) = @_;
  my($swap, $x);
  $x = run_command(System->get_home() . "/bin/swap.sh");
  $x =~ /SWAP: (\d+) total/;
  $swap = $1 || "UNKNOWN";
  return $swap;
}

sub cpus {
  my($class) = @_;
  my(@x) = split(/\n/, run_command('psrinfo'));
  return $#x + 1;
}



  
sub find_executable {
  my($class, $bin) = @_;
  my($dir);

  my($home) = System->get_home();

  my(@a) = split(/:/, "/usr/sbin:/usr/bin:/bin:$home/bin");
  foreach $dir (@a) {
     if (-x "$dir/$bin") {
        return "$dir/$bin";
     }
  }
  return undef;
}


sub find_luxadm {
  my($class) = @_;
  my($dir);

  my($home) = System->get_home();

  my(@a) = split(/:/, "/usr/sbin:/usr/bin:/bin:$home/bin");
  foreach $dir (@a) {
     if (-x "$dir/luxadm") {
        return "$dir/luxadm";
     }
  }
}

sub find_disk_inquiry {
  my($class) = @_;
  my(@a, $dir);

  my($home) = System->get_home();

  @a = split(/:/, "$home/bin:/opt/STORtools:/usr/bin:/bin");
  foreach $dir (@a) {
     if (-x "$dir/luxadm") {
        return "$dir/luxadm";
     }
  }
}

sub domain {
  my($class) = @_;
  my $do;
#  require Net::Domain;
#  return Net::Domain::hostdomain();

  $do = run_command('domainname');
  my $ix = index($do, ".");
  if ($ix > 0) {
     return substr($do,$ix+1);
  }
  return "";
}

sub host_domain {
  my($class) = @_;
  require Net::Domain;
  return Net::Domain::hostfqdn();
}

# inet addr:10.10.10.10  Bcast:10.10.255.255  Mask:255.255.0.0

#/opt/SUNWstade/bin: /usr/sbin/ifconfig -a
#lo0: flags=1000849<UP,LOOPBACK,RUNNING,MULTICAST,IPv4> mtu 8232 index 1
#        inet 127.0.0.1 netmask ff000000 
#dmfe0: flags=1000843<UP,BROADCAST,RUNNING,MULTICAST,IPv4> mtu 1500 index 2
#        inet 172.20.32.87 netmask ffffff00 broadcast 172.20.32.255
#        ether 0:3:ba:b:d1:71 
#dmfe1: flags=1000843<UP,BROADCAST,RUNNING,MULTICAST,IPv4> mtu 1500 index 3
#        inet 192.168.0.2 netmask ffffff00 broadcast 192.168.0.255
#        ether 0:3:ba:b:d1:71 


sub local_ip {
  my($class, $skip) = @_;
  my($if, @a, $x, $i, $ip);

  if ($class->os() =~ /Linux/) {
    @a = `/sbin/ifconfig -a`;
    for ($x = 0; $x <= $#a; $x++) {
       if ($a[$x] =~ /inet addr\:(.*) Bcast\:/) {
          return $1;
       }
    }
    return "Unknown";
  }
  @a = `/usr/sbin/ifconfig -a`;
     
  for ($x = 1; $x <= $#a; $x++) {
     $i = $a[$x];
     if ($i =~ /inet ([^s]+) / ) {
       $ip = $1;
       if ($ip ne "127.0.0.1") {
         return $ip;
       }
    }    
  }
  return undef;
}




sub get_hba {
  my($class) = @_ ;
  my($hba, $sbus, $pci) ;

#  chomp( $sbus = `/usr/sbin/prtconf -D | grep "SUNW,socal"` );
#  chomp( $pci = `/usr/sbin/prtconf -pv | grep "vendor-id:  00001077"` );

  if ($pci) {
     $hba = "P";
  } elsif ($sbus)  {
     $hba = "S";
  } else {
     $hba = "S";
  }
  return $hba;


}

sub readModules {
  my($class, $dir, $skip, $prefix) = @_;
  my($d0, @mods, $d);

  if (opendir(O, System->get_home . "/lib/$dir")) {
    while ($d0 = readdir(O)) {
       next if (substr($d0,-3) ne ".pm");
       $d = substr($d0, 0, -3);
       next if ($skip && $d eq $skip);
       next if ($prefix && substr($d,0,length($prefix)) ne $prefix);
       push(@mods, $d);
    }
    closedir(O);
    return @mods;
  } else {
    return ();
  }
}




#########################
# ENVIRONMENT
# save variables
#########################


sub AUTOLOAD {
  my($class, $val) = @_;
  my($key);

  if ($AUTOLOAD =~ /::set_(.*)/ ) {
       $key = $1;
       $AUTO{$key} = $val;
       return $val;
  } elsif ($AUTOLOAD =~ /::get_(.*)/ ) {
       $key = $1;
       if (!defined($AUTO{$key})) {
           print "get_$key not defined in System->get\n" if ($Debug::LEVEL > 3);
       }
       return $AUTO{$key};
  } else {
       return undef;
  }
}

1;
