package Service::Extract;
use strict;
use System;
use Process;


sub run {
  my($q) = @_;
  my $info;
  print Html->body();
  my $out = Html->header2("monitor.utilities.extract");

  my $LB = Labels->read("Service::Extract");

  if ($q->{ACTION_run}) {
    if (Util->findProcessByName("\/se_extract")) {
       print $out;
       print Html->warning($LB->{running});
       return;
    }
    my $tt = "-t $q->{password}" if ($q->{password});
    my $command =  System->get_home() . "/sysbin/se_extract -r -d 2 $tt -b";
    system($command);
    sleep(1);
    $info = Html->info($LB->{starting});
  }

  my ($status, $pid1) = Process->status(undef, "Extract");
  my ($run, $meta);
  if ($status =~ /Running/) {
     $meta = "<meta http-equiv=Refresh content=\"10;URL=$Http::WEBPROC?GO=Service::Extract::run\">";
     $run = "
        <tr><td align=right bgcolor=$Style::LIGHT>
            <table border=0><tr><td>Extraction Status:</table></td>
            <td colspan=2><b>&nbsp;$status (pid=$pid1)";
  } else {
    $run =<<EOF;
      <tr><td align=right bgcolor=$Style::LIGHT>$LB->{password}:</td>
      <td colspan=2> <input type=password name=password size=20>
      <tr><td colspan=3 bgcolor=$Style::BGCOLOR><center><b> 
      <input type=submit name=ACTION_run value="$LB->{submit_run}">
EOF
  }

  print <<EOF;
  $meta
  $out
<script>
    function win2(t) {
      var b = '$Http::WEBPROC?GO=Service::Extract::logfile&file=' + t;
      var O = window.open(b,'hist','menubar=no,resizable=yes,scrollbars=yes,width=600,height=600');
      O.focus();
    }
</script>
$info
<table border=1 cellspacing=0 cellpadding=2 bgcolor=white width=90%>
  <tr bgcolor=$Style::DARK><td colspan=3>
      <form><input type=hidden name=GO value=Service::Extract::run>
      <font color=white><b>$LB->{start}</td>
   $run

  <tr><td></td>
  <tr><td></td>
  <tr bgcolor=$Style::DARK><td colspan=3><font color=white><b>$LB->{download}</td>
  <tr bgcolor=$Style::LIGHT>
       <th>$LB->{down}
       <th width=30%>$LB->{file}
       <th>$LB->{log}
EOF

  opendir(O, System->get_home() . "/DATA/Download/Solution");
  my @D = readdir(O); closedir(O);

  foreach my $d (reverse sort @D) {
     if ($d =~ /extract_(.+)\.tar/) {
         my $d1    = $1;
         my $ix    = index($d1, "_");
         my $model = substr($d1, 0, $ix);
         my $date  = substr($d1, $ix+1);
         my $date2 = substr($date,0,13) . ":" . substr($date,13,2) .":" . substr($date,15,2);
         my $size  = Util->fileSize(System->get_home() . "/DATA/Download/Solution/$d");
         $size     = int($size/1000);

         my $url1 = "<a href=/Download/Solution/$d>$date2</a>";
         my $url2 = "<a href=javascript:win2('${model}_$date')>$LB->{review}</a>";
         print "<tr><td>&nbsp;$url1<td align=right>$size K&nbsp;<td><center>[ $url2 ]</td>";
     }
  }
  print "</table></form>";
}


sub logfile {
  my($q) = @_;

  print Html->body(undef, {color => "white"});
  my $LB = Labels->read("Service::Extract");

  print "</center>";
  print "<table border=0 width=100% bgcolor=$Style::LIGHT>
  <tr><td>&nbsp;<b>$LB->{log2}: $q->{file}</table>";

  open(O, System->get_home() . "/DATA/Download/Solution/log_$q->{file}.txt");
  my @l = <O>;
  close(O);
  print "<pre>";
  print join("", @l);
}
1;
