package Repeat;

# will return 'NEW' and 'AGAIN' every x seconds, undef otherwize
# freq : second
# uses a single file to track time;
# Ex:
#   $repeat = Repeat->new("/tmp/xx", 60*60);
#   $repeat->clear(); #  to reset the counter
#   ...
#   if ($repeat->read()) {
#       ...
#   }
#
sub new {
  my($class, $file, $freq) = @_;

  my $obj = {file => $file, seconds => $freq};
  bless($obj, 'Repeat');
  return $obj;
}


sub read {
  my($obj) = @_;
  my $time;
  my $rc;
  if (open(O,$obj->{file})) {
     $time = <O>; close(O);
     if (time - $time > $obj->{seconds}) {
        $rc = 'AGAIN';
     } else {
        return undef;
     }
  } else {
     $rc = "NEW";
  }
  open(O, ">$obj->{file}");
  print O time;
  close(O);
  return $rc;
}

sub clear {
  my($obj) = @_;
  unlink $obj->{file};
}

#  Repeat->timer("x", 20);  # minutes
#  triggers and reset itself when old enough.
#  return NEW the first time around.
#
sub timer {
  my($class, $name, $mins) = @_;
  my $F = System->get_home() . "/DATA/CACHE/timer.$name";
  if (!-f $F) {
     open(O, ">$F"); close(O);
     return "NEW";
  } else {
    my $age = Util->getFileAge($F);
    if ($age >= $mins) {
       open(O, ">$F"); close(O);
       return "OLD" ;
    }
  }
  return undef;
}



1;
  
