package Process;

use System;
use strict;
use Util::Http;
use Data::Dumper;
use Util;
use Mail;

use vars qw($ERROR);


# returns Running | Not running | Died | Done / pid
# returns ("Running", $pid)
#
sub status {
  my($pro, $host, $id) = @_;
  my ($st, $pid);
  my $PIDF = System->get_home() . "/DATA/tmp/${id}_pid";

  if (!$host) {  # local
    if (open(O, $PIDF)) {
      $pid = <O>; close(O);
    }
  } else {
    $pid = Util::Http->readFile($host, "tmp/${id}_pid", 10);
  }
  if ($pid =~ /^pid=\d+/) {
     my($a,$s) = Util->processTime(substr($pid,4), $host);
     if (!$a) {
       my $pid2 = Util::Http->readFile($host, "tmp/${id}_pid", 10);
       if ($pid2 =~ /^pid=\d+/) {
         $st = "Died";
       } else {
         $st = "Done / $pid";
       }

     } else {
       $st = "Running";
     }
  } elsif ($pid)  {
     $st = "Done / $pid";

  } else {
      $st = "Not running";
  }
  if (wantarray) {
    $pid = substr($pid,4) if ($pid);
    return ($st, $pid);
  } else {
    return $st;
  }
}

# can background itself local/remote 
# default is running in the backgroud.
# Command->run($host or blank, "bin/fccheck 1 2 3", [0|1]);
# return 1

sub run {
  my($class, $host, $program, $run_method, $foreground, $to, $progress) = @_;
  my ($cpid);
  die "run missing!" if (!$run_method);
  my ($renv, $devices, $hosts, $notifs, $Config) = PDM::ConfigFile->read();

  my $host_ip = Util->name2ip($host);
  if (!$host || $host_ip eq $renv->{ipno} || $host eq $renv->{hostname} ) {
     if ($foreground) {
        &$run_method();
     } elsif (($cpid = fork()) == 0) {
        close STDIN; close STDOUT; close STDERR;
        &$run_method();
     } else {
        my $ix = index($program, " ");
        my $prg1 = $ix > 0 ? substr($program,0,$ix) : $program;
        print "OK $prg1 started.\n";
     }

 # } elsif (!$Config->hostByKey($host) ) {
 #    $ERROR = "Cannot find host $host\n";
 #    return undef;
  } else {  # REMOTE 
     $program .= "&" if (!$foreground);
     return Util::Http->runit($host, $program, $to, $progress);
  }
}

sub write {
  my($class, $report, $id) = @_;

   my $F    = System->get_home() . "/DATA/tmp/$id";
   open(O, ">$F");
   $Data::Dumper::Indent=1;
   print O Dumper($report);
   close(O);
}

sub read {
  my($class, $host, $id) = @_;
  my $VAR1;
  my $renv = System->get_renv();
  my $F = "/tmp/${id}";
  my $host_ip = Util->name2ip($host);
  if (!$host || $host_ip eq $renv->{ipno} || $host eq $renv->{hostname}) {
      return Util->deserialize($F);
  } else {
      my $data = Util::Http->readFile($host, $F, 10);
      if ($data) {
          eval $data;
          return $VAR1;
      }
  }
}

sub done {
  my($pro, $id) = @_;

  my $PIDF   = System->get_home() . "/DATA/tmp/${id}_pid";

  open(O, ">$PIDF");
  print O `/bin/date`;
  close(O);
}

sub start {
  my($class, $id) = @_;

  my $F    = System->get_home() . "/DATA/tmp/$id";
  my $PIDF = System->get_home() . "/DATA/tmp/${id}_pid";
  unlink $F;
  open(O, ">$PIDF"); print O "pid=$$"; close(O);
}



sub email {
  my($class, $report, $title) = @_;

  my($renv, $devices, $hosts, $notifs) = PDM::ConfigFile->read();
  my $date = $report->{date} || Util->get_today();

  foreach my $notif (@$notifs) {  # Each notification.
     next if (!$notif->{email});
     my $admin = Util->rtrim($notif->{email});
     my $eventType = Util->rtrim($notif->{event});
     next if (($eventType ne "*") && index(lc($eventType),"upgradeevent") < 0 );
     my $content =<<EOF;
--- UPGRADE SUMMARY REPORT ---

Site    : $renv->{site_name} $renv->{site_city} 
Hostname: $renv->{hostname}
Date    : $date

--- TRACE ---

$report->{data}{trace}

EOF
     Mail->mail($admin, $renv->{GSV_ACRONYM}, $title, $content, 10);
  }
}


1;
