package Policies;
use PDM::Parse;
use strict;
use System;

sub new {
  my($class, $file) = @_;

  my $policies = PDM::Parse->parse("System/$file");
  my $extended = $class->extended();

  my $obj = { policies => $policies, extended => $extended };
  bless($obj, 'Policies');

  return $obj;
}

# comp1 : disk 
# key   : t3_serial_no:disk.u1d1

sub run {
  my($obj, $err, $lines, $ix, $comp1, $dev_name, $key, $ip, $key0, $known) = @_;

  my $policies = $obj->{policies};
  my $EX       = $obj->{extended};

  my $line = $lines->[$$ix];
  foreach my $pol (@$policies) {
     my $pat = substr($pol->{pattern},1,-1);
     my @PT;
     if ($line =~ /$pat/) {
       push(@PT, $1) if ($1);
       push(@PT, $2) if ($2);
       push(@PT, $3) if ($3);
       my $found;
       my $e1 = "$line\n";
       next if ($pol->{known} && !$known);

       if ($pol->{pattern2}) {
           my $p2 = substr($pol->{pattern2}, 1, -1);
           if ($lines->[$$ix+1] =~ /$p2/) {
             push(@PT, $1) if ($1);
             push(@PT, $2) if ($2);
             push(@PT, $3) if ($3);
             $e1 .= $lines->[$$ix+1] . "\n"; $found++;
           }
       }
       if (!$found && $pol->{pattern3}) {
           my $p2 = substr($pol->{pattern3}, 1, -1);
           if ($lines->[$$ix+2] =~ /$p2/) {
             push(@PT, $1) if ($1);
             push(@PT, $2) if ($2);
             push(@PT, $3) if ($3);
             $e1 .= $lines->[$$ix+2] . "\n"; $found++;
             $$ix += 2;
           }
       }
       if (($pol->{pattern2} || $pol->{pattern3}) && !$found) {
          next;
       }
       my $sev = $pol->{severity};
       if ($pol->{shortkey}) {
          $key  = $key0 . ":$comp1";
       }

       if ($pol->{key}) {
          if ($pol->{key} eq "\$PORT") {
            $key = $key0 . ":port." . ($PT[0]-1);
          } else {
            $key .= "." . $pol->{key};
          }
       }
       my $action = $pol->{action};
       my $eg     = $pol->{egrid};
       if ($pol->{extended}) {
          my $section = $pol->{extended};
          my $fo;
          if (($fo=$EX->{$section}{"$PT[0].$PT[1].$PT[2]"})  || 
              ($fo=$EX->{$section}{"$PT[0].$PT[1]"}       )  ||
              ($fo=$EX->{$section}{"$PT[0]"}              )) {
             $sev    = $fo eq "N" ? 0: ($fo eq "E" ? 2:1);         
             $action = $fo eq "E" ? 1:0;
             $eg     .= $fo;
          }
       }

       if ($eg) {
          $eg =~ s/\$comp1/$comp1/;
          $err->[$sev]{$key}{egrid} = $eg;
       }
       $err->[$sev]{$key}{action} = $action;
       $err->[$sev]{$key}{line}  .= $e1;
       $err->[$sev]{$key}{name}   = $dev_name;
       $err->[$sev]{$key}{count}++;
       $err->[$sev]{$key}{ip}     = $ip;
       last;
     }
  }
}


sub extended {
  my($class, $file) = @_;
  my $F = System->get_home() . "/System/extended_policies";
  my %H;
  my ($l, $section);
  my $cnt=-1;
  if (open(O, $F)) {
    while ($l = <O>) {
      chop($l);
      next if (substr($l,0,1)  eq "#");
      if ($l =~ /^\[(\w+)\]/) {
         $section = $1;
         $cnt++;
      } elsif (index($l, "=") > 0) {
         my($a,$b) = split(/\s*\=\s*/, $l,2);
         $a =~ s/\s+/./g;
         $H{$section}{$a} = $b;
      }
    }
    close(O);
  }

  return \%H;
}


1;

