package Perf;

use strict;

sub read {
  my($class, $name) = @_;

  my $DIR = System->get_home() . "/DATA/Perf";
  mkdir $DIR ,0777 if (!-d $DIR);

  my $stat1 = Util->deserialize("Perf/$name") || {};
  bless($stat1, "Perf");
  return $stat1;
}


sub cleanOld {
  my($stat, $old_jd) = @_;
  my $cnt; 
  foreach my $el (keys %$stat) {
     my @a = split(/\./, $el);
     if ($a[0] < $old_jd) {
        delete $stat->{$el};
        $cnt++;
     }
  }
  return $cnt;
}




sub write {
  my($stat, $name) = @_;

  Util->serialize("Perf/$name", $stat);
}


1;
