package Navigation;
use strict qw(vars);
use Style;
use GUI::Light;

use vars qw (%NAV);

sub base { return 'Navigation'}

sub exclude {
   return ",url,role,skip,help,target,rack,";
}

# mark with stars when writing in lan-specific file
sub mark {
   return ",desc,name,title,";
}

sub read {
  my($class, $nocache) = @_;
  my $renv = System->get_renv();
  my $ruser = System->get_ruser();
  my $base = $class->base();

  my $lang = $ruser->{language} || $renv->{language};
  $lang = "$lang/" if ($lang);

  if (!$nocache) {
    return $NAV{$base}{$lang} if (exists $NAV{$base}{$lang});
  }
  my $menus = $renv->{navigation_menus} || "menus";
  my $lfile = "${lang}$menus";
  my $file  = $menus;

  my ($V1, $V2, $V3);
  if (-r System->get_home() . "/Lang/System/$base/$lfile") {
     $V1 = $class->read_($lfile);
  } else {
     $V1 = $class->read_($file);
  }
  $NAV{$base}{$lang} = $V1;
  return $V1;
}


sub read_ {
  my($class, $file) = @_;
  my %V;
  my $LANG = "/Lang" if (index($file, "/") > 0);
  my $DIR =  System->get_home() . "$LANG/System/" . $class->base();

  if (!open(O, "$DIR/$file")) {
     print "Cannot read $DIR/$file!\n";
     return {};
  }
  my ($l);
  my ($section, $item, $last, $ix);
  my $section_no = -1;
  while ($l = <O>) {
     chop($l);
     next if (substr($l,0,1)  eq "#");
     if (substr($l,0,1) eq "'") {
        $V{$section}{items}{$item}{$last} .= " " . substr($l,1) if ($item);
     } elsif (substr($l,0,1) eq "[") {
        $l = Util->rtrim($l);
        $section = substr($l,1,-1);
        $section_no++;
        $V{$section}{info}{_order} = $section_no;
        $item = $last = "";
     } else {
        next if (index($l, "=") < 0);
        my($n, $v) = split(/\s*\=\s*/, $l, 2);
        if (substr($n,0,1) eq ".") {
          $V{$section}{info}{substr($n,1)} = $v;

        } else {
          my $ix = index($n,".");
          $item = substr($n,0,$ix);

          if (substr($n,-4) eq ".url") {
            $V{$section}{order} .= "$item,";
            $V{$section}{items}{$item}{url} = $v;
          } else {
            my $n0 = substr($n, $ix+1);
            $V{$section}{items}{$item}{$n0} = $v;
            $last = $n0;
          }
        }
     }
  }
  close(O);
  return \%V;
}


sub write {
  my($class,  $v1, $file, $arg) = @_;
  my (@OR);
  my $langOnly = $arg->{langOnly}; # only write fields that should be translated
  my $base = $class->base();

  my $EXCL = $class->exclude();
  my $LANG = "/Lang" if (index($file, "/") > 0);

  open(O, ">" . System->get_home(). "$LANG/System/$base/" . $file);
  foreach  my $el (sort keys %$v1) {
      $OR[$v1->{$el}{info}{_order}] = $el;
  }
  foreach my $el (@OR) {
      print O "\n[$el]\n";
      my $info = $v1->{$el}{info};
      foreach my $k (sort keys %$info) {
         next if ($k eq "_order");
         next if ($langOnly && index($EXCL, ",$k,") >= 0);
         print O sprintf(".%-20s = %s\n", $k, $info->{$k});
      }
      my @L = split(/,/, $v1->{$el}{order});
      foreach my $el2 (@L) {
          print O "\n";
          my $item = $v1->{$el}{items}{$el2};
          print O sprintf("%-21s = %s\n", "$el2.url", $item->{url});
          foreach my $k (sort keys %$item) {
              next if ($k eq "url");
              next if ($langOnly && index($EXCL, ",$k,") >= 0);
              print O sprintf("%-21s = %s\n", "$el2.$k", $item->{$k});
          }
      }
  }
  close(O);
}

# v1 is local
# replace in v1 language-specific tags from v2, return v1
# mark the missing fields with '$mark'

sub sync {
   my($class, $v1, $v2, $mark) = @_;

  my $EXCL = $class->exclude();
  my $MARK = $class->mark();

   foreach  my $el (keys %$v1) {
      if (exists $v2->{$el}) {
         my $X =  $v1->{$el}{info};
         foreach my $e (keys %$X) {
           next if (index($EXCL, ",$e,") >= 0);
           if (exists $v1->{$el}{info}{$e}) {
             next if (substr( $v1->{$el}{info}{$e},0,5) eq "FILE ");
             if (exists $v2->{$el}{info}{$e}) {
                $v1->{$el}{info}{$e} = $v2->{$el}{info}{$e} ;
             } elsif (index($MARK, ",$e,") >= 0) {
                $v1->{$el}{info}{$e} .= $mark;
             }
           }
         }
         my $items = $v1->{$el}{items};
         foreach my $line (keys %$items) {
            my $X =  $v1->{$el}{items}{$line};
            foreach my $e (keys %$X) {
               next if (index($EXCL, ",$e,") >= 0);
               if (exists $v1->{$el}{items}{$line}{$e}) {
                  next if (substr( $v1->{$el}{items}{$line}{$e},0,5) eq "FILE ");
                  if (exists $v2->{$el}{items}{$line}{$e}) {
                    $v1->{$el}{items}{$line}{$e} = $v2->{$el}{items}{$line}{$e};

                  } elsif (index($MARK, ",$e,") >= 0) {
                    $v1->{$el}{items}{$line}{$e} .= $mark;
                  }
               }
            }
         }
      }
   }
   return $v1;
}


#  0 : invisible
#  1 : inactive
#  2 : active

sub active {
  my($item, $ruser, $renv, $q) = @_;
  if ($item->{solaris}) {
    my $v = System->os_version();
    return 1 if ($v && $v lt $item->{solaris});
  }
  if (exists $item->{dir} && !-d System->get_home() . "/$item->{dir}") {
     return 0;
  }
  if (exists($item->{edition})) {
     my $ed = $renv->{edition} || "dev";
     return 0 if (index("|$item->{edition}|", "|$ed|") < 0);
  }

  if (exists($item->{rack})) {
    my $R = lc($item->{rack});
    my $sol = lc($renv->{solution});    # can be n,se,se2 so far
    $sol = "se" if ($sol eq "n" && $renv->{se_slave}); 
    if ( index("|$R|", "|$sol|") < 0) {
      return $R eq $item->{rack}? 1: 0;
    }
  }

  return 2 if ($ruser->{userid} eq "ROOT");
  if ($item->{cookie} && $q) {
    my $ck = $item->{cookie};
    return 1 if (!$q->{"COOKIE_$ck"});
  }

  return 2 if ($ruser->{isCustomer} && index("|$item->{role}|", "|c|") >= 0);
  return 2 if (!$ruser->{isCustomer} && index("|$item->{role}|", "|s|") >= 0);

  my @s = split(/\|/, $item->{role});
  foreach my $el (@s) {
     return 2 if (index("|$ruser->{roles}|", "|$el|") >= 0) ;
  }
  return 1;
}




#   leftmargin=0 topmargin=0 marginwidth=0 marginheight=0>

use TopFrame;

sub get_vars {
  my($info, $window, $renv, $q) = @_;
  my ($url1, $url2);

  if ($window eq "N") {
      $url1 = "$Http::WEBPROC?GO=GUI::Navigation::index";
      $url2 = "$Http::WEBPROC?GO=GUI::Navigation::frame&MENU=help_sys";
  } else {
      $url1 = "$Http::WEBPROC?GO=GUI::Welcome::welcome target=bottom";
      $url2 = "$Http::WEBPROC?GO=GUI::Navigation::frame&MENU=help_sys target=bottom";
  }
  my ($model, $out);
  if ($renv->{solution} ne "N") {
      $model = "&nbsp;(StorEdge $renv->{solution_model})";
  }
  if (substr($renv->{color_scheme},0,4) eq "hci2") {
    $out = TopFrame::hci2($info, $window, $q, $renv,$url1, $url2, $model);

  } else {
    $out = TopFrame::tabs($info, $window, $q,$renv,$url1, $url2, $model);
  }
  return $out;
   
}


# TOP OF PAGE, NO JS, uses $q->{TAB}

sub nf_top {
  my($q) = @_;
  # $q->{TAB} = 1,2
  my ($tab, $tab2);

  if (!defined $q->{TAB}) {
    $tab = -2 ;
  } else {
    ($tab, $tab2) = split(/,/, $q->{TAB});
  }
  my $high = $Style::TAB_BG;

  my $frame   = $q->{FRAME};
  my $renv    = System->get_renv();
  my $version = $renv->{version};
  my $ruser   = System->get_ruser();
  my $nav     = Navigation->read();
  my $nav1    = $nav->{ROOT};
  my $window  = $ruser->{window} || $renv->{window};
  my $G       = Labels->read();
  my ($sep2, $cols, $lcorner, $rcorner, $active_tab);
  if (substr($renv->{color_scheme},0,4) eq "hci2") {
    $sep2 = "sep2_plex.gif";
    $cols = 7;
    $rcorner = $lcorner= "&nbsp;";
    $active_tab = "&nbsp;";
  } else {
    $sep2 = "sep2.gif";
    $cols = 3;
    $lcorner= "<img src=/gif/lcorner.gif border=0>";
    $rcorner= "<img src=/gif/rcorner.gif border=0>";
    $active_tab = "<img src=/gif/$sep2 width=5 height=17 xalign=top>";
  }

  print &get_vars($nav1->{info}, $window, $renv, $q) . "\n";
  my $out;

  my @O = split(/,/, $nav1->{order});
  my ($tab_list, $sub_tab);
  my $cnt = 0;
  my ($i, $sub);
  my $menu2 = $q->{MENU};
  if ((my $i2 = index($menu2, ".")) > 0) {
    $menu2 = substr($menu2,0,$i2);
  }

  for ($i=0; $i <= $#O; $i++) {
    my $el = $O[$i];
    my $item = $nav1->{items}{$el};
    next if ($item->{skip} && index($item->{skip}, "t") >= 0);
    my $act = &active($item, $ruser, $renv, $q);
    $act = 1 if ($q->{OFF});
    next if ($act == 0);
    $tab = $i if ($menu2 eq $el);
    my $ll;
    my $fc = ($i == $tab) ? "<font color=$Style::TAB_FG>" : 
                         "<font color=$Style::TABOFF_FG>";
    if ($act == 2) {
       $ll .= "<a href=\"$Http::WEBPROC?GO=GUI::Navigation::index&MENU=>$el\"
                  onclick=javascript:start1('$el') class=t10>";

       #$ll .= "<a href=\"$Http::WEBPROC?GO=GUI::Navigation::welcome&MENU=$el&TOPDONE=1\" 
       #target=bottom onclick=javascript:start2('$el') class=t10>";

       $ll .= ($i == $tab)? "$fc<b>$item->{title}</b></font></a>" :
                            "$fc<b>$item->{title}</b></font></a>" ;
       $cnt++;
    } else {
       $ll .= ($i == $tab)? "$fc<b>$item->{title}</b></font>" :
                            "<font color=#404040 class=l10>$item->{title}</font>" ;
    }
    $ll = "&nbsp;$ll&nbsp;&nbsp;";
    if ($i == $tab) {
       $sub = $el;
       $out .= "<td bgcolor=$high>$active_tab$ll</td>\n";
    } else {
       if ($Style::HIGH_TAB) {
         $out .= "<td bgcolor=$Style::TABOFF_BG>
                  <table border=0 cellspacing=0 cellpadding=0>
                  <tr><td bgcolor=$Style::TOPBGCOLOR><img src=/gif/dot_clear.gif height=2></td>
                  <tr><td><img src=/gif/$sep2 width=5 height=17 xalign=top>$ll</table></td>\n";
       } else {
         $out .= "<td bgcolor=$Style::TABOFF_BG valign=top>
                <img src=/gif/$sep2 width=5 height=17 xalign=top>$ll</td>\n";
       }
    }
    $out .= "<td><img src=/gif/dot_clear.gif width=3></td>";
  }
  $out .= "</table></td>";


  if (substr($renv->{color_scheme},0,4) ne "hci2") {
     my $machine = System->get_machine_name();
     $machine = "$machine | " if ($machine);
     $out .= "<td align=right nowrap><ximg src=/gif/user_16.gif alt=\"User Name\" border=0>
              <font color=white>$machine $ruser->{userid} | v$version&nbsp;</td>";
  }

  if ($tab >= 0) {
     my @order = split(/,/, $nav->{$sub}{order});
     my ($out2, $y);
     $out .= "<tr bgcolor=$high><td valign=top xbgcolor=$Style::TOPBGCOLOR>$lcorner</td><td colspan=$cols valign=top>" . 
             "<table border=0 cellspacing=3 cellpadding=0><tr>\n";

     for ($y = 0; $y <= $#order; $y++) {
        my $e = $order[$y];
        my $el1 = $nav->{$sub}{items}{$e};
        next if ($el1->{skip} && index($el1->{skip}, "t") >= 0);
        my $act = &active($el1, $ruser, $renv);
        next if ($act == 0);
        my $lnk;
        if ($act == 2) {
          if ($frame) {
            if (substr($el1->{url},0,1) eq ">") {
              $lnk  = "<a href=\"$Http::WEBPROC?GO=GUI::Navigation::frame&MENU=" . 
                       substr($el1->{url},1) . "\" target=bottom class=l10>";
            } elsif (substr($el1->{url},0,1) eq "/") {
              my $tt = $el1->{target} || "bottom";
              $lnk  = "<a href=\"$el1->{url}\" target=$tt class=l10>";
            } else {
              $lnk  = "<a href=\"$Http::WEBPROC?GO=$el1->{url}\" target=bottom class=l10>";
            }
          } else {
            $lnk  = "<a href=\"$Http::WEBPROC?GO=GUI::Navigation::index&TAB=$tab,$y&MENU=$el1->{url}\" class=l10>";
          }
          $lnk .= "<font color=$Style::TAB_FG xclass=t10>$el1->{title}</font></a>";
        } else {
          $lnk =  "<font color=gray xclass=t10>$el1->{title}</font>";
        }
        if (defined($tab2) && $y == $tab2) {
            $out .= "<td><b>$lnk</b></td>";
        } else {
            $out .= "<td>$lnk</td>";
        }
        if ($y < $#order) {
            $out .= "<td>&nbsp;<font color=$Style::DELIMITER>|&nbsp;</td>\n";
        }
     }
     $out .= "</table></td><td align=right valign=top>$rcorner</td>";
      
  } else {
    my $i1 = $G->expand(select_function => $cnt) if (!$q->{OFF});
    #$out .= "<tr><td colspan=4 bgcolor=$Style::DARK>&nbsp;</td>\n";
    $out .= "<tr bgcolor=$high><td valign=top>$lcorner</td>";
    $out .= "<td colspan=$cols valign=top>" . 
     "<table border=0 cellspacing=2 cellpadding=0><tr><td><font color=$Style::DELIMITER>&nbsp;$i1" .
     "</table></td><td align=right valign=top>$rcorner</td>";
  }
  my $c1 = $cols + 2;
  $out .= "<tr bgcolor=$Style::TAB_BG><td colspan=$c1>&nbsp;</td>" if ($frame);
  $out .= "</table>";
  print $out;

}


# 'monitor.log' => {
#   'items' => {
#            'errors' => {
#                          'url' => 'GUI::Errlog::list',
#                          'title' => 'Agent Errors',
#                          'desc' => 'Agent Errors',
#                          'role' => 's|c'
#                        },
#            'events' => {
#                          'url' => 'GUI::EventLog::list ',
#                          'title' => 'Event Log',
#                          'desc' => 'Event Log',
#                          'role' => 's|c'
#                        },
#            'alerts' => {
#                          'url' => 'GUI::EventLog::alerts',
#                          'title' => 'Alert Log',
#                          'desc' => 'Alert Log',
#                          'role' => 's|c'
#                        },
#            'messages' => {
#                            'url' => 'GUI::MessageLog::list',
#                            'title' => 'Messages',
#                            'desc' => 'Messages',
#                            'role' => 's|c'
#                          }
#          },
#  order' => 'messages,events,alerts,errors,',
#  info' => {
#           'tab' => 'monitor',
#           'title' => 'Monitor Log',
#           'desc' => 'Monitor Log',
#           'name' => 'Monitor Log'
#         }
#}
#

1;
