package Mail;
use strict;

use System;
use Net::SMTP;

sub mail {
  my($class, $to, $from, $subject, $data, $TO) = @_;

  my $renv = System->get_renv();
  my $sendmailServer = $renv->{sendmail_server} || "localhost";
  $TO = 30 if (!$TO);

  my $smtp = Net::SMTP->new($sendmailServer, Timeout => $TO);
  if (!$smtp) {
     Debug->print2("Cannot create SMTP handle");
     return "Cannot create SMTP handle to $sendmailServer: $!";
  }
  my $ct = "Content-Type: text/plain; charset=us-ascii";

  my $text;
  $text = "From: $from\nTo: $to\nSubject: $subject\n\n$data";

  if ($smtp->mail($to) && $smtp->to($to)) {
     $smtp->data();
     $smtp->datasend($text);
     $smtp->dataend;
     $smtp->quit;
     return undef;
  } else {
     my $err = $smtp->message();
     $smtp->quit;
     return $err;
  }
}

sub mailData {
  my($class, $to, $data, $TO) = @_;

  my $renv = System->get_renv();
  my $sendmailServer = $renv->{sendmail_server} || "localhost";
  $TO = 30 if (!$TO);

  my $smtp = Net::SMTP->new($sendmailServer, Timeout => $TO);
  if (!$smtp) {
     Debug->print2("Cannot create SMTP handle");
     return "SMTP error";
  }

  if ($smtp->mail($to) && $smtp->to($to)) {
     $smtp->data();
     $smtp->datasend($data);
     $smtp->dataend;
     $smtp->quit;
     return undef;
  } else {
     my $err = $smtp->message();
     $smtp->quit;
     return $err;
  }
}


1;
