package Html::List;
use strict;
use Html;
use base 'Html';
use Labels;

#  $list = Html::List->makeList($q,
#     [ [r1c1, r1c2, r1c3 ...],
#       [r2c1, r2c2, r2c3 ...],
#     ],
#     ['Col1','Col2','Col3','Col4'],
#     ['l',   'r',   'c',   'c'   ],
#     ['+sn',   '-'                 ],
#     { pageSize => 20, map => 'list2', title => "this" , interactive => 0});
#       colDisplay => [undef,undef, \&func1] }
#  +s : means put a space when the sort value changes
#  +_n : don't repeat the column

      

sub makeList {
  my($class, $q, $array, $headers,$justify, $sorts, $opts) = @_;
  my($x, $c, $sign, $map, $lang, @L, $values, $line2_col, $line2_skip);
  my $interactive = $opts->{interactive};
  my $G = Labels->read();

  my $pageSize = $interactive ? ($opts->{pageSize} || 40) : 100000;
  my $page = $q->{PAGE} || 1;

  my $url = "$Http::WEBPROC?GO=$q->{GO}";
  my $c1  = $opts->{break} ; # break contains color and content 
  if ($opts->{line2}) {
     ($line2_col, $line2_skip) = split(/,/, $opts->{line2});
  }
  my $colorRow = $opts->{colorRow};
  $line2_skip = 1 if (!defined($line2_skip));
  my $fpnl = $opts->{fpnl} || "First|Previous|Next|Last";
  my @FPNL = split(/\|/, $fpnl);
  my $colDisplay = $opts->{colDisplay};

  foreach my $k (keys %$q) {
     next if ($k eq "SORT" || $k eq "SIGN" || $k eq "PAGE" || $k eq "GO");
     $url .= "&$k=$q->{$k}";
  }
  my $sort = $q->{SORT};
  $q->{SIGN} = 1 if (!$q->{SIGN} && $sort);

  my $out = "<tr bgcolor=$Style::LIGHT>";

  for ($x=0; $x <= $#$headers; $x++) {
     my $si = substr($sorts->[$x],0,1);
     my $v  = $headers->[$x];
     my $al = $justify->[$x] || 'l';

     if ($si eq "+" || $si eq "-" ) {
         my $prefix;
         if ($sort == $x+1) {
            $sign = - $q->{SIGN};
            $prefix = ($q->{SIGN} == 1)? "+&nbsp;":"-&nbsp;";
         } else {
            $sign = ($si eq "+") ? 1: -1;
         }
         my $href = $interactive ? "<a href=\"$url&SORT=" . ($x+1) . "&SIGN=$sign\">$v</a>" :
                        $v;
         if ($al eq "r") {
           $out .= "<td align=right><table border=0><tr>
             <td><b>$prefix$href&nbsp;</table></td>";
         } else {
           $out .= "<td><table border=0><tr><td><b>&nbsp;$prefix$href</table></td>";
         }
     } else {
         $out .= ($al eq "r") ? "<td align=right><table border=0><tr><td><b>$v&nbsp;</table></td>":  "<td>&nbsp;<b>$v</td>";
     }
  }
  $out .= "\n";
  my $S = $array;
  my(@NS, @NS2, $r);
  if ($sort) {
     for ($x=0; $x <= $#$array; $x++) {
         $r = $array->[$x];
         push(@NS2, $r->[$sort-1] . "\t" . sprintf("%3.3d", $x));
     }
     if ($q->{SIGN} == -1) {
        foreach my $v (reverse sort @NS2) {
          my($s, $no) = split(/\t/, $v);
          push(@NS, $array->[$no]);
        }
     } else {
        foreach my $v (sort @NS2) {
          my($s, $no) = split(/\t/, $v);
          push(@NS, $array->[$no]);
        }
     }
     $S = \@NS;
  }
     
  my $first = ($page-1) * $pageSize;
  my $last =  $page * $pageSize - 1;
  my $tot_pages  = int(($#$array+2) / $pageSize + 0.99);
  
  if($tot_pages == 0){
    $tot_pages = 1;
  }

  $last = $#$array if ($last > $#$array);
  my($y);
  my $lastv ="++++";
  my $norepeat = substr($sorts->[$sort-1],2,1);
  my $new = 0;

  for ($x=$first; $x <= $last; $x++) {
      my $row = $S->[$x];
      $new =0;
      if ($sort && substr($sorts->[$sort-1],1,1) eq 's' && $lastv ne $row->[$sort-1]) {
          if ($lastv ne "++++") {
              if ($c1) {
                $out .= "<tr><td></td><tr><td bgcolor=$c1 colspan=" . ($#$headers+1) . "><b>&nbsp;" . 
                         $headers->[$sort-1] . ": " . $row->[$sort-1] . "</td>";
              } else {
                $out .= "<tr><td></td><tr><td></td>";
              }
          }
          $lastv = $row->[$sort-1]; $new = 1;
      }
      if ($colorRow && $row->[$colorRow-1]) {
        $out .= "<tr bgcolor=$row->[$colorRow-1]>";
      } else {
        $out .= "<tr>";
      }
      my $cols = ($#$headers >= 0) ? $#$headers : $#$row;
      for ($y=0; $y <= $cols; $y++) {
         my $al = $justify->[$y] || 'l';
         my $bold;
         if ($sort-1 == $y && ($norepeat eq "n")) {
           if ( $new ) {
             $bold = "<b>";
           }  else {
             $out .= "<td></td>";
             next;
           }
         }
         if ($colDisplay->[$y]) {
            my $f = $colDisplay->[$y];
            $out .= &$f($row->[$y]);
         } elsif ($al eq "l") {
            $out .= "<td>$bold&nbsp;$row->[$y]</td>";
         } elsif ($al eq "r") {
            $out .= "<td align=right>$bold$row->[$y]&nbsp;</td>";
         } elsif ($al eq "x") {
            $out .= "<td>$row->[$y]</td>";
         } elsif ($al eq "c") {
            $out .= "<td><center>$bold$row->[$y]</td>";
         }
      }
      if ($line2_col && $row->[$line2_col] ) {
         my $w = $#$headers - $line2_skip + 1;
         $out .= "<tr><td colspan=$line2_skip><td colspan=$w>$row->[$line2_col]</td>" ;
      }
      $out .= "\n";
  }
  my $page_info = $G->expand(page => "<b>$page</b>", $tot_pages) . " &nbsp;[ ";
  if ($tot_pages  > 1) {
    my $ss = "&SORT=$q->{SORT}&SIGN=$q->{SIGN}";
    if ($page > 1) {
       $page_info .= "<a href=$url&PAGE=1$ss>First</a> | ";
    } else {
       $page_info .= "$FPNL[0] | ";
    }
    if ($page > 1) {
       my $pp = $page - 1;
       $page_info .= "<a href=$url&PAGE=$pp$ss>Prev</a> | ";
    } else {
       $page_info .= "$FPNL[1] | ";
    }
    if ($page < $tot_pages) {
       my $np = $page + 1;
       $page_info .= "<a href=$url&PAGE=$np$ss>Next</a> | ";
    } else {
       $page_info .= "$FPNL[2] | ";
    }
    if ($page < $tot_pages) {
      $page_info .= "<a href=$url&PAGE=$tot_pages$ss>Last</a>  ";
    } else {
      $page_info .= "$FPNL[3] ";
    }
    $page_info .= " ]";
  } else {
    chop($page_info);
    chop($page_info);
  }
  return ($page_info, $out);
}


1;
