package Grouping;
use System;
use Util;
use Data::Dumper;
use strict;

# 'info' => {
#      'description' => 'Systems',
#      'group' => 'systems'
#    },
#    'map' => {
#      'systems.san-01-rack1' => [
#        '',
#        'standard',
#        'F0C0F0'
#      ],


use vars qw (@COLORS $GROUPING);

$GROUPING = undef;

@COLORS = ('F0F0F0=gray', 'F0F0D0=yellow', 'F0F0E0=lyellow','F0C0F0=lpurple', 
           'C0C0F0=purple','C0F0C0=green', 'C0F0F0=blue', 'F0C0C0=brown',
           'DDDDFF=SunPale', '666699=Sun');

sub GROUP_TYPE {
  my $LB = Labels->read("GUI::Grouping");
  return ("standard=$LB->{g_default}","rack=$LB->{g_rack}",
                    "room=$LB->{g_room}",
                    "building=$LB->{g_building}",
                    "cloud=$LB->{g_cloud}" );
}

sub _load {
  my($class) = @_;
  my $VAR1;
  if (!$GROUPING) {
     open(O, System->get_home() . "/DATA/Grouping");
     my @l = <O>; close(O);
     eval "@l";
     $GROUPING = $VAR1;
  }
}


sub convert {
  my($class) = @_;
  my(@L);
  $class->_load();
  my $D =  System->get_home() . "/DATA/Groups";
  $Data::Dumper::Indent = 1;
  

  foreach my $el (keys %$GROUPING) {
     open(O, ">$D/$el");
     print O Dumper($GROUPING->{$el});
     close(O);
  }
}

sub group_islands {
  my($q) = @_;
  my $BAGS2 = Util->deserialize("island_list");
  my $to = TO->readTopo("MERGE-MASTER");

  Grouping->deleteCategory("MERGE-MASTER:Islands");
  my $islands = Grouping->addCategory("MERGE-MASTER", "Islands", "SAN Islands");
  my($x);
  for ($x=0;$x <= $#$BAGS2; $x++) {
     my @list = split(/\, /, $BAGS2->[$x]);
     my $done = 0;
     foreach my $node (@list) {
        my $desc;
        if (!$done && substr($node,0,4) eq "host") {
           $desc = substr($node,5); $done = 1;
        }
        $islands->setGroup("MERGE-MASTER:Islands", $node, "I$x", undef, undef,
                   $desc);
     }
  }
  $islands->save();
}

sub group_adm {
  my($q) = @_;
  my $N = "AdmGroup";
  my $to = TO->readTopo("MERGE-MASTER");
  Grouping->deleteCategory("MERGE-MASTER:$N");

  my $adm = Grouping->addCategory("MERGE-MASTER", $N, "Admin Groups");
  my($x);
  my $Config = PDM::ConfigFile->read();
  my $H = $Config->adminGroups();
  foreach my $e (keys %$H) {
     my $grp = $H->{$e};
     $adm->setGroup("MERGE-MASTER:$N", $e, $grp, undef, undef, $grp);
  }
  $adm->save();
}

  

sub groupList {
  my($class, $host) = @_;
  my (@L);
  my $D = System->get_home() . "/DATA/Groups";
  if (!-d $D) {
     mkdir $D, 0777;
     $class->convert();
  }
  opendir(O, System->get_home() . "/DATA/Groups");
  my @dirs = readdir(O); closedir(O);

  foreach my $el (sort @dirs) {
     next if (substr($el,0,1)  eq ".");
     my($h ,$gr) = split(/\:/, $el);
     next if ($host && $host ne $h);
     my $gr = $class->read($el);
     push(@L,  $gr->{info});
  }
  return \@L;
}

sub deleteCategory {
  my($class, $code) = @_;
  my $D = System->get_home() . "/DATA/Groups/$code";
  unlink $D;
}


sub updateId { 
  my($group, $k, $desc, $style, $color) = @_;
  $group->{map}{$k} = [$desc, $style, $color];
}

sub deleteId {
  my($group, $k) = @_;
  delete $group->{map}{$k};
}

sub addCategory {
  my($class, $host, $code, $desc, $noerase) = @_;

  my $code0 = "$host:$code";
  my $group = $class->read($code0);
     $group->{info}{host} = $host;
     $group->{info}{group} = $code;
     $group->{info}{description} = $desc;
  if (!$noerase) {
    $group->{members} = {};
  }
  $group->save();
  return $group;
}

# key = e10k.central.sun.com:lab1.rack1
# return ('e10k.central.sun.com', 'lab1','rack1...')
#
sub keyParts {
  my($class, $key) = @_;

  my($host, $rest) = split(/\:/, $key, 2);
  my($cat, $rest2) = split(/\./, $rest,2);
  return ($host, $cat, $rest2);
}

#  {
#    systems => {
#        'switch:wwn1' => 'sys1',
#        't3:wwn1'     => 'sys2',
#
sub read {
  my($class, $group) = @_;
  my $VAR1;
  my $D = System->get_home() . "/DATA/Groups/$group";
  my $gr= {};
  if (open(O, $D)) {
    my @l = <O>; close(O);
    eval "@l";
    $gr = $VAR1;
  }
  $gr->{key} = $group;
  bless($gr, "Grouping");
  return $gr;
}

#  $map = getMap("host:Labs")
#  $style = getMap("host:Labs", "lab1")
#
sub getMap {
  my($class, $group, $key) = @_;
  my $obj = ($class eq "Grouping")? $class->read($group) : $class;

  if (exists($obj->{map})) {
    if ($key) {
      return $obj->{map}{"$group.$key"};
    } else {
      return $obj->{map};
    }
  } 
  return [];
}
  

#$group->setGroup("group:MERGE-MASTER", "t3:1222", "Islans.i-1" ...)

sub setGroup {
  my($class, $group, $key, $groupID, $color, $style, $desc) = @_;

  my $obj = ($class eq "Grouping")? $class->read($group) : $class;

  if (substr($key,0,6) eq "group:") {
    $key = substr($key,6);
    my $M = $obj->{members};
    my $MP = $obj->{map};
    my(@T) = $class->keyParts($key);
    foreach my $el (keys %$M) {
      if ($M->{$el} eq $key) {
         my $new = "$T[0]:$T[1].$groupID";  # host:grouping.id
         $M->{$el} = $new;
         $MP->{$new} = [$desc, $style, $color || "F0C0F0"];
      } elsif (substr($M->{$el} , 0, length($key) + 1) eq "$key.") { # child
         my $new = "$T[0]:$T[1].$groupID" . substr($M->{$el},length($key));
         $M->{$el} = $new;
         $MP->{$new} = $MP->{$M->{$el}};
      }
    }
  } else {
    if (!$groupID) {
      delete( $obj->{members}{$key} );
    } else {
      $obj->{members}{$key} = "$group.$groupID";
      $obj->{map}{"$group.$groupID"}[0] = $desc  if ($desc);
      $obj->{map}{"$group.$groupID"}[1] = $style if ($style);
      $obj->{map}{"$group.$groupID"}[2] = $color if ($color);
    }
  }
}

sub refreshMap {
  my($class, $group) = @_;

  return if (!$group);
  my $obj = ($class eq "Grouping")? $class->read($group) : $class;

  my $l = $obj->{members};
  my %MAP;
  foreach my $x (keys %$l) {
    $MAP{$l->{$x}} = 1;
  }
  my $m = $obj->{map};

  foreach my $k (keys %$m) {
    if (!$MAP{$k}) {
      delete( $obj->{map}{$k} );
    }
  }

  foreach my $k (keys %MAP) {
     if (!$m->{$k})  {
        $obj->{map}{$k} = ["", "", "F0C0F0"];
     }
  }
  $obj->save();    
}
  

sub save {
  my($group) = @_;
  open(O,  ">" . System->get_home() . "/DATA/Groups/$group->{key}");
  $Data::Dumper::Indent = 1;
  print O Dumper($group);
  close(O);
}

sub members {
  my($class) = @_;

  return $class->{members};
}

sub info {
  my ($class) = @_;
  
  return $class->{info};
}

sub map {
  my ($class) = @_;
  
  return $class->{map};
}

1;
