package GUIAdmin::T3;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: T3.pm,v 1.67 2003/05/13 22:33:51 ccadieux Exp $

use PDM;
use Util;
use Html;
use strict;
use Debug;
use Carp;
use GUIAdmin;
use GUI::Devices;
use base 'GUIAdmin';
use Logic::T3;
use Discover;

sub isDevice {
   my $renv = System->get_renv();
   return 0 if ($renv->{solution} eq "se2");
   return 1;
}

sub description {'Sun T3'};

sub ipRequired {1}

sub discover {
  my( $q, $post, $util) = @_;
  my($o, $warn);
  print Html->text_header();

  my $name = $q->{NAME} || "T3";
  my($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  my $use;
  my $L = Labels->read("GUIAdmin::default")->section("discover");

  foreach my $h1 (@$host) {
      last;
      next if ($q->{select_host} && $q->{select_host} ne $h1->{hostname});
      if (!$h1->{t300logfile}) {
        $warn .= "<b><font color=red>Warning: The $name logfile on $h1->{hostname} has not been entered.</font></b><br>";
      } elsif ($q->{select_host}) {
        $use = "<br> </b>($h1->{t300logfile})";
      }

  }

  if (!$renv->{t300logfile}) {
     $warn .= "<b><font color=red>" . $L->expand(warn1 =>  $name) . "</font></b>";
  }

  if ($q->{ACTION_confirm}) {
     my $f = "-f $q->{logfile}" if ($q->{logfile});
     Discover->ras_admin($q->{select_host}, "discover_t3 -p $f", $renv, $host, "arrayFromLog");
     return 'DISCO';
  }

  my $h = Html->header2("admin.gen_maint.discovery", undef, "Sun $name", "discover_t3");

  my $sel = $q->{select_host} || $L->{all_hosts};
  $o =<<EOF;
 <body bgcolor=$Style::BGCOLOR>
 <center>
 $h
 <table border=0><tr><td>$warn</table>
</table>
<table border=1 cellspacing=0 cellpadding=4 width=80% bgcolor=white>
  <form method=get>
  <input type=hidden name=GO value=GUI::Discover::discover>
  <input type=hidden name=PKG value=GUIAdmin::T3::discover>
  <input type=hidden name=select_host value=\"$q->{select_host}\">
  <tr><td align=right width=25% bgcolor=$Style::LIGHT>$L->{select}:</td>
      <td><b>$sel $use</td>
  <tr><td align=right width=25% bgcolor=$Style::LIGHT>$L->{use}:</td>
      <td><b><input type=text type=logfile size=50 value=$renv->{t300logfile}></td>
 </table><b>
     <input type=submit name=ACTION_confirm value="$L->{confirm}">
 </form>
EOF
  print $o;
  return 0;

}

# returns the t3 that a slave has.
# response to a http request made by a master rasagent.

sub get_Devices {
  my($q, $post, $util) = @_;
  my($l, $loc, @a, $out, $t);

  my(%F);
  if (open(O, $q->{file})) {
     my $cnt1;
     while ($l = <O>) { 
       last if ($cnt1++ > 20000);
       @a = split(/ +/, $l);
       $loc = $a[3];
       $loc = substr($loc,1) if (substr($loc,0,1) eq "[");
       chop($loc) if (substr($loc,-1) eq "]");
       next if ($loc =~ /^\s*$/);
       next if ($loc =~ /\:/);
       $F{$loc} = 1;
     }
     close(O);
     $out = ""; 
     foreach $t (sort keys %F) {
        
        my($ip) = Util->testIp($t,5);
        my $h =  Agent::T3->getWWN($ip);
        if (!$ip) {
           $out .= "ERR=cannot ping $t\n";
        } elsif (!$h->{key}) {
           $out .= "ERR=No Midplane Serial# for $t\n";
        } elsif (!$h->{wwn}) {
           $out .= "ERR=No wwn for $t, probably not a T3\n";
        } else {
           $h->{ip} = $t;
           $h->{ipno} = $ip;
           require Data::Dumper;
           $Data::Dumper::Indent = 0;
           my $v = Data::Dumper::Dumper($h);
           $out .= "OK=$v\n";
        }
     }
     print "OK $out\n";
  } else {
     print "ERR $q->{file} $!";
  }
}

sub addDevice {
  my($class, $q) = @_;
  my($ho, $o, $err, $ipno, $x, $info);
  my($renv, $dev, $host,$notifs, $sel, $warn);

  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read("GUIAdmin::default")->section("add");

  require "GUI/Devices.pm";
  print Html->body();
  if ($q->{ACTION_back}) {
    GUI::Devices::add($q);
    return;

  } elsif ($q->{ACTION_add}) {
    my($active) = "Y";
    my($err, $dev) = Logic::T3->addToConfig($q);
    if ($err) {
       $info = $err->toHtml();
    } elsif ($dev) {
       print Html->info($G->{device_added});
       GUI::Devices::list($q);
       return;
    }
  }

  print GUI::Devices::add0($q);

  my $h = Html->header2("admin.gen_maint.add_device", undef, "Sun T3"," ", {nocrumb => 1});

  ($renv, $dev, $host,$notifs) =PDM::ConfigFile->read;
  $sel = ($q->{host} eq "")? "selected":"";


  my($phost) = "<select name=host><option value=\"\">[Select]</option>".
              "<option value=\"\" $sel>Local</option>";
  foreach $x (@$host) {
    next if($x->{dh} eq "Y");
    $sel = ($q->{host} eq $x->{hostname})? "selected":"";
    $phost .= "<option value=" . $x->{hostname} . " $sel>" . $x->{hostname} ."</option>";
  }
  $phost .= "</select>";

  my($phostD) = "<select name=datahost>".  "<option value=\"\" $sel>Same Host</option>";
  my $l1 = {hostname => System->hostname(), ip => System->hostname()};
  foreach $x (@$host, $l1) {
    next if($x->{dh} eq "Y");

    $sel = ($q->{datahost} eq $x->{ip})? "selected":"";
    $phostD .= "<option value=\"" . $x->{ip} . "\" $sel>" . $x->{hostname} ."</option>";
  }
  $phostD .= "<option value=\"*None\">*None</option></select>";

  $o =<<EOF;
<form  method=get>
 <input type=hidden name=GO value="GUIAdmin::T3->addDevice">
 <input type=hidden name=ADD value=T3>
<center>
$h
$info
<table border=1 cellspacing=0 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr><td colspan=2 bgcolor=$Style::DARK><b><font color=white>&nbsp;$L->{enter}</td>

<tr><td bgcolor=$Style::LIGHT width=30% align=right>$L->{dev_name}:</td>
    <td><input type=text name=name size=15 maxlength=35 value="$q->{name}">

<tr><td bgcolor=$Style::LIGHT width=30% align=right>$L->{telnet}:</td>
    <td><input type=password name=telnet size=20 maxlength=30 value="$q->{telnet}">

<tr><td bgcolor=$Style::LIGHT align=right>$L->{primary}:</td>
    <td>$phost</td>
<tr><td bgcolor=$Style::LIGHT width=30% nowrap align=right>$L->{ip}:</td>
    <td><input type=text name=ip size=40 maxlength=40 value="$q->{ip}">

</table>
</table>
<b>
EOF

# <tr><td bgcolor=$Style::LIGHT align=right>Data-Path Host :</td> <td>$phostD</td>

  print $o;
  if (!$deny) {
     print "<input type=submit name=ACTION_add value=$L->{submit_add}>";
  }
  print "<input type=submit name=ACTION_back value=$L->{submit_back}></form>";


}

sub updDevice {
  my($class, $q) = @_;
  my($ho, $o);
  my($name, $err, $ip, $ipno);
  my($renv, $dev, $host,$notifs, $x, $D, $type, $key, $h1, $h, $sel, $active);

  print Html->body();
  require "GUI/Devices.pm";
   my $deny = Roles->verifyRole($q, "admin");
   my $L = Labels->read("GUIAdmin::default")->section("update");

  if ($q->{ACTION_back}) {
    GUI::Devices::list($q);
    return;

  } elsif ($q->{ACTION_reNotUsed}) {
    ($renv, $dev, $host,$notifs) =PDM::ConfigFile->read;
    $x = $q->{no};
    $dev->[$x]{ip}          = $q->{ip};
    $dev->[$x]{ipno}        = Util->name2ip($q->{ip});
    my($key, $wwn, $wwn2, $ctrl, $t3name) =  
    my $hash = Agent::T3->getWWN($dev->[$x]{ipno}, $q->{host});

    $dev->[$x]{key}   = $hash->{key};
    $dev->[$x]{units} = $hash->{units};
    $dev->[$x]{wwn}   = $hash->{wwn};
    $dev->[$x]{wwn2}  = $hash->{wwn2};
    $dev->[$x]{ctrl_model} = $hash->{ctrl_model};
    $dev->[$x]{name}  = $hash->{name} if ($hash->{name});

    GUIAdmin->clearSlave($q->{host}, $host);
    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    $err = Html->error("Device $name updated!", "green");

  } elsif ($q->{ACTION_upd}) {
    ($renv, $dev, $host,$notifs) =PDM::ConfigFile->read;
    $x = $q->{no};
    $D = $dev->[$x];

    $dev->[$x]{host}        = $q->{host};
    #$dev->[$x]{datahost}   = $q->{datahost};
    $dev->[$x]{name}        = $q->{name};
    my $old_ipno = $dev->[$x]{ipno} ;
    $dev->[$x]{ip}          = $q->{ip};
    $dev->[$x]{ipno}        = Util->name2ip($q->{ip});
    $dev->[$x]{volVerify}   = $q->{volVerify};
    $dev->[$x]{telnet} = Util->encodeAll($q->{telnet});
    $dev->[$x]{class}  = "storage." . $dev->[$x]{type};
    $dev->[$x]{hba}    = $q->{hba};
    my $old_key        = $dev->[$x]{key};
    my $update = 1;
    if ($old_ipno ne $dev->[$x]{ipno}) {  #  rediscover in case it's a new one

      my $hash = Agent::T3->getWWN($dev->[$x]{ipno}, $q->{host});
      if ($hash->{key} ne $old_key) {
        $err = Html->error("Not the same array: nothing was changed!");
        $update = 0;
      }
    }
    if ($update) {
      GUIAdmin->clearSlave($q->{host}, $host);
      PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
      $err = Html->error("Device $name updated!", "green");
    }

  } elsif ($q->{ACTION_del}) {
    ($renv, $dev, $host,$notifs) =PDM::ConfigFile->read;
    $x = $q->{no};
    $type = $dev->[$x]{type};
    $key =  $dev->[$x]{ip};
    GUIAdmin->clearSlave($q->{host}, $host);

    #my($State) = State->read();
    #my $key = $dev->[$x]{key};
    #print "Clearing cache on  $key <br>";
    #$State->clearComponent("t3:$key");
    #$State->write();

    Events->saveEvent("DD", $type,  $key) if ($key);
    $dev->[$x]{_name} = "";
    $name = $dev->[$x]{name} . "/ " . $dev->[$x]{ip};
    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    &main::log_change("Device $name deleted");
    $q->{ERR} = Html->error("Device $name deleted!");
    GUI::Devices::list($q);
    return;
  }
out:

  $h1 = Html->header2("admin.gen_maint.maint_device", undef, "Sun T3"," ");

  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  $h = $dev->[$q->{no}];

  $ip = $h->{ip}; $ipno = $h->{ipno};

  $sel = ($h->{host})? "":"selected";

  $ho = "<select name=host><option value=\"\" $sel>Local</option>";
  foreach $h1 (@$host) {
       next if($h1->{dh} eq "Y");

       $sel = ($h1->{hostname} eq $h->{host}) ? "selected":"";
       $ho .= "<option name=$h1->{hostname} $sel>$h1->{hostname}</option>";
  }
  $ho .= "</select>";

  $sel = ($h->{datahost})? "":"selected";
  my($dataho) = "<select name=datahost><option value=\"\" $sel>Same Host</option>";
  my $l1 = {hostname => System->hostname(), ip => System->hostname()};
  foreach $h1 (@$host, $l1 ) {
       next if($h1->{dh} eq "Y");

       $sel = ($h1->{ip} eq $h->{datahost}) ? "selected":"";
       $dataho .= "<option value=\"$h1->{ip}\" $sel>$h1->{hostname}</option>";
  }
  $sel = ($h->{datahost} eq "*None")? "selected":"";
  $dataho .= "<option value=\"*None\" $sel>*None</option></select>";

  $active = ($h->{active} eq "Y") ? "On":"Off";
  my $telnet = Util->decode($h->{telnet});
  my $verify = Html->makeSelect("volVerify", "=Default|N=Off|Y=On", $h->{volVerify});


  $o =<<EOF;
<body bgcolor=$Style::BGCOLOR>
<form  method=get>
 <input type=hidden name=GO value="GUIAdmin::T3->updDevice">
 <input type=hidden name=no value=$q->{no}>
<center>
$h1
$err
<table border=1 cellspacing=0 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr>
<td colspan=2 bgcolor=$Style::DARK><b><font color=white>&nbsp;$L->{title}</td>

<tr><td bgcolor=$Style::LIGHT align=right>$L->{type}:</td>
    <td>
      <table border=0 cellspacing=0 width=100%> <tr>
        <td><b>&nbsp;$h->{type}</td>
        <td bgcolor=$Style::LIGHT align=right>$L->{monitoring}:</td>
        <td ><b>&nbsp;$active</td>
      </table>

<tr><td bgcolor=$Style::LIGHT width=30% align=right>$L->{name} :</td>
    <td><input type=text name=name size=40 maxlength=40 value="$h->{name}">

<tr><td bgcolor=$Style::LIGHT width=30% align=right>$L->{telnet} :</td>
    <td><input type=password name=telnet size=20 maxlength=40 value="$telnet">

<tr><td bgcolor=$Style::LIGHT width=30% nowrap align=right>$L->{ip} :</td>
    <td>&nbsp;<input type=text size=40 name=ip value=\"$ip\"></td>
<tr><td bgcolor=$Style::LIGHT width=30% nowrap align=right>$L->{ipno} :</td>
    <td>&nbsp;$ipno</td>

<tr><td bgcolor=$Style::LIGHT align=right>$L->{key} :</td>
    <td>$h->{key}</td>
<tr><td bgcolor=$Style::LIGHT align=right>$L->{wwn} :</td>
    <td>$h->{wwn} / $h->{wwn2}</td>
<tr><td bgcolor=$Style::LIGHT align=right>$L->{primary} :</td>
    <td><b>$ho</td>

<tr><td bgcolor=$Style::LIGHT align=right>$L->{verify} :</td>
    <td><b>$verify</td>
<input type=hidden name=WIN value=$q->{WIN}>


</table>
</table>
<b>

EOF

#<tr><td bgcolor=$Style::LIGHT align=right>Data-Path Host :</td> <td><b>$dataho</td>

  print $o;
  my ($del_but, $back_but);
  if (!$q->{WIN}) {
    $del_but = "<input type=submit name=ACTION_del value=$L->{submit_delete}>";
    $back_but= "<input type=submit name=ACTION_back value=$L->{submit_back}>";
  }
  if (!$deny) {
     print "<input type=submit name=ACTION_upd value=$L->{submit_update}> $del_but";

  }
  print " $back_but</form>";

#  <input type=submit name=ACTION_re value=$L->{submit_re}>";

}


1;

