package GUIAdmin::A3500FC;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: A3500FC.pm,v 1.31 2003/04/28 21:58:25 ccadieux Exp $

use PDM;

use strict;
use Debug;
use Util;
use Util::Http;
use System;
use Carp;
use GUIAdmin;
use GUI::Devices;
use base 'GUIAdmin';

sub description {'Sun A3500FC'}
sub isDevice {1}

sub discover {
  my($q,$post,$util) = @_;
  my(%T, @a, $loc, $ip, $new_dev, $d, $adding, $name, $wwn, $hba, $local, $found, $l, $h);
  my($url);
  my($TO) = $util->{TO} || 20;
  my($RASPORT) = $util->{RASPORT} || "7654";
  my $G = Labels->read();

  my(%F);
  my(@NEW);

  my($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  $new_dev= $#$dev ;
  foreach $d (@$dev) {
     if ($d->{type} eq "a3500fc") {
        $F{$d->{name}} = 1;
     }
  }
  $found = keys(%F);
  print "<pre>1 - ".  $G->expand('found_already', $found, &description) . "\n";


  print "2 - " . $G->expand('find_local', &description()) . "\n";
  $adding = 0; $found = 0;
  $q->{type} = "A3500";
  $local = Agent::get_RM6Devices($q);
  my($devs, $wwn2, $dev_type) ;

  if (substr($local,0,3) eq "ERR") {
     print "   $local<br>";
  } else {
    @a = split(/\n/, substr($local,3));
    foreach $l (@a) {
      $wwn2 = "";
      ($name, $devs, $wwn, $wwn2, $dev_type) = split(/=/, $l);
      $found++;
      print "  - " . $G->expand('found_new', "$name/$wwn");
      if (!$F{$name}) {
         $F{$name} = 1;
         $adding = 1;
         $new_dev++;
         $dev->[$new_dev]{_name}    = "device" . $new_dev;
         $dev->[$new_dev]{type}     = $dev_type || 'a3500fc';
         $dev->[$new_dev]{class}    = "storage." . $dev->[$new_dev]{type};
         $dev->[$new_dev]{wwn}      = $wwn;
         $dev->[$new_dev]{wwn2}     = $wwn2;
         $dev->[$new_dev]{key}      = $name;
         $dev->[$new_dev]{active}   = 'Y';
         $dev->[$new_dev]{name}     = $name;
         $dev->[$new_dev]{host}     = "";
         print $G->{device_added} . "\n"; 
      } else {
         print " " . $G->{already_exist} . "\n";
      }
    }
  }
  if (!$found) {
    print "  - " . $G->expand('no_found_master', &description()) . "\n";
  }

  my($data, $a5, $file);
  print "3 - " . $G->expand('find_slave', &description()) . "\n";
  foreach $h (@$host) {
    next if($h->{dh} eq "Y");
    print "  -" .  $G->expand('querying_host', "$h->{hostname} / $h->{ip}") . "\n";

    if (($data = Util::Http->getCommand($h->{ip}, "Agent::RM6Devices&type=A3500&print=1", 10)) ) {
      if (substr($data,0,3) eq "ERR") {
           print "  $data<br>";
           next;
      } else {
           $data = substr($data,3);
      }
      @a = split(/\n/, $data);
      foreach $a5 (@a) {
           $wwn2 = "";
           ($name, $devs, $wwn, $wwn2) = split(/=/, $a5);
           next if (!$name);
           print "  - " . $G->expand('found_new', "$name/$wwn") ;
           if (!$F{$name}) {
              $adding = 1;
              $new_dev++;
              $dev->[$new_dev]{_name}    = "device" . $new_dev;
              $dev->[$new_dev]{type}     = 'a3500fc';
              $dev->[$new_dev]{class}    = 'storage.a3500fc';
              $dev->[$new_dev]{wwn}      = $wwn;
              $dev->[$new_dev]{wwn2}     = $wwn2;
              $dev->[$new_dev]{key}      = $name;
              $dev->[$new_dev]{name}     = $name;
              $dev->[$new_dev]{active}   = 'Y';
              $dev->[$new_dev]{host}     = $h->{hostname};
              $h->{last_push} = "";
              print ", " . $G->{device_added} . "\n";
              $F{$name} = 1;
           } else {
              print ", " . $G->{already_exist} . "\n";
           }
      }
    } else {
      print $G->expand('no_response', $h->{ip}) . "\n";
    } 
  }

  if ($adding) {
      PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
  } else {
    print $G->{no_new_dev} . "\n";
  }
  print "</pre>";
  return "DONE";
}

#
# returns the a3500 that a slave has.
# response to a http request made by a master rasagent.

sub getDevicesDI {
  my($q, $post, $util) = @_;
  my(@out, $f, $l, $name, $hba, $in , $wwn, $x, $i, $path, $out, $out2, $err);
  my($details, $dev, $vendor);

  my($di) = System->get_home() . "/bin/disk_inquiry";

  ($err,$out) = Util->run_command($di, "luxprobe.txt", 20);

  return "\nERR $err" if ($err);

  for ($x=0; $x <= $#$out; $x++) {
    $l= $out->[$x];
    my($ix) = index($l, ":");
    $l= substr($l, $ix+2);
    my(@a) = split(/\s+/, $l);
    $dev = $a[0]; $vendor = $a[2]; $wwn = $a[1];
    next if ($a[2] !~ /A3500/);
    $f .= "$dev=$wwn=X\n";
  }

  return "OK $f\n";
}

sub getDevicesLUX {
  my($q, $post, $util) = @_;
  my(@out, $f, $l, $name, $hba, $in , $wwn, $x, $i, $path, $out, $out2, $err);
  my($details);

  my($lux) = "/usr/sbin/luxadm";

  my($HOME) = System->get_home();
  ($err,$out) = Util->run_command("$lux probe", "luxprobe.txt", 20);
  return "\nERR $err" if ($err);
  for ($x=0; $x <= $#$out; $x++) {
    $l= $out->[$x];
    $name = $out->[$x+1];
    $name =~ /Logical Path:\/.*\/.*\/(.*)/;
    $name = $1;
    if ($l =~ / Node WWN:(.+)\s+Device Type:Disk/) { # A3500
      $wwn = $1;
      ($err,$out2) = Util->run_command("$lux display $wwn", "luxadm_disk3.txt",
 10);
      next if ($err);
      $details = "@$out2";
      $f .= "$name=$wwn=X\n" if ($details =~ /A3500/);
    }
  }
  return "OK $f";
}




sub addDevice {
  my($class, $q) = @_;
  my($ho, $o, $err, $ipno, $x, $info);
  my($renv, $dev, $host,$notifs, $sel);

  my $L = Labels->read('GUIAdmin::A3500FC')->section('add'); 
  my $G = Labels->read();

  my $deny = Roles->verifyRole($q, "admin");
  require "GUI/Devices.pm";
  if ($q->{ACTION_back}) {
    GUI::Devices::add($q);
    return;

  } elsif ($q->{ACTION_add}) {
    while (1) {
     if (!$q->{name} || !$q->{wwn}) {
        $err = Html->error($L->{name_mandat});
        last;
     } else {
        ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
        foreach $x (@$dev) {
          if ($x->{name} eq $q->{name}) {
             $err = Html->error($G->{device_name_already});
             goto out;
          }
        }
        $x = $#$dev + 1;
        $dev->[$x]{_name}    = "device" . ($x+1);
        $dev->[$x]{type}     = "a3500fc";
        $dev->[$x]{class}    = "storage.a3500fc";
        $dev->[$x]{name}     = $q->{name};
        $dev->[$x]{wwn}      = $q->{wwn};
        $dev->[$x]{wwn2}     = $q->{wwn2};
        $dev->[$x]{key}      = $q->{name};
        $dev->[$x]{active}   = "Y";
        $dev->[$x]{host}     = $q->{host};
        GUIAdmin->clearSlave($q->{host}, $host);  

        if (!PDM::ConfigFile->write( $renv, $dev, $host,$notifs)) {
           print $G->{cannot_write_config} . "<br>";
        } else {
           $info = Html->info($G->{device_added});
        }

        GUI::Devices::list($q);
        return;
     }
     last;
    }
  }
out:

  print Html->body();
  print GUI::Devices::add0($q);

  my($h) = Html->header("$G->{add} " . &description(),
    "","","Maintenance.General#adddevice", undef, {nohelp => 1});

  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  $sel = ($q->{host} eq "")? "selected":"";

  my($phost) = "<select name=host><option value=\"\">[$G->{select}]</option>".
              "<option value=\"\" $sel>$G->{local}</option>";


  foreach $x (@$host) {
  next if($x->{dh} eq "Y");

    $sel = ($q->{host} eq $x->{hostname})? "selected":"";
    $phost .= "<option value=" . $x->{hostname} . " $sel>" . $x->{hostname} ."</option>";
  }
  $phost .= "</select>";

  $o =<<EOF;
<form  method=get>
 <input type=hidden name=GO value="GUIAdmin::A3500FC->addDevice">
<center>
$h
$err
<table border=1 cellspacing=0 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr><td colspan=2 bgcolor=$Style::DARK><b><font color=white>&nbsp;$L->{title}</td>

<tr><td bgcolor=$Style::LIGHT width=30% align=right>$L->{name}:</td>
    <td><input type=text name=name size=15 maxlength=15 value="$q->{name}">

<tr><td bgcolor=$Style::LIGHT width=30% align=right>$L->{serial}:</td>
    <td><input type=text name=wwn size=20 maxlength=20 value="$q->{wwn}">

<tr><td bgcolor=$Style::LIGHT width=30% align=right>$L->{serial2}:</td>
    <td><input type=text name=wwn2 size=20 maxlength=20 value="$q->{wwn2}">


<tr><td bgcolor=$Style::LIGHT align=right>$L->{host}:</td>
    <td>$phost</td>

</table>
</table>
<b>
EOF
  print $o;
  if (!$deny) {
     print "<input type=submit name=ACTION_add value=\" $G->{submit_add} \">&nbsp;";
  }
  print "<input type=submit name=ACTION_back value=\"$G->{submit_back}\"></form>";


}
sub updDevice {
  my($class, $q) = @_;
  my($ho, $o);
  my($name, $err, $ip, $ipno);
  my($renv, $dev, $host,$notifs, $x, $D, $type, $key, $h1, $h, $sel, $active);

  my $L = Labels->read('GUIAdmin::A3500FC')->section('update'); 
  my $G = Labels->read();

  my $deny = Roles->verifyRole($q, "admin");
  print Html->body();
  require "GUI/Devices.pm";

  if ($q->{ACTION_back}) {
    GUI::Devices::list($q);
    return;

  } elsif ($q->{ACTION_update}) {
    ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
    $x = $q->{no};
    $D = $dev->[$x];

    $dev->[$x]{host} = $q->{host};
    $dev->[$x]{name} = $q->{name};
    $dev->[$x]{class} = "storage.a3500fc";
    $dev->[$x]{wwn} = $q->{wwn};
    $dev->[$x]{key} = $q->{name};
    $dev->[$x]{wwn2} = $q->{wwn2};
    GUIAdmin->clearSlave($q->{host}, $host);

    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    $err = Html->info($G->expand('device_updated', $name));

  } elsif ($q->{ACTION_delete}) {
    ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
    $x = $q->{no};
    $type = $dev->[$x]{type};
    $key =  $dev->[$x]{name};

    GUIAdmin->clearSlave($q->{host}, $host);

    Events->saveEvent("DD", $type,  $key) if ($key);
    $dev->[$x]{_name} = "";
    $name = $dev->[$x]{name} . "/ " . $dev->[$x]{ip};
    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    &main::log_change($G->expand('device_deleted', $name));
    $q->{ERR} = Html->error($G->expand('device_deleted', $name));
    GUI::Devices::list($q);
    return;
  }
out:

  $h1 = Html->header2("admin.gen_maint.maint_device", undef, &description()," ");

  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  $h = $dev->[$q->{no}];

  $sel = ($h->{host})? "":"selected";
  $ho = "<select name=host><option value=\"\" $sel>$G->{local}</option>";
  foreach $h1 (@$host) {
       $sel = ($h1->{hostname} eq $h->{host}) ? "selected":"";
       $ho .= "<option name=$h1->{hostname} $sel>$h1->{hostname}</option>";
  }
  $ho .= "</select>";

  $active = ($h->{active} eq "Y") ? "On":"Off";
  my $dev_type = $h->{userLabel} || $h->{type};

  $o =<<EOF;
<body bgcolor=$Style::BGCOLOR>
<form  method=get>
 <input type=hidden name=GO value="GUIAdmin::A3500FC->updDevice">
 <input type=hidden name=no value=$q->{no}>
<center>
$h1
$err
<table border=1 cellspacing=0 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr>
<td colspan=2 bgcolor=$Style::DARK><b><font color=white>&nbsp;$L->{title}</td>

<tr><td bgcolor=$Style::LIGHT align=right>$L->{type}:</td>
    <td>
      <table border=0 cellspacing=0 width=100%> <tr>
        <td><b>&nbsp;$dev_type</td>
        <td bgcolor=$Style::LIGHT align=right>$L->{monitoring}:</td>
        <td ><b>&nbsp;$active</td>
      </table>

<tr><td bgcolor=$Style::LIGHT width=30% align=right>$L->{name}:</td>
    <td><input type=text name=name size=20 maxlength=40 value="$h->{name}">

<tr><td bgcolor=$Style::LIGHT width=30% align=right>$L->{serial}:</td>
    <td><input type=text name=wwn size=20 maxlength=20 value="$h->{wwn}">
<tr><td bgcolor=$Style::LIGHT width=30% align=right>$L->{serial2}:</td>
    <td><input type=text name=wwn2 size=20 maxlength=20 value="$h->{wwn2}">

<tr><td bgcolor=$Style::LIGHT align=right>$L->{host}:</td>
    <td><b>$ho</td>


</table>
</table>
<b>

EOF

  print $o;
  if (!$deny) {
      print "<input type=submit name=ACTION_update value=\"$G->{submit_update}\">&nbsp;
             <input type=submit name=ACTION_delete value=\"$G->{submit_delete}\">";
  }
  print " <input type=submit name=ACTION_back value=\"$G->{submit_back}\">
  </form>";

}




1;
