package GUI::Topo;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Id: Topo.pm,v 1.11 2003/03/10 03:30:36 ccadieux Exp $
use Data::Dumper;
use Util;
use System;
use Debug;
$SIZE=34;
$SIZE0=33;

sub list {
  my($q) = @_;

  print Html->text_header();
  print "<frameset rows=50%,* border=1>
  <frame src=$Http::WEBPROC?GO=GUI::Topo::list0  name=topo0 marginwidth=1 scrolling=auto>
  <frame src=empty2.html name=topo1 marginwidth=0 scrolling=auto>
</frameset>
";

}

sub get_topo {
 my($refresh) = @_;
 my($topo, $l, $l1);
 my($file) =  System->get_home() . "/DATA/topology";
 if (!-f $file || $refresh) {
#    print " - re-creating topology ...<br>\n";
    $topo = &run_discman();
    open(O, ">$file");
    $Data::Dumper::Indent = 0;
    print O Dumper($topo);
    close(O);

 } else {
    open(O, $file);
    while ($l1 = <O>) { $l .= $l1}
    close(O);
    $l = '$topo = ' . substr($l,7);
    eval $l;
 }
 ($nodes, $host) = &create_nodes($topo);
 return ($nodes, $host);
}


sub list0 {
  my($q) = @_;
 $WIDTH=75;

 print Html->body();
 print DropMenu::init();

 $q->{zoom} = 34 if (!$q->{zoom});
 $zoom   = "<select name=zoom>" . &main::select("34=Normal|30=80%|25=60%", $q->{zoom});
 $master = System->hostname;

 System->set_testMode(1);
 ($nodes,$host) = &get_topo($q->{ACTION} eq "Re-Discover");

# $Data::Dumper::Indent = 1;
# print "<pre>" . Dumper($topo);
 
 ($disp, $layers) =  &display($host, $q->{zoom});
 print "
  <table border=0 cellspacing=0 cellpadding=0 width=100%><tr><td bgcolor=#D0D0D0>
  <table border=0 cellspacing=0 cellpadding=0 width=100%>
  <form  method=get>
  <input type=hidden name=GO value=GUI::Topo::list0>
  <tr><td><b>&nbsp;<font color=navy>Topology</font></td>
    <td align=right><b>
       <input type=submit name=ACTION value=Re-Discover></td>
    <td align=right><b><font color=black>
     Zoom: $zoom
       <input type=submit name=ACTION value=Refresh>&nbsp;</td>
  </table></table>
  <table border=0 bgcolor=white cellspacing=3 width=100% cellpadding=4><tr><td>
    $disp
   </table></form>";

  print DropMenu::layers($layers, $WIDTH);
}
$HBA = "<img src=/Topo/hba.gif height=$SIZE border=0 align=middle>";

sub choose {
  my($cnt, $last, $z) = @_;
  if ($cnt == $last) {
    return (&img("g1","",$z) , &img("g2","",$z));
  } else {
    return (&img("g0","",$z) , &img("g3","",$z));
  }
}
sub explore_frame {
  my($q) = @_;

  print Html->text_header();
  print "<frameset cols=50%,* border=0>
  <frame src=$Http::WEBPROC?GO=GUI::Instr::explore1&wwn=$q->{wwn} name=topo0 marginwidth=1 scrolling=auto>
  <frame src=empty2.html name=main2 marginwidth=0 scrolling=auto>
</frameset>
";
 
}

sub img {
  my($i, $t, $z) = @_;
  my($size) = "height=$z" if ($z);
  my($alt)  = "alt=\"$t\"" if ($t);
  return "<img src=/Topo/$i.gif  border=0 align=middle  $alt $size>";
}

sub Dumper2 {
  my($i) = @_;
  my($o, $skip);
  if ($i->{path}) {
    $o   .= "Path: $i->{path}";
    $skip = 'path';
  } elsif ($i->{PhysPath})  {
    $o   .= "PhysPath: $i->{PhysPath}";
    $skip = 'PhysPath';
  } elsif ($i->{RegisterName}) {
    $o   .= "RegisterName: $i->{RegisterName}";
    $skip = 'RegisterName';
  } 
  $o .= "\n";
  foreach $x (sort keys %$i) {
     next if ($x eq $skip);
     next if (!$i->{$x});
     $o .= sprintf("<font color=blue>%30.30s:</font> %s\n", $x , $i->{$x});
  }
  foreach $x (sort keys %$i) {
     next if ($x eq $skip);
     next if ($i->{$x});
     $o .= sprintf("<font color=blue>%30.30s:</font> %s\n", $x , $i->{$x});
  }
  return $o;
}


sub show_sport {
  my($q) = @_;
  print "\n<body bgcolor=$Style::BGCOLOR><center>";
  System->set_testMode(1);
  ($nodes, $host) = &get_topo(0);
  print "<table border=0 cellpadding=0 width=90%><td><td bgcolor=black>
         <table border=0 width=100% bgcolor=white>
   <tr><td bgcolor=$Style::DARK><b><font color=white>HBA: $q->{hba}</td><tr><td><pre>";
  my($cnt) = 0;
  $Data::Dumper::Indent = 1;
  foreach my $port (@{$host->ports}) {
      if ($cnt == $q->{hba}) {
         print &Dumper2($port->info());
         last;
      }
      $cnt++;
  }
  print "</table></table>";
}

sub discman {
  my($q) = @_;
  print "\n<body bgcolor=$Style::BGCOLOR><center>";
  System->set_testMode(1);
  ($nodes, $host) = &get_topo(0);
  print "<table border=0 cellpadding=0 width=95%><td><td bgcolor=black>
         <table border=0 width=100% bgcolor=white>
   <tr><td bgcolor=$Style::DARK><b><font color=white>WWN: $q->{wwn}</td><tr><td><pre>";
  my($cnt) = 0;
  $Data::Dumper::Indent = 1;
  foreach my $node (@$nodes) {
     if ($node->key eq $q->{wwn}) {
         print &Dumper2($node->info);
         last;
      }
  }
  print "</table></table>";
}

sub show_hba {
  my($q) = @_;
  print "\n<body bgcolor=$Style::BGCOLOR><center>";
  System->set_testMode(1);
  ($nodes, $host) = &get_topo(0);
  print "<table border=0 cellpadding=0 width=90%><td><td bgcolor=black>
         <table border=0 width=100% bgcolor=white>
   <tr><td bgcolor=$Style::DARK><b><font color=white>HBA: $q->{hba}</td><tr><td><pre>";
  my($cnt) = 0;
  $Data::Dumper::Indent = 1;
  foreach my $port (@{$host->ports}) {
      if ($cnt == $q->{hba}) {
         print Dumper2($port->info());
         last;
      }
      $cnt++;
  }
  print "</table></table>";
}
  
$mColor = "navy";

sub display {
  my($node, $z) = @_;
  my(@layers);
  my($line, $out, $gif);
  my($fh,$fh1); 
  if ($z == 25) {
     $fh = "<font size=2>"; $fh1 = "</font>";
  }
  my($h1) = int(46 * $z / 34);
  if (-f System->get_home . "/htdocs/Topo/" . $node->info('hosttype') . ".gif") {     $gif = $node->info('hosttype');
  } else {
      $gif = "host";
  }
  my($img) = "<img src=/Topo/$gif.gif align=middle border=0 height=$h1 alt=\"".
                $node->name . "\">";
  $ix = index($node->name, ".");
  $name = ($ix)? substr($node->name,0,$ix) : $node->name;
  $out =  "<b>$img $name -" . $node->info('hosttype') . "</b> <br>\n";
  
  my($last_hba) = $#{$node->ports};
  my($X,$Y);
  $Y=65;
  $Y += 20 if ($ENV{HTTP_USER_AGENT} =~ /SunOS/); # solaris netscape has bigger buttons
  my($cnt) = 0; 
  my($menuCnt) = 1;
  foreach my $port (@{$node->ports}) {
     $Y+= $z;
     ($pre, $line) = &choose($cnt, $last_hba, $z);
     if ($port->info('al_pa') == -1) {
       $HBA = &img("hba0","",$z) ; #$port->info('path'), $z);
     } else {
       $HBA = &img("hba","",$z) ; #$port->info('path'), $z);
     }
     $out  .= "$pre<a href=javascript::false  onClick=Show($menuCnt) onMouseOut=Hide($menuCnt) target=topo1>$fh$HBA$fh1</a> ". 
               $port->type . " " . $port->key . "</a><br>\n";
     $menuCnt++; $X = $z + 10;
     push(@layers, &push_layers0($X, $Y, "show_hba&hba=$cnt" ));
     my($last_link) = $#{$port->{links}};
     my($cnt1) = 0;
     foreach my $link (@{$port->{links}} ) {
         $Y+= $z;
         my($node1) = $link->[0]; 
         my($port_no) = $link->[1]; 
         ($pre, $line2) = &choose($cnt1, $last_link, $z);
         $img = &img($node1->type, "", $z) ; # $node1->info('PhysPath') || $node1->info("RegisterName"), $z);
         if ($node1->type eq "switch") {
            $out .= $line . $pre. 
               "<a href=javascript::false  onClick=Show($menuCnt) onMouseOut=Hide($menuCnt) target=topo1>$img</a> " .
                         ucfirst($node1->type) . " (ip$port_no)," . $node1->key . "<br>\n";
            $menuCnt++; $X = $z * 2 + 10 ;
            push(@layers, &push_layers($X, $Y, "wwn=".$node1->key));
 
            $last_sp = -1;
            foreach my $p (@{$node1->ports}) {
                next if ($port_no eq $p->key);
                $last_sp++;
            }
            my($sp_cnt) = 0;
            foreach my $p (@{$node1->ports}) {
                next if ($port_no eq $p->key);
                $Y += $z;
                ($pre, $line3) = &choose($sp_cnt, $last_sp, $z);
                my($last_link2) = $#{$p->{links}};
                $HBA = &img("sport", $p->info('RegisterName'), $z);
                $out  .= "$line$line2 $pre<a href=javascript::false  onClick=Show($menuCnt) onMouseOut=Hide($menuCnt)".
                         " target=topo1>$HBA</a> " . $p->type . " " .  $p->key." <br>\n";
                $menuCnt++; $X = $z * 3 + 10;
                push(@layers, &push_layers0($X, $Y, "show_sport&port=".$p->key ));

                foreach $link2 (@{$p->{links}} ) {
                   $Y += $z;
                   my($node2) = $link2->[0];
                   $alt = "alt=\"".  $node2->info('PhysPath')   . "\"";
                   $img = &img( $node2->type,  $node2->info('PhysPath'), $z);
                   $out .= $line . $line2 . $line3 . &img("g1","",$z). 
                        "<a href=javascript::false  onClick=Show($menuCnt) onMouseOut=Hide($menuCnt) target=topo1>$img</a>" .
                         ucfirst($node2->type) . " - " . $node2->key . "<br>\n";
                   $X = $z * 4 + 10 ; $menuCnt++;
                   push(@layers, &push_layers($X, $Y, "wwn=".$node2->info('NodeWWN') ));
                }
                $sp_cnt++;
            }
         } else {
            $X = $z * 2 + 10;
            $out .= $line . $pre. "<a href=javascript::false ".
                         " onClick=Show($menuCnt) onMouseOut=Hide($menuCnt) target=topo1>$fh$img$fh1</a> " .  
                         ucfirst($node1->type) .  " - " . $node1->key . "</b><br>\n";
            $menuCnt++;
            push(@layers, &push_layers($X, $Y, "wwn=".$node1->key));
         }
         $cnt1++;
     }
     $cnt++;
  }
  return  ($out, \@layers);
}

sub push_layers {
  my($x,$y, $s) = @_;
  return [$x,$y,
    "<a href=$Http::WEBPROC?GO=GUI::Topo::explore_frame&$s target=topo1><font color=$mColor>-Report</font></a>",
    "<a href=$Http::WEBPROC?GO=GUI::Topo::discman&$s target=topo1><font color=$mColor>-DiscMan</font></a>",
    "<a href=$Http::WEBPROC?GO=GUI::Topo::$s target=topo1><font color=$mColor>-Events</font></a>",
    "<a href=$Http::WEBPROC?GO=GUI::Topo::$s target=topo1><font color=$mColor>-Messages</font></a>",
    ];
}

sub push_layers0 {
  my($x,$y, $s) = @_;
  return [$x,$y,
    "<a href=$Http::WEBPROC?GO=GUI::Topo::$s target=topo1><font color=$mColor>-DiscMan</font></a>",
    "<a href=$Http::WEBPROC?GO=GUI::Topo::$s target=topo1><font color=$mColor>-Report</font></a>",
    ];
}




sub run_discman {
    my($discman) = System->get_home() . "/Diags/bin/discman";

    my(%t, $in, $curr_hba, $curr_dev, $hostname);
    my($err,$com) = Util->run_command( $discman,"discman.out1", $renv->{"timeout.discman"}); 
  
    if ($err) {
       Debug->print2("Error: discman: $err");
       return undef;
    }
    foreach my $l (@$com) {
       next if ($l =~ /^\s*$/);
       $l = Util->trim($l);
       if ($l =~ /^\s*Hostname:\s*(.*)/) {
          $t{info}{hostname} = $1;
          $t{info}{hosttype} = System->host_type($1);

       } elsif ($l =~ /^\s*Detected.*HBA port\(s\)/) {
          $in = "hbasumm";

       } elsif ($l =~ /^\s*Detected.*FCAL Device\(s\)/) {
          $in = "devicesumm";

       } elsif ($l =~ /^\s*HBA Port (\d+) Path: (.*)/) {
          $in = "hba"; $curr_hba = sprintf("%2.2d", $1);
          $t{hba}{$curr_hba}{info}{path} = $2;

       } elsif ($l =~/^\s*Device # (\d+):\s*$/) {
          $in = "device";
          $curr_dev = sprintf("%3.3d",$1);

       } elsif ($in eq "hbasumm") {     #  SOCAL HBA port(s):      0

       } elsif ($in eq "devicesumm") {  
          @a = split(/\s*:\s*/, $l,2);
          $t{info}{$a[0]} .= $a[1] . ",";

       } elsif ($in eq "hba") {
          @a = split(/\s*:\s*/, $l,2);
          $t{hba}{$curr_hba}{info}{$a[0]} = $a[1];

       } elsif ($in eq "device") {
          @a = split(/\s*:\s*/, $l,2);
          $t{hba}{$curr_hba}{device}{$curr_dev}{$a[0]} = $a[1];
       }
    }
    return \%t;
}

sub create_nodes {
  my($t) = @_;
  my(@nodes);
    $host = Node->new('host',System->hostid,$t->{info}{hostname},  $t->{info});
    push(@nodes, $host);
    my($sw, $n1, $dev_no, $hba_no);
    my($hbas) = $t->{hba};
    foreach $hba_no (keys %$hbas) {
       $hba =  $hbas->{$hba_no};
#       if ($hba->{info}{NodeWWN} =~ /^0+$/) {
#          delete( $t->{hba}{$hba_no} );
#          next;
#       } else {
          $host->addPort( Port->new('hba',$hba_no, $hba->{info})); 
#       }
       $devs = $hba->{device}; my($first);
       my($first_no, $second_no, @rest) =  (sort keys %{$devs});
       $first = $devs->{$first_no};
       $second = $devs->{$second_no};

       if ($first->{ProductID} =~ /Switch/) {   # it's a switch
          $i = index($first->{ipAddr},".");
          $sw = Node->new('switch', $first->{sw_WWN},
                          $first->{VendorID} . substr($first->{ipAddr},$i+1),
                          $first);
          push(@nodes, $sw);
          my($p) = $first->{sw_PortNum};
          $sw->addPort( Port->new('port',$p, $first ));
          $sw->port($p)->addLink($host, $hba_no);        # tie new device to host
          $host->port($hba_no)->addLink($sw, $p);

          my($p2) = $second->{sw_PortNum};
          $sw->addPort( Port->new('port',$p2, $second));

          my($d1) = $devs->{$rest[0]};
          if ($d1->{LGroup} =~ /StorEdge-A5\d+/) {
             $type = 'a5k';
             $i = index($d1->{LGroup}, "(");
             my($name) = substr($d1->{LGroup}, 9,$i-9);
             my($a5) = Node->new($type, $d1->{LGroup},$name , $d1);
             push(@nodes, $a5);
             $a5->addPort(Port->new('port',0, {}));
             $sw->port($p2)->addLink($a5, 0);
             $a5->port(0)->addLink($sw, $p2);
             
             for ($x=1; $x <= $#rest; $x++) {
                $dev = $devs->{$rest[$x]};
                $a5->addDisk(Disk->new($dev->{NodeWWN},$dev));
             }
          } else {
             print "LGroup=$d1->{LGroup} unknown\n";
          }
          
       } else {
          foreach $dev_no (sort keys %{$devs}) {
             $dev = $devs->{$dev_no};
             $n1 = Node->new(lc($dev->{ProductID}), $dev->{NodeWWN}, $dev->{NodeWWN}, $dev);
             push(@nodes, $n1);
             $n1->addPort(Port->new('port',0, {}));
             $n1->port(0)->addLink($host,$hba_no);        # tie new device to host
             $host->port($hba_no)->addLink($n1,0);
          }
       }
    }
    
    return (\@nodes, $host);
}

############### NODE #####################
package Node;

sub new {
  my($class, $type, $key,$name, $arg)  = @_;

  my($node) = {};
  $node->{type}  = $type;
  $node->{info}  = $arg;
  $node->{key}   = $key;
  $node->{name} = $name;
  $node->{disks} = [];
  $node->{ports} = [];
  bless($node, $class);
  return $node;
}

sub type {
  my($node) = @_;
  return $node->{type};
}
sub key {
  my($node) = @_;
  return $node->{key};
}
sub name {
  my($node) = @_;
  return $node->{name};
}

sub addPort {
  my($node, $port) = @_;
  push(@{$node->{ports}}, $port);
}
sub ports {
  my($node) = @_;
  return $node->{ports};
}
sub port {
  my($node, $port_no) = @_;
  my($p);
  foreach $p (@{$node->{ports}}) {
     return $p if ($p->key == $port_no) ;
  }
  return undef;
}

sub addDisk {
  my($node, $disk) = @_;
  push(@{$node->{disks}}, $disk);
}

sub info {
  my($node, $arg) = @_;
  if ($arg) {
    return $node->{info}{$arg};
  } else {
    return $node->{info};
  }
}

sub disks {
  my($node) = @_;
  return $node->{disks};
}

############### PORT #####################
package Port;

sub new {
  my($class, $type, $key, $arg) = @_;

  my($port) = {};
  $port->{type} = $type;
  $port->{info} = $arg;
  $port->{key} = $key;
  $port->{links} = [];
  bless($port, $class) ;
  return $port;
}

sub type {
  my($node) = @_;
  return $node->{type};
}
sub key {
  my($node) = @_;
  return $node->{key};
}

sub info {
  my($node, $arg) = @_;
  if ($arg) {
    return $node->{info}{$arg};
  } else {
    return $node->{info};
  }
}

sub addLink {
   my($port, $node, $usingPort) = @_;
   push(@{$port->{links}}, [$node,$usingPort]);
}

sub links {
  my($port) = @_;
  return $port->{links};
}

############### DISK #####################
package Disk;

sub new {
  my($class, $key, $arg) = @_;

  my($disk) = {};
  $disk->{info} = $arg;
  $disk->{key} = $key;
  $disk->{links} = [];
  bless($disk, $class) ;
  return $disk;
}

sub info {
  my($node, $arg) = @_;
  if ($arg) {
    return $node->{info}{$arg};
  } else {
    return $node->{info};
  }
}


############### DROP MENU #################
package DropMenu;


sub init {
  my($o) =<<EOF;
<head>
<SCRIPT LANGUAGE="JavaScript" TYPE="text/javascript">
<!--
No3 = (parseInt(navigator.appVersion) > 3) ? 1:0;
layer = (document.all && No3) ? 
   "document.all['L'+menu].style" : 
   (document.layers && No3) ? "document.layers['L'+menu]" : 0;
var timer;

function Show() {
   if(layer) {
        if(timer) clearTimeout(timer);
        for (menu=0; menu < Layer.length; menu++) {
            if (Layer[menu]) {
               eval(layer).visibility = "hidden";
            }
        }
        for (i=0; i<arguments.length; i++) {
            menu=arguments[i];
            eval(layer).visibility = "visible";
        }
   }
}
function Hide() {
   timer = setTimeout("Show()", 500);
}

//-->
</SCRIPT>
</head>
EOF
  return $o;
}

sub layers {
  my($layers, $width) = @_;
  my($o) =<<EOF;

<SCRIPT LANGUAGE="JavaScript">
<!--
     hovercolor   = "gold";       
     bgcolor      = "#E0E0E0";
     background   = "";                // picture url

     menu_border  = 1;               // IE only
     border_color = "#000000";       // IE only

     arrow_pic    = "script740849_0_2.gif"; // url of arrow picture for submenus

if(document.all) { 
  if(!background) { background=bgcolor; } else { background = "url("+background+")"; } }

function LayerSpecs(Left,Top,Width) {
   if(No3) {
        if(document.all) { Top+=7; Left+=2; Width-=6; }
        this.left  = Left;
        this.top   = Top;
        this.info  = "";
        T=0;
        for (i=3; i < arguments.length; i++) {
           if(document.all) {
               this.info += "<TR><TD WIDTH="+Width+" onMouseOver='this.bgColor=\\""+hovercolor+"\\"' onMouseOut='this.bgColor=\\"\\"'>"+arguments[i]+"</TD></TR>";
           } else {
               this.info += "<LAYER onMouseOver='this.bgColor=\\""+hovercolor+"\\"' onMouseOut='this.bgColor=\\""+bgcolor+"\\"' WIDTH="+Width+" POSITION=RELATIVE TOP="+T+">"+arguments[i]+"</LAYER>";
           }
           T+=20;
        }
} }

Layer = new Array();
arrow = "<IMG SRC='"+arrow_pic+"' WIDTH=6 HEIGHT=10 BORDER=0 ALT=''>";

EOF
  my($x, $y);
  for ($x = 0; $x <= $#$layers; $x++) {
     $l = $layers->[$x];
     $o .= "Layer[" . ($x+1) . "] = new LayerSpecs($l->[0],$l->[1], $width, ";
     for ($y=2; $y <= $#$l; $y++) {
        $o .= "'$l->[$y]',\n";
     }
     chop($o); chop($o);
     $o .= ");\n";
  }
  $o .=<<EOF;

j = (Layer[0]) ? 0:1;

for(i=j; i<Layer.length; i++) {
   if(document.all && No3) {
      document.write("<SPAN onMouseOver='clearTimeout(timer)' onMouseOut='Hide("+i+")' ID='L"+i+"' STYLE='position:absolute; visibility:hidden; background:"+background+"; top:"+Layer[i].top+"; left:"+Layer[i].left+";'><TABLE STYLE='border:solid "+menu_border+" "+border_color+"'>"+Layer[i].info+"</TABLE></SPAN>");
   } else if (document.layers && No3) {
      document.write("<LAYER onMouseOver='clearTimeout(timer)' onMouseOut='Hide("+i+")' ID='L"+i+"' POSITION=ABSOLUTE VISIBILITY=HIDDEN BGCOLOR='"+bgcolor+"' BACKGROUND='"+background+"' TOP="+Layer[i].top+" LEFT="+Layer[i].left+">"
        + Layer[i].info + "</LAYER>");
   }
}

// if(document.all) {
//  document.all["menubar"].style.visibility = "visible";
//} else if (document.layers) {
//  document.layers["menubar"].visibility = "visible";
//}

// -->
</SCRIPT>
EOF


  return $o;

}


1;
