package GUI::Roles;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use Html;
use strict;
use AdminGroup;
# WINDOW = S : small window, few frames.
#          B : big window, many frames.
#          N : no frames at all.

use Roles;


sub test {
  my($q) = @_;
  foreach my $x (keys %$q) {print "$x=$q->{$x}<br>"}
  print "\n<body bgcolor=white>
  <a href=$Http::WEBPROC?GO=GUI::Roles::test>Test link</a><br>
  <form>
  <input type=hidden name=GO value=GUI::Roles::test>
  <input type=text name=field1 value=field1>
  <input type=submit name=ACTION value=Submit>
  </form>";
}

sub update {
  my($q) = @_;
  my $G = Labels->read();
  my $L = Labels->read('GUI::Roles');

  print Html->body();
  if ( Util->findMaster()) {
    print "<h1><center>$G->{e_101}";
    return;
  }

  print Html->header2("admin.system.roles");

  if (my $err = Roles->verifyRole($q, "admin|c_admin")) {
     print $err;
     return;
  }

  my $ruser      = System->get_ruser();
  my $isCustomer = $ruser->{isCustomer};
  my $info;
  if ($isCustomer) {
     $info = $L->{info1};
  } else {
     $info = Util->readHtdocs("role_maint");
  }

  my $db = Roles->read();

  my ($adds, $dels, $INFO);
  my $roles = $db->getRoles();

  $#$roles-- if ($roles->[$#$roles] eq "peer");

  if ($q->{ACTION_update}) {
     foreach my $k (keys %$q) {
       if (substr($k,0,4) eq "del_") {
          my $user = substr($k,4);
          $dels .= "$user,";
          $db->deleteUser($user);
           
       } elsif (substr($k,0,5) eq "USER_") {
          my $ix = substr($k,5);
          my $user = lc($q->{$k});
          $user =~ s/\W+/_/g;
          $user = "u$user" if ($user =~ /^\d+/);
          next if (!$user);
          my $name     = $q->{"USER_$ix"};
          my $password = $q->{"PASS_$ix"};
          my $nis      = $q->{"NIS_$ix"} ? "Y": "";
          my $lang     = $q->{"LANG_$ix"};
          my $group    = $q->{"GROUP_$ix"};
          my $window   = $q->{"WINDOW_$ix"};
          my $access   = "N";
          if ($window eq "A") {  # accessible 
             $window = "N"; $access= "Y";
          }
          my $rlist;
          foreach my $r (@$roles) {
             my $r0 = "ROLE_" . $ix . "_$r";
             if ($q->{$r0}) {
                if (substr($r,0,2) ne "c_" && index($rlist, "c_") >= 0) {
                   $INFO = Html->info("$user:" . $L->{invalid_role});
                   goto out;        
                }
                $rlist .= "$r|";
             }
          }
          if ($name && ($password||$nis) && $rlist) {
            $db->addUser($user, $name,$password, $rlist, $lang, $window, $access, $nis, $group);
            $adds .= "$user, ";
          } else {
            $INFO = Html->error($L->expand('err_no_name', $user));
          }         
       } elsif (substr($k,0,5) eq "pass_") { # update
          my $id = substr($k,5);
          my $user = $db->getUser($id);
          my $name = $id;
          if ($user) {
             if ($q->{"pass_$id"}) {
                $user->{password} = Roles->encode($q->{"pass_$id"});
             }
             $user->{window}   = $q->{"window_$id"};
             $user->{language} = $q->{"lang_$id"};
             $user->{adm_group} = $q->{"group_$id"};
             $user->{nis}      = $q->{"nis_$id"} ? "Y" : "";
             $user->{access}   = "N";
             if ($user->{window} eq "A") {
                $user->{window} = "N";
                $user->{access} = "Y";
             }
             my $rlist;
             foreach my $r (@$roles) {
                my $r0 = "role_$r" ."_$id";
                if ($q->{$r0}) {
                   if (substr($r,0,2) ne "c_" && index($rlist, "c_") >= 0) {
                      $INFO = Html->info("$name:". $L->{err_2users});
                      $db->deleteUser($id);
                      goto out;        
                  }
                  $rlist .= "$r|";
                }
             }
             if ($rlist) {
               $user->{roles} = $rlist;
             } else {
               $INFO = Html->error($L->expand('err_cannot_rem', $id));
             }
          }
       }
     }
     $INFO = Html->error($L->expand('err_dels', $dels)) if ($dels);
     $INFO = Html->info( $L->expand('info_add', $adds))  if ($adds);
     
     $db->write();
  }
out:
  print "
  <table border=0 width=95% bgcolor=white cellpadding=4><tr><td>$info</table>
  $INFO
  <form><input type=hidden name=GO value=GUI::Roles::update>";

  my $userlist = $db->idList();
  my $TOT = 8;

  my $cols = ($isCustomer ? 1 : $#$roles)+$TOT + 1;

  my $head = "<table border=1 cellspacing=0 width=95% bgcolor=white>
   <tr><td colspan=$cols bgcolor=$Style::DARK><font color=white><b>$L->{label}
   <tr><td  bgcolor=$Style::LIGHT colspan=$TOT>&nbsp;</td>
   <td colspan=" . ($#$roles+1) . " bgcolor=$Style::LIGHT><b><center>$L->{service}</td>";

  my $head0 = "
     <td><b>&nbsp;$L->{l_user}</td>
     <th><b>&nbsp;$L->{l_nis}</th>
     <td><b>&nbsp;$L->{l_pass}</td>
     <td><b>&nbsp;$L->{l_lang}</td>
     <td><b>&nbsp;$L->{l_window}</td>
     <td><b>&nbsp;$L->{l_group}</td>
    ";
  foreach my $r (@$roles) {
     my $r0 = $r;
     next if ($isCustomer && substr($r0,0,2) ne "c_");
     my $tname = $L->{$r0};
     $r0 = substr($r0,2) if (substr($r0,0,2) eq "c_");
     $head0 .= "<td bgcolor=$Style::LIGHT><center><b>$tname</td>";
  }
  $head .= "
       <tr bgcolor=$Style::LIGHT> 
       <td><b><center>#</td>
       <td><b>&nbsp;$L->{l_del}</td>
       $head0";
  print $head;

  my $cnt = 0;
  my $data;
  my $WIN_OPTIONS = "B=$L->{big}|S=$L->{small}|N=$L->{nof}|A=$L->{access}";
  my $LEVELS = "d=$L->{level_d}|s=$L->{level_s}";
  my $groups = AdminGroup->new();
  my $gr_list = "=$G->{all}|" . $groups->list();

  foreach my $userid (sort @$userlist) {
     my $user = $db->getUser($userid);
     my $lang = $user->{language};
     next if ($isCustomer && index($user->{roles}, "c_") < 0);
     next if (index($user->{roles}, "peer") >= 0);
     $cnt++;
     my $ck;
     my $peer = 1 if (index($user->{roles}, "peer") >= 0);
     foreach my $r (@$roles) {
       my $checked = (index("|$user->{roles}|", "|$r|") >= 0) ? "checked":"";
       next if (substr($r,0,2) ne "c_" && $isCustomer);
       my $bg = "bgcolor=#FFFFDD" if (substr($r,0,2) eq "c_");
       if ($peer) {
         $ck .= $checked ? 
           "<td $bg><center>X<input type=hidden name=role_${r}_$userid value=X></td>": "<td>&nbsp;</td>";
       } else {
         $ck .= "<td $bg><center><input type=checkbox $checked name=role_${r}_$userid></td>";
       }
     }
     
     my($pass,$del, $lang2, $window, $nis, $grp);
     if (!$peer) { 
         $del  = "<input type=checkbox name=del_$userid>" ;
         my $nis_ck = "checked" if ($user->{nis});
         $nis  = "<input type=checkbox name=nis_$userid $nis_ck>";
         $pass = "<input type=password size=8 name=pass_$userid>";
         $user->{window} = "A" if ($user->{access} eq "Y");
         $window = Html->makeSelect("window_$userid", $WIN_OPTIONS, $user->{window} );
         $lang2 = Html->makeSelect("lang_$userid", Util->languageList(), $user->{language});
         $grp   = Html->makeSelect("group_$userid", $gr_list, $user->{adm_group});
     }
     $data .= "<tr><td><center>$cnt</td>
    <td><center>&nbsp;$del</td>
    <td>&nbsp;$userid</td>
    <td>&nbsp;<center>$nis</td>
    <td>&nbsp;$pass</td>
    <td>&nbsp;$lang2</td>
    <td><center>&nbsp;$window</td>
    <td><center>&nbsp;$grp</td>
     $ck
     \n";
  }
  $data .= "</table>
    <table border=0 width=95%>
      <tr><td ><b>
            <input type=submit name=ACTION_update value=\"$L->{submit_del}\"></td>
          <td><center><b>
            <input type=submit name=ACTION_update value=\"$L->{submit_update}\"></td>
          <td width=25%>&nbsp;&nbsp;&nbsp;&nbsp;</td>
    </table>
    <table border=1 cellspacing=0 width=95% bgcolor=white>
    <tr><td colspan=11 bgcolor=$Style::DARK><font color=white><b>&nbsp; $L->{submit_add}</td>
    <tr bgcolor=$Style::LIGHT> $head0
          ";          

  my  $last = 3; # ($cnt < 6) ? 6:5;
  my($x);
  for ($x=1; $x <= $last; $x++) {
     my $sel1 =  Html->makeSelect("WINDOW_$x", $WIN_OPTIONS);
     my $ck;
     foreach my $r (@$roles) {
       next if (substr($r,0,2) ne "c_" && $isCustomer);
       my $bg = "bgcolor=#FFFFDD" if (substr($r,0,2) eq "c_");
       $ck .= "<td $bg><center><input type=checkbox name=ROLE_${x}_$r></td>";
     }
     my $lang2 = Html->makeSelect("LANG_$x", Util->languageList());
     my $grp = Html->makeSelect("GROUP_$x", $gr_list);
     $data .= "<tr>
       <td>&nbsp;<input type=text name=USER_$x size=8></td>
       <td><center><input type=checkbox name=NIS_$x></td>
       <td>&nbsp;<input type=password name=PASS_$x size=8></td>
       <td>$lang2</td>
       <td><center>&nbsp;$sel1</td>
       <td><center>&nbsp;$grp</td>
       $ck
       ";
  }
  print $data;

  print "</table>
  &nbsp;<br><b>
  <input type=submit name=ACTION_update value=\"$L->{submit_add}\"></form>";

}
1;

